/*!
FullCalendar v5.10.2
Docs & License: https://fullcalendar.io/
(c) 2021 Adam Shaw
*/var FullCalendarInteraction=(function(exports,common){'use strict';/*! *****************************************************************************
Copyright (c) Microsoft Corporation.
Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.
THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */var extendStatics=function(d,b){extendStatics=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(Object.prototype.hasOwnProperty.call(b,p))d[p]=b[p];};return extendStatics(d,b);};function __extends(d,b){if(typeof b!=="function"&&b!==null)
throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");extendStatics(d,b);function __(){this.constructor=d;}
d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __());}
var __assign=function(){__assign=Object.assign||function __assign(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p))t[p]=s[p];}
return t;};return __assign.apply(this,arguments);};common.config.touchMouseIgnoreWait=500;var ignoreMouseDepth=0;var listenerCnt=0;var isWindowTouchMoveCancelled=false;var PointerDragging=(function(){function PointerDragging(containerEl){var _this=this;this.subjectEl=null;this.selector='';this.handleSelector='';this.shouldIgnoreMove=false;this.shouldWatchScroll=true;this.isDragging=false;this.isTouchDragging=false;this.wasTouchScroll=false;this.handleMouseDown=function(ev){if(!_this.shouldIgnoreMouse()&&isPrimaryMouseButton(ev)&&_this.tryStart(ev)){var pev=_this.createEventFromMouse(ev,true);_this.emitter.trigger('pointerdown',pev);_this.initScrollWatch(pev);if(!_this.shouldIgnoreMove){document.addEventListener('mousemove',_this.handleMouseMove);}
document.addEventListener('mouseup',_this.handleMouseUp);}};this.handleMouseMove=function(ev){var pev=_this.createEventFromMouse(ev);_this.recordCoords(pev);_this.emitter.trigger('pointermove',pev);};this.handleMouseUp=function(ev){document.removeEventListener('mousemove',_this.handleMouseMove);document.removeEventListener('mouseup',_this.handleMouseUp);_this.emitter.trigger('pointerup',_this.createEventFromMouse(ev));_this.cleanup();};this.handleTouchStart=function(ev){if(_this.tryStart(ev)){_this.isTouchDragging=true;var pev=_this.createEventFromTouch(ev,true);_this.emitter.trigger('pointerdown',pev);_this.initScrollWatch(pev);var targetEl=ev.target;if(!_this.shouldIgnoreMove){targetEl.addEventListener('touchmove',_this.handleTouchMove);}
targetEl.addEventListener('touchend',_this.handleTouchEnd);targetEl.addEventListener('touchcancel',_this.handleTouchEnd);window.addEventListener('scroll',_this.handleTouchScroll,true);}};this.handleTouchMove=function(ev){var pev=_this.createEventFromTouch(ev);_this.recordCoords(pev);_this.emitter.trigger('pointermove',pev);};this.handleTouchEnd=function(ev){if(_this.isDragging){var targetEl=ev.target;targetEl.removeEventListener('touchmove',_this.handleTouchMove);targetEl.removeEventListener('touchend',_this.handleTouchEnd);targetEl.removeEventListener('touchcancel',_this.handleTouchEnd);window.removeEventListener('scroll',_this.handleTouchScroll,true);_this.emitter.trigger('pointerup',_this.createEventFromTouch(ev));_this.cleanup();_this.isTouchDragging=false;startIgnoringMouse();}};this.handleTouchScroll=function(){_this.wasTouchScroll=true;};this.handleScroll=function(ev){if(!_this.shouldIgnoreMove){var pageX=(window.pageXOffset-_this.prevScrollX)+_this.prevPageX;var pageY=(window.pageYOffset-_this.prevScrollY)+_this.prevPageY;_this.emitter.trigger('pointermove',{origEvent:ev,isTouch:_this.isTouchDragging,subjectEl:_this.subjectEl,pageX:pageX,pageY:pageY,deltaX:pageX-_this.origPageX,deltaY:pageY-_this.origPageY,});}};this.containerEl=containerEl;this.emitter=new common.Emitter();containerEl.addEventListener('mousedown',this.handleMouseDown);containerEl.addEventListener('touchstart',this.handleTouchStart,{passive:true});listenerCreated();}
PointerDragging.prototype.destroy=function(){this.containerEl.removeEventListener('mousedown',this.handleMouseDown);this.containerEl.removeEventListener('touchstart',this.handleTouchStart,{passive:true});listenerDestroyed();};PointerDragging.prototype.tryStart=function(ev){var subjectEl=this.querySubjectEl(ev);var downEl=ev.target;if(subjectEl&&(!this.handleSelector||common.elementClosest(downEl,this.handleSelector))){this.subjectEl=subjectEl;this.isDragging=true;this.wasTouchScroll=false;return true;}
return false;};PointerDragging.prototype.cleanup=function(){isWindowTouchMoveCancelled=false;this.isDragging=false;this.subjectEl=null;this.destroyScrollWatch();};PointerDragging.prototype.querySubjectEl=function(ev){if(this.selector){return common.elementClosest(ev.target,this.selector);}
return this.containerEl;};PointerDragging.prototype.shouldIgnoreMouse=function(){return ignoreMouseDepth||this.isTouchDragging;};PointerDragging.prototype.cancelTouchScroll=function(){if(this.isDragging){isWindowTouchMoveCancelled=true;}};PointerDragging.prototype.initScrollWatch=function(ev){if(this.shouldWatchScroll){this.recordCoords(ev);window.addEventListener('scroll',this.handleScroll,true);}};PointerDragging.prototype.recordCoords=function(ev){if(this.shouldWatchScroll){this.prevPageX=ev.pageX;this.prevPageY=ev.pageY;this.prevScrollX=window.pageXOffset;this.prevScrollY=window.pageYOffset;}};PointerDragging.prototype.destroyScrollWatch=function(){if(this.shouldWatchScroll){window.removeEventListener('scroll',this.handleScroll,true);}};PointerDragging.prototype.createEventFromMouse=function(ev,isFirst){var deltaX=0;var deltaY=0;if(isFirst){this.origPageX=ev.pageX;this.origPageY=ev.pageY;}
else{deltaX=ev.pageX-this.origPageX;deltaY=ev.pageY-this.origPageY;}
return{origEvent:ev,isTouch:false,subjectEl:this.subjectEl,pageX:ev.pageX,pageY:ev.pageY,deltaX:deltaX,deltaY:deltaY,};};PointerDragging.prototype.createEventFromTouch=function(ev,isFirst){var touches=ev.touches;var pageX;var pageY;var deltaX=0;var deltaY=0;if(touches&&touches.length){pageX=touches[0].pageX;pageY=touches[0].pageY;}
else{pageX=ev.pageX;pageY=ev.pageY;}
if(isFirst){this.origPageX=pageX;this.origPageY=pageY;}
else{deltaX=pageX-this.origPageX;deltaY=pageY-this.origPageY;}
return{origEvent:ev,isTouch:true,subjectEl:this.subjectEl,pageX:pageX,pageY:pageY,deltaX:deltaX,deltaY:deltaY,};};return PointerDragging;}());function isPrimaryMouseButton(ev){return ev.button===0&&!ev.ctrlKey;}
function startIgnoringMouse(){ignoreMouseDepth+=1;setTimeout(function(){ignoreMouseDepth-=1;},common.config.touchMouseIgnoreWait);}
function listenerCreated(){listenerCnt+=1;if(listenerCnt===1){window.addEventListener('touchmove',onWindowTouchMove,{passive:false});}}
function listenerDestroyed(){listenerCnt-=1;if(!listenerCnt){window.removeEventListener('touchmove',onWindowTouchMove,{passive:false});}}
function onWindowTouchMove(ev){if(isWindowTouchMoveCancelled){ev.preventDefault();}}
var ElementMirror=(function(){function ElementMirror(){this.isVisible=false;this.sourceEl=null;this.mirrorEl=null;this.sourceElRect=null;this.parentNode=document.body;this.zIndex=9999;this.revertDuration=0;}
ElementMirror.prototype.start=function(sourceEl,pageX,pageY){this.sourceEl=sourceEl;this.sourceElRect=this.sourceEl.getBoundingClientRect();this.origScreenX=pageX-window.pageXOffset;this.origScreenY=pageY-window.pageYOffset;this.deltaX=0;this.deltaY=0;this.updateElPosition();};ElementMirror.prototype.handleMove=function(pageX,pageY){this.deltaX=(pageX-window.pageXOffset)-this.origScreenX;this.deltaY=(pageY-window.pageYOffset)-this.origScreenY;this.updateElPosition();};ElementMirror.prototype.setIsVisible=function(bool){if(bool){if(!this.isVisible){if(this.mirrorEl){this.mirrorEl.style.display='';}
this.isVisible=bool;this.updateElPosition();}}
else if(this.isVisible){if(this.mirrorEl){this.mirrorEl.style.display='none';}
this.isVisible=bool;}};ElementMirror.prototype.stop=function(needsRevertAnimation,callback){var _this=this;var done=function(){_this.cleanup();callback();};if(needsRevertAnimation&&this.mirrorEl&&this.isVisible&&this.revertDuration&&(this.deltaX||this.deltaY)){this.doRevertAnimation(done,this.revertDuration);}
else{setTimeout(done,0);}};ElementMirror.prototype.doRevertAnimation=function(callback,revertDuration){var mirrorEl=this.mirrorEl;var finalSourceElRect=this.sourceEl.getBoundingClientRect();mirrorEl.style.transition='top '+revertDuration+'ms,'+
'left '+revertDuration+'ms';common.applyStyle(mirrorEl,{left:finalSourceElRect.left,top:finalSourceElRect.top,});common.whenTransitionDone(mirrorEl,function(){mirrorEl.style.transition='';callback();});};ElementMirror.prototype.cleanup=function(){if(this.mirrorEl){common.removeElement(this.mirrorEl);this.mirrorEl=null;}
this.sourceEl=null;};ElementMirror.prototype.updateElPosition=function(){if(this.sourceEl&&this.isVisible){common.applyStyle(this.getMirrorEl(),{left:this.sourceElRect.left+this.deltaX,top:this.sourceElRect.top+this.deltaY,});}};ElementMirror.prototype.getMirrorEl=function(){var sourceElRect=this.sourceElRect;var mirrorEl=this.mirrorEl;if(!mirrorEl){mirrorEl=this.mirrorEl=this.sourceEl.cloneNode(true);mirrorEl.classList.add('fc-unselectable');mirrorEl.classList.add('fc-event-dragging');common.applyStyle(mirrorEl,{position:'fixed',zIndex:this.zIndex,visibility:'',boxSizing:'border-box',width:sourceElRect.right-sourceElRect.left,height:sourceElRect.bottom-sourceElRect.top,right:'auto',bottom:'auto',margin:0,});this.parentNode.appendChild(mirrorEl);}
return mirrorEl;};return ElementMirror;}());var ScrollGeomCache=(function(_super){__extends(ScrollGeomCache,_super);function ScrollGeomCache(scrollController,doesListening){var _this=_super.call(this)||this;_this.handleScroll=function(){_this.scrollTop=_this.scrollController.getScrollTop();_this.scrollLeft=_this.scrollController.getScrollLeft();_this.handleScrollChange();};_this.scrollController=scrollController;_this.doesListening=doesListening;_this.scrollTop=_this.origScrollTop=scrollController.getScrollTop();_this.scrollLeft=_this.origScrollLeft=scrollController.getScrollLeft();_this.scrollWidth=scrollController.getScrollWidth();_this.scrollHeight=scrollController.getScrollHeight();_this.clientWidth=scrollController.getClientWidth();_this.clientHeight=scrollController.getClientHeight();_this.clientRect=_this.computeClientRect();if(_this.doesListening){_this.getEventTarget().addEventListener('scroll',_this.handleScroll);}
return _this;}
ScrollGeomCache.prototype.destroy=function(){if(this.doesListening){this.getEventTarget().removeEventListener('scroll',this.handleScroll);}};ScrollGeomCache.prototype.getScrollTop=function(){return this.scrollTop;};ScrollGeomCache.prototype.getScrollLeft=function(){return this.scrollLeft;};ScrollGeomCache.prototype.setScrollTop=function(top){this.scrollController.setScrollTop(top);if(!this.doesListening){this.scrollTop=Math.max(Math.min(top,this.getMaxScrollTop()),0);this.handleScrollChange();}};ScrollGeomCache.prototype.setScrollLeft=function(top){this.scrollController.setScrollLeft(top);if(!this.doesListening){this.scrollLeft=Math.max(Math.min(top,this.getMaxScrollLeft()),0);this.handleScrollChange();}};ScrollGeomCache.prototype.getClientWidth=function(){return this.clientWidth;};ScrollGeomCache.prototype.getClientHeight=function(){return this.clientHeight;};ScrollGeomCache.prototype.getScrollWidth=function(){return this.scrollWidth;};ScrollGeomCache.prototype.getScrollHeight=function(){return this.scrollHeight;};ScrollGeomCache.prototype.handleScrollChange=function(){};return ScrollGeomCache;}(common.ScrollController));var ElementScrollGeomCache=(function(_super){__extends(ElementScrollGeomCache,_super);function ElementScrollGeomCache(el,doesListening){return _super.call(this,new common.ElementScrollController(el),doesListening)||this;}
ElementScrollGeomCache.prototype.getEventTarget=function(){return this.scrollController.el;};ElementScrollGeomCache.prototype.computeClientRect=function(){return common.computeInnerRect(this.scrollController.el);};return ElementScrollGeomCache;}(ScrollGeomCache));var WindowScrollGeomCache=(function(_super){__extends(WindowScrollGeomCache,_super);function WindowScrollGeomCache(doesListening){return _super.call(this,new common.WindowScrollController(),doesListening)||this;}
WindowScrollGeomCache.prototype.getEventTarget=function(){return window;};WindowScrollGeomCache.prototype.computeClientRect=function(){return{left:this.scrollLeft,right:this.scrollLeft+this.clientWidth,top:this.scrollTop,bottom:this.scrollTop+this.clientHeight,};};WindowScrollGeomCache.prototype.handleScrollChange=function(){this.clientRect=this.computeClientRect();};return WindowScrollGeomCache;}(ScrollGeomCache));var getTime=typeof performance==='function'?performance.now:Date.now;var AutoScroller=(function(){function AutoScroller(){var _this=this;this.isEnabled=true;this.scrollQuery=[window,'.fc-scroller'];this.edgeThreshold=50;this.maxVelocity=300;this.pointerScreenX=null;this.pointerScreenY=null;this.isAnimating=false;this.scrollCaches=null;this.everMovedUp=false;this.everMovedDown=false;this.everMovedLeft=false;this.everMovedRight=false;this.animate=function(){if(_this.isAnimating){var edge=_this.computeBestEdge(_this.pointerScreenX+window.pageXOffset,_this.pointerScreenY+window.pageYOffset);if(edge){var now=getTime();_this.handleSide(edge,(now-_this.msSinceRequest)/1000);_this.requestAnimation(now);}
else{_this.isAnimating=false;}}};}
AutoScroller.prototype.start=function(pageX,pageY,scrollStartEl){if(this.isEnabled){this.scrollCaches=this.buildCaches(scrollStartEl);this.pointerScreenX=null;this.pointerScreenY=null;this.everMovedUp=false;this.everMovedDown=false;this.everMovedLeft=false;this.everMovedRight=false;this.handleMove(pageX,pageY);}};AutoScroller.prototype.handleMove=function(pageX,pageY){if(this.isEnabled){var pointerScreenX=pageX-window.pageXOffset;var pointerScreenY=pageY-window.pageYOffset;var yDelta=this.pointerScreenY===null?0:pointerScreenY-this.pointerScreenY;var xDelta=this.pointerScreenX===null?0:pointerScreenX-this.pointerScreenX;if(yDelta<0){this.everMovedUp=true;}
else if(yDelta>0){this.everMovedDown=true;}
if(xDelta<0){this.everMovedLeft=true;}
else if(xDelta>0){this.everMovedRight=true;}
this.pointerScreenX=pointerScreenX;this.pointerScreenY=pointerScreenY;if(!this.isAnimating){this.isAnimating=true;this.requestAnimation(getTime());}}};AutoScroller.prototype.stop=function(){if(this.isEnabled){this.isAnimating=false;for(var _i=0,_a=this.scrollCaches;_i<_a.length;_i++){var scrollCache=_a[_i];scrollCache.destroy();}
this.scrollCaches=null;}};AutoScroller.prototype.requestAnimation=function(now){this.msSinceRequest=now;requestAnimationFrame(this.animate);};AutoScroller.prototype.handleSide=function(edge,seconds){var scrollCache=edge.scrollCache;var edgeThreshold=this.edgeThreshold;var invDistance=edgeThreshold-edge.distance;var velocity=((invDistance*invDistance)/(edgeThreshold*edgeThreshold))*this.maxVelocity*seconds;var sign=1;switch(edge.name){case 'left':sign=-1;case 'right':scrollCache.setScrollLeft(scrollCache.getScrollLeft()+velocity*sign);break;case 'top':sign=-1;case 'bottom':scrollCache.setScrollTop(scrollCache.getScrollTop()+velocity*sign);break;}};AutoScroller.prototype.computeBestEdge=function(left,top){var edgeThreshold=this.edgeThreshold;var bestSide=null;var scrollCaches=this.scrollCaches||[];for(var _i=0,scrollCaches_1=scrollCaches;_i<scrollCaches_1.length;_i++){var scrollCache=scrollCaches_1[_i];var rect=scrollCache.clientRect;var leftDist=left-rect.left;var rightDist=rect.right-left;var topDist=top-rect.top;var bottomDist=rect.bottom-top;if(leftDist>=0&&rightDist>=0&&topDist>=0&&bottomDist>=0){if(topDist<=edgeThreshold&&this.everMovedUp&&scrollCache.canScrollUp()&&(!bestSide||bestSide.distance>topDist)){bestSide={scrollCache:scrollCache,name:'top',distance:topDist};}
if(bottomDist<=edgeThreshold&&this.everMovedDown&&scrollCache.canScrollDown()&&(!bestSide||bestSide.distance>bottomDist)){bestSide={scrollCache:scrollCache,name:'bottom',distance:bottomDist};}
if(leftDist<=edgeThreshold&&this.everMovedLeft&&scrollCache.canScrollLeft()&&(!bestSide||bestSide.distance>leftDist)){bestSide={scrollCache:scrollCache,name:'left',distance:leftDist};}
if(rightDist<=edgeThreshold&&this.everMovedRight&&scrollCache.canScrollRight()&&(!bestSide||bestSide.distance>rightDist)){bestSide={scrollCache:scrollCache,name:'right',distance:rightDist};}}}
return bestSide;};AutoScroller.prototype.buildCaches=function(scrollStartEl){return this.queryScrollEls(scrollStartEl).map(function(el){if(el===window){return new WindowScrollGeomCache(false);}
return new ElementScrollGeomCache(el,false);});};AutoScroller.prototype.queryScrollEls=function(scrollStartEl){var els=[];for(var _i=0,_a=this.scrollQuery;_i<_a.length;_i++){var query=_a[_i];if(typeof query==='object'){els.push(query);}
else{els.push.apply(els,Array.prototype.slice.call(common.getElRoot(scrollStartEl).querySelectorAll(query)));}}
return els;};return AutoScroller;}());var FeaturefulElementDragging=(function(_super){__extends(FeaturefulElementDragging,_super);function FeaturefulElementDragging(containerEl,selector){var _this=_super.call(this,containerEl)||this;_this.containerEl=containerEl;_this.delay=null;_this.minDistance=0;_this.touchScrollAllowed=true;_this.mirrorNeedsRevert=false;_this.isInteracting=false;_this.isDragging=false;_this.isDelayEnded=false;_this.isDistanceSurpassed=false;_this.delayTimeoutId=null;_this.onPointerDown=function(ev){if(!_this.isDragging){_this.isInteracting=true;_this.isDelayEnded=false;_this.isDistanceSurpassed=false;common.preventSelection(document.body);common.preventContextMenu(document.body);if(!ev.isTouch){ev.origEvent.preventDefault();}
_this.emitter.trigger('pointerdown',ev);if(_this.isInteracting&&!_this.pointer.shouldIgnoreMove){_this.mirror.setIsVisible(false);_this.mirror.start(ev.subjectEl,ev.pageX,ev.pageY);_this.startDelay(ev);if(!_this.minDistance){_this.handleDistanceSurpassed(ev);}}}};_this.onPointerMove=function(ev){if(_this.isInteracting){_this.emitter.trigger('pointermove',ev);if(!_this.isDistanceSurpassed){var minDistance=_this.minDistance;var distanceSq=void 0;var deltaX=ev.deltaX,deltaY=ev.deltaY;distanceSq=deltaX*deltaX+deltaY*deltaY;if(distanceSq>=minDistance*minDistance){_this.handleDistanceSurpassed(ev);}}
if(_this.isDragging){if(ev.origEvent.type!=='scroll'){_this.mirror.handleMove(ev.pageX,ev.pageY);_this.autoScroller.handleMove(ev.pageX,ev.pageY);}
_this.emitter.trigger('dragmove',ev);}}};_this.onPointerUp=function(ev){if(_this.isInteracting){_this.isInteracting=false;common.allowSelection(document.body);common.allowContextMenu(document.body);_this.emitter.trigger('pointerup',ev);if(_this.isDragging){_this.autoScroller.stop();_this.tryStopDrag(ev);}
if(_this.delayTimeoutId){clearTimeout(_this.delayTimeoutId);_this.delayTimeoutId=null;}}};var pointer=_this.pointer=new PointerDragging(containerEl);pointer.emitter.on('pointerdown',_this.onPointerDown);pointer.emitter.on('pointermove',_this.onPointerMove);pointer.emitter.on('pointerup',_this.onPointerUp);if(selector){pointer.selector=selector;}
_this.mirror=new ElementMirror();_this.autoScroller=new AutoScroller();return _this;}
FeaturefulElementDragging.prototype.destroy=function(){this.pointer.destroy();this.onPointerUp({});};FeaturefulElementDragging.prototype.startDelay=function(ev){var _this=this;if(typeof this.delay==='number'){this.delayTimeoutId=setTimeout(function(){_this.delayTimeoutId=null;_this.handleDelayEnd(ev);},this.delay);}
else{this.handleDelayEnd(ev);}};FeaturefulElementDragging.prototype.handleDelayEnd=function(ev){this.isDelayEnded=true;this.tryStartDrag(ev);};FeaturefulElementDragging.prototype.handleDistanceSurpassed=function(ev){this.isDistanceSurpassed=true;this.tryStartDrag(ev);};FeaturefulElementDragging.prototype.tryStartDrag=function(ev){if(this.isDelayEnded&&this.isDistanceSurpassed){if(!this.pointer.wasTouchScroll||this.touchScrollAllowed){this.isDragging=true;this.mirrorNeedsRevert=false;this.autoScroller.start(ev.pageX,ev.pageY,this.containerEl);this.emitter.trigger('dragstart',ev);if(this.touchScrollAllowed===false){this.pointer.cancelTouchScroll();}}}};FeaturefulElementDragging.prototype.tryStopDrag=function(ev){this.mirror.stop(this.mirrorNeedsRevert,this.stopDrag.bind(this,ev));};FeaturefulElementDragging.prototype.stopDrag=function(ev){this.isDragging=false;this.emitter.trigger('dragend',ev);};FeaturefulElementDragging.prototype.setIgnoreMove=function(bool){this.pointer.shouldIgnoreMove=bool;};FeaturefulElementDragging.prototype.setMirrorIsVisible=function(bool){this.mirror.setIsVisible(bool);};FeaturefulElementDragging.prototype.setMirrorNeedsRevert=function(bool){this.mirrorNeedsRevert=bool;};FeaturefulElementDragging.prototype.setAutoScrollEnabled=function(bool){this.autoScroller.isEnabled=bool;};return FeaturefulElementDragging;}(common.ElementDragging));var OffsetTracker=(function(){function OffsetTracker(el){this.origRect=common.computeRect(el);this.scrollCaches=common.getClippingParents(el).map(function(scrollEl){return new ElementScrollGeomCache(scrollEl,true);});}
OffsetTracker.prototype.destroy=function(){for(var _i=0,_a=this.scrollCaches;_i<_a.length;_i++){var scrollCache=_a[_i];scrollCache.destroy();}};OffsetTracker.prototype.computeLeft=function(){var left=this.origRect.left;for(var _i=0,_a=this.scrollCaches;_i<_a.length;_i++){var scrollCache=_a[_i];left+=scrollCache.origScrollLeft-scrollCache.getScrollLeft();}
return left;};OffsetTracker.prototype.computeTop=function(){var top=this.origRect.top;for(var _i=0,_a=this.scrollCaches;_i<_a.length;_i++){var scrollCache=_a[_i];top+=scrollCache.origScrollTop-scrollCache.getScrollTop();}
return top;};OffsetTracker.prototype.isWithinClipping=function(pageX,pageY){var point={left:pageX,top:pageY};for(var _i=0,_a=this.scrollCaches;_i<_a.length;_i++){var scrollCache=_a[_i];if(!isIgnoredClipping(scrollCache.getEventTarget())&&!common.pointInsideRect(point,scrollCache.clientRect)){return false;}}
return true;};return OffsetTracker;}());function isIgnoredClipping(node){var tagName=node.tagName;return tagName==='HTML'||tagName==='BODY';}
var HitDragging=(function(){function HitDragging(dragging,droppableStore){var _this=this;this.useSubjectCenter=false;this.requireInitial=true;this.initialHit=null;this.movingHit=null;this.finalHit=null;this.handlePointerDown=function(ev){var dragging=_this.dragging;_this.initialHit=null;_this.movingHit=null;_this.finalHit=null;_this.prepareHits();_this.processFirstCoord(ev);if(_this.initialHit||!_this.requireInitial){dragging.setIgnoreMove(false);_this.emitter.trigger('pointerdown',ev);}
else{dragging.setIgnoreMove(true);}};this.handleDragStart=function(ev){_this.emitter.trigger('dragstart',ev);_this.handleMove(ev,true);};this.handleDragMove=function(ev){_this.emitter.trigger('dragmove',ev);_this.handleMove(ev);};this.handlePointerUp=function(ev){_this.releaseHits();_this.emitter.trigger('pointerup',ev);};this.handleDragEnd=function(ev){if(_this.movingHit){_this.emitter.trigger('hitupdate',null,true,ev);}
_this.finalHit=_this.movingHit;_this.movingHit=null;_this.emitter.trigger('dragend',ev);};this.droppableStore=droppableStore;dragging.emitter.on('pointerdown',this.handlePointerDown);dragging.emitter.on('dragstart',this.handleDragStart);dragging.emitter.on('dragmove',this.handleDragMove);dragging.emitter.on('pointerup',this.handlePointerUp);dragging.emitter.on('dragend',this.handleDragEnd);this.dragging=dragging;this.emitter=new common.Emitter();}
HitDragging.prototype.processFirstCoord=function(ev){var origPoint={left:ev.pageX,top:ev.pageY};var adjustedPoint=origPoint;var subjectEl=ev.subjectEl;var subjectRect;if(subjectEl instanceof HTMLElement){subjectRect=common.computeRect(subjectEl);adjustedPoint=common.constrainPoint(adjustedPoint,subjectRect);}
var initialHit=this.initialHit=this.queryHitForOffset(adjustedPoint.left,adjustedPoint.top);if(initialHit){if(this.useSubjectCenter&&subjectRect){var slicedSubjectRect=common.intersectRects(subjectRect,initialHit.rect);if(slicedSubjectRect){adjustedPoint=common.getRectCenter(slicedSubjectRect);}}
this.coordAdjust=common.diffPoints(adjustedPoint,origPoint);}
else{this.coordAdjust={left:0,top:0};}};HitDragging.prototype.handleMove=function(ev,forceHandle){var hit=this.queryHitForOffset(ev.pageX+this.coordAdjust.left,ev.pageY+this.coordAdjust.top);if(forceHandle||!isHitsEqual(this.movingHit,hit)){this.movingHit=hit;this.emitter.trigger('hitupdate',hit,false,ev);}};HitDragging.prototype.prepareHits=function(){this.offsetTrackers=common.mapHash(this.droppableStore,function(interactionSettings){interactionSettings.component.prepareHits();return new OffsetTracker(interactionSettings.el);});};HitDragging.prototype.releaseHits=function(){var offsetTrackers=this.offsetTrackers;for(var id in offsetTrackers){offsetTrackers[id].destroy();}
this.offsetTrackers={};};HitDragging.prototype.queryHitForOffset=function(offsetLeft,offsetTop){var _a=this,droppableStore=_a.droppableStore,offsetTrackers=_a.offsetTrackers;var bestHit=null;for(var id in droppableStore){var component=droppableStore[id].component;var offsetTracker=offsetTrackers[id];if(offsetTracker&&offsetTracker.isWithinClipping(offsetLeft,offsetTop)){var originLeft=offsetTracker.computeLeft();var originTop=offsetTracker.computeTop();var positionLeft=offsetLeft-originLeft;var positionTop=offsetTop-originTop;var origRect=offsetTracker.origRect;var width=origRect.right-origRect.left;var height=origRect.bottom-origRect.top;if(positionLeft>=0&&positionLeft<width&&positionTop>=0&&positionTop<height){var hit=component.queryHit(positionLeft,positionTop,width,height);if(hit&&(common.rangeContainsRange(hit.dateProfile.activeRange,hit.dateSpan.range))&&(!bestHit||hit.layer>bestHit.layer)){hit.componentId=id;hit.context=component.context;hit.rect.left+=originLeft;hit.rect.right+=originLeft;hit.rect.top+=originTop;hit.rect.bottom+=originTop;bestHit=hit;}}}}
return bestHit;};return HitDragging;}());function isHitsEqual(hit0,hit1){if(!hit0&&!hit1){return true;}
if(Boolean(hit0)!==Boolean(hit1)){return false;}
return common.isDateSpansEqual(hit0.dateSpan,hit1.dateSpan);}
function buildDatePointApiWithContext(dateSpan,context){var props={};for(var _i=0,_a=context.pluginHooks.datePointTransforms;_i<_a.length;_i++){var transform=_a[_i];__assign(props,transform(dateSpan,context));}
__assign(props,buildDatePointApi(dateSpan,context.dateEnv));return props;}
function buildDatePointApi(span,dateEnv){return{date:dateEnv.toDate(span.range.start),dateStr:dateEnv.formatIso(span.range.start,{omitTime:span.allDay}),allDay:span.allDay,};}
var DateClicking=(function(_super){__extends(DateClicking,_super);function DateClicking(settings){var _this=_super.call(this,settings)||this;_this.handlePointerDown=function(pev){var dragging=_this.dragging;var downEl=pev.origEvent.target;dragging.setIgnoreMove(!_this.component.isValidDateDownEl(downEl));};_this.handleDragEnd=function(ev){var component=_this.component;var pointer=_this.dragging.pointer;if(!pointer.wasTouchScroll){var _a=_this.hitDragging,initialHit=_a.initialHit,finalHit=_a.finalHit;if(initialHit&&finalHit&&isHitsEqual(initialHit,finalHit)){var context=component.context;var arg=__assign(__assign({},buildDatePointApiWithContext(initialHit.dateSpan,context)),{dayEl:initialHit.dayEl,jsEvent:ev.origEvent,view:context.viewApi||context.calendarApi.view});context.emitter.trigger('dateClick',arg);}}};_this.dragging=new FeaturefulElementDragging(settings.el);_this.dragging.autoScroller.isEnabled=false;var hitDragging=_this.hitDragging=new HitDragging(_this.dragging,common.interactionSettingsToStore(settings));hitDragging.emitter.on('pointerdown',_this.handlePointerDown);hitDragging.emitter.on('dragend',_this.handleDragEnd);return _this;}
DateClicking.prototype.destroy=function(){this.dragging.destroy();};return DateClicking;}(common.Interaction));var DateSelecting=(function(_super){__extends(DateSelecting,_super);function DateSelecting(settings){var _this=_super.call(this,settings)||this;_this.dragSelection=null;_this.handlePointerDown=function(ev){var _a=_this,component=_a.component,dragging=_a.dragging;var options=component.context.options;var canSelect=options.selectable&&component.isValidDateDownEl(ev.origEvent.target);dragging.setIgnoreMove(!canSelect);dragging.delay=ev.isTouch?getComponentTouchDelay$1(component):null;};_this.handleDragStart=function(ev){_this.component.context.calendarApi.unselect(ev);};_this.handleHitUpdate=function(hit,isFinal){var context=_this.component.context;var dragSelection=null;var isInvalid=false;if(hit){var initialHit=_this.hitDragging.initialHit;var disallowed=hit.componentId===initialHit.componentId&&_this.isHitComboAllowed&&!_this.isHitComboAllowed(initialHit,hit);if(!disallowed){dragSelection=joinHitsIntoSelection(initialHit,hit,context.pluginHooks.dateSelectionTransformers);}
if(!dragSelection||!common.isDateSelectionValid(dragSelection,hit.dateProfile,context)){isInvalid=true;dragSelection=null;}}
if(dragSelection){context.dispatch({type:'SELECT_DATES',selection:dragSelection});}
else if(!isFinal){context.dispatch({type:'UNSELECT_DATES'});}
if(!isInvalid){common.enableCursor();}
else{common.disableCursor();}
if(!isFinal){_this.dragSelection=dragSelection;}};_this.handlePointerUp=function(pev){if(_this.dragSelection){common.triggerDateSelect(_this.dragSelection,pev,_this.component.context);_this.dragSelection=null;}};var component=settings.component;var options=component.context.options;var dragging=_this.dragging=new FeaturefulElementDragging(settings.el);dragging.touchScrollAllowed=false;dragging.minDistance=options.selectMinDistance||0;dragging.autoScroller.isEnabled=options.dragScroll;var hitDragging=_this.hitDragging=new HitDragging(_this.dragging,common.interactionSettingsToStore(settings));hitDragging.emitter.on('pointerdown',_this.handlePointerDown);hitDragging.emitter.on('dragstart',_this.handleDragStart);hitDragging.emitter.on('hitupdate',_this.handleHitUpdate);hitDragging.emitter.on('pointerup',_this.handlePointerUp);return _this;}
DateSelecting.prototype.destroy=function(){this.dragging.destroy();};return DateSelecting;}(common.Interaction));function getComponentTouchDelay$1(component){var options=component.context.options;var delay=options.selectLongPressDelay;if(delay==null){delay=options.longPressDelay;}
return delay;}
function joinHitsIntoSelection(hit0,hit1,dateSelectionTransformers){var dateSpan0=hit0.dateSpan;var dateSpan1=hit1.dateSpan;var ms=[dateSpan0.range.start,dateSpan0.range.end,dateSpan1.range.start,dateSpan1.range.end,];ms.sort(common.compareNumbers);var props={};for(var _i=0,dateSelectionTransformers_1=dateSelectionTransformers;_i<dateSelectionTransformers_1.length;_i++){var transformer=dateSelectionTransformers_1[_i];var res=transformer(hit0,hit1);if(res===false){return null;}
if(res){__assign(props,res);}}
props.range={start:ms[0],end:ms[3]};props.allDay=dateSpan0.allDay;return props;}
var EventDragging=(function(_super){__extends(EventDragging,_super);function EventDragging(settings){var _this=_super.call(this,settings)||this;_this.subjectEl=null;_this.subjectSeg=null;_this.isDragging=false;_this.eventRange=null;_this.relevantEvents=null;_this.receivingContext=null;_this.validMutation=null;_this.mutatedRelevantEvents=null;_this.handlePointerDown=function(ev){var origTarget=ev.origEvent.target;var _a=_this,component=_a.component,dragging=_a.dragging;var mirror=dragging.mirror;var options=component.context.options;var initialContext=component.context;_this.subjectEl=ev.subjectEl;var subjectSeg=_this.subjectSeg=common.getElSeg(ev.subjectEl);var eventRange=_this.eventRange=subjectSeg.eventRange;var eventInstanceId=eventRange.instance.instanceId;_this.relevantEvents=common.getRelevantEvents(initialContext.getCurrentData().eventStore,eventInstanceId);dragging.minDistance=ev.isTouch?0:options.eventDragMinDistance;dragging.delay=(ev.isTouch&&eventInstanceId!==component.props.eventSelection)?getComponentTouchDelay(component):null;if(options.fixedMirrorParent){mirror.parentNode=options.fixedMirrorParent;}
else{mirror.parentNode=common.elementClosest(origTarget,'.fc');}
mirror.revertDuration=options.dragRevertDuration;var isValid=component.isValidSegDownEl(origTarget)&&!common.elementClosest(origTarget,'.fc-event-resizer');dragging.setIgnoreMove(!isValid);_this.isDragging=isValid&&ev.subjectEl.classList.contains('fc-event-draggable');};_this.handleDragStart=function(ev){var initialContext=_this.component.context;var eventRange=_this.eventRange;var eventInstanceId=eventRange.instance.instanceId;if(ev.isTouch){if(eventInstanceId!==_this.component.props.eventSelection){initialContext.dispatch({type:'SELECT_EVENT',eventInstanceId:eventInstanceId});}}
else{initialContext.dispatch({type:'UNSELECT_EVENT'});}
if(_this.isDragging){initialContext.calendarApi.unselect(ev);initialContext.emitter.trigger('eventDragStart',{el:_this.subjectEl,event:new common.EventApi(initialContext,eventRange.def,eventRange.instance),jsEvent:ev.origEvent,view:initialContext.viewApi,});}};_this.handleHitUpdate=function(hit,isFinal){if(!_this.isDragging){return;}
var relevantEvents=_this.relevantEvents;var initialHit=_this.hitDragging.initialHit;var initialContext=_this.component.context;var receivingContext=null;var mutation=null;var mutatedRelevantEvents=null;var isInvalid=false;var interaction={affectedEvents:relevantEvents,mutatedEvents:common.createEmptyEventStore(),isEvent:true,};if(hit){receivingContext=hit.context;var receivingOptions=receivingContext.options;if(initialContext===receivingContext||(receivingOptions.editable&&receivingOptions.droppable)){mutation=computeEventMutation(initialHit,hit,receivingContext.getCurrentData().pluginHooks.eventDragMutationMassagers);if(mutation){mutatedRelevantEvents=common.applyMutationToEventStore(relevantEvents,receivingContext.getCurrentData().eventUiBases,mutation,receivingContext);interaction.mutatedEvents=mutatedRelevantEvents;if(!common.isInteractionValid(interaction,hit.dateProfile,receivingContext)){isInvalid=true;mutation=null;mutatedRelevantEvents=null;interaction.mutatedEvents=common.createEmptyEventStore();}}}
else{receivingContext=null;}}
_this.displayDrag(receivingContext,interaction);if(!isInvalid){common.enableCursor();}
else{common.disableCursor();}
if(!isFinal){if(initialContext===receivingContext&&isHitsEqual(initialHit,hit)){mutation=null;}
_this.dragging.setMirrorNeedsRevert(!mutation);_this.dragging.setMirrorIsVisible(!hit||!common.getElRoot(_this.subjectEl).querySelector('.fc-event-mirror'));_this.receivingContext=receivingContext;_this.validMutation=mutation;_this.mutatedRelevantEvents=mutatedRelevantEvents;}};_this.handlePointerUp=function(){if(!_this.isDragging){_this.cleanup();}};_this.handleDragEnd=function(ev){if(_this.isDragging){var initialContext_1=_this.component.context;var initialView=initialContext_1.viewApi;var _a=_this,receivingContext_1=_a.receivingContext,validMutation=_a.validMutation;var eventDef=_this.eventRange.def;var eventInstance=_this.eventRange.instance;var eventApi=new common.EventApi(initialContext_1,eventDef,eventInstance);var relevantEvents_1=_this.relevantEvents;var mutatedRelevantEvents_1=_this.mutatedRelevantEvents;var finalHit=_this.hitDragging.finalHit;_this.clearDrag();initialContext_1.emitter.trigger('eventDragStop',{el:_this.subjectEl,event:eventApi,jsEvent:ev.origEvent,view:initialView,});if(validMutation){if(receivingContext_1===initialContext_1){var updatedEventApi=new common.EventApi(initialContext_1,mutatedRelevantEvents_1.defs[eventDef.defId],eventInstance?mutatedRelevantEvents_1.instances[eventInstance.instanceId]:null);initialContext_1.dispatch({type:'MERGE_EVENTS',eventStore:mutatedRelevantEvents_1,});var eventChangeArg={oldEvent:eventApi,event:updatedEventApi,relatedEvents:common.buildEventApis(mutatedRelevantEvents_1,initialContext_1,eventInstance),revert:function(){initialContext_1.dispatch({type:'MERGE_EVENTS',eventStore:relevantEvents_1,});},};var transformed={};for(var _i=0,_b=initialContext_1.getCurrentData().pluginHooks.eventDropTransformers;_i<_b.length;_i++){var transformer=_b[_i];__assign(transformed,transformer(validMutation,initialContext_1));}
initialContext_1.emitter.trigger('eventDrop',__assign(__assign(__assign({},eventChangeArg),transformed),{el:ev.subjectEl,delta:validMutation.datesDelta,jsEvent:ev.origEvent,view:initialView}));initialContext_1.emitter.trigger('eventChange',eventChangeArg);}
else if(receivingContext_1){var eventRemoveArg={event:eventApi,relatedEvents:common.buildEventApis(relevantEvents_1,initialContext_1,eventInstance),revert:function(){initialContext_1.dispatch({type:'MERGE_EVENTS',eventStore:relevantEvents_1,});},};initialContext_1.emitter.trigger('eventLeave',__assign(__assign({},eventRemoveArg),{draggedEl:ev.subjectEl,view:initialView}));initialContext_1.dispatch({type:'REMOVE_EVENTS',eventStore:relevantEvents_1,});initialContext_1.emitter.trigger('eventRemove',eventRemoveArg);var addedEventDef=mutatedRelevantEvents_1.defs[eventDef.defId];var addedEventInstance=mutatedRelevantEvents_1.instances[eventInstance.instanceId];var addedEventApi=new common.EventApi(receivingContext_1,addedEventDef,addedEventInstance);receivingContext_1.dispatch({type:'MERGE_EVENTS',eventStore:mutatedRelevantEvents_1,});var eventAddArg={event:addedEventApi,relatedEvents:common.buildEventApis(mutatedRelevantEvents_1,receivingContext_1,addedEventInstance),revert:function(){receivingContext_1.dispatch({type:'REMOVE_EVENTS',eventStore:mutatedRelevantEvents_1,});},};receivingContext_1.emitter.trigger('eventAdd',eventAddArg);if(ev.isTouch){receivingContext_1.dispatch({type:'SELECT_EVENT',eventInstanceId:eventInstance.instanceId,});}
receivingContext_1.emitter.trigger('drop',__assign(__assign({},buildDatePointApiWithContext(finalHit.dateSpan,receivingContext_1)),{draggedEl:ev.subjectEl,jsEvent:ev.origEvent,view:finalHit.context.viewApi}));receivingContext_1.emitter.trigger('eventReceive',__assign(__assign({},eventAddArg),{draggedEl:ev.subjectEl,view:finalHit.context.viewApi}));}}
else{initialContext_1.emitter.trigger('_noEventDrop');}}
_this.cleanup();};var component=_this.component;var options=component.context.options;var dragging=_this.dragging=new FeaturefulElementDragging(settings.el);dragging.pointer.selector=EventDragging.SELECTOR;dragging.touchScrollAllowed=false;dragging.autoScroller.isEnabled=options.dragScroll;var hitDragging=_this.hitDragging=new HitDragging(_this.dragging,common.interactionSettingsStore);hitDragging.useSubjectCenter=settings.useEventCenter;hitDragging.emitter.on('pointerdown',_this.handlePointerDown);hitDragging.emitter.on('dragstart',_this.handleDragStart);hitDragging.emitter.on('hitupdate',_this.handleHitUpdate);hitDragging.emitter.on('pointerup',_this.handlePointerUp);hitDragging.emitter.on('dragend',_this.handleDragEnd);return _this;}
EventDragging.prototype.destroy=function(){this.dragging.destroy();};EventDragging.prototype.displayDrag=function(nextContext,state){var initialContext=this.component.context;var prevContext=this.receivingContext;if(prevContext&&prevContext!==nextContext){if(prevContext===initialContext){prevContext.dispatch({type:'SET_EVENT_DRAG',state:{affectedEvents:state.affectedEvents,mutatedEvents:common.createEmptyEventStore(),isEvent:true,},});}
else{prevContext.dispatch({type:'UNSET_EVENT_DRAG'});}}
if(nextContext){nextContext.dispatch({type:'SET_EVENT_DRAG',state:state});}};EventDragging.prototype.clearDrag=function(){var initialCalendar=this.component.context;var receivingContext=this.receivingContext;if(receivingContext){receivingContext.dispatch({type:'UNSET_EVENT_DRAG'});}
if(initialCalendar!==receivingContext){initialCalendar.dispatch({type:'UNSET_EVENT_DRAG'});}};EventDragging.prototype.cleanup=function(){this.subjectSeg=null;this.isDragging=false;this.eventRange=null;this.relevantEvents=null;this.receivingContext=null;this.validMutation=null;this.mutatedRelevantEvents=null;};EventDragging.SELECTOR='.fc-event-draggable, .fc-event-resizable';return EventDragging;}(common.Interaction));function computeEventMutation(hit0,hit1,massagers){var dateSpan0=hit0.dateSpan;var dateSpan1=hit1.dateSpan;var date0=dateSpan0.range.start;var date1=dateSpan1.range.start;var standardProps={};if(dateSpan0.allDay!==dateSpan1.allDay){standardProps.allDay=dateSpan1.allDay;standardProps.hasEnd=hit1.context.options.allDayMaintainDuration;if(dateSpan1.allDay){date0=common.startOfDay(date0);}}
var delta=common.diffDates(date0,date1,hit0.context.dateEnv,hit0.componentId===hit1.componentId?hit0.largeUnit:null);if(delta.milliseconds){standardProps.allDay=false;}
var mutation={datesDelta:delta,standardProps:standardProps,};for(var _i=0,massagers_1=massagers;_i<massagers_1.length;_i++){var massager=massagers_1[_i];massager(mutation,hit0,hit1);}
return mutation;}
function getComponentTouchDelay(component){var options=component.context.options;var delay=options.eventLongPressDelay;if(delay==null){delay=options.longPressDelay;}
return delay;}
var EventResizing=(function(_super){__extends(EventResizing,_super);function EventResizing(settings){var _this=_super.call(this,settings)||this;_this.draggingSegEl=null;_this.draggingSeg=null;_this.eventRange=null;_this.relevantEvents=null;_this.validMutation=null;_this.mutatedRelevantEvents=null;_this.handlePointerDown=function(ev){var component=_this.component;var segEl=_this.querySegEl(ev);var seg=common.getElSeg(segEl);var eventRange=_this.eventRange=seg.eventRange;_this.dragging.minDistance=component.context.options.eventDragMinDistance;_this.dragging.setIgnoreMove(!_this.component.isValidSegDownEl(ev.origEvent.target)||(ev.isTouch&&_this.component.props.eventSelection!==eventRange.instance.instanceId));};_this.handleDragStart=function(ev){var context=_this.component.context;var eventRange=_this.eventRange;_this.relevantEvents=common.getRelevantEvents(context.getCurrentData().eventStore,_this.eventRange.instance.instanceId);var segEl=_this.querySegEl(ev);_this.draggingSegEl=segEl;_this.draggingSeg=common.getElSeg(segEl);context.calendarApi.unselect();context.emitter.trigger('eventResizeStart',{el:segEl,event:new common.EventApi(context,eventRange.def,eventRange.instance),jsEvent:ev.origEvent,view:context.viewApi,});};_this.handleHitUpdate=function(hit,isFinal,ev){var context=_this.component.context;var relevantEvents=_this.relevantEvents;var initialHit=_this.hitDragging.initialHit;var eventInstance=_this.eventRange.instance;var mutation=null;var mutatedRelevantEvents=null;var isInvalid=false;var interaction={affectedEvents:relevantEvents,mutatedEvents:common.createEmptyEventStore(),isEvent:true,};if(hit){var disallowed=hit.componentId===initialHit.componentId&&_this.isHitComboAllowed&&!_this.isHitComboAllowed(initialHit,hit);if(!disallowed){mutation=computeMutation(initialHit,hit,ev.subjectEl.classList.contains('fc-event-resizer-start'),eventInstance.range);}}
if(mutation){mutatedRelevantEvents=common.applyMutationToEventStore(relevantEvents,context.getCurrentData().eventUiBases,mutation,context);interaction.mutatedEvents=mutatedRelevantEvents;if(!common.isInteractionValid(interaction,hit.dateProfile,context)){isInvalid=true;mutation=null;mutatedRelevantEvents=null;interaction.mutatedEvents=null;}}
if(mutatedRelevantEvents){context.dispatch({type:'SET_EVENT_RESIZE',state:interaction,});}
else{context.dispatch({type:'UNSET_EVENT_RESIZE'});}
if(!isInvalid){common.enableCursor();}
else{common.disableCursor();}
if(!isFinal){if(mutation&&isHitsEqual(initialHit,hit)){mutation=null;}
_this.validMutation=mutation;_this.mutatedRelevantEvents=mutatedRelevantEvents;}};_this.handleDragEnd=function(ev){var context=_this.component.context;var eventDef=_this.eventRange.def;var eventInstance=_this.eventRange.instance;var eventApi=new common.EventApi(context,eventDef,eventInstance);var relevantEvents=_this.relevantEvents;var mutatedRelevantEvents=_this.mutatedRelevantEvents;context.emitter.trigger('eventResizeStop',{el:_this.draggingSegEl,event:eventApi,jsEvent:ev.origEvent,view:context.viewApi,});if(_this.validMutation){var updatedEventApi=new common.EventApi(context,mutatedRelevantEvents.defs[eventDef.defId],eventInstance?mutatedRelevantEvents.instances[eventInstance.instanceId]:null);context.dispatch({type:'MERGE_EVENTS',eventStore:mutatedRelevantEvents,});var eventChangeArg={oldEvent:eventApi,event:updatedEventApi,relatedEvents:common.buildEventApis(mutatedRelevantEvents,context,eventInstance),revert:function(){context.dispatch({type:'MERGE_EVENTS',eventStore:relevantEvents,});},};context.emitter.trigger('eventResize',__assign(__assign({},eventChangeArg),{el:_this.draggingSegEl,startDelta:_this.validMutation.startDelta||common.createDuration(0),endDelta:_this.validMutation.endDelta||common.createDuration(0),jsEvent:ev.origEvent,view:context.viewApi}));context.emitter.trigger('eventChange',eventChangeArg);}
else{context.emitter.trigger('_noEventResize');}
_this.draggingSeg=null;_this.relevantEvents=null;_this.validMutation=null;};var component=settings.component;var dragging=_this.dragging=new FeaturefulElementDragging(settings.el);dragging.pointer.selector='.fc-event-resizer';dragging.touchScrollAllowed=false;dragging.autoScroller.isEnabled=component.context.options.dragScroll;var hitDragging=_this.hitDragging=new HitDragging(_this.dragging,common.interactionSettingsToStore(settings));hitDragging.emitter.on('pointerdown',_this.handlePointerDown);hitDragging.emitter.on('dragstart',_this.handleDragStart);hitDragging.emitter.on('hitupdate',_this.handleHitUpdate);hitDragging.emitter.on('dragend',_this.handleDragEnd);return _this;}
EventResizing.prototype.destroy=function(){this.dragging.destroy();};EventResizing.prototype.querySegEl=function(ev){return common.elementClosest(ev.subjectEl,'.fc-event');};return EventResizing;}(common.Interaction));function computeMutation(hit0,hit1,isFromStart,instanceRange){var dateEnv=hit0.context.dateEnv;var date0=hit0.dateSpan.range.start;var date1=hit1.dateSpan.range.start;var delta=common.diffDates(date0,date1,dateEnv,hit0.largeUnit);if(isFromStart){if(dateEnv.add(instanceRange.start,delta)<instanceRange.end){return{startDelta:delta};}}
else if(dateEnv.add(instanceRange.end,delta)>instanceRange.start){return{endDelta:delta};}
return null;}
var UnselectAuto=(function(){function UnselectAuto(context){var _this=this;this.context=context;this.isRecentPointerDateSelect=false;this.matchesCancel=false;this.matchesEvent=false;this.onSelect=function(selectInfo){if(selectInfo.jsEvent){_this.isRecentPointerDateSelect=true;}};this.onDocumentPointerDown=function(pev){var unselectCancel=_this.context.options.unselectCancel;var downEl=common.getEventTargetViaRoot(pev.origEvent);_this.matchesCancel=!!common.elementClosest(downEl,unselectCancel);_this.matchesEvent=!!common.elementClosest(downEl,EventDragging.SELECTOR);};this.onDocumentPointerUp=function(pev){var context=_this.context;var documentPointer=_this.documentPointer;var calendarState=context.getCurrentData();if(!documentPointer.wasTouchScroll){if(calendarState.dateSelection&&!_this.isRecentPointerDateSelect){var unselectAuto=context.options.unselectAuto;if(unselectAuto&&(!unselectAuto||!_this.matchesCancel)){context.calendarApi.unselect(pev);}}
if(calendarState.eventSelection&&!_this.matchesEvent){context.dispatch({type:'UNSELECT_EVENT'});}}
_this.isRecentPointerDateSelect=false;};var documentPointer=this.documentPointer=new PointerDragging(document);documentPointer.shouldIgnoreMove=true;documentPointer.shouldWatchScroll=false;documentPointer.emitter.on('pointerdown',this.onDocumentPointerDown);documentPointer.emitter.on('pointerup',this.onDocumentPointerUp);context.emitter.on('select',this.onSelect);}
UnselectAuto.prototype.destroy=function(){this.context.emitter.off('select',this.onSelect);this.documentPointer.destroy();};return UnselectAuto;}());var OPTION_REFINERS={fixedMirrorParent:common.identity,};var LISTENER_REFINERS={dateClick:common.identity,eventDragStart:common.identity,eventDragStop:common.identity,eventDrop:common.identity,eventResizeStart:common.identity,eventResizeStop:common.identity,eventResize:common.identity,drop:common.identity,eventReceive:common.identity,eventLeave:common.identity,};var ExternalElementDragging=(function(){function ExternalElementDragging(dragging,suppliedDragMeta){var _this=this;this.receivingContext=null;this.droppableEvent=null;this.suppliedDragMeta=null;this.dragMeta=null;this.handleDragStart=function(ev){_this.dragMeta=_this.buildDragMeta(ev.subjectEl);};this.handleHitUpdate=function(hit,isFinal,ev){var dragging=_this.hitDragging.dragging;var receivingContext=null;var droppableEvent=null;var isInvalid=false;var interaction={affectedEvents:common.createEmptyEventStore(),mutatedEvents:common.createEmptyEventStore(),isEvent:_this.dragMeta.create,};if(hit){receivingContext=hit.context;if(_this.canDropElOnCalendar(ev.subjectEl,receivingContext)){droppableEvent=computeEventForDateSpan(hit.dateSpan,_this.dragMeta,receivingContext);interaction.mutatedEvents=common.eventTupleToStore(droppableEvent);isInvalid=!common.isInteractionValid(interaction,hit.dateProfile,receivingContext);if(isInvalid){interaction.mutatedEvents=common.createEmptyEventStore();droppableEvent=null;}}}
_this.displayDrag(receivingContext,interaction);dragging.setMirrorIsVisible(isFinal||!droppableEvent||!document.querySelector('.fc-event-mirror'));if(!isInvalid){common.enableCursor();}
else{common.disableCursor();}
if(!isFinal){dragging.setMirrorNeedsRevert(!droppableEvent);_this.receivingContext=receivingContext;_this.droppableEvent=droppableEvent;}};this.handleDragEnd=function(pev){var _a=_this,receivingContext=_a.receivingContext,droppableEvent=_a.droppableEvent;_this.clearDrag();if(receivingContext&&droppableEvent){var finalHit=_this.hitDragging.finalHit;var finalView=finalHit.context.viewApi;var dragMeta=_this.dragMeta;receivingContext.emitter.trigger('drop',__assign(__assign({},buildDatePointApiWithContext(finalHit.dateSpan,receivingContext)),{draggedEl:pev.subjectEl,jsEvent:pev.origEvent,view:finalView}));if(dragMeta.create){var addingEvents_1=common.eventTupleToStore(droppableEvent);receivingContext.dispatch({type:'MERGE_EVENTS',eventStore:addingEvents_1,});if(pev.isTouch){receivingContext.dispatch({type:'SELECT_EVENT',eventInstanceId:droppableEvent.instance.instanceId,});}
receivingContext.emitter.trigger('eventReceive',{event:new common.EventApi(receivingContext,droppableEvent.def,droppableEvent.instance),relatedEvents:[],revert:function(){receivingContext.dispatch({type:'REMOVE_EVENTS',eventStore:addingEvents_1,});},draggedEl:pev.subjectEl,view:finalView,});}}
_this.receivingContext=null;_this.droppableEvent=null;};var hitDragging=this.hitDragging=new HitDragging(dragging,common.interactionSettingsStore);hitDragging.requireInitial=false;hitDragging.emitter.on('dragstart',this.handleDragStart);hitDragging.emitter.on('hitupdate',this.handleHitUpdate);hitDragging.emitter.on('dragend',this.handleDragEnd);this.suppliedDragMeta=suppliedDragMeta;}
ExternalElementDragging.prototype.buildDragMeta=function(subjectEl){if(typeof this.suppliedDragMeta==='object'){return common.parseDragMeta(this.suppliedDragMeta);}
if(typeof this.suppliedDragMeta==='function'){return common.parseDragMeta(this.suppliedDragMeta(subjectEl));}
return getDragMetaFromEl(subjectEl);};ExternalElementDragging.prototype.displayDrag=function(nextContext,state){var prevContext=this.receivingContext;if(prevContext&&prevContext!==nextContext){prevContext.dispatch({type:'UNSET_EVENT_DRAG'});}
if(nextContext){nextContext.dispatch({type:'SET_EVENT_DRAG',state:state});}};ExternalElementDragging.prototype.clearDrag=function(){if(this.receivingContext){this.receivingContext.dispatch({type:'UNSET_EVENT_DRAG'});}};ExternalElementDragging.prototype.canDropElOnCalendar=function(el,receivingContext){var dropAccept=receivingContext.options.dropAccept;if(typeof dropAccept==='function'){return dropAccept.call(receivingContext.calendarApi,el);}
if(typeof dropAccept==='string'&&dropAccept){return Boolean(common.elementMatches(el,dropAccept));}
return true;};return ExternalElementDragging;}());function computeEventForDateSpan(dateSpan,dragMeta,context){var defProps=__assign({},dragMeta.leftoverProps);for(var _i=0,_a=context.pluginHooks.externalDefTransforms;_i<_a.length;_i++){var transform=_a[_i];__assign(defProps,transform(dateSpan,dragMeta));}
var _b=common.refineEventDef(defProps,context),refined=_b.refined,extra=_b.extra;var def=common.parseEventDef(refined,extra,dragMeta.sourceId,dateSpan.allDay,context.options.forceEventDuration||Boolean(dragMeta.duration),context);var start=dateSpan.range.start;if(dateSpan.allDay&&dragMeta.startTime){start=context.dateEnv.add(start,dragMeta.startTime);}
var end=dragMeta.duration?context.dateEnv.add(start,dragMeta.duration):common.getDefaultEventEnd(dateSpan.allDay,start,context);var instance=common.createEventInstance(def.defId,{start:start,end:end});return{def:def,instance:instance};}
function getDragMetaFromEl(el){var str=getEmbeddedElData(el,'event');var obj=str?JSON.parse(str):{create:false};return common.parseDragMeta(obj);}
common.config.dataAttrPrefix='';function getEmbeddedElData(el,name){var prefix=common.config.dataAttrPrefix;var prefixedName=(prefix?prefix+'-':'')+name;return el.getAttribute('data-'+prefixedName)||'';}
var ExternalDraggable=(function(){function ExternalDraggable(el,settings){var _this=this;if(settings===void 0){settings={};}
this.handlePointerDown=function(ev){var dragging=_this.dragging;var _a=_this.settings,minDistance=_a.minDistance,longPressDelay=_a.longPressDelay;dragging.minDistance=minDistance!=null?minDistance:(ev.isTouch?0:common.BASE_OPTION_DEFAULTS.eventDragMinDistance);dragging.delay=ev.isTouch?(longPressDelay!=null?longPressDelay:common.BASE_OPTION_DEFAULTS.longPressDelay):0;};this.handleDragStart=function(ev){if(ev.isTouch&&_this.dragging.delay&&ev.subjectEl.classList.contains('fc-event')){_this.dragging.mirror.getMirrorEl().classList.add('fc-event-selected');}};this.settings=settings;var dragging=this.dragging=new FeaturefulElementDragging(el);dragging.touchScrollAllowed=false;if(settings.itemSelector!=null){dragging.pointer.selector=settings.itemSelector;}
if(settings.appendTo!=null){dragging.mirror.parentNode=settings.appendTo;}
dragging.emitter.on('pointerdown',this.handlePointerDown);dragging.emitter.on('dragstart',this.handleDragStart);new ExternalElementDragging(dragging,settings.eventData);}
ExternalDraggable.prototype.destroy=function(){this.dragging.destroy();};return ExternalDraggable;}());var InferredElementDragging=(function(_super){__extends(InferredElementDragging,_super);function InferredElementDragging(containerEl){var _this=_super.call(this,containerEl)||this;_this.shouldIgnoreMove=false;_this.mirrorSelector='';_this.currentMirrorEl=null;_this.handlePointerDown=function(ev){_this.emitter.trigger('pointerdown',ev);if(!_this.shouldIgnoreMove){_this.emitter.trigger('dragstart',ev);}};_this.handlePointerMove=function(ev){if(!_this.shouldIgnoreMove){_this.emitter.trigger('dragmove',ev);}};_this.handlePointerUp=function(ev){_this.emitter.trigger('pointerup',ev);if(!_this.shouldIgnoreMove){_this.emitter.trigger('dragend',ev);}};var pointer=_this.pointer=new PointerDragging(containerEl);pointer.emitter.on('pointerdown',_this.handlePointerDown);pointer.emitter.on('pointermove',_this.handlePointerMove);pointer.emitter.on('pointerup',_this.handlePointerUp);return _this;}
InferredElementDragging.prototype.destroy=function(){this.pointer.destroy();};InferredElementDragging.prototype.setIgnoreMove=function(bool){this.shouldIgnoreMove=bool;};InferredElementDragging.prototype.setMirrorIsVisible=function(bool){if(bool){if(this.currentMirrorEl){this.currentMirrorEl.style.visibility='';this.currentMirrorEl=null;}}
else{var mirrorEl=this.mirrorSelector?document.querySelector(this.mirrorSelector):null;if(mirrorEl){this.currentMirrorEl=mirrorEl;mirrorEl.style.visibility='hidden';}}};return InferredElementDragging;}(common.ElementDragging));var ThirdPartyDraggable=(function(){function ThirdPartyDraggable(containerOrSettings,settings){var containerEl=document;if(containerOrSettings===document||containerOrSettings instanceof Element){containerEl=containerOrSettings;settings=settings||{};}
else{settings=(containerOrSettings||{});}
var dragging=this.dragging=new InferredElementDragging(containerEl);if(typeof settings.itemSelector==='string'){dragging.pointer.selector=settings.itemSelector;}
else if(containerEl===document){dragging.pointer.selector='[data-event]';}
if(typeof settings.mirrorSelector==='string'){dragging.mirrorSelector=settings.mirrorSelector;}
new ExternalElementDragging(dragging,settings.eventData);}
ThirdPartyDraggable.prototype.destroy=function(){this.dragging.destroy();};return ThirdPartyDraggable;}());var plugin=common.createPlugin({componentInteractions:[DateClicking,DateSelecting,EventDragging,EventResizing],calendarInteractions:[UnselectAuto],elementDraggingImpl:FeaturefulElementDragging,optionRefiners:OPTION_REFINERS,listenerRefiners:LISTENER_REFINERS,});common.globalPlugins.push(plugin);exports.Draggable=ExternalDraggable;exports.FeaturefulElementDragging=FeaturefulElementDragging;exports.PointerDragging=PointerDragging;exports.ThirdPartyDraggable=ThirdPartyDraggable;exports.default=plugin;Object.defineProperty(exports,'__esModule',{value:true});return exports;}({},FullCalendar));